/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.base.MathUtils;

class JulianMath {
    public static final int MIN_YEAR = -999999999;
    public static final int MAX_YEAR = 999999999;
    private static final int OFFSET = 678883;

    private JulianMath() {
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0;
    }

    public static int getLengthOfMonth(int n, int n2) {
        switch (n2) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return JulianMath.isLeapYear(n) ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid month: " + n2);
    }

    public static boolean isValid(int n, int n2, int n3) {
        return n >= -999999999 && n <= 999999999 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= JulianMath.getLengthOfMonth(n, n2);
    }

    public static void checkDate(int n, int n2, int n3) {
        if (n < -999999999 || n > 999999999) {
            throw new IllegalArgumentException("YEAR out of range: " + n);
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("MONTH out of range: " + n2);
        }
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("DAY_OF_MONTH out of range: " + n3);
        }
        if (n3 > JulianMath.getLengthOfMonth(n, n2)) {
            throw new IllegalArgumentException("DAY_OF_MONTH exceeds month length in given year: " + JulianMath.toString(n, n2, n3));
        }
    }

    public static int readYear(long l) {
        return (int)(l >> 32);
    }

    public static int readMonth(long l) {
        return (int)(l >> 16 & 0xFFL);
    }

    public static int readDayOfMonth(long l) {
        return (int)(l & 0xFFL);
    }

    public static long toPackedDate(long l) {
        int n;
        int n2;
        long l2;
        long l3 = MathUtils.safeAdd(l, 678883L);
        long l4 = MathUtils.floorDivide(l3, 1461);
        int n3 = MathUtils.floorModulo(l3, 1461);
        if (n3 == 1460) {
            l2 = (l4 + 1L) * 4L;
            n2 = 2;
            n = 29;
        } else {
            int n4 = n3 / 365;
            int n5 = n3 % 365;
            l2 = l4 * 4L + (long)n4;
            n2 = (n5 + 31) * 5 / 153 + 2;
            n = n5 - (n2 + 1) * 153 / 5 + 123;
            if (n2 > 12) {
                ++l2;
                n2 -= 12;
            }
        }
        if (l2 < -999999999L || l2 > 999999999L) {
            throw new IllegalArgumentException("Year out of range: " + l2);
        }
        long l5 = l2 << 32;
        l5 |= (long)(n2 << 16);
        return l5 |= (long)n;
    }

    public static long toMJD(int n, int n2, int n3) {
        JulianMath.checkDate(n, n2, n3);
        long l = n;
        int n4 = n2;
        if (n4 < 3) {
            --l;
            n4 += 12;
        }
        long l2 = l * 365L + MathUtils.floorDivide(l, 4) + (long)((n4 + 1) * 153 / 5) - 123L + (long)n3;
        return l2 - 678883L;
    }

    private static String toString(int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append('-');
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }
}

