/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.List;
import java.util.Locale;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumericalElement;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.history.ChronoHistory;
import net.time4j.history.CutOverEvent;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

final class HistoricalIntegerElement
extends BasicElement<Integer>
implements NumericalElement<Integer>,
TextElement<Integer> {
    private static final int YEAR_OF_ERA_INDEX = 2;
    private static final int MONTH_INDEX = 3;
    private static final int DAY_OF_MONTH_INDEX = 4;
    private static final long serialVersionUID = -6283098762945747308L;
    private final ChronoHistory history;
    private final transient int index;
    private final transient char symbol;
    private final transient Integer defaultMin;
    private final transient Integer defaultMax;

    private HistoricalIntegerElement(String string, char c, Integer n, Integer n2, ChronoHistory chronoHistory, int n3) {
        super(string);
        this.symbol = c;
        this.defaultMin = n;
        this.defaultMax = n2;
        this.history = chronoHistory;
        this.index = n3;
    }

    static TextElement<Integer> forYearOfEra(ChronoHistory chronoHistory) {
        return new HistoricalIntegerElement("YEAR_OF_ERA", 'y', 1, 999999999, chronoHistory, 2);
    }

    static TextElement<Integer> forMonth(ChronoHistory chronoHistory) {
        return new HistoricalIntegerElement("HISTORIC_MONTH", 'M', 1, 12, chronoHistory, 3);
    }

    static TextElement<Integer> forDayOfMonth(ChronoHistory chronoHistory) {
        return new HistoricalIntegerElement("HISTORIC_DAY_OF_MONTH", 'd', 1, 31, chronoHistory, 4);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public Integer getDefaultMinimum() {
        return this.defaultMin;
    }

    @Override
    public Integer getDefaultMaximum() {
        return this.defaultMax;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public int numerical(Integer n) {
        return n;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        int n = chronoDisplay.get(this);
        switch (this.index) {
            case 3: {
                appendable.append(this.monthAccessor(attributeQuery).print(Month.valueOf(n)));
                break;
            }
            default: {
                appendable.append(String.valueOf(n));
            }
        }
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        int n;
        int n2;
        switch (this.index) {
            case 3: {
                Month month = this.monthAccessor(attributeQuery).parse(charSequence, parsePosition, Month.class, attributeQuery);
                return month.getValue();
            }
        }
        char c = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        int n3 = 0;
        int n4 = charSequence.length();
        for (int i = n = parsePosition.getIndex(); i < n4 && (n2 = charSequence.charAt(i) - c) >= 0 && n2 <= 9; ++i) {
            n3 = n3 * 10 + n2;
            ++n;
        }
        if (n == parsePosition.getIndex()) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        parsePosition.setIndex(n);
        return n3;
    }

    @Override
    protected <T extends ChronoEntity<T>> ElementRule<T, Integer> derive(Chronology<T> chronology) {
        if (chronology.isRegistered(PlainDate.COMPONENT)) {
            return new Rule(this.index, this.history);
        }
        return null;
    }

    private TextAccessor monthAccessor(AttributeQuery attributeQuery) {
        CalendarText calendarText = CalendarText.getInstance(attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601"), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
        return calendarText.getStdMonths(textWidth, outputContext);
    }

    private Object readResolve() throws ObjectStreamException {
        String string = this.name();
        if (string.equals(this.history.yearOfEra().name())) {
            return this.history.yearOfEra();
        }
        if (string.equals(this.history.month().name())) {
            return this.history.month();
        }
        if (string.equals(this.history.dayOfMonth().name())) {
            return this.history.dayOfMonth();
        }
        throw new InvalidObjectException("Unknown element: " + string);
    }

    private static class Rule<C extends ChronoEntity<C>>
    implements ElementRule<C, Integer> {
        private final int index;
        private final ChronoHistory history;

        Rule(int n, ChronoHistory chronoHistory) {
            this.index = n;
            this.history = chronoHistory;
        }

        @Override
        public Integer getValue(C c) {
            HistoricDate historicDate = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
            switch (this.index) {
                case 2: {
                    return historicDate.getYearOfEra();
                }
                case 3: {
                    return historicDate.getMonth();
                }
                case 4: {
                    return historicDate.getDayOfMonth();
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMinimum(C c) {
            int n;
            if (this.index == 2) {
                return 1;
            }
            HistoricDate historicDate = this.adjust(c, 1);
            if (this.history.isValid(historicDate)) {
                return 1;
            }
            HistoricDate historicDate2 = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
            List<CutOverEvent> list = this.history.getEvents();
            for (n = list.size() - 1; n >= 0; --n) {
                CutOverEvent cutOverEvent = list.get(n);
                if (historicDate2.compareTo(cutOverEvent.dateAtCutOver) < 0) continue;
                historicDate = cutOverEvent.dateAtCutOver;
                break;
            }
            n = this.index == 3 ? historicDate.getMonth() : historicDate.getDayOfMonth();
            return n;
        }

        @Override
        public Integer getMaximum(C c) {
            HistoricDate historicDate;
            int n;
            HistoricDate historicDate2 = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
            switch (this.index) {
                case 2: {
                    int n2 = historicDate2.getEra() == HistoricEra.BC ? this.history.convert(PlainDate.axis().getMinimum()).getYearOfEra() : this.history.convert(PlainDate.axis().getMaximum()).getYearOfEra();
                    return n2;
                }
                case 3: {
                    n = 12;
                    historicDate = this.adjust(c, n);
                    break;
                }
                case 4: {
                    n = this.history.getAlgorithm(historicDate2).getMaximumDayOfMonth(historicDate2);
                    historicDate = this.adjust(c, n);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown element index: " + this.index);
                }
            }
            if (this.history.isValid(historicDate)) {
                return n;
            }
            List<CutOverEvent> list = this.history.getEvents();
            for (int i = list.size() - 1; i >= 0; --i) {
                CutOverEvent cutOverEvent;
                CutOverEvent cutOverEvent2 = cutOverEvent = list.get(i);
                if (historicDate2.compareTo(cutOverEvent.dateAtCutOver) >= 0) continue;
                historicDate = cutOverEvent2.dateBeforeCutOver;
                break;
            }
            n = this.index == 3 ? historicDate.getMonth() : historicDate.getDayOfMonth();
            return n;
        }

        @Override
        public boolean isValid(C c, Integer n) {
            if (n == null) {
                return false;
            }
            HistoricDate historicDate = this.adjust(c, n);
            return this.history.isValid(historicDate);
        }

        @Override
        public C withValue(C c, Integer n, boolean bl) {
            HistoricDate historicDate = this.adjust(c, n);
            return (C)((ChronoEntity)c).with((ChronoElement<PlainDate>)PlainDate.COMPONENT, (PlainDate)this.history.convert(historicDate));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        private HistoricDate adjust(C c, int n) {
            HistoricDate historicDate;
            HistoricDate historicDate2 = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
            switch (this.index) {
                case 2: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), n, historicDate2.getMonth(), historicDate2.getDayOfMonth());
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                case 3: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), historicDate2.getYearOfEra(), n, historicDate2.getDayOfMonth());
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                case 4: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), historicDate2.getYearOfEra(), historicDate2.getMonth(), n);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown element index: " + this.index);
                }
            }
            return historicDate;
        }
    }
}

