/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.util.Locale;
import net.time4j.engine.CalendarEra;
import net.time4j.format.CalendarText;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.history.ChronoHistory;

public enum HistoricEra implements CalendarEra
{
    BC,
    AD;


    @Override
    public int getValue() {
        return this.ordinal();
    }

    public String getDisplayName(Locale locale, TextWidth textWidth) {
        CalendarText calendarText = CalendarText.getInstance("iso8601", locale);
        return calendarText.getEras(textWidth).print(this);
    }

    public String getAlternativeName(Locale locale, TextWidth textWidth) {
        CalendarText calendarText = CalendarText.getInstance("iso8601", locale);
        TextElement<HistoricEra> textElement = ChronoHistory.ofFirstGregorianReform().era();
        return calendarText.getTextForms(textElement, textWidth == TextWidth.WIDE ? "w" : "a", "alt").print(this);
    }
}

