/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.format.expert.TimezoneOffsetProcessor;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

enum TimezoneIDProcessor implements FormatProcessor<TZID>
{
    INSTANCE;


    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        if (!chronoDisplay.hasTimezone()) {
            throw new IllegalArgumentException("Cannot extract timezone id from: " + chronoDisplay);
        }
        int n = -1;
        int n2 = 0;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        String string = chronoDisplay.getTimezone().canonical();
        appendable.append(string);
        n2 = string.length();
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        String string;
        char c;
        int n = charSequence.length();
        int n2 = parseLog.getPosition();
        int n3 = n2;
        if (n3 >= n) {
            parseLog.setError(n2, "Missing timezone name.");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n3 < n && ((c = charSequence.charAt(n3)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-' || c == '_' || c == '/')) {
            stringBuilder.append(c);
            ++n3;
        }
        if (!Character.isLetter(stringBuilder.charAt(stringBuilder.length() - 1))) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            --n3;
        }
        if ((string = stringBuilder.toString()).isEmpty()) {
            parseLog.setError(n2, "Missing valid timezone id.");
            return;
        }
        if (string.startsWith("Etc/GMT")) {
            parseLog.setError(n2, "Inverse Etc/GMT-Offsets are not supported, use UTC-Offsets instead.");
            return;
        }
        if (string.equals("Z")) {
            map.put(TimezoneElement.TIMEZONE_ID, ZonalOffset.UTC);
            parseLog.setPosition(n3);
            return;
        }
        if (string.equals("UTC") || string.equals("GMT") || string.equals("UT")) {
            char c2;
            if (n > n3 && ((c2 = charSequence.charAt(n3)) == '+' || c2 == '-')) {
                parseLog.setPosition(n3);
                TimezoneOffsetProcessor.EXTENDED_LONG_PARSER.parse(charSequence, parseLog, attributeQuery, map, formatStep);
                return;
            }
            map.put(TimezoneElement.TIMEZONE_ID, ZonalOffset.UTC);
            parseLog.setPosition(n3);
            return;
        }
        List<TZID> list = Timezone.getAvailableIDs();
        int n4 = 0;
        int n5 = list.size() - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            TZID tZID = list.get(n6);
            int n7 = tZID.canonical().compareTo(string);
            if (n7 < 0) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n5 = n6 - 1;
                continue;
            }
            map.put(TimezoneElement.TIMEZONE_ID, tZID);
            parseLog.setPosition(n3);
            return;
        }
        parseLog.setError(n2, "Cannot parse to timezone id: " + string);
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_ID;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }
}

