/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.FractionalElement;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;

final class FractionProcessor
implements FormatProcessor<Integer> {
    private static final Integer MRD_MINUS_1 = 999999999;
    private final FormatProcessor<Void> decimalSeparator;
    private final ChronoElement<Integer> element;
    private final int minDigits;
    private final int maxDigits;
    private final boolean fixedWidth;

    FractionProcessor(ChronoElement<Integer> chronoElement, int n, int n2, boolean bl) {
        this.element = chronoElement;
        this.minDigits = n;
        this.maxDigits = n2;
        this.fixedWidth = !bl && n == n2;
        LiteralProcessor literalProcessor = this.decimalSeparator = bl ? new LiteralProcessor(Attributes.DECIMAL_SEPARATOR) : null;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative min digits: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("Max smaller than min: " + n2 + " < " + n);
        }
        if (n > 9) {
            throw new IllegalArgumentException("Min digits out of range: " + n);
        }
        if (n2 > 9) {
            throw new IllegalArgumentException("Max digits out of range: " + n2);
        }
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2 = FractionProcessor.toDecimal(chronoDisplay.get(this.element));
        BigDecimal bigDecimal3 = FractionProcessor.toDecimal(chronoDisplay.getMinimum(this.element));
        BigDecimal bigDecimal4 = FractionProcessor.toDecimal(chronoDisplay.getMaximum(this.element));
        if (bigDecimal2.compareTo(bigDecimal4) > 0) {
            bigDecimal2 = bigDecimal4;
        }
        bigDecimal = (bigDecimal = bigDecimal2.subtract(bigDecimal3).divide(bigDecimal4.subtract(bigDecimal3).add(BigDecimal.ONE), 9, RoundingMode.FLOOR)).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : bigDecimal.stripTrailingZeros();
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        int n = -1;
        int n2 = 0;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        if (bigDecimal.scale() == 0) {
            if (this.minDigits > 0) {
                if (this.hasDecimalSeparator()) {
                    this.decimalSeparator.print(chronoDisplay, appendable, attributeQuery, set, formatStep);
                    ++n2;
                }
                for (int i = 0; i < this.minDigits; ++i) {
                    appendable.append(c);
                }
                n2 += this.minDigits;
            }
        } else {
            if (this.hasDecimalSeparator()) {
                this.decimalSeparator.print(chronoDisplay, appendable, attributeQuery, set, formatStep);
                ++n2;
            }
            int n3 = Math.min(Math.max(bigDecimal.scale(), this.minDigits), this.maxDigits);
            bigDecimal = bigDecimal.setScale(n3, RoundingMode.FLOOR);
            String string = bigDecimal.toPlainString();
            int n4 = c - 48;
            int n5 = string.length();
            for (int i = 2; i < n5; ++i) {
                char c2 = (char)(string.charAt(i) + n4);
                appendable.append(c2);
                ++n2;
            }
        }
        if (n != -1 && n2 > 1 && set != null) {
            set.add(new ElementPosition(this.element, n + 1, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n;
        Leniency leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        int n2 = 0;
        int n3 = 9;
        if (!leniency.isLax() || this.fixedWidth) {
            n2 = this.minDigits;
            n3 = this.maxDigits;
        }
        int n4 = charSequence.length();
        if (parseLog.getPosition() >= n4) {
            if (n2 > 0) {
                parseLog.setError(parseLog.getPosition(), "Expected fraction digits not found for: " + this.element.name());
            }
            return;
        }
        if (this.hasDecimalSeparator()) {
            this.decimalSeparator.parse(charSequence, parseLog, attributeQuery, null, formatStep);
            if (parseLog.isError()) {
                if (n2 == 0) {
                    parseLog.clearError();
                }
                return;
            }
        }
        int n5 = n + n2;
        int n6 = Math.min(n + n3, n4);
        if (n5 > n4) {
            parseLog.setError(parseLog.getPosition(), "Expected at least " + n2 + " digits.");
            return;
        }
        char c = formatStep.getAttribute(Attributes.ZERO_DIGIT, attributeQuery, Character.valueOf('0')).charValue();
        long l = 0L;
        for (n = parseLog.getPosition(); n < n6; ++n) {
            int n7 = charSequence.charAt(n) - c;
            if (n7 >= 0 && n7 <= 9) {
                l = l * 10L + (long)n7;
                continue;
            }
            if (n >= n5) break;
            parseLog.setError(parseLog.getPosition(), "Expected at least " + n2 + " digits.");
            return;
        }
        BigDecimal bigDecimal = new BigDecimal(l);
        bigDecimal = bigDecimal.movePointLeft(n - parseLog.getPosition());
        if (this.element.name().equals("NANO_OF_SECOND")) {
            Integer n8 = 0;
            Integer n9 = MRD_MINUS_1;
            Integer n10 = this.getRealValue(bigDecimal, n8, n9);
            map.put(this.element, n10);
        } else {
            map.put(FractionalElement.FRACTION, bigDecimal);
            map.put(this.element, this.element.getDefaultMinimum());
        }
        parseLog.setPosition(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FractionProcessor) {
            FractionProcessor fractionProcessor = (FractionProcessor)object;
            return this.element.equals(fractionProcessor.element) && this.minDigits == fractionProcessor.minDigits && this.maxDigits == fractionProcessor.maxDigits && this.hasDecimalSeparator() == fractionProcessor.hasDecimalSeparator();
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.minDigits + this.maxDigits * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", min-digits=");
        stringBuilder.append(this.minDigits);
        stringBuilder.append(", max-digits=");
        stringBuilder.append(this.maxDigits);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Integer> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<Integer> withElement(ChronoElement<Integer> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new FractionProcessor(chronoElement, this.minDigits, this.maxDigits, this.hasDecimalSeparator());
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    <T extends ChronoEntity<T>> T update(T t, ParsedValues parsedValues) {
        if (!parsedValues.contains(FractionalElement.FRACTION)) {
            return t;
        }
        BigDecimal bigDecimal = parsedValues.get(FractionalElement.FRACTION);
        Integer n = t.getMinimum(this.element);
        Integer n2 = t.getMaximum(this.element);
        Integer n3 = this.getRealValue(bigDecimal, n, n2);
        parsedValues.with((ChronoElement)FractionalElement.FRACTION, (Object)null);
        parsedValues.with((ChronoElement)this.element, n3);
        return t.with(this.element, (Integer)n3);
    }

    private Integer getRealValue(BigDecimal bigDecimal, Integer n, Integer n2) {
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n.intValue());
        BigDecimal bigDecimal3 = BigDecimal.valueOf(n2.intValue()).subtract(bigDecimal2).add(BigDecimal.ONE);
        BigDecimal bigDecimal4 = bigDecimal.multiply(bigDecimal3).setScale(0, RoundingMode.FLOOR).add(bigDecimal2);
        return bigDecimal4.intValueExact();
    }

    private static BigDecimal toDecimal(Number number) {
        return BigDecimal.valueOf(number.longValue());
    }

    private boolean hasDecimalSeparator() {
        return this.decimalSeparator != null;
    }
}

