/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.Serializable;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.format.CalendarType;
import net.time4j.tz.model.DayOfWeekInMonthPattern;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.FixedDayPattern;
import net.time4j.tz.model.LastWeekdayPattern;
import net.time4j.tz.model.OffsetIndicator;

@CalendarType(value="iso8601")
public class GregorianTimezoneRule
extends DaylightSavingRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient byte month;

    protected GregorianTimezoneRule(Month month, PlainTime plainTime, OffsetIndicator offsetIndicator, int n) {
        super(plainTime, offsetIndicator, n);
        this.month = (byte)month.getValue();
    }

    public static GregorianTimezoneRule ofFixedDay(Month month, int n, PlainTime plainTime, OffsetIndicator offsetIndicator, int n2) {
        return new FixedDayPattern(month, n, plainTime, offsetIndicator, n2);
    }

    public static GregorianTimezoneRule ofLastWeekday(Month month, Weekday weekday, PlainTime plainTime, OffsetIndicator offsetIndicator, int n) {
        return new LastWeekdayPattern(month, weekday, plainTime, offsetIndicator, n);
    }

    public static GregorianTimezoneRule ofWeekdayAfterDate(Month month, int n, Weekday weekday, PlainTime plainTime, OffsetIndicator offsetIndicator, int n2) {
        return new DayOfWeekInMonthPattern(month, n, weekday, plainTime, offsetIndicator, n2, true);
    }

    public static GregorianTimezoneRule ofWeekdayBeforeDate(Month month, int n, Weekday weekday, PlainTime plainTime, OffsetIndicator offsetIndicator, int n2) {
        return new DayOfWeekInMonthPattern(month, n, weekday, plainTime, offsetIndicator, n2, false);
    }

    @Override
    public PlainDate getDate(int n) {
        throw new AbstractMethodError("Implemented by subclasses.");
    }

    public Month getMonth() {
        return Month.valueOf(this.month);
    }

    @Override
    protected int toCalendarYear(long l) {
        return GregorianMath.readYear(GregorianMath.toPackedDate(l));
    }

    @Override
    protected int toCalendarYear(GregorianDate gregorianDate) {
        return gregorianDate.getYear();
    }

    @Override
    protected String getCalendarType() {
        return "iso8601";
    }

    boolean isEqual(GregorianTimezoneRule gregorianTimezoneRule) {
        return this.getTimeOfDay().equals(gregorianTimezoneRule.getTimeOfDay()) && this.getIndicator() == gregorianTimezoneRule.getIndicator() && this.getSavings() == gregorianTimezoneRule.getSavings() && this.month == gregorianTimezoneRule.month;
    }

    byte getMonthValue() {
        return this.month;
    }
}

