/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.time4j.format.PluralCategory;
import net.time4j.format.TextWidth;
import net.time4j.format.UnitPatternProvider;
import net.time4j.i18n.UTF8ResourceBundle;
import net.time4j.i18n.UTF8ResourceControl;

public final class UnitPatternProviderSPI
implements UnitPatternProvider {
    @Override
    public String getYearPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'Y', textWidth, pluralCategory);
    }

    @Override
    public String getMonthPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'M', textWidth, pluralCategory);
    }

    @Override
    public String getWeekPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'W', textWidth, pluralCategory);
    }

    @Override
    public String getDayPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'D', textWidth, pluralCategory);
    }

    @Override
    public String getHourPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'H', textWidth, pluralCategory);
    }

    @Override
    public String getMinutePattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'N', textWidth, pluralCategory);
    }

    @Override
    public String getSecondPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, 'S', textWidth, pluralCategory);
    }

    @Override
    public String getMilliPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, '3', textWidth, pluralCategory);
    }

    @Override
    public String getMicroPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, '6', textWidth, pluralCategory);
    }

    @Override
    public String getNanoPattern(Locale locale, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getUnitPattern(locale, '9', textWidth, pluralCategory);
    }

    @Override
    public String getYearPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'Y', bl, pluralCategory);
    }

    @Override
    public String getMonthPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'M', bl, pluralCategory);
    }

    @Override
    public String getWeekPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'W', bl, pluralCategory);
    }

    @Override
    public String getDayPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'D', bl, pluralCategory);
    }

    @Override
    public String getHourPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'H', bl, pluralCategory);
    }

    @Override
    public String getMinutePattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'N', bl, pluralCategory);
    }

    @Override
    public String getSecondPattern(Locale locale, boolean bl, PluralCategory pluralCategory) {
        return this.getRelativePattern(locale, 'S', bl, pluralCategory);
    }

    @Override
    public String getNowWord(Locale locale) {
        return this.getPattern(locale, "reltime/pattern", "now", null, PluralCategory.OTHER);
    }

    @Override
    public String getListPattern(Locale locale, TextWidth textWidth, int n) {
        String string;
        String string2;
        ResourceBundle.Control control;
        if (n < 2) {
            throw new IllegalArgumentException("Size must be greater than 1.");
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("units/pattern", locale, classLoader, control = UTF8ResourceControl.SINGLETON);
        if (resourceBundle.containsKey(string2 = UnitPatternProviderSPI.buildListKey(textWidth, String.valueOf(n)))) {
            return resourceBundle.getString(string2);
        }
        String string3 = resourceBundle.getString(UnitPatternProviderSPI.buildListKey(textWidth, "end"));
        if (n == 2) {
            return string3;
        }
        String string4 = resourceBundle.getString(UnitPatternProviderSPI.buildListKey(textWidth, "start"));
        String string5 = resourceBundle.getString(UnitPatternProviderSPI.buildListKey(textWidth, "middle"));
        string3 = UnitPatternProviderSPI.replace(string3, '1', n - 1);
        String string6 = string = (string3 = UnitPatternProviderSPI.replace(string3, '0', n - 2));
        for (int i = n - 3; i >= 0; --i) {
            String string7 = i == 0 ? string4 : string5;
            int n2 = -1;
            int n3 = string7.length();
            for (int j = n3 - 1; j >= 0; --j) {
                if (j < 2 || string7.charAt(j) != '}' || string7.charAt(j - 1) != '1' || string7.charAt(j - 2) != '{') continue;
                n2 = j - 2;
                break;
            }
            if (n2 > -1) {
                string6 = string7.substring(0, n2) + string;
                if (n2 < n3 - 3) {
                    string6 = string6 + string7.substring(n2 + 3);
                }
            }
            if (i <= 0) continue;
            string = UnitPatternProviderSPI.replace(string6, '0', i);
        }
        return string6;
    }

    private String getUnitPattern(Locale locale, char c, TextWidth textWidth, PluralCategory pluralCategory) {
        return this.getPattern(locale, "units/pattern", UnitPatternProviderSPI.buildKey(c, textWidth, pluralCategory), UnitPatternProviderSPI.buildKey(c, textWidth, PluralCategory.OTHER), pluralCategory);
    }

    private String getRelativePattern(Locale locale, char c, boolean bl, PluralCategory pluralCategory) {
        return this.getPattern(locale, "reltime/pattern", UnitPatternProviderSPI.buildKey(c, bl, pluralCategory), UnitPatternProviderSPI.buildKey(c, bl, PluralCategory.OTHER), pluralCategory);
    }

    private String getPattern(Locale locale, String string, String string2, String string3, PluralCategory pluralCategory) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ResourceBundle.Control control = UTF8ResourceControl.SINGLETON;
        boolean bl = true;
        ResourceBundle resourceBundle = null;
        for (Locale locale2 : control.getCandidateLocales(string, locale)) {
            UTF8ResourceBundle uTF8ResourceBundle;
            ResourceBundle resourceBundle2;
            ResourceBundle resourceBundle3 = resourceBundle2 = bl && resourceBundle != null ? resourceBundle : ResourceBundle.getBundle(string, locale2, classLoader, control);
            if (bl) {
                if (locale2.equals(resourceBundle2.getLocale())) {
                    bl = false;
                } else {
                    resourceBundle = resourceBundle2;
                    continue;
                }
            }
            if ((uTF8ResourceBundle = (UTF8ResourceBundle)UTF8ResourceBundle.class.cast(resourceBundle2)).getInternalKeys().contains(string2)) {
                return uTF8ResourceBundle.getString(string2);
            }
            if (pluralCategory == PluralCategory.OTHER || !uTF8ResourceBundle.getInternalKeys().contains(string3)) continue;
            return uTF8ResourceBundle.getString(string3);
        }
        throw new MissingResourceException("Can't find resource for bundle " + string + ".properties, key " + string2, string + ".properties", string2);
    }

    private static String buildKey(char c, TextWidth textWidth, PluralCategory pluralCategory) {
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(c);
        switch (textWidth) {
            case WIDE: {
                stringBuilder.append('w');
                break;
            }
            case ABBREVIATED: 
            case SHORT: {
                stringBuilder.append('s');
                break;
            }
            case NARROW: {
                stringBuilder.append('n');
                break;
            }
            default: {
                throw new UnsupportedOperationException(textWidth.name());
            }
        }
        return stringBuilder.append(pluralCategory.ordinal()).toString();
    }

    private static String buildKey(char c, boolean bl, PluralCategory pluralCategory) {
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append(c);
        stringBuilder.append(bl ? (char)'+' : '-');
        return stringBuilder.append(pluralCategory.ordinal()).toString();
    }

    private static String buildListKey(TextWidth textWidth, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('L');
        switch (textWidth) {
            case WIDE: {
                stringBuilder.append('w');
                break;
            }
            case ABBREVIATED: 
            case SHORT: {
                stringBuilder.append('s');
                break;
            }
            case NARROW: {
                stringBuilder.append('n');
                break;
            }
            default: {
                throw new UnsupportedOperationException(textWidth.name());
            }
        }
        return stringBuilder.append('-').append(string).toString();
    }

    private static String replace(String string, char c, int n) {
        int n2 = string.length() - 2;
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != '{' || string.charAt(i + 1) != c || string.charAt(i + 2) != '}') continue;
            StringBuilder stringBuilder = new StringBuilder(n2 + 10);
            stringBuilder.append(string);
            stringBuilder.replace(i + 1, i + 2, String.valueOf(n));
            return stringBuilder.toString();
        }
        return string;
    }
}

