/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.i18n.UTF8ResourceControl;

public final class SymbolProviderSPI
implements NumberSymbolProvider {
    @Override
    public Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    @Override
    public char getZeroDigit(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "zero", SymbolProviderSPI.getSymbols(locale).getZeroDigit());
    }

    @Override
    public char getDecimalSeparator(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "separator", SymbolProviderSPI.getSymbols(locale).getDecimalSeparator());
    }

    @Override
    public String getMinusSign(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "minus", String.valueOf(SymbolProviderSPI.getSymbols(locale).getMinusSign()));
    }

    public String toString() {
        return "SymbolProviderSPI";
    }

    private static DecimalFormatSymbols getSymbols(Locale locale) {
        return DecimalFormatSymbols.getInstance(locale);
    }

    private static char lookup(Locale locale, String string, char c) {
        ResourceBundle resourceBundle = SymbolProviderSPI.getBundle(locale);
        if (resourceBundle != null && resourceBundle.containsKey(string)) {
            return resourceBundle.getString(string).charAt(0);
        }
        return c;
    }

    private static String lookup(Locale locale, String string, String string2) {
        ResourceBundle resourceBundle = SymbolProviderSPI.getBundle(locale);
        if (resourceBundle != null && resourceBundle.containsKey(string)) {
            return resourceBundle.getString(string);
        }
        return string2;
    }

    private static ResourceBundle getBundle(Locale locale) {
        try {
            return ResourceBundle.getBundle("numbers/symbol", locale, SymbolProviderSPI.getLoader(), UTF8ResourceControl.SINGLETON);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static ClassLoader getLoader() {
        return SymbolProviderSPI.class.getClassLoader();
    }
}

