/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumericalElement;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

final class HistoricalEraElement
extends BasicElement<HistoricEra>
implements NumericalElement<HistoricEra>,
TextElement<HistoricEra> {
    private static final long serialVersionUID = 5200533417265981438L;
    private static final Locale LATIN = new Locale("la");
    private final ChronoHistory history;

    HistoricalEraElement(ChronoHistory chronoHistory) {
        super("ERA");
        this.history = chronoHistory;
    }

    @Override
    public Class<HistoricEra> getType() {
        return HistoricEra.class;
    }

    @Override
    public char getSymbol() {
        return 'G';
    }

    @Override
    public HistoricEra getDefaultMinimum() {
        return HistoricEra.BC;
    }

    @Override
    public HistoricEra getDefaultMaximum() {
        return HistoricEra.AD;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public int numerical(HistoricEra historicEra) {
        return historicEra.getValue();
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        appendable.append(this.accessor(attributeQuery).print(chronoDisplay.get(this)));
    }

    @Override
    public HistoricEra parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        return this.accessor(attributeQuery).parse(charSequence, parsePosition, this.getType(), attributeQuery);
    }

    @Override
    protected <T extends ChronoEntity<T>> ElementRule<T, HistoricEra> derive(Chronology<T> chronology) {
        if (chronology.isRegistered(PlainDate.COMPONENT)) {
            return new Rule(this.history);
        }
        return null;
    }

    private TextAccessor accessor(AttributeQuery attributeQuery) {
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        if (attributeQuery.get(ChronoHistory.ATTRIBUTE_LATIN_ERA, Boolean.FALSE).booleanValue()) {
            CalendarText calendarText = CalendarText.getInstance("historic", LATIN);
            return calendarText.getTextForms(this, textWidth == TextWidth.WIDE ? "w" : "a");
        }
        CalendarText calendarText = CalendarText.getInstance(attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601"), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        if (attributeQuery.get(ChronoHistory.ATTRIBUTE_COMMON_ERA, Boolean.FALSE).booleanValue()) {
            return calendarText.getTextForms(this, textWidth == TextWidth.WIDE ? "w" : "a", "alt");
        }
        return calendarText.getEras(textWidth);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.history.era();
    }

    private static class Rule<C extends ChronoEntity<C>>
    implements ElementRule<C, HistoricEra> {
        private final ChronoHistory history;

        Rule(ChronoHistory chronoHistory) {
            this.history = chronoHistory;
        }

        @Override
        public HistoricEra getValue(C c) {
            return this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT)).getEra();
        }

        @Override
        public HistoricEra getMinimum(C c) {
            return HistoricEra.BC;
        }

        @Override
        public HistoricEra getMaximum(C c) {
            return HistoricEra.AD;
        }

        @Override
        public boolean isValid(C c, HistoricEra historicEra) {
            if (historicEra == null) {
                return false;
            }
            HistoricDate historicDate = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
            HistoricDate historicDate2 = HistoricDate.of(historicEra, historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
            historicDate2 = this.history.adjustDayOfMonth(historicDate2);
            return this.history.isValid(historicDate2);
        }

        @Override
        public C withValue(C c, HistoricEra historicEra, boolean bl) {
            HistoricDate historicDate = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
            HistoricDate historicDate2 = HistoricDate.of(historicEra, historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
            historicDate2 = this.history.adjustDayOfMonth(historicDate2);
            return (C)((ChronoEntity)c).with((ChronoElement<PlainDate>)PlainDate.COMPONENT, (PlainDate)this.history.convert(historicDate2));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(C c) {
            throw new UnsupportedOperationException("Never called.");
        }
    }
}

