/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.base.GregorianMath;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.JulianMath;

enum CalendarAlgorithm {
    GREGORIAN{

        @Override
        long toMJD(HistoricDate historicDate) {
            return GregorianMath.toMJD(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        HistoricDate fromMJD(long l) {
            long l2 = GregorianMath.toPackedDate(l);
            int n = GregorianMath.readYear(l2);
            int n2 = GregorianMath.readMonth(l2);
            int n3 = GregorianMath.readDayOfMonth(l2);
            return new HistoricDate(n <= 0 ? HistoricEra.BC : HistoricEra.AD, n <= 0 ? 1 - n : n, n2, n3);
        }

        @Override
        boolean isValid(HistoricDate historicDate) {
            return GregorianMath.isValid(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        int getMaximumDayOfMonth(HistoricDate historicDate) {
            return GregorianMath.getLengthOfMonth(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth());
        }
    }
    ,
    JULIAN{

        @Override
        long toMJD(HistoricDate historicDate) {
            return JulianMath.toMJD(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        HistoricDate fromMJD(long l) {
            long l2 = JulianMath.toPackedDate(l);
            int n = JulianMath.readYear(l2);
            int n2 = JulianMath.readMonth(l2);
            int n3 = JulianMath.readDayOfMonth(l2);
            return new HistoricDate(n <= 0 ? HistoricEra.BC : HistoricEra.AD, n <= 0 ? 1 - n : n, n2, n3);
        }

        @Override
        boolean isValid(HistoricDate historicDate) {
            int n = CalendarAlgorithm.getProlepticYear(historicDate);
            int n2 = historicDate.getMonth();
            int n3 = historicDate.getDayOfMonth();
            if (n < -999979466 || n == -999979466 && (n2 < 11 || n2 == 11 && n3 < 21)) {
                return false;
            }
            return JulianMath.isValid(n, n2, n3);
        }

        @Override
        int getMaximumDayOfMonth(HistoricDate historicDate) {
            return JulianMath.getLengthOfMonth(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth());
        }
    }
    ,
    SWEDISH{

        @Override
        long toMJD(HistoricDate historicDate) {
            if (historicDate.getDayOfMonth() == 30 && historicDate.getMonth() == 2 && historicDate.getYearOfEra() == 1712 && historicDate.getEra() == HistoricEra.AD) {
                return -53576L;
            }
            return JulianMath.toMJD(historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth()) - 1L;
        }

        @Override
        HistoricDate fromMJD(long l) {
            if (l == -53576L) {
                return new HistoricDate(HistoricEra.AD, 1712, 2, 30);
            }
            return JULIAN.fromMJD(l + 1L);
        }

        @Override
        boolean isValid(HistoricDate historicDate) {
            if (historicDate.getDayOfMonth() == 30 && historicDate.getMonth() == 2 && historicDate.getYearOfEra() == 1712 && historicDate.getEra() == HistoricEra.AD) {
                return true;
            }
            return JulianMath.isValid(historicDate.getYearOfEra(), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        int getMaximumDayOfMonth(HistoricDate historicDate) {
            if (historicDate.getMonth() == 2 && historicDate.getYearOfEra() == 1712 && historicDate.getEra() == HistoricEra.AD) {
                return 30;
            }
            return JulianMath.getLengthOfMonth(historicDate.getYearOfEra(), historicDate.getMonth());
        }
    };


    abstract long toMJD(HistoricDate var1);

    abstract HistoricDate fromMJD(long var1);

    abstract boolean isValid(HistoricDate var1);

    abstract int getMaximumDayOfMonth(HistoricDate var1);

    private static int getProlepticYear(HistoricDate historicDate) {
        return historicDate.getEra() == HistoricEra.AD ? historicDate.getYearOfEra() : 1 - historicDate.getYearOfEra();
    }
}

