/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.text.Normalizer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import net.time4j.format.OutputContext;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.i18n.UTF8ResourceControl;

public final class GenericTextProviderSPI
implements TextProvider {
    private static final Set<String> LANGUAGES;
    private static final Set<Locale> LOCALES;
    private static final ResourceBundle.Control CONTROL;

    @Override
    public String[] getSupportedCalendarTypes() {
        return new String[]{"islamic"};
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LOCALES.toArray(new Locale[LOCALES.size()]);
    }

    @Override
    public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
        ResourceBundle resourceBundle = GenericTextProviderSPI.getBundle(string, locale);
        if (resourceBundle != null) {
            String[] stringArray;
            boolean bl2;
            String string2 = GenericTextProviderSPI.getKey(resourceBundle, "MONTH_OF_YEAR");
            boolean bl3 = bl2 = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone"));
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = bl2 ? GenericTextProviderSPI.lookupBundle(resourceBundle, 12, string2, textWidth, outputContext, bl) : GenericTextProviderSPI.lookupBundle(resourceBundle, 12, string2, textWidth, bl)) == null) {
                if (textWidth == TextWidth.NARROW) {
                    stringArray = this.months(string, locale, TextWidth.ABBREVIATED, outputContext, bl);
                    if (stringArray == null) {
                        if (bl2) {
                            stringArray = this.months(string, locale, textWidth, OutputContext.FORMAT, bl);
                        }
                        if (stringArray == null) {
                            throw new MissingResourceException("Cannot find calendar month.", GenericTextProviderSPI.class.getName(), locale.toString());
                        }
                    }
                    return GenericTextProviderSPI.narrow(stringArray, 12);
                }
                if (bl2) {
                    stringArray = this.months(string, locale, textWidth, OutputContext.FORMAT, bl);
                }
                if (stringArray == null) {
                    throw new MissingResourceException("Cannot find calendar month.", GenericTextProviderSPI.class.getName(), locale.toString());
                }
            }
            return stringArray;
        }
        if (textWidth == TextWidth.WIDE) {
            return new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
        }
        return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
    }

    @Override
    public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return new String[]{"1", "2", "3", "4"};
    }

    @Override
    public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return new String[]{"1", "2", "3", "4", "5", "6", "7"};
    }

    @Override
    public String[] eras(String string, Locale locale, TextWidth textWidth) {
        String[] stringArray;
        ResourceBundle resourceBundle = GenericTextProviderSPI.getBundle(string, locale);
        if (resourceBundle != null) {
            String string2;
            String[] stringArray2;
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray2 = GenericTextProviderSPI.lookupBundle(resourceBundle, 1, string2 = GenericTextProviderSPI.getKey(resourceBundle, "ERA"), textWidth, false)) != null) {
                return stringArray2;
            }
            if (textWidth == TextWidth.NARROW) {
                return GenericTextProviderSPI.narrow(this.eras(string, locale, TextWidth.ABBREVIATED), 1);
            }
            throw new MissingResourceException("Cannot find calendar resource for era.", GenericTextProviderSPI.class.getName(), locale.toString());
        }
        if (textWidth == TextWidth.WIDE) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "Anno Hegirae";
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "AH";
        }
        return stringArray;
    }

    @Override
    public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
        return new String[]{"AM", "PM"};
    }

    @Override
    public ResourceBundle.Control getControl() {
        return CONTROL;
    }

    public String toString() {
        return "GenericTextProviderSPI";
    }

    private static String[] narrow(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = !stringArray[i].isEmpty() ? GenericTextProviderSPI.toSingleLetter(stringArray[i]) : String.valueOf(i + 1);
        }
        return stringArray2;
    }

    private static String toSingleLetter(String string) {
        char c = Normalizer.normalize(string, Normalizer.Form.NFD).charAt(0);
        if (c >= 'A' && c <= 'Z') {
            return String.valueOf(c);
        }
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
            return String.valueOf(c);
        }
        if (c >= '\u0410' && c <= '\u042f') {
            return String.valueOf(c);
        }
        if (c >= '\u0430' && c <= '\u044f') {
            c = (char)(c - 32);
            return String.valueOf(c);
        }
        return string;
    }

    private static ResourceBundle getBundle(String string, Locale locale) throws MissingResourceException {
        if (LANGUAGES.contains(locale.getLanguage())) {
            return ResourceBundle.getBundle("calendar/" + string, locale, GenericTextProviderSPI.getDefaultLoader(), CONTROL);
        }
        return null;
    }

    private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth, boolean bl) {
        return GenericTextProviderSPI.lookupBundle(resourceBundle, n, string, textWidth, null, bl);
    }

    private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth, OutputContext outputContext, boolean bl) {
        String[] stringArray = new String[n];
        boolean bl2 = string.length() == 1;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('(');
            if (bl2) {
                char c = textWidth.name().charAt(0);
                if (outputContext != OutputContext.STANDALONE) {
                    c = Character.toLowerCase(c);
                }
                stringBuilder.append(c);
            } else {
                stringBuilder.append(textWidth.name());
                if (outputContext == OutputContext.STANDALONE) {
                    stringBuilder.append('|');
                    stringBuilder.append(outputContext.name());
                }
                if (bl) {
                    stringBuilder.append('|');
                    stringBuilder.append("LEAP");
                }
            }
            stringBuilder.append(')');
            stringBuilder.append('_');
            stringBuilder.append(i + 1);
            String string2 = stringBuilder.toString();
            if (!resourceBundle.containsKey(string2)) {
                return null;
            }
            stringArray[i] = resourceBundle.getString(string2);
        }
        return stringArray;
    }

    private static String getKey(ResourceBundle resourceBundle, String string) {
        if (resourceBundle.containsKey("useShortKeys") && "true".equals(resourceBundle.getString("useShortKeys"))) {
            return string.substring(0, 1);
        }
        return string;
    }

    private static ClassLoader getDefaultLoader() {
        return GenericTextProviderSPI.class.getClassLoader();
    }

    static {
        CONTROL = new UTF8ResourceControl(){

            @Override
            protected String getModuleName() {
                return "calendar";
            }

            @Override
            protected Class<?> getModuleRef() {
                return GenericTextProviderSPI.class;
            }
        };
        ResourceBundle resourceBundle = ResourceBundle.getBundle("calendar/islamic", Locale.ROOT, GenericTextProviderSPI.getDefaultLoader(), CONTROL);
        String[] stringArray = resourceBundle.getString("languages").split(" ");
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, stringArray);
        hashSet.add("");
        LANGUAGES = Collections.unmodifiableSet(hashSet);
        HashSet<Locale> hashSet2 = new HashSet<Locale>();
        for (String string : LANGUAGES) {
            if (string.isEmpty()) {
                hashSet2.add(Locale.ROOT);
                continue;
            }
            hashSet2.add(new Locale(string));
        }
        LOCALES = Collections.unmodifiableSet(hashSet2);
    }
}

