/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.time4j.PlainDate;
import net.time4j.base.ResourceLoader;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HijriEra;
import net.time4j.calendar.MonthBasedCalendarSystem;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.EpochDays;
import net.time4j.format.expert.Iso8601Format;

final class AstronomicalHijriData
implements MonthBasedCalendarSystem<HijriCalendar> {
    static final AstronomicalHijriData UMALQURA;
    private final String variant;
    private final String version;
    private final int minYear;
    private final int maxYear;
    private final long minUTC;
    private final long maxUTC;
    private final int[] lengthOfMonth;
    private final long[] firstOfMonth;

    AstronomicalHijriData(String string) throws IOException {
        this.variant = string;
        String string2 = "data/" + string.replace('-', '_') + ".data";
        URI uRI = ResourceLoader.getInstance().locate("calendar", AstronomicalHijriData.class, string2);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream != null) {
            try {
                int n;
                int n2;
                Properties properties = new Properties();
                properties.load(inputStream);
                String string3 = properties.getProperty("type");
                if (!string.equals(string3)) {
                    throw new IOException("Wrong hijri variant: expected=" + string + ", found=" + string3);
                }
                this.version = properties.getProperty("version", "1.0");
                String string4 = properties.getProperty("iso-start", "");
                PlainDate plainDate = (PlainDate)Iso8601Format.EXTENDED_CALENDAR_DATE.parse(string4);
                this.minUTC = plainDate.get(EpochDays.UTC);
                this.minYear = n2 = Integer.parseInt(properties.getProperty("min", "1"));
                this.maxYear = n = Integer.parseInt(properties.getProperty("max", "0"));
                int n3 = (n - n2 + 1) * 12;
                long l = this.minUTC - 1L;
                int[] nArray = new int[n3];
                long[] lArray = new long[n3];
                int n4 = 0;
                long l2 = this.minUTC;
                for (int i = n2; i <= n; ++i) {
                    String string5 = properties.getProperty(String.valueOf(i));
                    if (string5 == null) {
                        throw new IOException("Wrong file format: " + string2 + " (missing year=" + i + ")");
                    }
                    String[] stringArray = string5.split(" ");
                    if (stringArray.length != 12) {
                        throw new IOException("Wrong file format: " + string2 + " (incomplete year=" + i + ")");
                    }
                    for (int j = 0; j < 12; ++j) {
                        nArray[n4] = Integer.parseInt(stringArray[j]);
                        l += (long)nArray[n4];
                        lArray[n4] = l2;
                        l2 += (long)nArray[n4];
                        ++n4;
                    }
                }
                this.maxUTC = l;
                this.lengthOfMonth = nArray;
                this.firstOfMonth = lArray;
            }
            catch (ParseException parseException) {
                throw new IOException("Wrong file format: " + string2, parseException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Wrong file format: " + string2, numberFormatException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        throw new FileNotFoundException(string2);
    }

    @Override
    public HijriCalendar transform(long l) {
        int n = AstronomicalHijriData.search(l, this.firstOfMonth);
        if (n >= 0 && (n < this.firstOfMonth.length - 1 || this.firstOfMonth[n] + (long)this.lengthOfMonth[n] > l)) {
            int n2 = n / 12 + this.minYear;
            int n3 = n % 12 + 1;
            int n4 = (int)(l - this.firstOfMonth[n] + 1L);
            return HijriCalendar.of(this.variant, n2, n3, n4);
        }
        throw new IllegalArgumentException("Out of range: " + l);
    }

    @Override
    public long transform(HijriCalendar hijriCalendar) {
        if (!hijriCalendar.getVariant().equals(this.variant)) {
            throw new IllegalArgumentException("Given date does not belong to this calendar system: " + hijriCalendar + " (calendar variants are different).");
        }
        int n = (hijriCalendar.getYear() - this.minYear) * 12 + hijriCalendar.getMonth().getValue() - 1;
        return this.firstOfMonth[n] + (long)hijriCalendar.getDayOfMonth() - 1L;
    }

    @Override
    public long getMinimumSinceUTC() {
        return this.minUTC;
    }

    @Override
    public long getMaximumSinceUTC() {
        return this.maxUTC;
    }

    @Override
    public List<CalendarEra> getEras() {
        HijriEra hijriEra = HijriEra.ANNO_HEGIRAE;
        return Collections.singletonList(hijriEra);
    }

    @Override
    public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
        return calendarEra == HijriEra.ANNO_HEGIRAE && n >= this.minYear && n <= this.maxYear && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
    }

    @Override
    public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
        if (calendarEra != HijriEra.ANNO_HEGIRAE) {
            throw new IllegalArgumentException("Wrong era: " + calendarEra);
        }
        int n3 = (n - this.minYear) * 12 + n2 - 1;
        if (n3 < 0 || n3 >= this.lengthOfMonth.length) {
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + n2);
        }
        return this.lengthOfMonth[n3];
    }

    private static int search(long l, long[] lArray) {
        int n = 0;
        int n2 = lArray.length - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            if (lArray[n3] <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n - 1;
    }

    static {
        try {
            UMALQURA = new AstronomicalHijriData("islamic-umalqura");
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }
}

