/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.base;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ServiceLoader;

public abstract class ResourceLoader {
    public static final String EXTERNAL_RESOURCE_LOADER = "net.time4j.base.ResourceLoader";
    private static final boolean ANDROID = "Dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"));
    private static final ResourceLoader INSTANCE;

    protected ResourceLoader() {
    }

    public static ResourceLoader getInstance() {
        return INSTANCE;
    }

    public abstract URI locate(String var1, Class<?> var2, String var3);

    public abstract InputStream load(URI var1, boolean var2);

    public abstract <S> Iterable<S> services(Class<S> var1);

    static {
        String string = System.getProperty(EXTERNAL_RESOURCE_LOADER);
        if (string == null) {
            INSTANCE = new StdResourceLoader();
        } else {
            try {
                INSTANCE = (ResourceLoader)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("Wrong configuration of external resource loader: " + exception.getMessage()));
            }
        }
    }

    private static class StdResourceLoader
    extends ResourceLoader {
        protected StdResourceLoader() {
            if (ANDROID) {
                throw new IllegalStateException("The module time4j-android is not active. Check your configuration.");
            }
        }

        @Override
        public URI locate(String string, Class<?> clazz, String string2) {
            Object object;
            String string3 = null;
            try {
                CodeSource codeSource;
                object = clazz.getProtectionDomain();
                CodeSource codeSource2 = codeSource = object == null ? null : ((ProtectionDomain)object).getCodeSource();
                if (codeSource != null) {
                    string3 = codeSource.getLocation().toExternalForm();
                    if (string3.endsWith(".jar")) {
                        string3 = "jar:" + string3 + "!/";
                    }
                    string3 = string3 + string2;
                    return new URI(string3);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (URISyntaxException uRISyntaxException) {
                System.err.println("Warning: malformed resource path = " + string3);
            }
            try {
                object = clazz.getClassLoader().getResource(string2);
                if (object != null) {
                    return ((URL)object).toURI();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public InputStream load(URI uRI, boolean bl) {
            if (uRI == null) {
                return null;
            }
            try {
                URL uRL = uRI.toURL();
                if (bl) {
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    uRLConnection.connect();
                    return uRLConnection.getInputStream();
                }
                return uRL.openStream();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public <S> Iterable<S> services(Class<S> clazz) {
            return ServiceLoader.load(clazz, clazz.getClassLoader());
        }
    }
}

