/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.OverflowUnit;
import net.time4j.PlainTimestamp;
import net.time4j.SystemClock;
import net.time4j.UnitPatterns;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.TimeSpan;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralRules;
import net.time4j.format.TextWidth;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class PrettyTime {
    private static final NumberSymbolProvider NUMBER_SYMBOLS;
    private static final int MIO = 1000000;
    private static final ConcurrentMap<Locale, PrettyTime> LANGUAGE_MAP;
    private static final IsoUnit[] STD_UNITS;
    private static final IsoUnit[] TSP_UNITS;
    private static final Set<IsoUnit> SUPPORTED_UNITS;
    private final PluralRules rules;
    private final Locale locale;
    private final TimeSource<?> refClock;
    private final char zeroDigit;
    private final IsoUnit emptyUnit;
    private final String minusSign;
    private final boolean weekToDays;

    private PrettyTime(Locale locale, TimeSource<?> timeSource, char c, String string, IsoUnit isoUnit, boolean bl) {
        if (isoUnit == null) {
            throw new NullPointerException("Missing zero time unit.");
        }
        if (timeSource == null) {
            throw new NullPointerException("Missing reference clock.");
        }
        this.rules = PluralRules.of(locale, NumberType.CARDINALS);
        this.locale = locale;
        this.refClock = timeSource;
        this.zeroDigit = c;
        this.emptyUnit = isoUnit;
        this.minusSign = string;
        this.weekToDays = bl;
    }

    public static PrettyTime of(Locale locale) {
        PrettyTime prettyTime;
        PrettyTime prettyTime2 = (PrettyTime)LANGUAGE_MAP.get(locale);
        if (prettyTime2 == null && (prettyTime = LANGUAGE_MAP.putIfAbsent(locale, prettyTime2 = new PrettyTime(locale, SystemClock.INSTANCE, NUMBER_SYMBOLS.getZeroDigit(locale), NUMBER_SYMBOLS.getMinusSign(locale), ClockUnit.SECONDS, false))) != null) {
            prettyTime2 = prettyTime;
        }
        return prettyTime2;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeSource<?> getReferenceClock() {
        return this.refClock;
    }

    public PrettyTime withReferenceClock(TimeSource<?> timeSource) {
        return new PrettyTime(this.locale, timeSource, this.zeroDigit, this.minusSign, this.emptyUnit, this.weekToDays);
    }

    public PrettyTime withZeroDigit(char c) {
        if (this.zeroDigit == c) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, c, this.minusSign, this.emptyUnit, this.weekToDays);
    }

    public PrettyTime withMinusSign(String string) {
        if (string.equals(this.minusSign)) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.zeroDigit, string, this.emptyUnit, this.weekToDays);
    }

    public PrettyTime withEmptyUnit(CalendarUnit calendarUnit) {
        if (this.emptyUnit.equals(calendarUnit)) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.zeroDigit, this.minusSign, calendarUnit, this.weekToDays);
    }

    public PrettyTime withEmptyUnit(ClockUnit clockUnit) {
        if (this.emptyUnit.equals(clockUnit)) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.zeroDigit, this.minusSign, clockUnit, this.weekToDays);
    }

    public PrettyTime withWeeksToDays() {
        if (this.weekToDays) {
            return this;
        }
        return new PrettyTime(this.locale, this.refClock, this.zeroDigit, this.minusSign, this.emptyUnit, true);
    }

    public String print(long l, CalendarUnit calendarUnit, TextWidth textWidth) {
        CalendarUnit calendarUnit2;
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        switch (calendarUnit) {
            case MILLENNIA: {
                l = MathUtils.safeMultiply(l, 1000L);
                calendarUnit2 = CalendarUnit.YEARS;
                break;
            }
            case CENTURIES: {
                l = MathUtils.safeMultiply(l, 100L);
                calendarUnit2 = CalendarUnit.YEARS;
                break;
            }
            case DECADES: {
                l = MathUtils.safeMultiply(l, 10L);
                calendarUnit2 = CalendarUnit.YEARS;
                break;
            }
            case YEARS: {
                calendarUnit2 = CalendarUnit.YEARS;
                break;
            }
            case QUARTERS: {
                l = MathUtils.safeMultiply(l, 3L);
                calendarUnit2 = CalendarUnit.MONTHS;
                break;
            }
            case MONTHS: {
                calendarUnit2 = CalendarUnit.MONTHS;
                break;
            }
            case WEEKS: {
                if (this.weekToDays) {
                    l = MathUtils.safeMultiply(l, 7L);
                    calendarUnit2 = CalendarUnit.DAYS;
                    break;
                }
                calendarUnit2 = CalendarUnit.WEEKS;
                break;
            }
            case DAYS: {
                calendarUnit2 = CalendarUnit.DAYS;
                break;
            }
            default: {
                throw new UnsupportedOperationException(calendarUnit.name());
            }
        }
        String string = unitPatterns.getPattern(textWidth, this.getCategory(l), calendarUnit2);
        return this.format(string, l);
    }

    public String print(long l, ClockUnit clockUnit, TextWidth textWidth) {
        String string = UnitPatterns.of(this.locale).getPattern(textWidth, this.getCategory(l), clockUnit);
        return this.format(string, l);
    }

    public String print(Duration<?> duration, TextWidth textWidth) {
        return this.print(duration, textWidth, false, Integer.MAX_VALUE);
    }

    public String print(Duration<?> duration, TextWidth textWidth, boolean bl, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Max length is invalid: " + n);
        }
        if (duration.isEmpty()) {
            if (this.emptyUnit.isCalendrical()) {
                CalendarUnit calendarUnit = (CalendarUnit)CalendarUnit.class.cast(this.emptyUnit);
                return this.print(0L, calendarUnit, textWidth);
            }
            ClockUnit clockUnit = (ClockUnit)ClockUnit.class.cast(this.emptyUnit);
            return this.print(0L, clockUnit, textWidth);
        }
        boolean bl2 = duration.isNegative();
        long[] lArray = new long[8];
        PrettyTime.pushDuration(lArray, duration, this.refClock, this.weekToDays);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (n2 >= n || this.weekToDays && i == 2 || (!bl || n2 <= 0) && lArray[i] <= 0L) continue;
            ClockUnit clockUnit = i == 7 ? ClockUnit.NANOS : STD_UNITS[i];
            arrayList.add(this.format(lArray[i], clockUnit, bl2, textWidth));
            ++n2;
        }
        assert (n2 > 0);
        if (n2 == 1) {
            return arrayList.get(0).toString();
        }
        return MessageFormat.format(UnitPatterns.of(this.locale).getListPattern(textWidth, n2), arrayList.toArray(new Object[n2]));
    }

    public String printRelativeInStdTimezone(UnixTime unixTime) {
        return this.printRelative(unixTime, Timezone.ofSystem());
    }

    public String printRelative(UnixTime unixTime, TZID tZID) {
        return this.printRelative(unixTime, Timezone.of(tZID));
    }

    public String printRelative(UnixTime unixTime, String string) {
        return this.printRelative(unixTime, Timezone.of(string));
    }

    private String printRelative(UnixTime unixTime, Timezone timezone) {
        Object obj = this.getReferenceClock().currentTime();
        PlainTimestamp plainTimestamp = PlainTimestamp.from(obj, timezone.getOffset((UnixTime)obj));
        PlainTimestamp plainTimestamp2 = PlainTimestamp.from(unixTime, timezone.getOffset(unixTime));
        IsoUnit[] isoUnitArray = this.weekToDays ? TSP_UNITS : STD_UNITS;
        Duration<IsoUnit> duration = Duration.in(timezone, isoUnitArray).between(plainTimestamp, plainTimestamp2);
        if (duration.isEmpty()) {
            return UnitPatterns.of(this.locale).getNowWord();
        }
        TimeSpan.Item<IsoUnit> item = duration.getTotalLength().get(0);
        long l = item.getAmount();
        IsoUnit isoUnit = item.getUnit();
        String string = duration.isNegative() ? (isoUnit.isCalendrical() ? this.getPastPattern(l, (CalendarUnit)isoUnit) : this.getPastPattern(l, (ClockUnit)isoUnit)) : (isoUnit.isCalendrical() ? this.getFuturePattern(l, (CalendarUnit)isoUnit) : this.getFuturePattern(l, (ClockUnit)isoUnit));
        return this.format(string, l);
    }

    private String getPastPattern(long l, CalendarUnit calendarUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l);
        return unitPatterns.getPatternInPast(pluralCategory, calendarUnit);
    }

    private String getFuturePattern(long l, CalendarUnit calendarUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l);
        return unitPatterns.getPatternInFuture(pluralCategory, calendarUnit);
    }

    private String getPastPattern(long l, ClockUnit clockUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l);
        return unitPatterns.getPatternInPast(pluralCategory, clockUnit);
    }

    private String getFuturePattern(long l, ClockUnit clockUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l);
        return unitPatterns.getPatternInFuture(pluralCategory, clockUnit);
    }

    private PluralCategory getCategory(long l) {
        return this.rules.getCategory(Math.abs(l));
    }

    private static void pushDuration(long[] lArray, Duration<?> duration, TimeSource<?> timeSource, boolean bl) {
        int n = duration.getTotalLength().size();
        for (int i = 0; i < n; ++i) {
            TimeSpan.Item<?> item = duration.getTotalLength().get(i);
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            long l = item.getAmount();
            if (isoUnit instanceof CalendarUnit) {
                PrettyTime.push(lArray, (CalendarUnit)CalendarUnit.class.cast(isoUnit), l, bl);
                continue;
            }
            if (isoUnit instanceof ClockUnit) {
                PrettyTime.push(lArray, (ClockUnit)ClockUnit.class.cast(isoUnit), l);
                continue;
            }
            if (isoUnit instanceof OverflowUnit) {
                PrettyTime.push(lArray, ((OverflowUnit)OverflowUnit.class.cast(isoUnit)).getCalendarUnit(), l, bl);
                continue;
            }
            if (isoUnit.equals(CalendarUnit.weekBasedYears())) {
                lArray[0] = MathUtils.safeAdd(l, lArray[0]);
                continue;
            }
            Moment moment = Moment.from(timeSource.currentTime());
            PlainTimestamp plainTimestamp = moment.toZonalTimestamp(ZonalOffset.UTC);
            PlainTimestamp plainTimestamp2 = (PlainTimestamp)plainTimestamp.plus(l, isoUnit);
            IsoUnit[] isoUnitArray = bl ? TSP_UNITS : STD_UNITS;
            Duration duration2 = (Duration)Duration.in((IsoUnit[])isoUnitArray).between(plainTimestamp, plainTimestamp2);
            PrettyTime.pushDuration(lArray, duration2, timeSource, bl);
        }
    }

    private static void push(long[] lArray, CalendarUnit calendarUnit, long l, boolean bl) {
        int n;
        switch (calendarUnit) {
            case MILLENNIA: {
                l = MathUtils.safeMultiply(l, 1000L);
                n = 0;
                break;
            }
            case CENTURIES: {
                l = MathUtils.safeMultiply(l, 100L);
                n = 0;
                break;
            }
            case DECADES: {
                l = MathUtils.safeMultiply(l, 10L);
                n = 0;
                break;
            }
            case YEARS: {
                n = 0;
                break;
            }
            case QUARTERS: {
                l = MathUtils.safeMultiply(l, 3L);
                n = 1;
                break;
            }
            case MONTHS: {
                n = 1;
                break;
            }
            case WEEKS: {
                if (bl) {
                    l = MathUtils.safeMultiply(l, 7L);
                    n = 3;
                    break;
                }
                n = 2;
                break;
            }
            case DAYS: {
                n = 3;
                break;
            }
            default: {
                throw new UnsupportedOperationException(calendarUnit.name());
            }
        }
        lArray[n] = MathUtils.safeAdd(l, lArray[n]);
    }

    private static void push(long[] lArray, ClockUnit clockUnit, long l) {
        int n;
        switch (clockUnit) {
            case HOURS: {
                n = 4;
                break;
            }
            case MINUTES: {
                n = 5;
                break;
            }
            case SECONDS: {
                n = 6;
                break;
            }
            case MILLIS: {
                l = MathUtils.safeMultiply(l, 1000000L);
                n = 7;
                break;
            }
            case MICROS: {
                l = MathUtils.safeMultiply(l, 1000L);
                n = 7;
                break;
            }
            case NANOS: {
                n = 7;
                break;
            }
            default: {
                throw new UnsupportedOperationException(clockUnit.name());
            }
        }
        lArray[n] = MathUtils.safeAdd(l, lArray[n]);
    }

    private String format(long l, IsoUnit isoUnit, boolean bl, TextWidth textWidth) {
        long l2 = l;
        if (bl) {
            l2 = MathUtils.safeNegate(l);
        }
        if (SUPPORTED_UNITS.contains(isoUnit)) {
            if (isoUnit.isCalendrical()) {
                CalendarUnit calendarUnit = (CalendarUnit)CalendarUnit.class.cast(isoUnit);
                return this.print(l2, calendarUnit, textWidth);
            }
            ClockUnit clockUnit = (ClockUnit)ClockUnit.class.cast(isoUnit);
            if (clockUnit == ClockUnit.NANOS) {
                if (l % 1000000L == 0L) {
                    clockUnit = ClockUnit.MILLIS;
                    l2 /= 1000000L;
                } else if (l % 1000L == 0L) {
                    clockUnit = ClockUnit.MICROS;
                    l2 /= 1000L;
                }
            }
            return this.print(l2, clockUnit, textWidth);
        }
        throw new UnsupportedOperationException("Unknown unit: " + isoUnit);
    }

    private String format(String string, long l) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (i >= n - 2 || string.charAt(i) != '{' || string.charAt(i + 1) != '0' || string.charAt(i + 2) != '}') continue;
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.replace(i, i + 3, this.format(l));
            return stringBuilder.toString();
        }
        return string;
    }

    private String format(long l) {
        String string = String.valueOf(Math.abs(l));
        char c = this.zeroDigit;
        StringBuilder stringBuilder = new StringBuilder();
        if (l < 0L) {
            stringBuilder.append(this.minusSign);
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c != '0') {
                c2 = (char)(c2 + c - 48);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    static {
        IsoUnit[] isoUnitArray = null;
        Iterator<NumberSymbolProvider> iterator = ResourceLoader.getInstance().services(NumberSymbolProvider.class).iterator();
        if (iterator.hasNext()) {
            NumberSymbolProvider numberSymbolProvider = iterator.next();
            isoUnitArray = numberSymbolProvider;
        }
        if (isoUnitArray == null) {
            isoUnitArray = NumberSymbolProvider.DEFAULT;
        }
        NUMBER_SYMBOLS = isoUnitArray;
        LANGUAGE_MAP = new ConcurrentHashMap<Locale, PrettyTime>();
        isoUnitArray = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.WEEKS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS};
        STD_UNITS = isoUnitArray;
        TSP_UNITS = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS};
        iterator = new HashSet();
        Collections.addAll(iterator, isoUnitArray);
        iterator.add((NumberSymbolProvider)((Object)ClockUnit.NANOS));
        SUPPORTED_UNITS = Collections.unmodifiableSet(iterator);
    }
}

