/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class LiteralProcessor
implements FormatProcessor<Void> {
    private final char single;
    private final char alt;
    private final String multi;
    private final AttributeKey<Character> attribute;
    private final boolean caseInsensitive;
    private final boolean interpunctuationMode;
    private final boolean rtl;

    LiteralProcessor(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing literal.");
        }
        this.alt = this.single = string.charAt(0);
        this.attribute = null;
        this.multi = string;
        if (this.single < ' ') {
            throw new IllegalArgumentException("Literal must not start with non-printable char.");
        }
        this.caseInsensitive = true;
        this.interpunctuationMode = string.length() == 1 && LiteralProcessor.isInterpunctuation(this.single);
        this.rtl = false;
    }

    LiteralProcessor(char c, char c2) {
        this.single = c;
        this.alt = c2;
        this.attribute = null;
        this.multi = null;
        if (c < ' ' || c2 < ' ') {
            throw new IllegalArgumentException("Literal must not start with non-printable char.");
        }
        if (Character.isDigit(c) || Character.isDigit(c2)) {
            throw new IllegalArgumentException("Literal must not be a decimal digit.");
        }
        this.caseInsensitive = true;
        this.interpunctuationMode = false;
        this.rtl = false;
    }

    LiteralProcessor(AttributeKey<Character> attributeKey) {
        if (attributeKey == null) {
            throw new NullPointerException("Missing format attribute.");
        }
        this.alt = this.single = '\u0000';
        this.attribute = attributeKey;
        this.multi = null;
        this.caseInsensitive = true;
        this.interpunctuationMode = false;
        this.rtl = false;
    }

    private LiteralProcessor(char c, char c2, String string, AttributeKey<Character> attributeKey, boolean bl, boolean bl2, boolean bl3) {
        this.single = c;
        this.alt = c2;
        this.multi = string;
        this.attribute = attributeKey;
        this.caseInsensitive = bl;
        this.interpunctuationMode = bl2;
        this.rtl = bl3;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        if (this.attribute != null) {
            char c = ((Character)attributeQuery.get(this.attribute, null)).charValue();
            appendable.append(c);
            return 1;
        }
        if (this.multi == null) {
            appendable.append(this.single);
            return 1;
        }
        appendable.append(this.multi);
        return this.multi.length();
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        if (bl && this.interpunctuationMode) {
            int n = parseLog.getPosition();
            if (n < charSequence.length() && charSequence.charAt(n) == this.single) {
                parseLog.setPosition(n + 1);
            } else {
                this.logError(charSequence, parseLog);
            }
        } else if (this.multi == null) {
            this.parseChar(charSequence, parseLog, attributeQuery, bl);
        } else {
            this.parseMulti(charSequence, parseLog, attributeQuery, bl);
        }
    }

    private void parseChar(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, boolean bl) {
        boolean bl2;
        int n = parseLog.getPosition();
        char c = '\u0000';
        char c2 = this.single;
        if (this.attribute != null) {
            c2 = attributeQuery.get(this.attribute, Character.valueOf('\u0000')).charValue();
        }
        if (n >= charSequence.length() || c2 == '\u0000' || Character.isDigit(c2)) {
            bl2 = true;
        } else {
            c = charSequence.charAt(n);
            char c3 = this.alt;
            if (this.attribute != null && Attributes.DECIMAL_SEPARATOR.name().equals(this.attribute.name()) && Locale.ROOT.equals(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT))) {
                c3 = c2 == ',' ? (char)'.' : (c2 == '.' ? (char)',' : (char)c2);
            }
            boolean bl3 = bl2 = c != c2 && c != c3;
            if (bl2) {
                boolean bl4;
                boolean bl5 = bl4 = bl ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
                if (bl4 && (LiteralProcessor.charEqualsIgnoreCase(c, c2) || LiteralProcessor.charEqualsIgnoreCase(c, c3))) {
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            StringBuilder stringBuilder = new StringBuilder("Cannot parse: \"");
            stringBuilder.append(charSequence);
            stringBuilder.append("\" (expected: [");
            stringBuilder.append(c2);
            stringBuilder.append("], found: [");
            if (c != '\u0000') {
                stringBuilder.append(c);
            }
            stringBuilder.append("])");
            parseLog.setError(n, stringBuilder.toString());
        } else {
            parseLog.setPosition(n + 1);
        }
    }

    private void parseMulti(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, boolean bl) {
        boolean bl2;
        boolean bl3;
        int n = parseLog.getPosition();
        int n2 = LiteralProcessor.subSequenceEquals(charSequence, n, this.multi, bl3 = bl ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), bl2 = bl ? this.rtl : CalendarText.isRTL(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT)));
        if (n2 == -1) {
            this.logError(charSequence, parseLog);
        } else {
            parseLog.setPosition(n + n2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LiteralProcessor) {
            LiteralProcessor literalProcessor = (LiteralProcessor)object;
            if (this.attribute != null) {
                return this.attribute.equals(literalProcessor.attribute);
            }
            if (this.multi == null) {
                return literalProcessor.multi == null && this.single == literalProcessor.single && this.alt == literalProcessor.alt;
            }
            return this.multi.equals(literalProcessor.multi) && this.interpunctuationMode == literalProcessor.interpunctuationMode;
        }
        return false;
    }

    public int hashCode() {
        String string = this.attribute == null ? (this.multi == null ? "" : this.multi) : this.attribute.name();
        return this.single ^ string.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[literal=");
        if (this.attribute != null) {
            stringBuilder.append('{');
            stringBuilder.append(this.attribute);
            stringBuilder.append('}');
        } else if (this.multi == null) {
            stringBuilder.append(this.single);
            if (this.alt != this.single) {
                stringBuilder.append(", alternative=");
                stringBuilder.append(this.alt);
            }
        } else {
            stringBuilder.append(this.multi);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Void> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<Void> withElement(ChronoElement<Void> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        if (this.multi == null) {
            return false;
        }
        return this.getPrefixedDigitArea() == this.multi.length();
    }

    @Override
    public FormatProcessor<Void> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        boolean bl = CalendarText.isRTL(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        return new LiteralProcessor(this.single, this.alt, this.multi, this.attribute, attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), this.interpunctuationMode && !bl, bl);
    }

    int getPrefixedDigitArea() {
        if (this.multi == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.multi.length();
        for (int i = 0; i < n2 && Character.isDigit(this.multi.charAt(i)); ++i) {
            ++n;
        }
        return n;
    }

    static int subSequenceEquals(CharSequence charSequence, int n, CharSequence charSequence2, boolean bl, boolean bl2) {
        int n2 = 0;
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        for (int i = 0; i < n4; ++i) {
            char c = '\u0000';
            char c2 = charSequence2.charAt(i);
            if (LiteralProcessor.isBidi(c2)) continue;
            if (bl2) {
                while (n2 + n < n3 && LiteralProcessor.isBidi(c = charSequence.charAt(n2 + n))) {
                    ++n2;
                }
            } else if (n2 + n < n3) {
                c = charSequence.charAt(n2 + n);
            }
            if (n2 + n >= n3) {
                return -1;
            }
            ++n2;
            if (!(bl ? !LiteralProcessor.charEqualsIgnoreCase(c, c2) : c != c2)) continue;
            return -1;
        }
        if (bl2) {
            while (n2 + n < n3 && LiteralProcessor.isBidi(charSequence.charAt(n2 + n))) {
                ++n2;
            }
        }
        return n2;
    }

    private static boolean charEqualsIgnoreCase(char c, char c2) {
        return c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    private static boolean isBidi(char c) {
        return c == '\u200e' || c == '\u200f' || c == '\u061c';
    }

    private static boolean isInterpunctuation(char c) {
        return !Character.isLetter(c) && !Character.isDigit(c) && !LiteralProcessor.isBidi(c);
    }

    private void logError(CharSequence charSequence, ParseLog parseLog) {
        int n = parseLog.getPosition();
        StringBuilder stringBuilder = new StringBuilder("Cannot parse: \"");
        stringBuilder.append(charSequence);
        stringBuilder.append("\" (expected: [");
        stringBuilder.append(this.multi);
        stringBuilder.append("], found: [");
        stringBuilder.append(charSequence.subSequence(n, Math.min(n + this.multi.length(), charSequence.length())));
        stringBuilder.append("])");
        parseLog.setError(n, stringBuilder.toString());
    }
}

