/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.frenchrev;

import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.base.MathUtils;
import net.time4j.calendar.astro.AstronomicalSeason;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.calendar.frenchrev.FrenchRepublicanCalendar;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.ZonalOffset;

public enum FrenchRepublicanAlgorithm {
    EQUINOX{

        @Override
        public boolean isLeapYear(int n) {
            if (n < 1 || n > 1202) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            long l = this.autumnalEquinox(n).getDaysSinceEpochUTC();
            long l2 = this.autumnalEquinox(n + 1).getDaysSinceEpochUTC();
            return l2 - l == 366L;
        }

        @Override
        FrenchRepublicanCalendar transform(long l) {
            FrenchRepublicanAlgorithm.check(l);
            PlainDate plainDate = PlainDate.of(l, EpochDays.UTC);
            int n = plainDate.getYear() - 1791;
            if (plainDate.getMonth() < 9) {
                --n;
            }
            PlainDate plainDate2 = this.autumnalEquinox(n);
            long l2 = CalendarUnit.DAYS.between(plainDate2, plainDate);
            while (l2 < 0L) {
                plainDate2 = this.autumnalEquinox(--n);
                l2 = CalendarUnit.DAYS.between(plainDate2, plainDate);
            }
            int n2 = (int)(l2 + 1L);
            return new FrenchRepublicanCalendar(n, n2);
        }

        @Override
        long transform(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            long l = this.autumnalEquinox(frenchRepublicanCalendar.getYear()).getDaysSinceEpochUTC();
            return l + (long)frenchRepublicanCalendar.getDayOfYear() - 1L;
        }

        private PlainDate autumnalEquinox(int n) {
            PlainTimestamp plainTimestamp = AstronomicalSeason.AUTUMNAL_EQUINOX.inYear(n + 1791).get(SolarTime.apparentAt(PARIS_OBSERVATORY));
            return plainTimestamp.getCalendarDate();
        }
    }
    ,
    ROMME{

        @Override
        public boolean isLeapYear(int n) {
            if (n < 1 || n > 1202) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            if (n == 3 || n == 7 || n == 11) {
                return true;
            }
            if (n >= 15) {
                return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
            }
            return false;
        }

        @Override
        FrenchRepublicanCalendar transform(long l) {
            if (l < ABOLITION) {
                return EQUINOX.transform(l);
            }
            FrenchRepublicanAlgorithm.check(l);
            int n = (int)(MathUtils.floorDivide((l - EPOCH + 2L) * 4000L, 1460969) + 1L);
            long l2 = this.transform(new FrenchRepublicanCalendar(n, 1));
            if (l2 > l) {
                l2 = this.transform(new FrenchRepublicanCalendar(n - 1, 1));
                --n;
            }
            int n2 = (int)(l - l2 + 1L);
            return new FrenchRepublicanCalendar(n, n2);
        }

        @Override
        long transform(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            if (frenchRepublicanCalendar.getYear() < 15) {
                return EQUINOX.transform(frenchRepublicanCalendar);
            }
            int n = frenchRepublicanCalendar.getYear() - 1;
            return EPOCH - 1L + (long)(365 * n) + (long)MathUtils.floorDivide(n, 4) - (long)MathUtils.floorDivide(n, 100) + (long)MathUtils.floorDivide(n, 400) + (long)frenchRepublicanCalendar.getDayOfYear();
        }
    };

    private static final ZonalOffset PARIS_OBSERVATORY;
    private static final long ABOLITION;
    private static final long EPOCH;
    private static final AttributeKey<FrenchRepublicanAlgorithm> ATTRIBUTE;

    public static AttributeKey<FrenchRepublicanAlgorithm> attribute() {
        return ATTRIBUTE;
    }

    public boolean isLeapYear(int n) {
        throw new AbstractMethodError();
    }

    abstract FrenchRepublicanCalendar transform(long var1);

    abstract long transform(FrenchRepublicanCalendar var1);

    private static void check(long l) {
        if (l < -65478L || l > 373542L) {
            throw new IllegalArgumentException("Out of range: " + l);
        }
    }

    static {
        PARIS_OBSERVATORY = ZonalOffset.atLongitude(OffsetSign.AHEAD_OF_UTC, 2, 20, 14.025);
        ABOLITION = PlainDate.of(1806, 1, 1).get(EpochDays.UTC);
        EPOCH = PlainDate.of(1792, 9, 22).get(EpochDays.UTC);
        ATTRIBUTE = Attributes.createKey("FRENCH_REPUBLICAN_ALGORITHM", FrenchRepublicanAlgorithm.class);
    }
}

