/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.DisplayElement;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.NumberSystem;
import net.time4j.format.NumericalElement;
import net.time4j.format.TextElement;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.YearDefinition;
import net.time4j.history.internal.HistoricAttribute;
import net.time4j.i18n.HistoricExtension;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="historic")
public final class HistoricCalendar
extends CalendarVariant<HistoricCalendar>
implements LocalizedPatternSupport {
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    private static final int CENTURY_INDEX = 4;
    private static final int CONTINUOUS_DOM_INDEX = 5;
    @FormattableElement(format="G")
    public static final ChronoElement<HistoricEra> ERA = new EraElement();
    public static final ChronoElement<Integer> CENTURY_OF_ERA = new SimpleElement("CENTURY_OF_ERA", ChronoHistory.ofFirstGregorianReform().centuryOfEra().getDefaultMinimum(), ChronoHistory.ofFirstGregorianReform().centuryOfEra().getDefaultMaximum());
    @FormattableElement(format="y")
    public static final TextElement<Integer> RELATED_STANDARD_YEAR = new YearElement();
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<Month, HistoricCalendar> MONTH_OF_YEAR = new StdEnumDateElement<Month, HistoricCalendar>("MONTH_OF_YEAR", HistoricCalendar.class, Month.class, 'M', (ChronoOperator)new MonthOperator(true), (ChronoOperator)new MonthOperator(false)){

        @Override
        protected String getCalendarType(AttributeQuery attributeQuery) {
            return "iso8601";
        }
    };
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, HistoricCalendar> DAY_OF_MONTH = new StdIntegerDateElement<HistoricCalendar>("DAY_OF_MONTH", HistoricCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, HistoricCalendar> DAY_OF_YEAR = new StdIntegerDateElement<HistoricCalendar>("DAY_OF_YEAR", HistoricCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, HistoricCalendar> DAY_OF_WEEK = new StdWeekdayElement<HistoricCalendar>(HistoricCalendar.class, HistoricCalendar.getDefaultWeekmodel());
    private static final ChronoElement<Integer> CONTINUOUS_DOM = new SimpleElement("HC_CONTINUOUS_DOM", 1, 31);
    private static final WeekdayInMonthElement<HistoricCalendar> WIM_ELEMENT = new WeekdayInMonthElement<HistoricCalendar>(HistoricCalendar.class, CONTINUOUS_DOM, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<HistoricCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final Map<String, CalendarSystem<HistoricCalendar>> CALSYS;
    private static final CalendarFamily<HistoricCalendar> ENGINE;
    private static final long serialVersionUID = 7723641381724201009L;
    private final transient HistoricDate date;
    private final PlainDate gregorian;
    private final ChronoHistory history;

    private HistoricCalendar(ChronoHistory chronoHistory, HistoricDate historicDate) {
        this.gregorian = chronoHistory.convert(historicDate);
        this.date = historicDate;
        this.history = chronoHistory;
    }

    private HistoricCalendar(ChronoHistory chronoHistory, PlainDate plainDate) {
        this.date = chronoHistory.convert(plainDate);
        this.gregorian = plainDate;
        this.history = chronoHistory;
    }

    public static HistoricCalendar of(ChronoHistory chronoHistory, HistoricEra historicEra, int n, int n2, int n3) {
        return HistoricCalendar.of(chronoHistory, historicEra, n, YearDefinition.DUAL_DATING, n2, n3);
    }

    public static HistoricCalendar of(ChronoHistory chronoHistory, HistoricEra historicEra, int n, YearDefinition yearDefinition, int n2, int n3) {
        HistoricDate historicDate = HistoricDate.of(historicEra, n, n2, n3, yearDefinition, chronoHistory.getNewYearStrategy());
        return HistoricCalendar.of(chronoHistory, historicDate);
    }

    public static HistoricCalendar nowInSystemTime(ChronoHistory chronoHistory) {
        return SystemClock.inLocalView().now(HistoricCalendar.family(), chronoHistory, StartOfDay.MIDNIGHT).toDate();
    }

    public ChronoHistory getHistory() {
        return this.history;
    }

    public HistoricEra getEra() {
        return this.date.getEra();
    }

    public int getCentury() {
        return this.getInt(this.history.centuryOfEra());
    }

    public int getYear() {
        return this.date.getYearOfEra(this.history.getNewYearStrategy());
    }

    public Month getMonth() {
        return Month.valueOf(this.date.getMonth());
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public Weekday getDayOfWeek() {
        long l = this.gregorian.getDaysSinceEpochUTC();
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return (Integer)this.get(DAY_OF_YEAR);
    }

    @Override
    public String getVariant() {
        return this.history.getVariant();
    }

    public int lengthOfMonth() {
        try {
            PlainDate plainDate = ((HistoricCalendar)this.with(HistoricCalendar.DAY_OF_MONTH, (int)((Integer)this.getMinimum(HistoricCalendar.DAY_OF_MONTH)).intValue())).gregorian;
            PlainDate plainDate2 = ((HistoricCalendar)this.with(HistoricCalendar.DAY_OF_MONTH, (int)((Integer)this.getMaximum(HistoricCalendar.DAY_OF_MONTH)).intValue())).gregorian;
            return (int)CalendarDays.between(plainDate, plainDate2).getAmount() + 1;
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    public int lengthOfYear() {
        return this.history.getLengthOfYear(this.getEra(), this.getYear());
    }

    public HistoricCalendar withNewYear() {
        HistoricDate historicDate = this.history.getBeginOfYear(this.getEra(), this.getYear());
        return HistoricCalendar.of(this.history, historicDate);
    }

    public HistoricCalendar nextDay() {
        return this.with(DAY_OF_MONTH.incremented());
    }

    public GeneralTimestamp<HistoricCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<HistoricCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HistoricCalendar) {
            HistoricCalendar historicCalendar = (HistoricCalendar)object;
            return this.gregorian.equals(historicCalendar.gregorian) && this.history.equals(historicCalendar.history) && this.date.equals(historicCalendar.date);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.gregorian.hashCode() + 31 * this.history.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.date);
        stringBuilder.append('[');
        stringBuilder.append(this.history);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SUNDAY, 1);
    }

    public static CalendarFamily<HistoricCalendar> family() {
        return ENGINE;
    }

    @Override
    protected CalendarFamily<HistoricCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected HistoricCalendar getContext() {
        return this;
    }

    private static HistoricCalendar of(ChronoHistory chronoHistory, HistoricDate historicDate) {
        if (chronoHistory.isValid(historicDate)) {
            return new HistoricCalendar(chronoHistory, historicDate);
        }
        throw new IllegalArgumentException("Historic date \"" + historicDate + "\" invalid in history: " + chronoHistory);
    }

    private static ChronoHistory getHistory(AttributeQuery attributeQuery) {
        if (attributeQuery.contains(HistoricAttribute.CALENDAR_HISTORY)) {
            return attributeQuery.get(HistoricAttribute.CALENDAR_HISTORY);
        }
        if (attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601").equals("historic") && attributeQuery.contains(Attributes.CALENDAR_VARIANT)) {
            return ChronoHistory.from(attributeQuery.get(Attributes.CALENDAR_VARIANT));
        }
        if (!attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isStrict()) {
            return ChronoHistory.of(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        }
        return null;
    }

    private Object writeReplace() {
        return new SPX(this, 11);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        VariantMap variantMap = new VariantMap();
        ChronoHistory chronoHistory = ChronoHistory.ofFirstGregorianReform();
        variantMap.put(chronoHistory.getVariant(), new Transformer(chronoHistory));
        CALSYS = variantMap;
        Chronology.Builder builder = ((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)((CalendarFamily.Builder)CalendarFamily.Builder.setUp(HistoricCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)PlainDate.COMPONENT, (ElementRule)new GregorianDateRule())).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement((ChronoElement)CENTURY_OF_ERA, (ElementRule)new IntegerRule(4))).appendElement((ChronoElement)RELATED_STANDARD_YEAR, (ElementRule)new IntegerRule(0))).appendElement((ChronoElement)MONTH_OF_YEAR, (ElementRule)new MonthRule())).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<HistoricCalendar>(CALSYS, DAY_OF_YEAR))).appendElement((ChronoElement)CONTINUOUS_DOM, (ElementRule)new IntegerRule(5))).appendElement((ChronoElement)DAY_OF_MONTH, (ElementRule)new IntegerRule(2))).appendElement((ChronoElement)DAY_OF_YEAR, (ElementRule)new IntegerRule(3))).appendElement((ChronoElement)DAY_OF_WEEK, new WeekdayRule<HistoricCalendar>(HistoricCalendar.getDefaultWeekmodel(), new ChronoFunction<HistoricCalendar, CalendarSystem<HistoricCalendar>>(){

            @Override
            public CalendarSystem<HistoricCalendar> apply(HistoricCalendar historicCalendar) {
                return ((CalendarFamily)historicCalendar.getChronology()).getCalendarSystem(historicCalendar.getVariant());
            }
        }))).appendElement(WIM_ELEMENT, (ElementRule)WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendExtension(new CommonElements.Weekengine(HistoricCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, HistoricCalendar.getDefaultWeekmodel()));
        ENGINE = ((CalendarFamily.Builder)builder).build();
    }

    private static class Merger
    implements ChronoMerger<HistoricCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("generic", displayStyle, locale);
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        @Override
        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear();
        }

        @Override
        public HistoricCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            String string = attributeQuery.get(Attributes.CALENDAR_VARIANT, "");
            if (string.isEmpty()) {
                return null;
            }
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (HistoricCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, string, tZID, startOfDay).toDate();
        }

        @Override
        @Deprecated
        public HistoricCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public HistoricCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            Enum enum_;
            ChronoHistory chronoHistory = HistoricCalendar.getHistory(attributeQuery);
            if (chronoHistory == null) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Cannot find any calendar history.");
                return null;
            }
            if (chronoEntity.contains(ERA)) {
                enum_ = chronoEntity.get(ERA);
                chronoEntity.with(ERA, null);
                chronoEntity.with(chronoHistory.era(), enum_);
            }
            if (chronoEntity.contains(RELATED_STANDARD_YEAR)) {
                int n = chronoEntity.getInt(RELATED_STANDARD_YEAR);
                chronoEntity.with(RELATED_STANDARD_YEAR, null);
                chronoEntity.with((ChronoElement<Integer>)chronoHistory.yearOfEra(), n);
            }
            if (chronoEntity.contains(DAY_OF_YEAR)) {
                int n = chronoEntity.getInt(DAY_OF_YEAR);
                chronoEntity.with(DAY_OF_YEAR, null);
                chronoEntity.with(chronoHistory.dayOfYear(), n);
            } else {
                if (chronoEntity.contains(MONTH_OF_YEAR)) {
                    enum_ = (Month)chronoEntity.get(MONTH_OF_YEAR);
                    chronoEntity.with(MONTH_OF_YEAR, null);
                    chronoEntity.with((ChronoElement<Integer>)chronoHistory.month(), ((Month)enum_).getValue());
                }
                if (chronoEntity.contains(DAY_OF_MONTH)) {
                    int n = chronoEntity.getInt(DAY_OF_MONTH);
                    chronoEntity.with(DAY_OF_MONTH, null);
                    chronoEntity.with(chronoHistory.dayOfMonth(), n);
                }
            }
            HistoricExtension historicExtension = new HistoricExtension();
            chronoEntity = historicExtension.resolve(chronoEntity, chronoHistory, attributeQuery);
            if (chronoEntity.contains(PlainDate.COMPONENT)) {
                return new HistoricCalendar(chronoHistory, chronoEntity.get(PlainDate.COMPONENT));
            }
            return null;
        }

        @Override
        public ChronoDisplay preformat(HistoricCalendar historicCalendar, AttributeQuery attributeQuery) {
            return historicCalendar;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }
    }

    private static class MonthOperator
    implements ChronoOperator<HistoricCalendar> {
        private final boolean backwards;

        MonthOperator(boolean bl) {
            this.backwards = bl;
        }

        @Override
        public HistoricCalendar apply(HistoricCalendar historicCalendar) {
            HistoricEra historicEra = historicCalendar.date.getEra();
            int n = historicCalendar.date.getYearOfEra();
            int n2 = historicCalendar.date.getMonth() + (this.backwards ? -1 : 1);
            int n3 = historicCalendar.date.getDayOfMonth();
            if (n2 > 12) {
                n2 = 1;
                if (historicEra == HistoricEra.BC) {
                    if (--n == 0) {
                        historicEra = HistoricEra.AD;
                        n = 1;
                    }
                } else {
                    ++n;
                }
            } else if (n2 < 1) {
                n2 = 12;
                if (historicEra == HistoricEra.BC) {
                    ++n;
                } else if (--n == 0 && historicEra == HistoricEra.AD) {
                    n = 1;
                    historicEra = HistoricEra.BC;
                }
            }
            HistoricDate historicDate = HistoricDate.of(historicEra, n, n2, n3);
            int n4 = n3;
            while (n3 > 1 && !historicCalendar.history.isValid(historicDate)) {
                historicDate = HistoricDate.of(historicEra, n, n2, --n3);
            }
            if (n3 == 1) {
                n3 = n4;
                while (n3 <= 31 && !historicCalendar.history.isValid(historicDate)) {
                    historicDate = HistoricDate.of(historicEra, n, n2, ++n3);
                }
            }
            return new HistoricCalendar(historicCalendar.history, historicDate);
        }
    }

    private static class YearElement
    extends SimpleElement
    implements DualFormatElement {
        private static final long serialVersionUID = 6400379438892131807L;

        private YearElement() {
            super("YEAR_OF_ERA", 1, 999999999);
        }

        @Override
        public char getSymbol() {
            return 'y';
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            if (!(chronoDisplay instanceof HistoricCalendar)) {
                throw new ChronoException("Cannot cast to historic calendar: " + chronoDisplay);
            }
            HistoricCalendar historicCalendar = (HistoricCalendar)HistoricCalendar.class.cast(chronoDisplay);
            TextElement<Integer> textElement = historicCalendar.history.yearOfEra();
            textElement.print(historicCalendar, appendable, attributeQuery);
        }

        @Override
        public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            ChronoHistory chronoHistory = HistoricCalendar.getHistory(attributeQuery);
            TextElement<Integer> textElement = chronoHistory.yearOfEra();
            return textElement.parse(charSequence, parsePosition, attributeQuery);
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, NumberSystem numberSystem, char c, int n, int n2) throws IOException, ChronoException {
            if (!(chronoDisplay instanceof HistoricCalendar)) {
                throw new ChronoException("Cannot cast to historic calendar: " + chronoDisplay);
            }
            HistoricCalendar historicCalendar = (HistoricCalendar)HistoricCalendar.class.cast(chronoDisplay);
            DualFormatElement dualFormatElement = (DualFormatElement)DualFormatElement.class.cast(historicCalendar.history.yearOfEra());
            dualFormatElement.print(chronoDisplay, appendable, attributeQuery, numberSystem, c, n, n2);
        }

        @Override
        public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery, ChronoEntity<?> chronoEntity) {
            ChronoHistory chronoHistory = HistoricCalendar.getHistory(attributeQuery);
            DualFormatElement dualFormatElement = (DualFormatElement)DualFormatElement.class.cast(chronoHistory.yearOfEra());
            return dualFormatElement.parse(charSequence, parsePosition, attributeQuery, chronoEntity);
        }

        private Object readResolve() throws ObjectStreamException {
            return RELATED_STANDARD_YEAR;
        }
    }

    private static class SimpleElement
    extends DisplayElement<Integer> {
        private static final long serialVersionUID = 3808762239145701486L;
        private final transient Integer min;
        private final transient Integer max;

        private SimpleElement(String string, int n, int n2) {
            super(string);
            this.min = n;
            this.max = n2;
        }

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public Integer getDefaultMinimum() {
            return this.min;
        }

        @Override
        public Integer getDefaultMaximum() {
            return this.max;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean doEquals(BasicElement<?> basicElement) {
            SimpleElement simpleElement = (SimpleElement)basicElement;
            return this.min.equals(simpleElement.min) && this.max.equals(simpleElement.max);
        }

        private Object readResolve() throws ObjectStreamException {
            String string = this.name();
            if (string.equals("HC_CONTINUOUS_DOM")) {
                return CONTINUOUS_DOM;
            }
            if (string.equals("CENTURY_OF_ERA")) {
                return CENTURY_OF_ERA;
            }
            throw new InvalidObjectException("Unknown element: " + string);
        }
    }

    private static class EraElement
    extends DisplayElement<HistoricEra>
    implements NumericalElement<HistoricEra>,
    TextElement<HistoricEra> {
        private static final long serialVersionUID = -4614710504356171166L;

        EraElement() {
            super("ERA");
        }

        @Override
        public Class<HistoricEra> getType() {
            return HistoricEra.class;
        }

        @Override
        public char getSymbol() {
            return 'G';
        }

        @Override
        public HistoricEra getDefaultMinimum() {
            return HistoricEra.BC;
        }

        @Override
        public HistoricEra getDefaultMaximum() {
            return HistoricEra.AD;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            ChronoHistory chronoHistory = HistoricCalendar.getHistory(attributeQuery);
            ((TextElement)TextElement.class.cast(chronoHistory.era())).print(chronoDisplay, appendable, attributeQuery);
        }

        @Override
        public HistoricEra parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            ChronoHistory chronoHistory = HistoricCalendar.getHistory(attributeQuery);
            Object v = ((TextElement)TextElement.class.cast(chronoHistory.era())).parse(charSequence, parsePosition, attributeQuery);
            return (HistoricEra)HistoricEra.class.cast(v);
        }

        @Override
        public int numerical(HistoricEra historicEra) {
            return historicEra.getValue();
        }

        @Override
        public int printToInt(HistoricEra historicEra, ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
            return historicEra.ordinal();
        }

        @Override
        public boolean parseFromInt(ChronoEntity<?> chronoEntity, int n) {
            try {
                chronoEntity.with(this, HistoricEra.values()[n]);
                return true;
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return ERA;
        }
    }

    private static class EraRule
    implements ElementRule<HistoricCalendar, HistoricEra> {
        private EraRule() {
        }

        @Override
        public HistoricEra getValue(HistoricCalendar historicCalendar) {
            return historicCalendar.getEra();
        }

        @Override
        public HistoricEra getMinimum(HistoricCalendar historicCalendar) {
            HistoricEra historicEra = historicCalendar.getEra();
            if (historicEra == HistoricEra.AD) {
                return HistoricEra.BC;
            }
            return historicEra;
        }

        @Override
        public HistoricEra getMaximum(HistoricCalendar historicCalendar) {
            HistoricEra historicEra = historicCalendar.getEra();
            if (historicEra == HistoricEra.BC) {
                return HistoricEra.AD;
            }
            return historicEra;
        }

        @Override
        public boolean isValid(HistoricCalendar historicCalendar, HistoricEra historicEra) {
            if (historicEra == null) {
                return false;
            }
            return historicCalendar.date.getEra() == historicEra;
        }

        @Override
        public HistoricCalendar withValue(HistoricCalendar historicCalendar, HistoricEra historicEra, boolean bl) {
            if (historicEra != null && historicCalendar.date.getEra() == historicEra) {
                return historicCalendar;
            }
            throw new IllegalArgumentException(historicEra.name());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HistoricCalendar historicCalendar) {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HistoricCalendar historicCalendar) {
            throw new UnsupportedOperationException("Never called.");
        }
    }

    private static class GregorianDateRule
    implements ElementRule<HistoricCalendar, PlainDate> {
        private GregorianDateRule() {
        }

        @Override
        public PlainDate getValue(HistoricCalendar historicCalendar) {
            return historicCalendar.gregorian;
        }

        @Override
        public PlainDate getMinimum(HistoricCalendar historicCalendar) {
            return historicCalendar.history.convert(historicCalendar.gregorian.getMinimum(historicCalendar.history.date()));
        }

        @Override
        public PlainDate getMaximum(HistoricCalendar historicCalendar) {
            return historicCalendar.history.convert(historicCalendar.gregorian.getMaximum(historicCalendar.history.date()));
        }

        @Override
        public boolean isValid(HistoricCalendar historicCalendar, PlainDate plainDate) {
            if (plainDate == null) {
                return false;
            }
            try {
                historicCalendar.history.convert(plainDate);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        @Override
        public HistoricCalendar withValue(HistoricCalendar historicCalendar, PlainDate plainDate, boolean bl) {
            return new HistoricCalendar(historicCalendar.history, plainDate);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HistoricCalendar historicCalendar) {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HistoricCalendar historicCalendar) {
            throw new UnsupportedOperationException("Never called.");
        }
    }

    private static class MonthRule
    implements ElementRule<HistoricCalendar, Month> {
        private MonthRule() {
        }

        @Override
        public Month getValue(HistoricCalendar historicCalendar) {
            return historicCalendar.getMonth();
        }

        @Override
        public Month getMinimum(HistoricCalendar historicCalendar) {
            return Month.valueOf(historicCalendar.getMinimum(historicCalendar.history.month()));
        }

        @Override
        public Month getMaximum(HistoricCalendar historicCalendar) {
            return Month.valueOf(historicCalendar.getMaximum(historicCalendar.history.month()));
        }

        @Override
        public boolean isValid(HistoricCalendar historicCalendar, Month month) {
            if (month == null) {
                return false;
            }
            return historicCalendar.isValid((ChronoElement<Integer>)historicCalendar.history.month(), month.getValue());
        }

        @Override
        public HistoricCalendar withValue(HistoricCalendar historicCalendar, Month month, boolean bl) {
            return (HistoricCalendar)historicCalendar.with((ChronoElement<Integer>)historicCalendar.history.month(), month.getValue());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HistoricCalendar historicCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HistoricCalendar historicCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements IntElementRule<HistoricCalendar> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public Integer getValue(HistoricCalendar historicCalendar) {
            return this.getInt(historicCalendar);
        }

        @Override
        public Integer getMinimum(HistoricCalendar historicCalendar) {
            if (this.index == 5) {
                int n = historicCalendar.date.getDayOfMonth();
                HistoricEra historicEra = historicCalendar.date.getEra();
                int n2 = historicCalendar.date.getYearOfEra();
                int n3 = historicCalendar.date.getMonth();
                for (int i = 1; i <= n; ++i) {
                    HistoricDate historicDate = HistoricDate.of(historicEra, n2, n3, i);
                    if (!historicCalendar.history.isValid(historicDate)) continue;
                    return i;
                }
            }
            return historicCalendar.getMinimum(this.getElement(historicCalendar));
        }

        @Override
        public Integer getMaximum(HistoricCalendar historicCalendar) {
            if (this.index == 5) {
                int n = historicCalendar.getMaximum(historicCalendar.history.dayOfMonth());
                HistoricEra historicEra = historicCalendar.date.getEra();
                int n2 = historicCalendar.date.getYearOfEra();
                int n3 = historicCalendar.date.getMonth();
                int n4 = 0;
                for (int i = 1; i <= n; ++i) {
                    HistoricDate historicDate = HistoricDate.of(historicEra, n2, n3, i);
                    if (historicCalendar.history.isValid(historicDate)) continue;
                    ++n4;
                }
                return n - n4;
            }
            return historicCalendar.getMaximum(this.getElement(historicCalendar));
        }

        @Override
        public boolean isValid(HistoricCalendar historicCalendar, Integer n) {
            if (n == null || this.index == 5) {
                return false;
            }
            return historicCalendar.isValid(this.getElement(historicCalendar), n);
        }

        @Override
        public HistoricCalendar withValue(HistoricCalendar historicCalendar, Integer n, boolean bl) {
            return (HistoricCalendar)historicCalendar.with(this.getElement(historicCalendar), n);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HistoricCalendar historicCalendar) {
            switch (this.index) {
                case 2: 
                case 3: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HistoricCalendar historicCalendar) {
            switch (this.index) {
                case 2: 
                case 3: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Never called.");
        }

        private ChronoElement<Integer> getElement(HistoricCalendar historicCalendar) {
            switch (this.index) {
                case 0: {
                    return historicCalendar.history.yearOfEra();
                }
                case 2: {
                    return historicCalendar.history.dayOfMonth();
                }
                case 3: {
                    return historicCalendar.history.dayOfYear();
                }
                case 4: {
                    return historicCalendar.history.centuryOfEra();
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public int getInt(HistoricCalendar historicCalendar) {
            switch (this.index) {
                case 0: {
                    return historicCalendar.date.getYearOfEra();
                }
                case 2: {
                    return historicCalendar.date.getDayOfMonth();
                }
                case 5: {
                    int n = historicCalendar.date.getDayOfMonth();
                    HistoricEra historicEra = historicCalendar.date.getEra();
                    int n2 = historicCalendar.date.getYearOfEra();
                    int n3 = historicCalendar.date.getMonth();
                    int n4 = 0;
                    for (int i = 1; i < n; ++i) {
                        HistoricDate historicDate = HistoricDate.of(historicEra, n2, n3, i);
                        if (historicCalendar.history.isValid(historicDate)) continue;
                        ++n4;
                    }
                    return n - n4;
                }
            }
            return historicCalendar.getInt(this.getElement(historicCalendar));
        }

        @Override
        public boolean isValid(HistoricCalendar historicCalendar, int n) {
            if (this.index == 5) {
                return false;
            }
            return historicCalendar.isValid(this.getElement(historicCalendar), n);
        }

        @Override
        public HistoricCalendar withValue(HistoricCalendar historicCalendar, int n, boolean bl) {
            return (HistoricCalendar)historicCalendar.with(this.getElement(historicCalendar), n);
        }
    }

    private static class VariantMap
    extends ConcurrentHashMap<String, CalendarSystem<HistoricCalendar>> {
        private VariantMap() {
        }

        @Override
        public CalendarSystem<HistoricCalendar> get(Object object) {
            CalendarSystem calendarSystem = (CalendarSystem)super.get(object);
            if (calendarSystem == null) {
                String string = object.toString();
                try {
                    calendarSystem = new Transformer(ChronoHistory.from(string));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return null;
                }
                CalendarSystem calendarSystem2 = this.putIfAbsent(string, calendarSystem);
                if (calendarSystem2 != null) {
                    calendarSystem = calendarSystem2;
                }
            }
            return calendarSystem;
        }
    }

    private static class Transformer
    implements CalendarSystem<HistoricCalendar> {
        private final ChronoHistory history;

        Transformer(ChronoHistory chronoHistory) {
            this.history = chronoHistory;
        }

        @Override
        public HistoricCalendar transform(long l) {
            return new HistoricCalendar(this.history, PlainDate.of(l, EpochDays.UTC));
        }

        @Override
        public long transform(HistoricCalendar historicCalendar) {
            return historicCalendar.gregorian.getDaysSinceEpochUTC();
        }

        @Override
        public long getMinimumSinceUTC() {
            PlainDate plainDate = PlainDate.of(2000, 1, 1);
            HistoricDate historicDate = plainDate.getMinimum(this.history.date());
            return this.history.convert(historicDate).getDaysSinceEpochUTC();
        }

        @Override
        public long getMaximumSinceUTC() {
            PlainDate plainDate = PlainDate.of(2000, 1, 1);
            HistoricDate historicDate = plainDate.getMaximum(this.history.date());
            return this.history.convert(historicDate).getDaysSinceEpochUTC();
        }

        @Override
        public List<CalendarEra> getEras() {
            ArrayList<HistoricEra> arrayList = new ArrayList<HistoricEra>();
            for (HistoricEra historicEra : HistoricEra.values()) {
                arrayList.add(historicEra);
            }
            return Collections.unmodifiableList(arrayList);
        }
    }
}

