/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.time4j.Month;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoElement;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.ArrayTransitionModel;
import net.time4j.tz.model.CompositeTransitionModel;
import net.time4j.tz.model.DayOfWeekInMonthPattern;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.FixedDayPattern;
import net.time4j.tz.model.GregorianTimezoneRule;
import net.time4j.tz.model.LastWeekdayPattern;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.RuleBasedTransitionModel;
import net.time4j.tz.model.RuleComparator;
import net.time4j.tz.model.TransitionModel;

final class SPX
implements Externalizable {
    static final int FIXED_DAY_PATTERN_TYPE = 120;
    static final int DAY_OF_WEEK_IN_MONTH_PATTERN_TYPE = 121;
    static final int LAST_WEEKDAY_PATTERN_TYPE = 122;
    static final int RULE_BASED_TRANSITION_MODEL_TYPE = 125;
    static final int ARRAY_TRANSITION_MODEL_TYPE = 126;
    static final int COMPOSITE_TRANSITION_MODEL_TYPE = 127;
    private static final long POSIX_TIME_1825 = -4575744000L;
    private static final long DAYS_IN_18_BITS = 22642848000L;
    private static final long QUARTERS_IN_24_BITS = 15040511099L;
    private static final int NO_COMPRESSION = 0;
    private static final long serialVersionUID = 6526945678752534989L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 120: {
                SPX.writeFixedDayPattern(this.obj, objectOutput);
                break;
            }
            case 121: {
                SPX.writeDayOfWeekInMonthPattern(this.obj, objectOutput);
                break;
            }
            case 122: {
                SPX.writeLastDayOfWeekPattern(this.obj, objectOutput);
                break;
            }
            case 125: {
                SPX.writeRuleBasedTransitionModel(this.obj, objectOutput);
                break;
            }
            case 126: {
                SPX.writeArrayTransitionModel(this.obj, objectOutput);
                break;
            }
            case 127: {
                SPX.writeCompositeTransitionModel(this.obj, objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by) {
            case 120: {
                this.obj = SPX.readFixedDayPattern(objectInput);
                break;
            }
            case 121: {
                this.obj = SPX.readDayOfWeekInMonthPattern(objectInput);
                break;
            }
            case 122: {
                this.obj = SPX.readLastDayOfWeekPattern(objectInput);
                break;
            }
            case 125: {
                this.obj = SPX.readRuleBasedTransitionModel(objectInput);
                break;
            }
            case 126: {
                this.obj = SPX.readArrayTransitionModel(objectInput);
                break;
            }
            case 127: {
                this.obj = SPX.readCompositeTransitionModel(objectInput);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    static void writeTransitions(ZonalTransition[] zonalTransitionArray, int n, DataOutput dataOutput) throws IOException {
        int n2 = Math.min(n, zonalTransitionArray.length);
        dataOutput.writeInt(n2);
        if (n2 > 0) {
            int n3 = zonalTransitionArray[0].getPreviousOffset();
            SPX.writeOffset(dataOutput, n3);
            for (int i = 0; i < n2; ++i) {
                n3 = SPX.writeTransition(zonalTransitionArray[i], n3, dataOutput);
            }
        }
    }

    private static List<ZonalTransition> readTransitions(ObjectInput objectInput) throws IOException {
        int n;
        int n2 = objectInput.readInt();
        if (n2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>(n2);
        int n3 = n = SPX.readOffset(objectInput);
        long l = Long.MIN_VALUE;
        for (int i = 0; i < n2; ++i) {
            int n4;
            long l2;
            byte by = objectInput.readByte();
            boolean bl = by < 0;
            int n5 = by >>> 5 & 3;
            int n6 = by >>> 2 & 7;
            int n7 = SPX.toTimeOfDayT(n6);
            if (n7 == -1) {
                l2 = objectInput.readLong();
            } else {
                n4 = (by & 3) << 16;
                n4 |= (objectInput.readByte() & 0xFF) << 8;
                l2 = (long)(n4 |= objectInput.readByte() & 0xFF) * 86400L + -4575744000L + (long)n7 - 7200L;
                l2 -= (long)n3;
            }
            if (l2 <= l) {
                throw new StreamCorruptedException("Wrong order of transitions.");
            }
            l = l2;
            switch (n5) {
                case 1: {
                    n4 = 0;
                    break;
                }
                case 2: {
                    n4 = 3600;
                    break;
                }
                case 3: {
                    n4 = 7200;
                    break;
                }
                default: {
                    n4 = SPX.readOffset(objectInput);
                }
            }
            if (bl) {
                n3 = SPX.readOffset(objectInput);
            }
            int n8 = n3 + (n4 == Integer.MAX_VALUE ? 0 : n4);
            ZonalTransition zonalTransition = new ZonalTransition(l2, n, n8, n4);
            n = n8;
            arrayList.add(zonalTransition);
        }
        return arrayList;
    }

    private static void writeRules(List<DaylightSavingRule> list, ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(list.size());
        block5: for (DaylightSavingRule daylightSavingRule : list) {
            objectOutput.writeByte(daylightSavingRule.getType());
            switch (daylightSavingRule.getType()) {
                case 120: {
                    SPX.writeFixedDayPattern(daylightSavingRule, objectOutput);
                    continue block5;
                }
                case 121: {
                    SPX.writeDayOfWeekInMonthPattern(daylightSavingRule, objectOutput);
                    continue block5;
                }
                case 122: {
                    SPX.writeLastDayOfWeekPattern(daylightSavingRule, objectOutput);
                    continue block5;
                }
            }
            objectOutput.writeObject(daylightSavingRule);
        }
    }

    private static List<DaylightSavingRule> readRules(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readByte();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<DaylightSavingRule> arrayList = new ArrayList<DaylightSavingRule>(n);
        DaylightSavingRule daylightSavingRule = null;
        for (int i = 0; i < n; ++i) {
            DaylightSavingRule daylightSavingRule2;
            byte by = objectInput.readByte();
            switch (by) {
                case 120: {
                    daylightSavingRule2 = SPX.readFixedDayPattern(objectInput);
                    break;
                }
                case 121: {
                    daylightSavingRule2 = SPX.readDayOfWeekInMonthPattern(objectInput);
                    break;
                }
                case 122: {
                    daylightSavingRule2 = SPX.readLastDayOfWeekPattern(objectInput);
                    break;
                }
                default: {
                    daylightSavingRule2 = (DaylightSavingRule)objectInput.readObject();
                }
            }
            if (daylightSavingRule != null && RuleComparator.INSTANCE.compare(daylightSavingRule, daylightSavingRule2) >= 0) {
                throw new InvalidObjectException("Order of daylight saving rules is not ascending.");
            }
            daylightSavingRule = daylightSavingRule2;
            arrayList.add(daylightSavingRule2);
        }
        return arrayList;
    }

    private static void writeOffset(DataOutput dataOutput, int n) throws IOException {
        if (n % 900 == 0) {
            dataOutput.writeByte(n / 900);
        } else {
            dataOutput.writeByte(127);
            dataOutput.writeInt(n);
        }
    }

    private static int readOffset(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        if (by == 127) {
            return dataInput.readInt();
        }
        return by * 900;
    }

    private static int readSavings(int n) throws IOException {
        switch (n / 3) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1800;
            }
            case 2: {
                return 3600;
            }
            case 3: {
                return 7200;
            }
        }
        return -1;
    }

    private static void writeFixedDayPattern(Object object, DataOutput dataOutput) throws IOException {
        FixedDayPattern fixedDayPattern = (FixedDayPattern)object;
        boolean bl = SPX.writeMonthIndicatorOffset(fixedDayPattern, dataOutput);
        int n = fixedDayPattern.getDayOfMonth() << 3;
        int n2 = (Integer)fixedDayPattern.getTimeOfDay().get(PlainTime.SECOND_OF_DAY);
        int n3 = SPX.toTimeIndexR(n2);
        dataOutput.writeByte((n |= n3) & 0xFF);
        if (!bl) {
            SPX.writeOffset(dataOutput, fixedDayPattern.getSavings0());
        }
        if (n3 == 0) {
            dataOutput.writeInt(n2);
        }
    }

    private static DaylightSavingRule readFixedDayPattern(DataInput dataInput) throws IOException, ClassNotFoundException {
        int n = dataInput.readByte() & 0xFF;
        int n2 = n >>> 4;
        int n3 = n & 0xF;
        OffsetIndicator offsetIndicator = OffsetIndicator.VALUES[n3 % 3];
        int n4 = SPX.readSavings(n3);
        int n5 = dataInput.readByte() & 0xFF;
        int n6 = n5 >>> 3;
        int n7 = SPX.toTimeOfDayR(n5 & 7);
        if (n4 == -1) {
            n4 = SPX.readOffset(dataInput);
        }
        if (n7 == -1) {
            n7 = dataInput.readInt();
        }
        PlainTime plainTime = (PlainTime)PlainTime.midnightAtStartOfDay().with((ChronoElement<Integer>)PlainTime.SECOND_OF_DAY, n7);
        return new FixedDayPattern(Month.valueOf(n2), n6, plainTime, offsetIndicator, n4);
    }

    private static void writeDayOfWeekInMonthPattern(Object object, DataOutput dataOutput) throws IOException {
        DayOfWeekInMonthPattern dayOfWeekInMonthPattern = (DayOfWeekInMonthPattern)object;
        boolean bl = SPX.writeMonthIndicatorOffset(dayOfWeekInMonthPattern, dataOutput);
        int n = dayOfWeekInMonthPattern.getDayOfMonth() << 3;
        dataOutput.writeByte((n |= dayOfWeekInMonthPattern.getDayOfWeek()) & 0xFF);
        int n2 = dayOfWeekInMonthPattern.isAfter() ? 128 : 0;
        int n3 = (Integer)dayOfWeekInMonthPattern.getTimeOfDay().get(PlainTime.SECOND_OF_DAY);
        boolean bl2 = false;
        if (n3 % 1800 == 0) {
            n2 |= n3 / 1800;
            bl2 = true;
        } else {
            n2 |= 0x3F;
        }
        dataOutput.writeByte(n2 & 0xFF);
        if (!bl) {
            SPX.writeOffset(dataOutput, dayOfWeekInMonthPattern.getSavings0());
        }
        if (!bl2) {
            dataOutput.writeInt(n3);
        }
    }

    private static DaylightSavingRule readDayOfWeekInMonthPattern(DataInput dataInput) throws IOException, ClassNotFoundException {
        int n = dataInput.readByte() & 0xFF;
        Month month = Month.valueOf(n >>> 4);
        int n2 = n & 0xF;
        OffsetIndicator offsetIndicator = OffsetIndicator.VALUES[n2 % 3];
        int n3 = SPX.readSavings(n2);
        int n4 = dataInput.readByte() & 0xFF;
        int n5 = n4 >>> 3;
        Weekday weekday = Weekday.valueOf(n4 & 7);
        int n6 = dataInput.readByte() & 0xFF;
        boolean bl = n6 >>> 7 == 1;
        int n7 = n6 & 0x3F;
        if (n3 == -1) {
            n3 = SPX.readOffset(dataInput);
        }
        n7 = n7 == 63 ? dataInput.readInt() : (n7 *= 1800);
        PlainTime plainTime = (PlainTime)PlainTime.midnightAtStartOfDay().with((ChronoElement<Integer>)PlainTime.SECOND_OF_DAY, n7);
        return new DayOfWeekInMonthPattern(month, n5, weekday, plainTime, offsetIndicator, n3, bl);
    }

    private static void writeLastDayOfWeekPattern(Object object, DataOutput dataOutput) throws IOException {
        LastWeekdayPattern lastWeekdayPattern = (LastWeekdayPattern)object;
        boolean bl = SPX.writeMonthIndicatorOffset(lastWeekdayPattern, dataOutput);
        int n = lastWeekdayPattern.getDayOfWeek() << 5;
        int n2 = (Integer)lastWeekdayPattern.getTimeOfDay().get(PlainTime.SECOND_OF_DAY);
        boolean bl2 = false;
        if (n2 % 3600 == 0) {
            n |= n2 / 3600;
            bl2 = true;
        } else {
            n |= 0x1F;
        }
        dataOutput.writeByte(n & 0xFF);
        if (!bl) {
            SPX.writeOffset(dataOutput, lastWeekdayPattern.getSavings0());
        }
        if (!bl2) {
            dataOutput.writeInt(n2);
        }
    }

    private static DaylightSavingRule readLastDayOfWeekPattern(DataInput dataInput) throws IOException, ClassNotFoundException {
        int n = dataInput.readByte() & 0xFF;
        Month month = Month.valueOf(n >>> 4);
        int n2 = n & 0xF;
        OffsetIndicator offsetIndicator = OffsetIndicator.VALUES[n2 % 3];
        int n3 = SPX.readSavings(n2);
        int n4 = dataInput.readByte() & 0xFF;
        Weekday weekday = Weekday.valueOf(n4 >>> 5);
        int n5 = n4 & 0x1F;
        if (n3 == -1) {
            n3 = SPX.readOffset(dataInput);
        }
        n5 = n5 == 31 ? dataInput.readInt() : (n5 *= 3600);
        PlainTime plainTime = (PlainTime)PlainTime.midnightAtStartOfDay().with((ChronoElement<Integer>)PlainTime.SECOND_OF_DAY, n5);
        return new LastWeekdayPattern(month, weekday, plainTime, offsetIndicator, n3);
    }

    private static void writeRuleBasedTransitionModel(Object object, ObjectOutput objectOutput) throws IOException {
        int n;
        RuleBasedTransitionModel ruleBasedTransitionModel = (RuleBasedTransitionModel)object;
        ZonalTransition zonalTransition = ruleBasedTransitionModel.getInitialTransition();
        long l = zonalTransition.getPosixTime();
        if (l >= -4575744000L && l < 10464767099L && l % 900L == 0L) {
            n = (int)((l - -4575744000L) / 900L);
            objectOutput.writeByte(n >>> 16 & 0xFF);
            objectOutput.writeByte(n >>> 8 & 0xFF);
            objectOutput.writeByte(n & 0xFF);
        } else {
            objectOutput.writeByte(255);
            objectOutput.writeLong(zonalTransition.getPosixTime());
        }
        SPX.writeOffset(objectOutput, zonalTransition.getPreviousOffset());
        SPX.writeOffset(objectOutput, zonalTransition.getTotalOffset());
        n = zonalTransition.getDaylightSavingOffset();
        if (zonalTransition.isDaylightSaving() && n == 0) {
            n = Integer.MAX_VALUE;
        }
        SPX.writeOffset(objectOutput, n);
        SPX.writeRules(ruleBasedTransitionModel.getRules(), objectOutput);
    }

    private static Object readRuleBasedTransitionModel(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        long l;
        int n3 = objectInput.readByte() & 0xFF;
        if (n3 == 255) {
            l = objectInput.readLong();
        } else {
            n2 = objectInput.readByte() & 0xFF;
            n = objectInput.readByte() & 0xFF;
            l = (long)((n3 << 16) + (n2 << 8) + n) * 900L;
            l += -4575744000L;
        }
        n2 = SPX.readOffset(objectInput);
        n = SPX.readOffset(objectInput);
        int n4 = SPX.readOffset(objectInput);
        ZonalTransition zonalTransition = new ZonalTransition(l, n2, n, n4);
        List<DaylightSavingRule> list = SPX.readRules(objectInput);
        return new RuleBasedTransitionModel(zonalTransition, list, false);
    }

    private static void writeArrayTransitionModel(Object object, ObjectOutput objectOutput) throws IOException {
        ArrayTransitionModel arrayTransitionModel = (ArrayTransitionModel)object;
        arrayTransitionModel.writeTransitions(objectOutput);
    }

    private static Object readArrayTransitionModel(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        return new ArrayTransitionModel(SPX.readTransitions(objectInput), false, false);
    }

    private static void writeCompositeTransitionModel(Object object, ObjectOutput objectOutput) throws IOException {
        CompositeTransitionModel compositeTransitionModel = (CompositeTransitionModel)object;
        compositeTransitionModel.writeTransitions(objectOutput);
        SPX.writeRules(compositeTransitionModel.getRules(), objectOutput);
    }

    private static Object readCompositeTransitionModel(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        List<ZonalTransition> list = SPX.readTransitions(objectInput);
        return TransitionModel.of(ZonalOffset.ofTotalSeconds(list.get(0).getPreviousOffset()), list, SPX.readRules(objectInput), false, false);
    }

    private static int writeTransition(ZonalTransition zonalTransition, int n, DataOutput dataOutput) throws IOException {
        int n2;
        int n3 = zonalTransition.getStandardOffset();
        boolean bl = n3 != n;
        int n4 = 0;
        if (bl) {
            n4 = (byte)(n4 | 0x80);
        }
        int n5 = zonalTransition.getDaylightSavingOffset();
        if (zonalTransition.isDaylightSaving() && n5 == 0) {
            n5 = Integer.MAX_VALUE;
        }
        switch (n5) {
            case 0: {
                n2 = 1;
                break;
            }
            case 3600: {
                n2 = 2;
                break;
            }
            case 7200: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        n4 = (byte)(n4 | n2 << 5);
        long l = zonalTransition.getPosixTime() + (long)n + 7200L;
        int n6 = 0;
        if (l >= -4575744000L && l < 18067104000L) {
            n6 = SPX.toTimeIndexT(MathUtils.floorModulo(l, 86400));
        }
        n4 = (byte)(n4 | n6 << 2);
        if (n6 == 0) {
            dataOutput.writeByte(n4);
            dataOutput.writeLong(zonalTransition.getPosixTime());
        } else {
            int n7 = (int)((l - -4575744000L) / 86400L);
            byte by = (byte)(n7 >>> 16 & 3);
            n4 = (byte)(n4 | by);
            dataOutput.writeByte(n4);
            dataOutput.writeByte(n7 >>> 8 & 0xFF);
            dataOutput.writeByte(n7 & 0xFF);
        }
        if (n2 == 0) {
            SPX.writeOffset(dataOutput, n5);
        }
        if (bl) {
            SPX.writeOffset(dataOutput, n3);
        }
        return n3;
    }

    private static int toTimeIndexT(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 60: {
                return 2;
            }
            case 3600: {
                return 3;
            }
            case 7200: {
                return 4;
            }
            case 10800: {
                return 5;
            }
            case 14400: {
                return 6;
            }
            case 18000: {
                return 7;
            }
        }
        return 0;
    }

    private static int toTimeOfDayT(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 60;
            }
            case 3: {
                return 3600;
            }
            case 4: {
                return 7200;
            }
            case 5: {
                return 10800;
            }
            case 6: {
                return 14400;
            }
            case 7: {
                return 18000;
            }
        }
        return -1;
    }

    private static boolean writeMonthIndicatorOffset(GregorianTimezoneRule gregorianTimezoneRule, DataOutput dataOutput) throws IOException {
        int n = gregorianTimezoneRule.getMonthValue() << 4;
        int n2 = gregorianTimezoneRule.getIndicator().ordinal();
        int n3 = gregorianTimezoneRule.getSavings0();
        boolean bl = true;
        switch (n3) {
            case 0: {
                n |= n2;
                break;
            }
            case 1800: {
                n |= 3 + n2;
                break;
            }
            case 3600: {
                n |= 6 + n2;
                break;
            }
            case 7200: {
                n |= 9 + n2;
                break;
            }
            default: {
                bl = false;
                n |= 12 + n2;
            }
        }
        dataOutput.writeByte(n & 0xFF);
        return bl;
    }

    private static int toTimeIndexR(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 3600: {
                return 2;
            }
            case 7200: {
                return 3;
            }
            case 10800: {
                return 4;
            }
            case 79200: {
                return 5;
            }
            case 82800: {
                return 6;
            }
            case 86400: {
                return 7;
            }
        }
        return 0;
    }

    private static int toTimeOfDayR(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 3600;
            }
            case 3: {
                return 7200;
            }
            case 4: {
                return 10800;
            }
            case 5: {
                return 79200;
            }
            case 6: {
                return 82800;
            }
            case 7: {
                return 86400;
            }
        }
        return -1;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

