/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.SystemClock;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.Temporal;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.PatternType;
import net.time4j.tz.Timezone;

@CalendarType(value="iso8601")
public final class AnnualDate
extends ChronoEntity<AnnualDate>
implements Comparable<AnnualDate>,
Temporal<AnnualDate>,
LocalizedPatternSupport,
Serializable {
    @FormattableElement(format="M", standalone="L")
    public static final ChronoElement<Month> MONTH_OF_YEAR = PlainDate.MONTH_OF_YEAR;
    public static final ChronoElement<Integer> MONTH_AS_NUMBER = PlainDate.MONTH_AS_NUMBER;
    @FormattableElement(format="d")
    public static final ChronoElement<Integer> DAY_OF_MONTH = PlainDate.DAY_OF_MONTH;
    private static final Chronology<AnnualDate> ENGINE = Chronology.Builder.setUp(AnnualDate.class, new Merger()).appendElement(DAY_OF_MONTH, new IntegerElementRule(true)).appendElement(MONTH_OF_YEAR, new MonthElementRule()).appendElement(MONTH_AS_NUMBER, new IntegerElementRule(false)).build();
    private static final ChronoFormatter<AnnualDate> PARSER = ChronoFormatter.setUp(ENGINE, Locale.ROOT).addPattern("--MM-dd", PatternType.CLDR).build();
    private static final long serialVersionUID = 7510648008819092983L;
    private final int month;
    private final int dayOfMonth;

    private AnnualDate(int n, int n2) {
        this.month = n;
        this.dayOfMonth = n2;
    }

    public static AnnualDate of(Month month, int n) {
        return AnnualDate.of(month.getValue(), n);
    }

    public static AnnualDate of(int n, int n2) {
        AnnualDate.check(n, n2);
        return new AnnualDate(n, n2);
    }

    public static AnnualDate from(GregorianDate gregorianDate) {
        PlainDate plainDate = PlainDate.from(gregorianDate);
        return new AnnualDate(plainDate.getMonth(), plainDate.getDayOfMonth());
    }

    public static AnnualDate nowInSystemTime() {
        return SystemClock.inLocalView().now(ENGINE);
    }

    public Month getMonth() {
        return Month.valueOf(this.month);
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Override
    public boolean isAfter(AnnualDate annualDate) {
        return this.compareTo(annualDate) > 0;
    }

    @Override
    public boolean isBefore(AnnualDate annualDate) {
        return this.compareTo(annualDate) < 0;
    }

    @Override
    public boolean isSimultaneous(AnnualDate annualDate) {
        return this.compareTo(annualDate) == 0;
    }

    @Override
    public int compareTo(AnnualDate annualDate) {
        if (this.month < annualDate.month) {
            return -1;
        }
        if (this.month > annualDate.month) {
            return 1;
        }
        if (this.dayOfMonth < annualDate.dayOfMonth) {
            return -1;
        }
        if (this.dayOfMonth > annualDate.dayOfMonth) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AnnualDate) {
            AnnualDate annualDate = (AnnualDate)object;
            return this.month == annualDate.month && this.dayOfMonth == annualDate.dayOfMonth;
        }
        return false;
    }

    public int hashCode() {
        return (this.month << 16) + this.dayOfMonth;
    }

    public String toString() {
        return AnnualDate.toString(this.month, this.dayOfMonth);
    }

    public static AnnualDate parseXML(String string) throws ParseException {
        return PARSER.parse(string);
    }

    public PlainDate atYear(int n) {
        return PlainDate.of(n, this.month, this.dayOfMonth);
    }

    public boolean isValidDate(int n) {
        return n >= -999999999 && n <= 999999999 && (this.month != 2 || this.dayOfMonth != 29 || GregorianMath.isLeapYear(n));
    }

    public ChronoOperator<PlainDate> asNextExactEvent() {
        return new ChronoOperator<PlainDate>(){

            @Override
            public PlainDate apply(PlainDate plainDate) {
                int n = plainDate.getYear();
                int n2 = AnnualDate.this.getMonth().getValue();
                int n3 = AnnualDate.this.getDayOfMonth();
                if (n2 < plainDate.getMonth() || n2 == plainDate.getMonth() && n3 <= plainDate.getDayOfMonth()) {
                    ++n;
                }
                if (n2 == 2 && n3 == 29) {
                    while (!GregorianMath.isLeapYear(n)) {
                        ++n;
                    }
                }
                return PlainDate.of(n, n2, n3);
            }
        };
    }

    public ChronoOperator<PlainDate> asNextRoundedEvent() {
        return new ChronoOperator<PlainDate>(){

            @Override
            public PlainDate apply(PlainDate plainDate) {
                int n = plainDate.getYear();
                int n2 = AnnualDate.this.getMonth().getValue();
                int n3 = AnnualDate.this.getDayOfMonth();
                if (n2 < plainDate.getMonth() || n2 == plainDate.getMonth() && n3 <= plainDate.getDayOfMonth()) {
                    ++n;
                }
                if (n2 == 2 && n3 == 29 && !GregorianMath.isLeapYear(n)) {
                    n2 = 3;
                    n3 = 1;
                }
                return PlainDate.of(n, n2, n3);
            }
        };
    }

    public static Chronology<AnnualDate> chronology() {
        return ENGINE;
    }

    @Override
    protected Chronology<AnnualDate> getChronology() {
        return ENGINE;
    }

    @Override
    protected AnnualDate getContext() {
        return this;
    }

    private static void check(int n, int n2) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Month not in range 1-12: " + n);
        }
        if (n2 < 1 || n2 > AnnualDate.getMaxDay(n)) {
            throw new IllegalArgumentException("Out of bounds: " + AnnualDate.toString(n, n2));
        }
    }

    private static int getMaxDay(int n) {
        switch (n) {
            case 2: {
                return 29;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    private static String toString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("--");
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        stringBuilder.append('-');
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            AnnualDate.check(this.month, this.dayOfMonth);
            return this;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException(illegalArgumentException.getMessage());
        }
    }

    private static class IntegerElementRule
    implements IntElementRule<AnnualDate> {
        private final boolean daywise;

        IntegerElementRule(boolean bl) {
            this.daywise = bl;
        }

        @Override
        public int getInt(AnnualDate annualDate) {
            return this.daywise ? annualDate.dayOfMonth : annualDate.month;
        }

        @Override
        public boolean isValid(AnnualDate annualDate, int n) {
            if (n < 1) {
                return false;
            }
            if (this.daywise) {
                return n <= AnnualDate.getMaxDay(annualDate.month);
            }
            return n <= 12;
        }

        @Override
        public AnnualDate withValue(AnnualDate annualDate, int n, boolean bl) {
            if (this.daywise) {
                return AnnualDate.of(annualDate.month, n);
            }
            return AnnualDate.of(n, Math.min(annualDate.dayOfMonth, AnnualDate.getMaxDay(n)));
        }

        @Override
        public Integer getValue(AnnualDate annualDate) {
            return this.getInt(annualDate);
        }

        @Override
        public Integer getMinimum(AnnualDate annualDate) {
            return 1;
        }

        @Override
        public Integer getMaximum(AnnualDate annualDate) {
            if (this.daywise) {
                return AnnualDate.getMaxDay(annualDate.month);
            }
            return 12;
        }

        @Override
        public boolean isValid(AnnualDate annualDate, Integer n) {
            if (n == null) {
                return false;
            }
            return this.isValid(annualDate, (int)n);
        }

        @Override
        public AnnualDate withValue(AnnualDate annualDate, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            return this.withValue(annualDate, (int)n, bl);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(AnnualDate annualDate) {
            return this.daywise ? null : DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(AnnualDate annualDate) {
            return this.daywise ? null : DAY_OF_MONTH;
        }
    }

    private static class MonthElementRule
    implements ElementRule<AnnualDate, Month> {
        private MonthElementRule() {
        }

        @Override
        public Month getValue(AnnualDate annualDate) {
            return annualDate.getMonth();
        }

        @Override
        public Month getMinimum(AnnualDate annualDate) {
            return Month.JANUARY;
        }

        @Override
        public Month getMaximum(AnnualDate annualDate) {
            return Month.DECEMBER;
        }

        @Override
        public boolean isValid(AnnualDate annualDate, Month month) {
            return month != null;
        }

        @Override
        public AnnualDate withValue(AnnualDate annualDate, Month month, boolean bl) {
            if (month == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            int n = month.getValue();
            return new AnnualDate(n, Math.min(annualDate.dayOfMonth, AnnualDate.getMaxDay(n)));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(AnnualDate annualDate) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(AnnualDate annualDate) {
            return DAY_OF_MONTH;
        }
    }

    private static class Merger
    implements ChronoMerger<AnnualDate> {
        private Merger() {
        }

        @Override
        public AnnualDate createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of(attributeQuery.get(Attributes.TIMEZONE_ID));
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            PlainDate plainDate = Moment.from(timeSource.currentTime()).toZonalTimestamp(timezone.getID()).toDate();
            return AnnualDate.of(plainDate.getMonth(), plainDate.getDayOfMonth());
        }

        @Override
        public AnnualDate createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public AnnualDate createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(DAY_OF_MONTH);
            if (n != Integer.MIN_VALUE) {
                int n2 = chronoEntity.getInt(PlainDate.MONTH_AS_NUMBER);
                if (n2 == Integer.MIN_VALUE && chronoEntity.contains(MONTH_OF_YEAR)) {
                    n2 = chronoEntity.get(MONTH_OF_YEAR).getValue();
                }
                if (n2 != Integer.MIN_VALUE) {
                    if (n >= 1 && n <= AnnualDate.getMaxDay(n2)) {
                        if (n2 >= 1 && n2 <= 12) {
                            return new AnnualDate(n2, n);
                        }
                        chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Month out of bounds: " + n2);
                    } else {
                        chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Day-of-month out of bounds: " + n);
                    }
                }
            }
            return null;
        }

        @Override
        public ChronoDisplay preformat(AnnualDate annualDate, AttributeQuery attributeQuery) {
            return annualDate;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            Map<String, String> map = CalendarText.getIsoInstance(locale).getTextForms();
            String string = null;
            switch (displayStyle.getStyleValue()) {
                case 0: {
                    string = "F_MMMMd";
                    break;
                }
                case 1: {
                    string = "F_MMMd";
                    break;
                }
                case 2: {
                    string = "F_MMd";
                    break;
                }
                case 3: {
                    string = "F_Md";
                }
            }
            String string2 = Merger.getFormatPattern(map, string);
            return string2 == null ? "MM-dd" : string2;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        @Override
        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear();
        }

        private static String getFormatPattern(Map<String, String> map, String string) {
            if (map.containsKey(string)) {
                return map.get(string);
            }
            if ("F_MMMMd".equals(string)) {
                return Merger.getFormatPattern(map, "F_MMMd");
            }
            if ("F_MMMd".equals(string)) {
                return Merger.getFormatPattern(map, "F_MMd");
            }
            if ("F_MMd".equals(string)) {
                return Merger.getFormatPattern(map, "F_Md");
            }
            return null;
        }
    }
}

