/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.base.GregorianMath;
import net.time4j.tz.model.GregorianTimezoneRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.SPX;

final class FixedDayPattern
extends GregorianTimezoneRule {
    private static final long serialVersionUID = 3957240859230862745L;
    private final transient byte dayOfMonth;

    FixedDayPattern(Month month, int n, PlainTime plainTime, OffsetIndicator offsetIndicator, int n2) {
        super(month, plainTime, offsetIndicator, n2);
        GregorianMath.checkDate(2000, month.getValue(), n);
        this.dayOfMonth = (byte)n;
    }

    @Override
    public PlainDate getDate(int n) {
        return PlainDate.of(n, (int)this.getMonthValue(), (int)this.dayOfMonth);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FixedDayPattern) {
            FixedDayPattern fixedDayPattern = (FixedDayPattern)object;
            return this.dayOfMonth == fixedDayPattern.dayOfMonth && super.isEqual(fixedDayPattern);
        }
        return false;
    }

    public int hashCode() {
        return this.dayOfMonth + 37 * this.getMonthValue();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("FixedDayPattern:[month=");
        stringBuilder.append(this.getMonthValue());
        stringBuilder.append(",day-of-month=");
        stringBuilder.append(this.dayOfMonth);
        stringBuilder.append(",time-of-day=");
        stringBuilder.append(this.getTimeOfDay());
        stringBuilder.append(",offset-indicator=");
        stringBuilder.append((Object)this.getIndicator());
        stringBuilder.append(",dst-active=");
        stringBuilder.append(this.isSaving());
        stringBuilder.append(",dst-offset=");
        stringBuilder.append(this.getSavings());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    int getDayOfMonth() {
        return this.dayOfMonth;
    }

    @Override
    int getType() {
        return 120;
    }

    private Object writeReplace() {
        return new SPX(this, this.getType());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

