/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import net.time4j.Moment;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TimeScale;

public enum AstronomicalSeason {
    VERNAL_EQUINOX,
    SUMMER_SOLSTICE,
    AUTUMNAL_EQUINOX,
    WINTER_SOLSTICE;

    private static final int[] A;
    private static final double[] B;
    private static final double[] C;

    public Moment inYear(int n) {
        TimeScale timeScale;
        double d;
        double d2 = (this.jdEphemerisDays(n) - 2441317.5) * 86400.0;
        boolean bl = LeapSeconds.getInstance().isEnabled();
        if (!bl || n < 1972) {
            d = d2 - TimeScale.deltaT(n, (this.ordinal() + 1) * 3);
            timeScale = TimeScale.UT;
        } else {
            d = d2 - 42.184;
            timeScale = TimeScale.UTC;
        }
        long l = (long)Math.floor(d);
        int n2 = (int)((d - (double)l) * 1.0E9);
        if (!bl) {
            l += 63072000L;
            timeScale = TimeScale.POSIX;
        }
        return Moment.of(l, n2, timeScale);
    }

    public JulianDay julianDay(int n) {
        return JulianDay.ofEphemerisTime(this.jdEphemerisDays(n));
    }

    public AstronomicalSeason onNorthernHemisphere() {
        return this;
    }

    public AstronomicalSeason onSouthernHemisphere() {
        return AstronomicalSeason.values()[(this.ordinal() + 2) % 4];
    }

    private double jdEphemerisDays(int n) {
        double d = this.jdMean(n);
        double d2 = (d - 2451545.0) / 36525.0;
        double d3 = 35999.373 * d2 - 2.47;
        double d4 = 1.0 + 0.0334 * AstronomicalSeason.cos(d3) + 7.0E-4 * AstronomicalSeason.cos(2.0 * d3);
        double d5 = AstronomicalSeason.periodic24(d2);
        return d + 1.0E-5 * d5 / d4;
    }

    private double jdMean(int n) {
        if (n < 1000) {
            double d = (double)n / 1000.0;
            switch (this) {
                case VERNAL_EQUINOX: {
                    return 1721139.29189 + (365242.1374 + (0.06134 + (0.00111 - 7.1E-4 * d) * d) * d) * d;
                }
                case SUMMER_SOLSTICE: {
                    return 1721233.25401 + (365241.72562 + (-0.05323 + (0.00907 + 2.5E-4 * d) * d) * d) * d;
                }
                case AUTUMNAL_EQUINOX: {
                    return 1721325.70455 + (365242.49558 + (-0.11677 + (-0.00297 + 7.4E-4 * d) * d) * d) * d;
                }
                case WINTER_SOLSTICE: {
                    return 1721414.39987 + (365242.88257 + (-0.00769 + (-0.00933 - 6.0E-5 * d) * d) * d) * d;
                }
            }
            throw new AssertionError((Object)this);
        }
        double d = (double)(n - 2000) / 1000.0;
        switch (this) {
            case VERNAL_EQUINOX: {
                return 2451623.80984 + (365242.37404 + (0.05169 + (-0.00411 - 5.7E-4 * d) * d) * d) * d;
            }
            case SUMMER_SOLSTICE: {
                return 2451716.56767 + (365241.62603 + (0.00325 + (0.00888 - 3.0E-4 * d) * d) * d) * d;
            }
            case AUTUMNAL_EQUINOX: {
                return 2451810.21715 + (365242.01767 + (-0.11575 + (0.00337 + 7.8E-4 * d) * d) * d) * d;
            }
            case WINTER_SOLSTICE: {
                return 2451900.05952 + (365242.74049 + (-0.06223 + (-0.00823 + 3.2E-4 * d) * d) * d) * d;
            }
        }
        throw new AssertionError((Object)this);
    }

    private static double periodic24(double d) {
        double d2 = 0.0;
        for (int i = 0; i < 24; ++i) {
            d2 += (double)A[i] * AstronomicalSeason.cos(B[i] + C[i] * d);
        }
        return d2;
    }

    private static double cos(double d) {
        return Math.cos(d * Math.PI / 180.0);
    }

    static {
        A = new int[]{485, 203, 199, 182, 156, 136, 77, 74, 70, 58, 52, 50, 45, 44, 29, 18, 17, 16, 14, 12, 12, 12, 9, 8};
        B = new double[]{324.96, 337.23, 342.08, 27.85, 73.14, 171.52, 222.54, 296.72, 243.58, 119.81, 297.17, 21.02, 247.54, 325.15, 60.93, 155.12, 288.79, 198.04, 199.76, 95.39, 287.11, 320.81, 227.73, 15.45};
        C = new double[]{1934.136, 32964.467, 20.186, 445267.112, 45036.886, 22518.443, 65928.934, 3034.906, 9037.513, 33718.147, 150.678, 2281.226, 29929.562, 31555.956, 4443.417, 67555.328, 4562.452, 62894.029, 31436.921, 14577.848, 31931.756, 34777.259, 1222.114, 16859.074};
    }
}

