/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.MinguoEra;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="roc")
public final class MinguoCalendar
extends Calendrical<CalendarUnit, MinguoCalendar>
implements LocalizedPatternSupport {
    @FormattableElement(format="G")
    public static final ChronoElement<MinguoEra> ERA = new StdEnumDateElement<MinguoEra, MinguoCalendar>("ERA", MinguoCalendar.class, MinguoEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, MinguoCalendar> YEAR_OF_ERA = new StdIntegerDateElement<MinguoCalendar>("YEAR_OF_ERA", MinguoCalendar.class, 1, 999998088, 'y', null, null);
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<Month, MinguoCalendar> MONTH_OF_YEAR = new StdEnumDateElement<Month, MinguoCalendar>("MONTH_OF_YEAR", MinguoCalendar.class, Month.class, 'M');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, MinguoCalendar> DAY_OF_MONTH = new StdIntegerDateElement<MinguoCalendar>("DAY_OF_MONTH", MinguoCalendar.class, 1, 31, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, MinguoCalendar> DAY_OF_YEAR = new StdIntegerDateElement<MinguoCalendar>("DAY_OF_YEAR", MinguoCalendar.class, 1, 365, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, MinguoCalendar> DAY_OF_WEEK = new StdWeekdayElement<MinguoCalendar>(MinguoCalendar.class, MinguoCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<MinguoCalendar> WIM_ELEMENT = new WeekdayInMonthElement<MinguoCalendar>(MinguoCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<MinguoCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final Map<Object, ChronoElement<?>> CHILDREN;
    private static final EraYearMonthDaySystem<MinguoCalendar> CALSYS;
    private static final TimeAxis<CalendarUnit, MinguoCalendar> ENGINE;
    private static final long serialVersionUID = -6628190121085147706L;
    private final PlainDate iso;

    private MinguoCalendar(PlainDate plainDate) {
        this.iso = plainDate;
    }

    public static MinguoCalendar of(MinguoEra minguoEra, int n, Month month, int n2) {
        return MinguoCalendar.of(minguoEra, n, month.getValue(), n2);
    }

    public static MinguoCalendar of(MinguoEra minguoEra, int n, int n2, int n3) {
        int n4 = MinguoCalendar.toProlepticYear(minguoEra, n);
        PlainDate plainDate = PlainDate.of(n4, n2, n3);
        return new MinguoCalendar(plainDate);
    }

    public static MinguoCalendar nowInSystemTime() {
        return (MinguoCalendar)SystemClock.inLocalView().now(MinguoCalendar.axis());
    }

    public MinguoEra getEra() {
        return this.iso.getYear() < 1912 ? MinguoEra.BEFORE_ROC : MinguoEra.ROC;
    }

    public int getYear() {
        MinguoEra minguoEra = this.getEra();
        return minguoEra == MinguoEra.ROC ? this.iso.getYear() - 1911 : 1912 - this.iso.getYear();
    }

    public Month getMonth() {
        return Month.valueOf(this.iso.getMonth());
    }

    public int getDayOfMonth() {
        return this.iso.getDayOfMonth();
    }

    public Weekday getDayOfWeek() {
        return this.iso.get(PlainDate.DAY_OF_WEEK);
    }

    public int getDayOfYear() {
        return (Integer)this.iso.get(PlainDate.DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return this.iso.lengthOfMonth();
    }

    public int lengthOfYear() {
        return this.iso.lengthOfYear();
    }

    public boolean isLeapYear() {
        return this.iso.isLeapYear();
    }

    public static boolean isValid(MinguoEra minguoEra, int n, int n2, int n3) {
        return CALSYS.isValid(minguoEra, n, n2, n3);
    }

    public GeneralTimestamp<MinguoCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<MinguoCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MinguoCalendar) {
            MinguoCalendar minguoCalendar = (MinguoCalendar)object;
            return this.iso.equals(minguoCalendar.iso);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.iso.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getEra());
        stringBuilder.append('-');
        stringBuilder.append(this.getYear());
        stringBuilder.append('-');
        int n = this.getMonth().getValue();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        stringBuilder.append('-');
        int n2 = this.getDayOfMonth();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SUNDAY, 1);
    }

    public static TimeAxis<CalendarUnit, MinguoCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<CalendarUnit, MinguoCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected MinguoCalendar getContext() {
        return this;
    }

    PlainDate toISO() {
        return this.iso;
    }

    private static int toProlepticYear(MinguoEra minguoEra, int n) {
        return minguoEra == MinguoEra.ROC ? MathUtils.safeAdd(n, 1911) : MathUtils.safeSubtract(1912, n);
    }

    private static void registerUnits(TimeAxis.Builder<CalendarUnit, MinguoCalendar> builder) {
        EnumSet<CalendarUnit> enumSet = EnumSet.range(CalendarUnit.MILLENNIA, CalendarUnit.MONTHS);
        EnumSet<CalendarUnit> enumSet2 = EnumSet.range(CalendarUnit.WEEKS, CalendarUnit.DAYS);
        for (CalendarUnit calendarUnit : CalendarUnit.values()) {
            builder.appendUnit(calendarUnit, new MinguoUnitRule(calendarUnit), calendarUnit.getLength(), calendarUnit.compareTo(CalendarUnit.WEEKS) < 0 ? enumSet : enumSet2);
        }
    }

    private Object writeReplace() {
        return new SPX(this, 6);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        HashMap<ChronoElement<MinguoEra>, StdCalendarElement<Object, MinguoCalendar>> hashMap = new HashMap<ChronoElement<MinguoEra>, StdCalendarElement<Object, MinguoCalendar>>();
        hashMap.put(ERA, YEAR_OF_ERA);
        hashMap.put(YEAR_OF_ERA, MONTH_OF_YEAR);
        hashMap.put(MONTH_OF_YEAR, DAY_OF_MONTH);
        CHILDREN = Collections.unmodifiableMap(hashMap);
        CALSYS = new Transformer();
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(CalendarUnit.class, MinguoCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)FieldRule.of(ERA))).appendElement(YEAR_OF_ERA, FieldRule.of(YEAR_OF_ERA), CalendarUnit.YEARS).appendElement(MONTH_OF_YEAR, FieldRule.of(MONTH_OF_YEAR), CalendarUnit.MONTHS).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<MinguoCalendar>(CALSYS, DAY_OF_YEAR))).appendElement(DAY_OF_MONTH, FieldRule.of(DAY_OF_MONTH), CalendarUnit.DAYS).appendElement(DAY_OF_YEAR, FieldRule.of(DAY_OF_YEAR), CalendarUnit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<MinguoCalendar>(MinguoCalendar.getDefaultWeekmodel(), new ChronoFunction<MinguoCalendar, CalendarSystem<MinguoCalendar>>(){

            @Override
            public CalendarSystem<MinguoCalendar> apply(MinguoCalendar minguoCalendar) {
                return CALSYS;
            }
        }), CalendarUnit.DAYS).appendElement(WIM_ELEMENT, (ElementRule)WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendExtension(new CommonElements.Weekengine(MinguoCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, MinguoCalendar.getDefaultWeekmodel()));
        MinguoCalendar.registerUnits((TimeAxis.Builder<CalendarUnit, MinguoCalendar>)builder);
        ENGINE = ((TimeAxis.Builder)builder).build();
    }

    private static class Merger
    implements ChronoMerger<MinguoCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("roc", displayStyle, locale);
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        @Override
        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() - 1911;
        }

        @Override
        public MinguoCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (MinguoCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        @Deprecated
        public MinguoCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public MinguoCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            MinguoEra minguoEra;
            if (chronoEntity.contains(PlainDate.COMPONENT)) {
                return new MinguoCalendar(chronoEntity.get(PlainDate.COMPONENT));
            }
            if (chronoEntity.contains(ERA)) {
                minguoEra = chronoEntity.get(ERA);
            } else if (bl) {
                minguoEra = MinguoEra.ROC;
            } else {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Minguo era.");
                return null;
            }
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Minguo year.");
                return null;
            }
            int n2 = MinguoCalendar.toProlepticYear(minguoEra, n);
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n3 = ((Month)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n4 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n4 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(minguoEra, n, n3, n4)) {
                        return MinguoCalendar.of(minguoEra, n, n3, n4);
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Minguo date.");
                }
            } else {
                int n5 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n5 != Integer.MIN_VALUE) {
                    if (n5 > 0) {
                        int n6 = 1;
                        int n7 = 0;
                        while (n6 <= 12) {
                            int n8 = GregorianMath.getLengthOfMonth(n2, n6);
                            if (n5 > n7 + n8) {
                                ++n6;
                                n7 += n8;
                                continue;
                            }
                            int n9 = n5 - n7;
                            return MinguoCalendar.of(minguoEra, n, n6, n9);
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Minguo date.");
                }
            }
            return null;
        }

        @Override
        public ChronoDisplay preformat(MinguoCalendar minguoCalendar, AttributeQuery attributeQuery) {
            return minguoCalendar;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }
    }

    private static class MinguoUnitRule
    implements UnitRule<MinguoCalendar> {
        private final CalendarUnit unit;

        MinguoUnitRule(CalendarUnit calendarUnit) {
            this.unit = calendarUnit;
        }

        @Override
        public MinguoCalendar addTo(MinguoCalendar minguoCalendar, long l) {
            return new MinguoCalendar((PlainDate)minguoCalendar.iso.plus(l, this.unit));
        }

        @Override
        public long between(MinguoCalendar minguoCalendar, MinguoCalendar minguoCalendar2) {
            return this.unit.between(minguoCalendar.iso, minguoCalendar2.iso);
        }
    }

    private static class FieldRule<V extends Comparable<V>>
    implements ElementRule<MinguoCalendar, V> {
        private final ChronoElement<V> element;

        private FieldRule(ChronoElement<V> chronoElement) {
            this.element = chronoElement;
        }

        static <V extends Comparable<V>> FieldRule<V> of(ChronoElement<V> chronoElement) {
            return new FieldRule<V>(chronoElement);
        }

        @Override
        public V getValue(MinguoCalendar minguoCalendar) {
            Object object;
            if (this.element == ERA) {
                object = minguoCalendar.getEra();
            } else if (this.element.equals(YEAR_OF_ERA)) {
                object = minguoCalendar.getYear();
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = minguoCalendar.getMonth();
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = minguoCalendar.getDayOfMonth();
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = minguoCalendar.getDayOfYear();
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public V getMinimum(MinguoCalendar minguoCalendar) {
            Object object;
            if (this.element == ERA) {
                object = MinguoEra.BEFORE_ROC;
            } else if (Integer.class.isAssignableFrom(this.element.getType())) {
                object = 1;
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = Month.JANUARY;
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public V getMaximum(MinguoCalendar minguoCalendar) {
            Object object;
            if (this.element == ERA) {
                object = MinguoEra.ROC;
            } else if (this.element.equals(YEAR_OF_ERA)) {
                MinguoEra minguoEra = minguoCalendar.getEra();
                object = minguoEra == MinguoEra.ROC ? Integer.valueOf(999998088) : Integer.valueOf(1000001911);
            } else if (this.element.equals(MONTH_OF_YEAR)) {
                object = Month.DECEMBER;
            } else if (this.element.equals(DAY_OF_MONTH)) {
                object = minguoCalendar.iso.getMaximum(PlainDate.DAY_OF_MONTH);
            } else if (this.element.equals(DAY_OF_YEAR)) {
                object = minguoCalendar.iso.getMaximum(PlainDate.DAY_OF_YEAR);
            } else {
                throw new ChronoException("Missing rule for: " + this.element.name());
            }
            return (V)((Comparable)this.element.getType().cast(object));
        }

        @Override
        public boolean isValid(MinguoCalendar minguoCalendar, V v) {
            if (v == null) {
                return false;
            }
            if (this.element == ERA) {
                return v.equals(minguoCalendar.getEra());
            }
            V v2 = this.getMinimum(minguoCalendar);
            V v3 = this.getMaximum(minguoCalendar);
            return v2.compareTo(v) <= 0 && v.compareTo(v3) <= 0;
        }

        @Override
        public MinguoCalendar withValue(MinguoCalendar minguoCalendar, V v, boolean bl) {
            if (!this.isValid(minguoCalendar, v)) {
                throw new IllegalArgumentException("Out of range: " + v);
            }
            if (this.element == ERA) {
                return minguoCalendar;
            }
            if (this.element.equals(YEAR_OF_ERA)) {
                MinguoCalendar minguoCalendar2 = MinguoCalendar.of(minguoCalendar.getEra(), FieldRule.toNumber(v), minguoCalendar.getMonth(), 1);
                return (MinguoCalendar)minguoCalendar2.with((ChronoElement<Integer>)DAY_OF_MONTH, Math.min(minguoCalendar.getDayOfMonth(), minguoCalendar2.lengthOfMonth()));
            }
            if (this.element.equals(MONTH_OF_YEAR)) {
                PlainDate plainDate = (PlainDate)minguoCalendar.iso.with(PlainDate.MONTH_OF_YEAR, Month.class.cast(v));
                return new MinguoCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_MONTH)) {
                PlainDate plainDate = (PlainDate)minguoCalendar.iso.with((ChronoElement<Integer>)PlainDate.DAY_OF_MONTH, FieldRule.toNumber(v));
                return new MinguoCalendar(plainDate);
            }
            if (this.element.equals(DAY_OF_YEAR)) {
                PlainDate plainDate = (PlainDate)minguoCalendar.iso.with((ChronoElement<Integer>)PlainDate.DAY_OF_YEAR, FieldRule.toNumber(v));
                return new MinguoCalendar(plainDate);
            }
            throw new ChronoException("Missing rule for: " + this.element.name());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(MinguoCalendar minguoCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(MinguoCalendar minguoCalendar) {
            return (ChronoElement)CHILDREN.get(this.element);
        }

        private static int toNumber(Object object) {
            return (Integer)Integer.class.cast(object);
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<MinguoCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            try {
                if (calendarEra instanceof MinguoEra) {
                    int n4 = MinguoCalendar.toProlepticYear((MinguoEra)MinguoEra.class.cast(calendarEra), n);
                    return n >= 1 && n4 <= 999999999 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= GregorianMath.getLengthOfMonth(n4, n2);
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            try {
                int n3 = MinguoCalendar.toProlepticYear((MinguoEra)MinguoEra.class.cast(calendarEra), n);
                return PlainDate.of(n3, n2, 1).lengthOfMonth();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            try {
                int n2 = MinguoCalendar.toProlepticYear((MinguoEra)MinguoEra.class.cast(calendarEra), n);
                return PlainDate.of(n2, Month.JANUARY, 1).lengthOfYear();
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException(runtimeException.getMessage(), runtimeException);
            }
        }

        @Override
        public MinguoCalendar transform(long l) {
            return new MinguoCalendar(PlainDate.of(l, EpochDays.UTC));
        }

        @Override
        public long transform(MinguoCalendar minguoCalendar) {
            return minguoCalendar.iso.get(EpochDays.UTC);
        }

        @Override
        public long getMinimumSinceUTC() {
            return PlainDate.axis().getCalendarSystem().getMinimumSinceUTC();
        }

        @Override
        public long getMaximumSinceUTC() {
            return PlainDate.axis().getCalendarSystem().getMaximumSinceUTC();
        }

        @Override
        public List<CalendarEra> getEras() {
            MinguoEra minguoEra = MinguoEra.BEFORE_ROC;
            MinguoEra minguoEra2 = MinguoEra.ROC;
            return Arrays.asList(minguoEra, minguoEra2);
        }
    }
}

