/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.net.URI;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EastAsianME;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.Nengo;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="japanese")
public final class JapaneseCalendar
extends Calendrical<Unit, JapaneseCalendar>
implements LocalizedPatternSupport {
    private static final int YEAR_OF_NENGO_INDEX = 0;
    private static final int MONTH_AS_ORDINAL_INDEX = 1;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    private static final int RELATED_GREGORIAN_YEAR_INDEX = 4;
    private static final int KOKI_INDEX = 5;
    private static final int MRD = 1000000000;
    private static final long EPOCH_1873 = -36158L;
    private static final byte[] LEAP_INDICATORS;
    private static final int[] LUNISOLAR_MONTHS;
    private static final long[] START_OF_YEAR;
    @FormattableElement(format="G")
    public static final TextElement<Nengo> ERA;
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, JapaneseCalendar> YEAR_OF_ERA;
    public static final ChronoElement<Integer> KOKI_YEAR;
    @FormattableElement(format="M", standalone="L")
    public static final TextElement<EastAsianMonth> MONTH_OF_YEAR;
    public static final StdCalendarElement<Integer, JapaneseCalendar> MONTH_AS_ORDINAL;
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, JapaneseCalendar> DAY_OF_MONTH;
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, JapaneseCalendar> DAY_OF_YEAR;
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, JapaneseCalendar> DAY_OF_WEEK;
    private static final WeekdayInMonthElement<JapaneseCalendar> WIM_ELEMENT;
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<JapaneseCalendar> WEEKDAY_IN_MONTH;
    private static final Transformer CALSYS;
    private static final TimeAxis<Unit, JapaneseCalendar> ENGINE;
    private static final long serialVersionUID = -153630575450868922L;
    private final transient int relgregyear;
    private final transient int dayOfYear;
    private final transient Nengo nengo;
    private final transient EastAsianMonth month;
    private final transient int dayOfMonth;

    private JapaneseCalendar(Nengo nengo, int n, int n2) {
        this(nengo, n, n2, JapaneseCalendar.getMonth(n, n2), JapaneseCalendar.getDayOfMonth(n, n2));
    }

    private JapaneseCalendar(Nengo nengo, int n, int n2, EastAsianMonth eastAsianMonth, int n3) {
        this.nengo = nengo;
        this.relgregyear = n;
        this.dayOfYear = n2;
        this.month = eastAsianMonth;
        this.dayOfMonth = n3;
    }

    public static JapaneseCalendar ofGregorian(Nengo nengo, int n, int n2, int n3) {
        if (!nengo.isModern() || nengo == Nengo.MEIJI && n < 6) {
            throw new IllegalArgumentException("Cannot create modern calendar with lunisolar calendar year.");
        }
        return JapaneseCalendar.of(nengo, n, EastAsianMonth.valueOf(n2), n3, Leniency.SMART);
    }

    public static JapaneseCalendar of(Nengo nengo, int n, EastAsianMonth eastAsianMonth, int n2) {
        return JapaneseCalendar.of(nengo, n, eastAsianMonth, n2, Leniency.SMART);
    }

    public static JapaneseCalendar of(Nengo nengo, int n, EastAsianMonth eastAsianMonth, int n2, Leniency leniency) {
        int n3;
        if (n < 1) {
            throw new IllegalArgumentException("Year of nengo smaller than 1: " + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Day of month smaller than 1: " + n2);
        }
        int n4 = nengo.getFirstRelatedGregorianYear() + n - 1;
        Nengo nengo2 = nengo.findNext();
        if (nengo2 != null && nengo2.getFirstRelatedGregorianYear() < n4) {
            throw new IllegalArgumentException("Year of nengo out of range: " + nengo + "/" + n);
        }
        int n5 = 0;
        if (n4 >= 1873) {
            if (eastAsianMonth.isLeap()) {
                throw new IllegalArgumentException("Lunisolar leap month not valid in modern times: " + eastAsianMonth);
            }
            if (n2 > GregorianMath.getLengthOfMonth(n4, eastAsianMonth.getNumber())) {
                throw new IllegalArgumentException("Day of month out of range: " + n2);
            }
            int n6 = eastAsianMonth.getNumber();
            for (n3 = 1; n3 < n6; ++n3) {
                n5 += GregorianMath.getLengthOfMonth(n4, n3);
            }
            n5 += n2;
        } else {
            n3 = LUNISOLAR_MONTHS[n4 - 701];
            int n7 = JapaneseCalendar.getMonthIndex(n4, eastAsianMonth);
            if (eastAsianMonth.isLeap() && n7 != LEAP_INDICATORS[n4 - 701]) {
                throw new IllegalArgumentException("Invalid leap month: " + eastAsianMonth);
            }
            for (int i = 1; i <= n7; ++i) {
                int n8;
                int n9 = n8 = (n3 & 1) == 1 ? 30 : 29;
                if (i == n7) {
                    if (n2 > n8) {
                        throw new IllegalArgumentException("Day of month out of range: " + n2);
                    }
                    n5 += n2;
                    continue;
                }
                n5 += n8;
                n3 >>>= 1;
            }
        }
        if (n4 == 1872 && eastAsianMonth.getNumber() == 12 && n2 >= 3) {
            if (leniency.isStrict()) {
                throw new IllegalArgumentException("Last month of lunisolar calendar had only 2 days.");
            }
            n3 = n2 - 2;
            return new JapaneseCalendar(Nengo.MEIJI, 1873, n3, EastAsianMonth.valueOf(1), n3);
        }
        long l = JapaneseCalendar.transform(n4, n5);
        CALSYS.check(l);
        Nengo nengo3 = JapaneseCalendar.findBestNengo(nengo.matches(Nengo.Selector.NORTHERN_COURT), n4, l);
        switch (leniency) {
            case STRICT: {
                if (nengo3 == nengo) break;
                throw new IllegalArgumentException("Nengo should be: " + nengo3 + ", but was: " + nengo);
            }
            case SMART: {
                nengo = nengo3;
                break;
            }
        }
        return new JapaneseCalendar(nengo, n4, n5, eastAsianMonth, n2);
    }

    public static JapaneseCalendar nowInSystemTime() {
        return (JapaneseCalendar)SystemClock.inLocalView().now(JapaneseCalendar.axis());
    }

    public Nengo getEra() {
        return this.nengo;
    }

    public int getYear() {
        return this.relgregyear - this.nengo.getFirstRelatedGregorianYear() + 1;
    }

    public EastAsianMonth getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return this.dayOfYear;
    }

    public int lengthOfMonth() {
        return JapaneseCalendar.getLengthOfMonth(this.relgregyear, this.month);
    }

    public int lengthOfYear() {
        return JapaneseCalendar.getLengthOfYear(this.relgregyear);
    }

    public boolean isLeapYear() {
        if (this.relgregyear >= 1873) {
            return GregorianMath.isLeapYear(this.relgregyear);
        }
        return LEAP_INDICATORS[this.relgregyear - 701] > 0;
    }

    public GeneralTimestamp<JapaneseCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<JapaneseCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public int compareTo(JapaneseCalendar japaneseCalendar) {
        int n = super.compareTo(japaneseCalendar);
        if (n == 0 && (n = this.nengo.getValue() - japaneseCalendar.nengo.getValue()) == 0) {
            boolean bl = this.nengo.matches(Nengo.Selector.NORTHERN_COURT);
            boolean bl2 = japaneseCalendar.nengo.matches(Nengo.Selector.NORTHERN_COURT);
            n = !bl && bl2 ? -1 : (bl && !bl2 ? 1 : 0);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JapaneseCalendar) {
            JapaneseCalendar japaneseCalendar = (JapaneseCalendar)object;
            return this.relgregyear == japaneseCalendar.relgregyear && this.dayOfYear == japaneseCalendar.dayOfYear && this.nengo == japaneseCalendar.nengo && this.dayOfMonth == japaneseCalendar.dayOfMonth && this.month.equals(japaneseCalendar.month);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.relgregyear + 31 * this.dayOfYear;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.nengo.getDisplayName(Locale.ROOT));
        stringBuilder.append('-');
        stringBuilder.append(this.getYear());
        stringBuilder.append('(');
        stringBuilder.append(this.relgregyear);
        stringBuilder.append(")-");
        if (this.month.isLeap()) {
            stringBuilder.append('*');
        }
        int n = this.month.getNumber();
        if (this.relgregyear >= 1873 && n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        stringBuilder.append('-');
        int n2 = this.getDayOfMonth();
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Locale.JAPAN);
    }

    public static TimeAxis<Unit, JapaneseCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, JapaneseCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected JapaneseCalendar getContext() {
        return this;
    }

    @Override
    protected int compareByTime(CalendarDate calendarDate) {
        JapaneseCalendar japaneseCalendar = calendarDate instanceof JapaneseCalendar ? (JapaneseCalendar)JapaneseCalendar.class.cast(calendarDate) : CALSYS.transform(calendarDate.getDaysSinceEpochUTC());
        if (this.relgregyear < japaneseCalendar.relgregyear) {
            return -1;
        }
        if (this.relgregyear > japaneseCalendar.relgregyear) {
            return 1;
        }
        if (this.dayOfYear < japaneseCalendar.dayOfYear) {
            return -1;
        }
        if (this.dayOfYear > japaneseCalendar.dayOfYear) {
            return 1;
        }
        return 0;
    }

    private JapaneseCalendar tryWithNorthernCourt() {
        if (this.relgregyear >= 1332 && this.relgregyear < 1394) {
            Nengo nengo = Nengo.ofRelatedGregorianYear(this.relgregyear, Nengo.Selector.NORTHERN_COURT);
            while (nengo.getStartAsDaysSinceEpochUTC() > this.getDaysSinceEpochUTC()) {
                nengo = nengo.findPrevious();
            }
            return new JapaneseCalendar(nengo, this.relgregyear, this.dayOfYear, this.month, this.dayOfMonth);
        }
        return this;
    }

    private static Nengo findBestNengo(boolean bl, int n, long l) {
        Nengo nengo;
        Nengo nengo2 = bl && n >= 1332 && n < 1394 ? Nengo.ofRelatedGregorianYear(n, Nengo.Selector.NORTHERN_COURT) : Nengo.ofRelatedGregorianYear(n, Nengo.Selector.OFFICIAL);
        while (nengo2.getStartAsDaysSinceEpochUTC() > l && (nengo = nengo2.findPrevious()) != null) {
            nengo2 = nengo;
        }
        return nengo2;
    }

    private static EastAsianMonth getMonth(int n, int n2) {
        block6: {
            int n3 = 0;
            if (n2 < 1) break block6;
            if (n >= 1873) {
                for (int i = 1; i <= 12; ++i) {
                    if ((n3 += GregorianMath.getLengthOfMonth(n, i)) < n2) continue;
                    return EastAsianMonth.valueOf(i);
                }
            } else {
                int n4;
                int n5 = LEAP_INDICATORS[n - 701];
                int n6 = LUNISOLAR_MONTHS[n - 701];
                int n7 = n4 = n5 == 0 ? 12 : 13;
                for (int i = 1; i <= n4; ++i) {
                    int n8 = (n6 & 1) == 1 ? 30 : 29;
                    n6 >>>= 1;
                    if ((n3 += n8) < n2) continue;
                    int n9 = i;
                    if (n5 > 0 && n5 <= i) {
                        --n9;
                    }
                    EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n9);
                    if (i == n5) {
                        eastAsianMonth = eastAsianMonth.withLeap();
                    }
                    return eastAsianMonth;
                }
            }
        }
        throw new IllegalArgumentException("Day of year out of range: " + n2);
    }

    private static int getLengthOfMonth(int n, EastAsianMonth eastAsianMonth) {
        if (n >= 1873) {
            return GregorianMath.getLengthOfMonth(n, eastAsianMonth.getNumber());
        }
        if (n == 1872 && eastAsianMonth.getNumber() == 12) {
            return 2;
        }
        int n2 = JapaneseCalendar.getMonthIndex(n, eastAsianMonth);
        int n3 = LUNISOLAR_MONTHS[n - 701];
        for (int i = 1; i <= n2; ++i) {
            if (i == n2) {
                return (n3 & 1) == 1 ? 30 : 29;
            }
            n3 >>>= 1;
        }
        throw new AssertionError();
    }

    private static int getLengthOfYear(int n) {
        int n2;
        if (n >= 1873) {
            return GregorianMath.isLeapYear(n) ? 366 : 365;
        }
        if (n == 1872) {
            return (int)(-36158L - START_OF_YEAR[1171]);
        }
        int n3 = n - 701;
        int n4 = LUNISOLAR_MONTHS[n3];
        int n5 = 0;
        int n6 = n2 = LEAP_INDICATORS[n3] == 0 ? 12 : 13;
        for (int i = 1; i <= n2; ++i) {
            n5 += (n4 & 1) == 1 ? 30 : 29;
            n4 >>>= 1;
        }
        return n5;
    }

    private static int getMonthIndex(int n, EastAsianMonth eastAsianMonth) {
        int n2 = eastAsianMonth.getNumber();
        if (n >= 1873) {
            return n2;
        }
        byte by = LEAP_INDICATORS[n - 701];
        if (eastAsianMonth.isLeap() || by > 0 && n2 >= by) {
            return n2 + 1;
        }
        return n2;
    }

    private static int getDayOfMonth(int n, int n2) {
        int n3 = n2;
        EastAsianMonth eastAsianMonth = JapaneseCalendar.getMonth(n, n2);
        if (n >= 1873) {
            int n4 = eastAsianMonth.getNumber();
            for (int i = 1; i < n4; ++i) {
                n3 -= GregorianMath.getLengthOfMonth(n, i);
            }
        } else {
            int n5 = JapaneseCalendar.getMonthIndex(n, eastAsianMonth);
            int n6 = LUNISOLAR_MONTHS[n - 701];
            for (int i = 1; i < n5; ++i) {
                n3 -= (n6 & 1) == 1 ? 30 : 29;
                n6 >>>= 1;
            }
        }
        return n3;
    }

    private static int getArrayIndex(long l) {
        int n = 0;
        int n2 = START_OF_YEAR.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            if (START_OF_YEAR[n3] <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n - 1;
    }

    static long transform(int n, int n2) {
        if (n >= 1873) {
            return PlainDate.of(n, n2).getDaysSinceEpochUTC();
        }
        return START_OF_YEAR[n - 701] + (long)n2 - 1L;
    }

    private static JapaneseCalendar create(JapaneseCalendar japaneseCalendar, int n, EastAsianMonth eastAsianMonth, int n2) {
        Nengo nengo = Nengo.ofRelatedGregorianYear(n);
        JapaneseCalendar japaneseCalendar2 = JapaneseCalendar.of(nengo, n - nengo.getFirstRelatedGregorianYear() + 1, eastAsianMonth, n2, Leniency.SMART);
        if (japaneseCalendar.nengo.matches(Nengo.Selector.NORTHERN_COURT)) {
            japaneseCalendar2 = japaneseCalendar2.tryWithNorthernCourt();
        }
        return japaneseCalendar2;
    }

    private Object writeReplace() {
        return new SPX(this, 9);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Object object = "data/tsuchihashi.data";
        URI uRI = ResourceLoader.getInstance().locate("calendar", JapaneseCalendar.class, (String)object);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        try {
            if (inputStream == null) {
                inputStream = ResourceLoader.getInstance().load(JapaneseCalendar.class, (String)object, true);
            }
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            long l = -464176L;
            int n = 1172;
            byte[] byArray = new byte[n];
            int[] nArray = new int[n];
            long[] lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                byte by = dataInputStream.readByte();
                int n2 = dataInputStream.readShort();
                byArray[i] = by;
                nArray[i] = n2;
                lArray[i] = l;
                int n3 = 0;
                for (int j = 1; j <= (by == 0 ? 12 : 13); ++j) {
                    n3 += (n2 & 1) == 1 ? 30 : 29;
                    n2 >>>= 1;
                }
                l += (long)n3;
            }
            LEAP_INDICATORS = byArray;
            LUNISOLAR_MONTHS = nArray;
            START_OF_YEAR = lArray;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
        ERA = Nengo.Element.SINGLETON;
        YEAR_OF_ERA = new YearOfNengoElement();
        KOKI_YEAR = new StdIntegerDateElement<JapaneseCalendar>("KOKI_YEAR", JapaneseCalendar.class, 1361, 1000000659, '\u0000', null, null);
        MONTH_OF_YEAR = new MonthPrimitiveElement();
        MONTH_AS_ORDINAL = new StdIntegerDateElement<JapaneseCalendar>("MONTH_AS_ORDINAL", JapaneseCalendar.class, 1, 12, '\u0000', null, null);
        DAY_OF_MONTH = new StdIntegerDateElement<JapaneseCalendar>("DAY_OF_MONTH", JapaneseCalendar.class, 1, 31, 'd');
        DAY_OF_YEAR = new StdIntegerDateElement<JapaneseCalendar>("DAY_OF_YEAR", JapaneseCalendar.class, 1, 365, 'D');
        DAY_OF_WEEK = new StdWeekdayElement<JapaneseCalendar>(JapaneseCalendar.class, JapaneseCalendar.getDefaultWeekmodel());
        WIM_ELEMENT = new WeekdayInMonthElement<JapaneseCalendar>(JapaneseCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
        WEEKDAY_IN_MONTH = WIM_ELEMENT;
        CALSYS = new Transformer();
        object = ((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, JapaneseCalendar.class, new Merger(), CALSYS).appendElement(ERA, new NengoRule(), Unit.ERAS).appendElement(YEAR_OF_ERA, new IntegerRule(0), Unit.YEARS).appendElement(MONTH_OF_YEAR, MonthPrimitiveElement.SINGLETON_JP, Unit.MONTHS).appendElement(MONTH_AS_ORDINAL, new IntegerRule(1), Unit.MONTHS).appendElement(DAY_OF_MONTH, new IntegerRule(2), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<JapaneseCalendar>(JapaneseCalendar.getDefaultWeekmodel(), new ChronoFunction<JapaneseCalendar, CalendarSystem<JapaneseCalendar>>(){

            @Override
            public CalendarSystem<JapaneseCalendar> apply(JapaneseCalendar japaneseCalendar) {
                return CALSYS;
            }
        }), Unit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendElement(KOKI_YEAR, new IntegerRule(5), Unit.YEARS).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, (ElementRule)new IntegerRule(4))).appendUnit(Unit.ERAS, new JapaneseUnitRule(Unit.ERAS), Unit.ERAS.getLength()).appendUnit(Unit.YEARS, new JapaneseUnitRule(Unit.YEARS), Unit.YEARS.getLength()).appendUnit(Unit.MONTHS, new JapaneseUnitRule(Unit.MONTHS), Unit.MONTHS.getLength()).appendUnit(Unit.WEEKS, new JapaneseUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new JapaneseUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS));
        ENGINE = ((TimeAxis.Builder)object).build();
    }

    private static class Merger
    implements ChronoMerger<JapaneseCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("japanese", displayStyle, locale);
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        @Override
        public int getDefaultPivotYear() {
            return 100;
        }

        @Override
        public JapaneseCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (JapaneseCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        @Deprecated
        public JapaneseCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public JapaneseCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n;
            int n2;
            Nengo nengo = chronoEntity.get(ERA);
            if (nengo == null) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Japanese nengo/era.");
                return null;
            }
            int n3 = chronoEntity.getInt(YEAR_OF_ERA);
            if (n3 == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Japanese year.");
                return null;
            }
            int n4 = nengo.getFirstRelatedGregorianYear() + n3 - 1;
            EastAsianMonth eastAsianMonth = null;
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                eastAsianMonth = chronoEntity.get(MONTH_OF_YEAR);
            } else if (chronoEntity.contains(MONTH_AS_ORDINAL)) {
                n2 = chronoEntity.getInt(MONTH_AS_ORDINAL);
                eastAsianMonth = n4 >= 1873 ? EastAsianMonth.valueOf(n2) : (n2 == (n = LEAP_INDICATORS[n4 - 701]) ? EastAsianMonth.valueOf(n2 - 1).withLeap() : (n2 > n ? EastAsianMonth.valueOf(n2 - 1) : EastAsianMonth.valueOf(n2)));
            }
            if (eastAsianMonth != null) {
                n2 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n2 == Integer.MIN_VALUE) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Japanese day of month.");
                    return null;
                }
                Leniency leniency = bl ? Leniency.LAX : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
                return JapaneseCalendar.of(nengo, n3, eastAsianMonth, n2, leniency);
            }
            n2 = chronoEntity.getInt(DAY_OF_YEAR);
            if (n2 != Integer.MIN_VALUE && n2 <= JapaneseCalendar.getLengthOfYear(n4)) {
                try {
                    eastAsianMonth = JapaneseCalendar.getMonth(n4, n2);
                    n = JapaneseCalendar.getDayOfMonth(n4, n2);
                    Leniency leniency = bl ? Leniency.LAX : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
                    return JapaneseCalendar.of(nengo, n3, eastAsianMonth, n, leniency);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Japanese date.");
                    return null;
                }
            }
            return null;
        }

        @Override
        public ChronoDisplay preformat(JapaneseCalendar japaneseCalendar, AttributeQuery attributeQuery) {
            return japaneseCalendar;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }
    }

    private static class MonthPrimitiveElement
    extends EastAsianME
    implements ElementRule<JapaneseCalendar, EastAsianMonth> {
        static final MonthPrimitiveElement SINGLETON_JP = new MonthPrimitiveElement();
        private static final long serialVersionUID = -2978966174642315851L;

        private MonthPrimitiveElement() {
        }

        @Override
        public EastAsianMonth getValue(JapaneseCalendar japaneseCalendar) {
            return japaneseCalendar.month;
        }

        @Override
        public EastAsianMonth getMinimum(JapaneseCalendar japaneseCalendar) {
            return EastAsianMonth.valueOf(1);
        }

        @Override
        public EastAsianMonth getMaximum(JapaneseCalendar japaneseCalendar) {
            EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(12);
            if (japaneseCalendar.relgregyear < 1873 && LEAP_INDICATORS[japaneseCalendar.relgregyear - 701] == 13) {
                return eastAsianMonth.withLeap();
            }
            return eastAsianMonth;
        }

        @Override
        public boolean isValid(JapaneseCalendar japaneseCalendar, EastAsianMonth eastAsianMonth) {
            if (eastAsianMonth == null) {
                return false;
            }
            if (japaneseCalendar.relgregyear >= 1873) {
                return !eastAsianMonth.isLeap();
            }
            if (eastAsianMonth.isLeap()) {
                return LEAP_INDICATORS[japaneseCalendar.relgregyear - 701] == eastAsianMonth.getNumber() + 1;
            }
            return true;
        }

        @Override
        public JapaneseCalendar withValue(JapaneseCalendar japaneseCalendar, EastAsianMonth eastAsianMonth, boolean bl) {
            if (this.isValid(japaneseCalendar, eastAsianMonth)) {
                int n = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(japaneseCalendar.relgregyear, eastAsianMonth));
                return JapaneseCalendar.create(japaneseCalendar, japaneseCalendar.relgregyear, eastAsianMonth, n);
            }
            throw new IllegalArgumentException("Invalid month: " + eastAsianMonth);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JapaneseCalendar japaneseCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JapaneseCalendar japaneseCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            return SINGLETON_JP;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            if (chronoDisplay.get(CommonElements.RELATED_GREGORIAN_YEAR) >= 1873) {
                int n = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
                int n2 = chronoDisplay.get(MONTH_OF_YEAR).getNumber();
                if (n == 0) {
                    Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
                    TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                    OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                    appendable.append(CalendarText.getIsoInstance(locale).getStdMonths(textWidth, outputContext).print(Month.valueOf(n2)));
                } else {
                    NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                    char c = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(numberSystem.getDigits().charAt(0))).charValue();
                    String string = EastAsianMonth.toNumeral(numberSystem, c, n2);
                    if (numberSystem.isDecimal()) {
                        for (int i = n - string.length(); i > 0; --i) {
                            appendable.append(c);
                        }
                    }
                    appendable.append(string);
                }
            } else {
                super.print(chronoDisplay, appendable, attributeQuery);
            }
        }

        @Override
        public EastAsianMonth parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            int n = attributeQuery.get(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, 0);
            int n2 = parsePosition.getIndex();
            if (n == 0) {
                TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                TextAccessor textAccessor = CalendarText.getIsoInstance(locale).getStdMonths(textWidth, outputContext);
                Month month = textAccessor.parse(charSequence, parsePosition, Month.class, attributeQuery);
                if (month != null) {
                    return EastAsianMonth.valueOf(month.getValue());
                }
                parsePosition.setIndex(n2);
                parsePosition.setErrorIndex(-1);
            }
            return super.parse(charSequence, parsePosition, attributeQuery);
        }
    }

    private static class YearOfNengoElement
    extends StdIntegerDateElement<JapaneseCalendar>
    implements DualFormatElement {
        private static final long serialVersionUID = -8502388572788955989L;

        private YearOfNengoElement() {
            super("YEAR_OF_ERA", JapaneseCalendar.class, 1, 1000000000 - Nengo.Element.SINGLETON.getDefaultMaximum().getFirstRelatedGregorianYear(), 'y', null, null);
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            char c = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
            this.print(chronoDisplay, appendable, attributeQuery, numberSystem, c, 1, 9);
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, NumberSystem numberSystem, char c, int n, int n2) throws IOException, ChronoException {
            int n3 = chronoDisplay.getInt(this);
            if (n3 == 1 && numberSystem == NumberSystem.ARABIC && attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT).getLanguage().equals("ja")) {
                appendable.append('\u5143');
            } else {
                String string = numberSystem.toNumeral(n3);
                if (numberSystem.isDecimal()) {
                    int n4 = string.length();
                    int n5 = n - n4;
                    for (int i = 0; i < n5; ++i) {
                        appendable.append(c);
                    }
                }
                appendable.append(string);
            }
        }

        @Override
        public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            int n;
            NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            int n2 = n = parsePosition.getIndex();
            if (numberSystem == NumberSystem.ARABIC && charSequence.charAt(n2) == '\u5143' && attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT).getLanguage().equals("ja")) {
                parsePosition.setIndex(n2 + 1);
                return 1;
            }
            int n3 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (int)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (int)numberSystem.getDigits().charAt(0) : 48);
            Leniency leniency = numberSystem.isDecimal() ? Leniency.SMART : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
            int n4 = 0;
            if (numberSystem.isDecimal()) {
                int n5;
                int n6 = Math.min(n2 + 9, charSequence.length());
                for (int i = n2; i < n6 && (n5 = charSequence.charAt(i) - n3) >= 0 && n5 <= 9; ++i) {
                    n4 = n4 * 10 + n5;
                    ++n2;
                }
            } else {
                int n7 = 0;
                int n8 = charSequence.length();
                for (int i = n2; i < n8 && numberSystem.contains(charSequence.charAt(i)); ++i) {
                    ++n7;
                }
                if (n7 > 0) {
                    n4 = numberSystem.toInteger(charSequence.subSequence(n2, n2 + n7).toString(), leniency);
                    n2 += n7;
                }
            }
            if (n2 == n) {
                parsePosition.setErrorIndex(n);
                return null;
            }
            parsePosition.setIndex(n2);
            return n4;
        }

        @Override
        public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery, ChronoEntity<?> chronoEntity) {
            return this.parse(charSequence, parsePosition, attributeQuery);
        }
    }

    private static class IntegerRule
    implements IntElementRule<JapaneseCalendar> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public int getInt(JapaneseCalendar japaneseCalendar) {
            switch (this.index) {
                case 0: {
                    return japaneseCalendar.getYear();
                }
                case 2: {
                    return japaneseCalendar.dayOfMonth;
                }
                case 3: {
                    return japaneseCalendar.dayOfYear;
                }
                case 1: {
                    return JapaneseCalendar.getMonthIndex(japaneseCalendar.relgregyear, japaneseCalendar.month);
                }
                case 4: {
                    return japaneseCalendar.relgregyear;
                }
                case 5: {
                    return japaneseCalendar.relgregyear + 660;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        int getMin() {
            switch (this.index) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return 1;
                }
                case 4: {
                    return 701;
                }
                case 5: {
                    return 1361;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        int getMax(JapaneseCalendar japaneseCalendar) {
            switch (this.index) {
                case 0: {
                    Nengo nengo = japaneseCalendar.nengo;
                    Nengo nengo2 = nengo.findNext();
                    if (nengo2 != null) {
                        return nengo2.getFirstRelatedGregorianYear() - nengo.getFirstRelatedGregorianYear() + 1;
                    }
                    return 1000000000 - Nengo.Element.SINGLETON.getDefaultMaximum().getFirstRelatedGregorianYear();
                }
                case 2: {
                    return JapaneseCalendar.getLengthOfMonth(japaneseCalendar.relgregyear, japaneseCalendar.month);
                }
                case 3: {
                    return JapaneseCalendar.getLengthOfYear(japaneseCalendar.relgregyear);
                }
                case 1: {
                    return japaneseCalendar.relgregyear >= 1873 || LEAP_INDICATORS[japaneseCalendar.relgregyear - 701] == 0 ? 12 : 13;
                }
                case 4: {
                    return 999999999;
                }
                case 5: {
                    return 1000000659;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(JapaneseCalendar japaneseCalendar, int n) {
            switch (this.index) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: {
                    return n >= 1 && n <= this.getMax(japaneseCalendar);
                }
                case 4: {
                    return japaneseCalendar.relgregyear == n;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public JapaneseCalendar withValue(JapaneseCalendar japaneseCalendar, int n, boolean bl) {
            if (this.isValid(japaneseCalendar, n)) {
                switch (this.index) {
                    case 0: {
                        return IntegerRule.yearsAdded(japaneseCalendar, japaneseCalendar.nengo.getFirstRelatedGregorianYear() + n - 1);
                    }
                    case 2: {
                        return JapaneseCalendar.create(japaneseCalendar, japaneseCalendar.relgregyear, japaneseCalendar.month, n);
                    }
                    case 3: {
                        return new JapaneseCalendar(japaneseCalendar.nengo, japaneseCalendar.relgregyear, n);
                    }
                    case 1: {
                        byte by;
                        EastAsianMonth eastAsianMonth = japaneseCalendar.relgregyear >= 1873 ? EastAsianMonth.valueOf(n) : (n == (by = LEAP_INDICATORS[japaneseCalendar.relgregyear - 701]) ? EastAsianMonth.valueOf(n - 1).withLeap() : (n > by ? EastAsianMonth.valueOf(n - 1) : EastAsianMonth.valueOf(n)));
                        return (JapaneseCalendar)japaneseCalendar.with(MONTH_OF_YEAR, eastAsianMonth);
                    }
                    case 4: {
                        return japaneseCalendar;
                    }
                    case 5: {
                        return IntegerRule.yearsAdded(japaneseCalendar, n - 660);
                    }
                }
                throw new UnsupportedOperationException("Unknown element index: " + this.index);
            }
            if (this.index == 4) {
                throw new IllegalArgumentException("The related gregorian year is read-only.");
            }
            throw new IllegalArgumentException("Out of range: " + n);
        }

        @Override
        public Integer getValue(JapaneseCalendar japaneseCalendar) {
            return this.getInt(japaneseCalendar);
        }

        @Override
        public Integer getMinimum(JapaneseCalendar japaneseCalendar) {
            return this.getMin();
        }

        @Override
        public Integer getMaximum(JapaneseCalendar japaneseCalendar) {
            return this.getMax(japaneseCalendar);
        }

        @Override
        public boolean isValid(JapaneseCalendar japaneseCalendar, Integer n) {
            return n != null && this.isValid(japaneseCalendar, (int)n);
        }

        @Override
        public JapaneseCalendar withValue(JapaneseCalendar japaneseCalendar, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Not nullable.");
            }
            return this.withValue(japaneseCalendar, (int)n, bl);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JapaneseCalendar japaneseCalendar) {
            switch (this.index) {
                case 0: {
                    return MONTH_OF_YEAR;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return null;
                }
                case 1: {
                    return DAY_OF_MONTH;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JapaneseCalendar japaneseCalendar) {
            return this.getChildAtFloor(japaneseCalendar);
        }

        private static JapaneseCalendar yearsAdded(JapaneseCalendar japaneseCalendar, int n) {
            EastAsianMonth eastAsianMonth = japaneseCalendar.month;
            int n2 = eastAsianMonth.getNumber();
            if (n >= 1873) {
                if (eastAsianMonth.isLeap()) {
                    eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                }
            } else if (eastAsianMonth.isLeap() && LEAP_INDICATORS[n - 701] != n2 + 1) {
                eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
            }
            int n3 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(n, eastAsianMonth));
            return JapaneseCalendar.create(japaneseCalendar, n, eastAsianMonth, n3);
        }
    }

    private static class NengoRule
    implements ElementRule<JapaneseCalendar, Nengo> {
        private NengoRule() {
        }

        @Override
        public Nengo getValue(JapaneseCalendar japaneseCalendar) {
            return japaneseCalendar.nengo;
        }

        @Override
        public Nengo getMinimum(JapaneseCalendar japaneseCalendar) {
            return (Nengo)ERA.getDefaultMinimum();
        }

        @Override
        public Nengo getMaximum(JapaneseCalendar japaneseCalendar) {
            return (Nengo)ERA.getDefaultMaximum();
        }

        @Override
        public boolean isValid(JapaneseCalendar japaneseCalendar, Nengo nengo) {
            return nengo != null;
        }

        @Override
        public JapaneseCalendar withValue(JapaneseCalendar japaneseCalendar, Nengo nengo, boolean bl) {
            int n;
            int n2;
            int n3 = japaneseCalendar.getYear();
            EastAsianMonth eastAsianMonth = japaneseCalendar.month;
            int n4 = japaneseCalendar.dayOfMonth;
            Nengo nengo2 = nengo.findNext();
            if (nengo2 != null && n3 > (n2 = nengo2.getFirstRelatedGregorianYear() - nengo.getFirstRelatedGregorianYear() + 1)) {
                n3 = n2;
            }
            if ((n2 = n3 - 1 + nengo.getFirstRelatedGregorianYear()) >= 1873) {
                if (eastAsianMonth.isLeap()) {
                    eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                }
            } else if (eastAsianMonth.isLeap() && LEAP_INDICATORS[n2 - 701] == 0) {
                eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
            }
            if (n4 > (n = JapaneseCalendar.getLengthOfMonth(n2, eastAsianMonth))) {
                n4 = n;
            }
            return JapaneseCalendar.of(nengo, n3, eastAsianMonth, n4, bl ? Leniency.LAX : Leniency.SMART);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(JapaneseCalendar japaneseCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(JapaneseCalendar japaneseCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class JapaneseUnitRule
    implements UnitRule<JapaneseCalendar> {
        private final Unit unit;

        JapaneseUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public JapaneseCalendar addTo(JapaneseCalendar japaneseCalendar, long l) {
            switch (this.unit) {
                case ERAS: {
                    try {
                        return JapaneseUnitRule.erasAdded(japaneseCalendar, l);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new IllegalArgumentException(indexOutOfBoundsException);
                    }
                }
                case YEARS: {
                    try {
                        int n = MathUtils.safeAdd(japaneseCalendar.relgregyear, MathUtils.safeCast(l));
                        EastAsianMonth eastAsianMonth = japaneseCalendar.month;
                        int n2 = eastAsianMonth.getNumber();
                        if (n >= 1873) {
                            if (eastAsianMonth.isLeap()) {
                                eastAsianMonth = EastAsianMonth.valueOf(n2);
                            }
                        } else if (eastAsianMonth.isLeap() && LEAP_INDICATORS[n - 701] != n2 + 1) {
                            eastAsianMonth = EastAsianMonth.valueOf(n2);
                        }
                        int n3 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(n, eastAsianMonth));
                        return JapaneseCalendar.create(japaneseCalendar, n, eastAsianMonth, n3);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new IllegalArgumentException(indexOutOfBoundsException);
                    }
                }
                case MONTHS: {
                    try {
                        int n;
                        JapaneseUnitRule.checkAmountOfMonths(l);
                        int n4 = japaneseCalendar.relgregyear;
                        int n5 = JapaneseCalendar.getMonthIndex(n4, japaneseCalendar.month);
                        int n6 = n = l > 0L ? 1 : -1;
                        while (l != 0L) {
                            n5 += n;
                            if (n4 >= 1873) {
                                if (n5 == 0) {
                                    n5 = --n4 >= 1873 || LEAP_INDICATORS[n4 - 701] == 0 ? 12 : 13;
                                } else if (n5 == 13) {
                                    ++n4;
                                    n5 = 1;
                                }
                            } else if (n5 == 0) {
                                n5 = LEAP_INDICATORS[--n4 - 701] == 0 ? 12 : 13;
                            } else if (n5 > (LEAP_INDICATORS[n4 - 701] == 0 ? 12 : 13)) {
                                ++n4;
                                n5 = 1;
                            }
                            l -= (long)n;
                        }
                        if (n4 >= 1873) {
                            Nengo nengo = Nengo.ofRelatedGregorianYear(n4, Nengo.Selector.MODERN);
                            EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n5);
                            int n7 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(n4, eastAsianMonth));
                            return JapaneseCalendar.of(nengo, n4 - nengo.getFirstRelatedGregorianYear() + 1, eastAsianMonth, n7, Leniency.SMART);
                        }
                        int n8 = n5;
                        boolean bl = false;
                        byte by = LEAP_INDICATORS[n4 - 701];
                        if (by > 0) {
                            if (by <= n5) {
                                --n8;
                            }
                            if (by == n5) {
                                bl = true;
                            }
                        }
                        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n8);
                        if (bl) {
                            eastAsianMonth = eastAsianMonth.withLeap();
                        }
                        int n9 = Math.min(japaneseCalendar.dayOfMonth, JapaneseCalendar.getLengthOfMonth(n4, eastAsianMonth));
                        return JapaneseCalendar.create(japaneseCalendar, n4, eastAsianMonth, n9);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new IllegalArgumentException(indexOutOfBoundsException);
                    }
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply(l, 7L);
                }
                case DAYS: {
                    long l2 = MathUtils.safeAdd(CALSYS.transform(japaneseCalendar), l);
                    JapaneseCalendar japaneseCalendar2 = CALSYS.transform(l2);
                    if (japaneseCalendar.nengo.matches(Nengo.Selector.NORTHERN_COURT)) {
                        japaneseCalendar2 = japaneseCalendar2.tryWithNorthernCourt();
                    }
                    return japaneseCalendar2;
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(JapaneseCalendar japaneseCalendar, JapaneseCalendar japaneseCalendar2) {
            switch (this.unit) {
                case ERAS: {
                    return JapaneseUnitRule.erasBetween(japaneseCalendar, japaneseCalendar2);
                }
                case YEARS: {
                    int n = japaneseCalendar2.relgregyear - japaneseCalendar.relgregyear;
                    if (n == 0) {
                        return 0L;
                    }
                    int n2 = JapaneseCalendar.getMonthIndex(japaneseCalendar2.relgregyear, japaneseCalendar2.month);
                    int n3 = JapaneseCalendar.getMonthIndex(japaneseCalendar.relgregyear, japaneseCalendar.month);
                    if (n > 0) {
                        if (n3 > n2 || n3 == n2 && japaneseCalendar.dayOfMonth > japaneseCalendar2.dayOfMonth) {
                            --n;
                        }
                    } else if (n < 0 && (n3 < n2 || n3 == n2 && japaneseCalendar.dayOfMonth < japaneseCalendar2.dayOfMonth)) {
                        ++n;
                    }
                    return n;
                }
                case MONTHS: {
                    int n = japaneseCalendar2.relgregyear;
                    int n4 = JapaneseCalendar.getMonthIndex(japaneseCalendar2.relgregyear, japaneseCalendar2.month);
                    int n5 = japaneseCalendar.relgregyear;
                    int n6 = JapaneseCalendar.getMonthIndex(japaneseCalendar.relgregyear, japaneseCalendar.month);
                    int n7 = japaneseCalendar2.compareByTime(japaneseCalendar);
                    int n8 = 0;
                    while (n5 != n || n6 != n4) {
                        n6 += n7;
                        if (n5 >= 1873) {
                            if (n6 == 0) {
                                n6 = --n5 >= 1873 || LEAP_INDICATORS[n5 - 701] == 0 ? 12 : 13;
                            } else if (n6 == 13) {
                                ++n5;
                                n6 = 1;
                            }
                        } else if (n6 == 0) {
                            n6 = LEAP_INDICATORS[--n5 - 701] == 0 ? 12 : 13;
                        } else if (n6 > (LEAP_INDICATORS[n5 - 701] == 0 ? 12 : 13)) {
                            ++n5;
                            n6 = 1;
                        }
                        JapaneseUnitRule.checkAmountOfMonths(n8 += n7);
                    }
                    if (n8 > 0 && japaneseCalendar.dayOfMonth > japaneseCalendar2.dayOfMonth) {
                        --n8;
                    } else if (n8 < 0 && japaneseCalendar.dayOfMonth < japaneseCalendar2.dayOfMonth) {
                        ++n8;
                    }
                    return n8;
                }
                case WEEKS: {
                    return Unit.DAYS.between(japaneseCalendar, japaneseCalendar2) / 7L;
                }
                case DAYS: {
                    return CALSYS.transform(japaneseCalendar2) - CALSYS.transform(japaneseCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static JapaneseCalendar erasAdded(JapaneseCalendar japaneseCalendar, long l) {
            int n;
            int n2;
            Nengo nengo;
            Nengo nengo2;
            Nengo nengo3 = japaneseCalendar.nengo;
            int n3 = japaneseCalendar.getYear();
            EastAsianMonth eastAsianMonth = japaneseCalendar.month;
            int n4 = japaneseCalendar.dayOfMonth;
            if (nengo3.matches(Nengo.Selector.NORTHERN_COURT)) {
                nengo3 = Nengo.ofRelatedGregorianYear(japaneseCalendar.relgregyear);
                n3 = japaneseCalendar.relgregyear - nengo3.getFirstRelatedGregorianYear() + 1;
            }
            if ((nengo2 = (nengo = Nengo.ofIndexOfficial(MathUtils.safeAdd(nengo3.getIndexOfficial(), MathUtils.safeCast(l)))).findNext()) != null && n3 > (n2 = nengo2.getFirstRelatedGregorianYear() - nengo.getFirstRelatedGregorianYear() + 1)) {
                n3 = n2;
            }
            if ((n2 = n3 - 1 + nengo.getFirstRelatedGregorianYear()) >= 1873) {
                if (eastAsianMonth.isLeap()) {
                    eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                }
            } else if (eastAsianMonth.isLeap() && LEAP_INDICATORS[n2 - 701] == 0) {
                eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
            }
            if (n4 > (n = JapaneseCalendar.getLengthOfMonth(n2, eastAsianMonth))) {
                n4 = n;
            }
            return JapaneseCalendar.of(nengo, n3, eastAsianMonth, n4);
        }

        private static int erasBetween(JapaneseCalendar japaneseCalendar, JapaneseCalendar japaneseCalendar2) {
            int n;
            Nengo nengo = japaneseCalendar.nengo;
            int n2 = japaneseCalendar.getYear();
            int n3 = JapaneseCalendar.getMonthIndex(japaneseCalendar.relgregyear, japaneseCalendar.month);
            int n4 = japaneseCalendar.dayOfMonth;
            if (nengo.matches(Nengo.Selector.NORTHERN_COURT)) {
                nengo = Nengo.ofRelatedGregorianYear(japaneseCalendar.relgregyear);
                n2 = japaneseCalendar.relgregyear - nengo.getFirstRelatedGregorianYear() + 1;
            }
            Nengo nengo2 = japaneseCalendar2.nengo;
            int n5 = japaneseCalendar2.getYear();
            int n6 = JapaneseCalendar.getMonthIndex(japaneseCalendar2.relgregyear, japaneseCalendar2.month);
            int n7 = japaneseCalendar2.dayOfMonth;
            if (nengo2.matches(Nengo.Selector.NORTHERN_COURT)) {
                nengo2 = Nengo.ofRelatedGregorianYear(japaneseCalendar2.relgregyear);
                n5 = japaneseCalendar2.relgregyear - nengo2.getFirstRelatedGregorianYear() + 1;
            }
            if ((n = nengo2.getIndexOfficial() - nengo.getIndexOfficial()) > 0) {
                if (n2 > n5 || n2 == n5 && (n3 > n6 || n3 == n6 && n4 > n7)) {
                    --n;
                }
            } else if (n < 0 && (n2 < n5 || n2 == n5 && (n3 < n6 || n3 == n6 && n4 < n7))) {
                ++n;
            }
            return n;
        }

        private static void checkAmountOfMonths(long l) {
            if (Math.abs(l) >= 25000L) {
                throw new ArithmeticException("Month arithmetic limited to delta smaller than 25000.");
            }
        }
    }

    private static class Transformer
    implements CalendarSystem<JapaneseCalendar> {
        private Transformer() {
        }

        @Override
        public JapaneseCalendar transform(long l) {
            if (l >= -36158L) {
                PlainDate plainDate = PlainDate.of(l, EpochDays.UTC);
                int n = plainDate.getYear();
                Nengo nengo = JapaneseCalendar.findBestNengo(false, n, l);
                return new JapaneseCalendar(nengo, n, plainDate.getDayOfYear(), EastAsianMonth.valueOf(plainDate.getMonth()), plainDate.getDayOfMonth());
            }
            int n = JapaneseCalendar.getArrayIndex(l);
            if (n < 0) {
                throw new IllegalArgumentException("Out of bounds: " + l);
            }
            int n2 = n + 701;
            int n3 = (int)(l - START_OF_YEAR[n] + 1L);
            Nengo nengo = JapaneseCalendar.findBestNengo(false, n2, l);
            return new JapaneseCalendar(nengo, n2, n3);
        }

        @Override
        public long transform(JapaneseCalendar japaneseCalendar) {
            return JapaneseCalendar.transform(japaneseCalendar.relgregyear, japaneseCalendar.dayOfYear);
        }

        @Override
        public long getMinimumSinceUTC() {
            return START_OF_YEAR[0];
        }

        @Override
        public long getMaximumSinceUTC() {
            return 365241779741L;
        }

        @Override
        public List<CalendarEra> getEras() {
            List<CalendarEra> list = Nengo.list();
            return list;
        }

        void check(long l) {
            if (l < this.getMinimumSinceUTC() || l > this.getMaximumSinceUTC()) {
                throw new IllegalArgumentException("Japanese calendar out of supported range.");
            }
        }
    }

    public static enum Unit implements ChronoUnit
    {
        ERAS(2.147483647E9),
        YEARS(3.1556952E7),
        MONTHS(2592000.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public long between(JapaneseCalendar japaneseCalendar, JapaneseCalendar japaneseCalendar2) {
            return japaneseCalendar.until(japaneseCalendar2, this);
        }
    }
}

