/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.android;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.time4j.PlainDate;
import net.time4j.SystemClock;
import net.time4j.android.AssetLocation;
import net.time4j.android.spi.AndroidResourceLoader;
import net.time4j.base.ResourceLoader;
import net.time4j.format.DisplayMode;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public class ApplicationStarter {
    private static final String VERSION = "v3.43-2018e";
    private static final int RELEASE_YEAR = 2018;
    private static final int RELEASE_MONTH = 5;
    private static final int RELEASE_DAY = 18;
    private static final String TIME4A = "time4a";
    private static final AtomicBoolean PREPARED = new AtomicBoolean(false);
    private static final AtomicBoolean REGISTERED = new AtomicBoolean(false);

    private ApplicationStarter() {
    }

    public static void initialize(Application application) {
        ApplicationStarter.initialize((Context)application, false);
    }

    public static void initialize(Context context, boolean bl) {
        long l;
        long l2 = System.nanoTime();
        ApplicationStarter.prepareAssets(context, null);
        ApplicationStarter.registerReceiver(context.getApplicationContext());
        PlainDate plainDate = PlainDate.of(2018, 5, 18);
        Log.i((String)TIME4A, (String)("Starting Time4A (v3.43-2018e published on " + plainDate + ")"));
        if (bl) {
            l = System.nanoTime();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayMode displayMode = DisplayMode.FULL;
                    TZID tZID = Timezone.ofSystem().getID();
                    Locale locale = Locale.getDefault();
                    Log.i((String)ApplicationStarter.TIME4A, (String)("System locale at start: " + locale));
                    Log.i((String)ApplicationStarter.TIME4A, (String)ChronoFormatter.ofMomentStyle(displayMode, displayMode, locale, tZID).format(SystemClock.currentMoment()));
                    long l2 = (System.nanoTime() - l) / 1000000L;
                    Log.i((String)ApplicationStarter.TIME4A, (String)("Prefetch-Thread consumed in ms: " + l2));
                }
            };
            Executors.defaultThreadFactory().newThread(runnable).start();
        }
        l = (System.nanoTime() - l2) / 1000000L;
        Log.i((String)TIME4A, (String)("Main-Thread consumed in ms: " + l));
    }

    @Deprecated
    public static void prepareResources(Application application) {
        ApplicationStarter.prepareAssets((Context)application, null);
    }

    public static void prepareAssets(Context context, AssetLocation assetLocation) {
        if (!PREPARED.getAndSet(true)) {
            System.setProperty("net.time4j.base.ResourceLoader", "net.time4j.android.spi.AndroidResourceLoader");
            ((AndroidResourceLoader)ResourceLoader.getInstance()).init(context, assetLocation);
        }
    }

    public static void registerReceiver(Context context) {
        if (context != null && !REGISTERED.getAndSet(true)) {
            System.setProperty("net.time4j.allow.system.tz.override", "true");
            context.registerReceiver((BroadcastReceiver)new TimezoneChangedReceiver(), new IntentFilter("android.intent.action.TIMEZONE_CHANGED"));
        }
    }

    private static class TimezoneChangedReceiver
    extends BroadcastReceiver {
        private TimezoneChangedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Timezone.Cache.refresh();
            Log.i((String)ApplicationStarter.TIME4A, (String)("Event ACTION_TIMEZONE_CHANGED received, system timezone changed to: [" + Timezone.ofSystem().getID().canonical() + "]. Original tz-id reported by Android: [" + intent.getStringExtra("time-zone") + "]"));
        }
    }
}

