/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import net.time4j.ClockUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.base.GregorianDate;
import net.time4j.format.CalendarType;
import net.time4j.tz.model.OffsetIndicator;

public abstract class DaylightSavingRule {
    private final transient PlainTime timeOfDay;
    private final transient OffsetIndicator indicator;
    private final transient int savings;

    protected DaylightSavingRule(PlainTime plainTime, OffsetIndicator offsetIndicator, int n) {
        if (plainTime == null) {
            throw new NullPointerException("Missing time of day.");
        }
        if (offsetIndicator == null) {
            throw new NullPointerException("Missing offset indicator.");
        }
        if (n != Integer.MAX_VALUE && (n < -64800 || n > 64800)) {
            throw new IllegalArgumentException("DST out of range: " + n);
        }
        this.timeOfDay = (PlainTime)plainTime.with(PlainTime.PRECISION, ClockUnit.SECONDS);
        this.indicator = offsetIndicator;
        this.savings = n;
    }

    public abstract PlainDate getDate(int var1);

    public PlainTime getTimeOfDay() {
        return this.timeOfDay;
    }

    public OffsetIndicator getIndicator() {
        return this.indicator;
    }

    public int getSavings() {
        return this.savings == Integer.MAX_VALUE ? 0 : this.savings;
    }

    public boolean isSaving() {
        return this.savings > 0;
    }

    protected abstract int toCalendarYear(long var1);

    protected abstract int toCalendarYear(GregorianDate var1);

    protected String getCalendarType() {
        CalendarType calendarType = this.getClass().getAnnotation(CalendarType.class);
        if (calendarType == null) {
            throw new IllegalStateException("Cannot find calendar type annotation: " + this.getClass());
        }
        return calendarType.value();
    }

    int getSavings0() {
        return this.savings;
    }

    int getType() {
        return 0;
    }
}

