/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.calendar.astro.AstroUtils;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.SolarTime;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.EpochDays;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TimeScale;
import net.time4j.tz.ZonalOffset;

public enum StdSolarCalculator implements SolarTime.Calculator
{
    SIMPLE{

        @Override
        public Moment sunrise(CalendarDate calendarDate, double d, double d2, double d3) {
            return this.event(calendarDate, d, d2, d3, true);
        }

        @Override
        public Moment sunset(CalendarDate calendarDate, double d, double d2, double d3) {
            return this.event(calendarDate, d, d2, d3, false);
        }

        @Override
        public double equationOfTime(double d) {
            double d2 = this.time0(d);
            return (-7.66 * Math.sin(Math.toRadians(0.9856 * d2 - 3.8)) - 9.78 * Math.sin(Math.toRadians(1.9712 * d2 + 17.96))) * 60.0;
        }

        @Override
        public double getGeodeticAngle(double d, int n) {
            return 0.0;
        }

        @Override
        public double getZenithAngle(double d, int n) {
            return 90.83333333333333 + this.getGeodeticAngle(d, n);
        }

        @Override
        public double declination(double d) {
            double d2 = this.time0(d);
            double d3 = this.trueLongitudeOfSunInDegrees(d2);
            double d4 = 0.39782 * Math.sin(Math.toRadians(d3));
            return Math.toDegrees(Math.asin(d4));
        }

        @Override
        public double rightAscension(double d) {
            double d2 = this.time0(d);
            double d3 = this.trueLongitudeOfSunInDegrees(d2);
            double d4 = Math.toDegrees(Math.atan(0.91764 * Math.tan(Math.toRadians(d3))));
            d4 = AstroUtils.toRange_0_360(d4);
            double d5 = Math.floor(d3 / 90.0) * 90.0;
            double d6 = Math.floor(d4 / 90.0) * 90.0;
            return d4 + d5 - d6;
        }

        private double time0(double d) {
            PlainTimestamp plainTimestamp = JulianDay.ofEphemerisTime(d).toMoment().toZonalTimestamp(ZonalOffset.UTC);
            return (double)plainTimestamp.getCalendarDate().getDayOfYear() + (double)((Integer)plainTimestamp.getWallTime().get(PlainTime.SECOND_OF_DAY)).intValue() / 86400.0;
        }

        private double trueLongitudeOfSunInDegrees(double d) {
            double d2 = 0.9856 * d - 3.289;
            double d3 = d2 + 1.916 * Math.sin(Math.toRadians(d2)) + 0.02 * Math.sin(2.0 * Math.toRadians(d2)) + 282.634;
            return AstroUtils.toRange_0_360(d3);
        }

        private Moment event(CalendarDate calendarDate, double d, double d2, double d3, boolean bl) {
            double d4;
            PlainDate plainDate = SolarTime.toGregorian(calendarDate);
            int n = plainDate.getDayOfYear();
            double d5 = d2 / 15.0;
            double d6 = (double)n + ((double)(bl ? 6 : 18) - d5) / 24.0;
            double d7 = this.trueLongitudeOfSunInDegrees(d6);
            double d8 = Math.toDegrees(Math.atan(0.91764 * Math.tan(Math.toRadians(d7))));
            d8 = AstroUtils.toRange_0_360(d8);
            double d9 = Math.floor(d7 / 90.0) * 90.0;
            double d10 = Math.floor(d8 / 90.0) * 90.0;
            d8 = (d8 + (d9 - d10)) / 15.0;
            double d11 = 0.39782 * Math.sin(Math.toRadians(d7));
            double d12 = Math.cos(Math.asin(d11));
            double d13 = Math.toRadians(d);
            double d14 = (Math.cos(Math.toRadians(d3)) - d11 * Math.sin(d13)) / (d12 * Math.cos(d13));
            if (Double.compare(d14, 1.0) > 0 || Double.compare(d14, -1.0) < 0) {
                return null;
            }
            double d15 = Math.toDegrees(Math.acos(d14));
            if (bl) {
                d15 = 360.0 - d15;
            }
            if (Double.compare(0.0, d4 = (d15 /= 15.0) + d8 - 0.06571 * d6 - 6.622) > 0) {
                d4 += 24.0;
            } else if (Double.compare(24.0, d4) <= 0) {
                d4 -= 24.0;
            }
            double d16 = d4 - d5;
            int n2 = (int)Math.floor(d16 * 3600.0);
            long l = plainDate.get(EpochDays.UTC) * 86400L + (long)n2;
            TimeScale timeScale = TimeScale.UT;
            if (!LeapSeconds.getInstance().isEnabled()) {
                l += 63072000L;
                timeScale = TimeScale.POSIX;
            }
            Moment moment = Moment.of(Math.round((double)l / 60.0) * 60L, timeScale);
            return (Moment)moment.with(Moment.PRECISION, TimeUnit.MINUTES);
        }
    }
    ,
    NOAA{

        @Override
        public Moment sunrise(CalendarDate calendarDate, double d, double d2, double d3) {
            return this.event(true, calendarDate, d, d2, d3);
        }

        @Override
        public Moment sunset(CalendarDate calendarDate, double d, double d2, double d3) {
            return this.event(false, calendarDate, d, d2, d3);
        }

        @Override
        public double equationOfTime(double d) {
            double d2 = StdSolarCalculator.toJulianCenturies(d);
            double d3 = Math.tan(Math.toRadians(this.obliquity(d2) / 2.0));
            double d4 = d3 * d3;
            double d5 = Math.toRadians(2.0 * this.meanLongitude(d2));
            double d6 = this.excentricity(d2);
            double d7 = Math.toRadians(this.meanAnomaly(d2));
            double d8 = Math.sin(d7);
            double d9 = d4 * Math.sin(d5) - 2.0 * d6 * d8 + 4.0 * d6 * d4 * d8 * Math.cos(d5) - d4 * d4 * Math.sin(2.0 * d5) / 2.0 - 5.0 * d6 * d6 * Math.sin(2.0 * d7) / 4.0;
            return Math.toDegrees(d9) * 240.0;
        }

        @Override
        public double declination(double d) {
            double d2 = StdSolarCalculator.toJulianCenturies(d);
            return Math.toDegrees(this.declinationRad(d2));
        }

        @Override
        public double getGeodeticAngle(double d, int n) {
            return 0.0;
        }

        @Override
        public double getZenithAngle(double d, int n) {
            return 90.83333333333333 + this.getGeodeticAngle(d, n);
        }

        @Override
        public double rightAscension(double d) {
            double d2 = StdSolarCalculator.toJulianCenturies(d);
            double d3 = Math.toRadians(this.solarLongitude(d2));
            double d4 = Math.cos(Math.toRadians(this.obliquity(d2))) * Math.sin(d3);
            double d5 = Math.toDegrees(Math.atan2(d4, Math.cos(d3)));
            return AstroUtils.toRange_0_360(d5);
        }

        private Moment event(boolean bl, CalendarDate calendarDate, double d, double d2, double d3) {
            Moment moment = SolarTime.fromLocalEvent(calendarDate, 12, d2, this.name());
            double d4 = JulianDay.getValue(moment, TimeScale.TT);
            double d5 = this.localHourAngle(bl, d4, d, d3);
            if (Double.isNaN(d5)) {
                return null;
            }
            if (Double.isNaN(d5 = this.localHourAngle(bl, d4 + d5 / 86400.0, d, d3))) {
                return null;
            }
            long l = (long)Math.floor(d5);
            int n = (int)((d5 - (double)l) * 1.0E9);
            Moment moment2 = (Moment)((Moment)moment.plus(l, TimeUnit.SECONDS)).plus((long)n, TimeUnit.NANOSECONDS);
            return (Moment)moment2.with(Moment.PRECISION, TimeUnit.SECONDS);
        }

        private double localHourAngle(boolean bl, double d, double d2, double d3) {
            double d4 = StdSolarCalculator.toJulianCenturies(d);
            double d5 = this.localHourAngle(d4, d2, d3);
            if (Double.isNaN(d5)) {
                return Double.NaN;
            }
            if (bl) {
                d5 = -d5;
            }
            return d5;
        }

        private double obliquity(double d) {
            double d2 = 23.433333333333334 + (21.448 + (-46.815 + (-5.9E-4 + 0.001813 * d) * d) * d) / 3600.0;
            double d3 = 0.00256 * Math.cos(Math.toRadians(125.04 - 1934.136 * d));
            return d2 + d3;
        }

        private double meanLongitude(double d) {
            return (280.46646 + (36000.76983 + 3.032E-4 * d) * d) % 360.0;
        }

        private double meanAnomaly(double d) {
            return 357.52911 + (35999.05029 - 1.537E-4 * d) * d;
        }

        private double excentricity(double d) {
            return 0.016708634 - (4.2037E-5 + 1.267E-7 * d) * d;
        }

        private double localHourAngle(double d, double d2, double d3) {
            double d4 = Math.toRadians(d2);
            double d5 = this.declinationRad(d);
            double d6 = (Math.cos(Math.toRadians(d3)) - Math.sin(d5) * Math.sin(d4)) / (Math.cos(d5) * Math.cos(d4));
            if (Double.compare(d6, 1.0) > 0 || Double.compare(d6, -1.0) < 0) {
                return Double.NaN;
            }
            return Math.toDegrees(Math.acos(d6)) * 240.0;
        }

        private double declinationRad(double d) {
            return Math.asin(Math.sin(Math.toRadians(this.obliquity(d))) * Math.sin(Math.toRadians(this.solarLongitude(d))));
        }

        private double solarLongitude(double d) {
            return this.meanLongitude(d) + this.equationOfCenter(d) - 0.00569 - 0.00478 * Math.sin(Math.toRadians(125.04 - 1934.136 * d));
        }

        private double equationOfCenter(double d) {
            double d2 = Math.toRadians(this.meanAnomaly(d));
            return Math.sin(d2) * (1.914602 - (0.004817 + 1.4E-5 * d) * d) + Math.sin(2.0 * d2) * (0.019993 - 1.01E-4 * d) + Math.sin(3.0 * d2) * 2.89E-4;
        }
    }
    ,
    CC{

        @Override
        public Moment sunrise(CalendarDate calendarDate, double d, double d2, double d3) {
            return this.event(true, calendarDate, d, d2, d3);
        }

        @Override
        public Moment sunset(CalendarDate calendarDate, double d, double d2, double d3) {
            return this.event(false, calendarDate, d, d2, d3);
        }

        private Moment event(boolean bl, CalendarDate calendarDate, double d, double d2, double d3) {
            double d4 = bl ? 0.25 : 0.75;
            double d5 = (double)EpochDays.JULIAN_DAY_NUMBER.transform(calendarDate.getDaysSinceEpochUTC(), EpochDays.UTC) + d4;
            double d6 = TimeScale.deltaT(SolarTime.toGregorian(calendarDate)) - 43200.0;
            double d7 = ((double)ZonalOffset.atLongitude(new BigDecimal(d2)).getIntegralAmount() - d6) / 86400.0;
            double d8 = this.momentOfDepression(d5, d, d7, d3 - 90.0, bl);
            if (Double.isNaN(d8)) {
                return null;
            }
            Moment moment = JulianDay.ofEphemerisTime(d8 - d7).toMoment();
            return (Moment)moment.with(Moment.PRECISION, TimeUnit.SECONDS);
        }

        @Override
        public double equationOfTime(double d) {
            double d2 = StdSolarCalculator.toJulianCenturies(d);
            double d3 = Math.tan(Math.toRadians(this.obliquity(d2) / 2.0));
            double d4 = d3 * d3;
            double d5 = Math.toRadians(2.0 * this.meanLongitude(d2));
            double d6 = this.excentricity(d2);
            double d7 = Math.toRadians(this.meanAnomaly(d2));
            double d8 = Math.sin(d7);
            double d9 = d4 * Math.sin(d5) - 2.0 * d6 * d8 + 4.0 * d6 * d4 * d8 * Math.cos(d5) - d4 * d4 * Math.sin(2.0 * d5) / 2.0 - 5.0 * d6 * d6 * Math.sin(2.0 * d7) / 4.0;
            return Math.toDegrees(d9) * 240.0;
        }

        @Override
        public double declination(double d) {
            return this.getFeature(d, "declination");
        }

        @Override
        public double rightAscension(double d) {
            return this.getFeature(d, "right-ascension");
        }

        @Override
        public double getFeature(double d, String string) {
            double d2 = StdSolarCalculator.toJulianCenturies(d);
            if (string.equals("declination")) {
                return Math.toDegrees(this.declinationRad(d2));
            }
            if (string.equals("right-ascension")) {
                double d3 = Math.toRadians(StdSolarCalculator.apparentSolarLongitude(d2, this.nutation(d2)));
                double d4 = Math.cos(Math.toRadians(this.obliquity(d2))) * Math.sin(d3);
                double d5 = Math.toDegrees(Math.atan2(d4, Math.cos(d3)));
                return AstroUtils.toRange_0_360(d5);
            }
            if (string.equals("nutation")) {
                return this.nutation(d2);
            }
            if (string.equals("obliquity")) {
                return this.obliquity(d2);
            }
            if (string.equals("mean-anomaly")) {
                return this.meanAnomaly(d2);
            }
            if (string.equals("solar-longitude")) {
                return StdSolarCalculator.apparentSolarLongitude(d2, this.nutation(d2));
            }
            if (string.equals("solar-latitude")) {
                return 0.0;
            }
            return Double.NaN;
        }

        @Override
        public double getGeodeticAngle(double d, int n) {
            if (n == 0) {
                return 0.0;
            }
            double d2 = 6372000.0;
            return Math.toDegrees(Math.acos(d2 / (d2 + (double)n))) + Math.sqrt(n) * 0.005277777777777778;
        }

        @Override
        public double getZenithAngle(double d, int n) {
            return 90.83333333333333 + this.getGeodeticAngle(d, n);
        }

        private double momentOfDepression(double d, double d2, double d3, double d4, boolean bl) {
            double d5 = this.approxMomentOfDepression(d, d2, d3, d4, bl);
            if (Double.isNaN(d5)) {
                return Double.NaN;
            }
            if (Math.abs(d - d5) * 86400.0 < 30.0) {
                return d5;
            }
            return this.momentOfDepression(d5, d2, d3, d4, bl);
        }

        private double approxMomentOfDepression(double d, double d2, double d3, double d4, boolean bl) {
            double d5;
            long l = (long)Math.floor(d);
            double d6 = this.sineOffset(d - d3, d2, d4);
            double d7 = d4 >= 0.0 ? (double)(bl ? l : l + 1L) : (double)l + 0.5;
            double d8 = d5 = Math.abs(d6) > 1.0 ? this.sineOffset(d7 - d3, d2, d4) : d6;
            if (Math.abs(d5) <= 1.0) {
                double d9 = bl ? -1 : 1;
                d9 *= (0.5 + Math.toDegrees(Math.asin(d5)) / 360.0) % 1.0 - 0.25;
                d9 += (double)l;
                return (d9 += 0.5) - this.equationOfTime(d9 - d3) / 86400.0;
            }
            return Double.NaN;
        }

        private double sineOffset(double d, double d2, double d3) {
            double d4 = StdSolarCalculator.toJulianCenturies(d);
            double d5 = Math.toRadians(d2);
            double d6 = this.declinationRad(d4);
            return Math.tan(d5) * Math.tan(d6) + Math.sin(Math.toRadians(d3)) / (Math.cos(d6) * Math.cos(d5));
        }

        private double declinationRad(double d) {
            return Math.asin(Math.sin(Math.toRadians(this.obliquity(d))) * Math.sin(Math.toRadians(StdSolarCalculator.apparentSolarLongitude(d, this.nutation(d)))));
        }

        private double nutation(double d) {
            double d2 = Math.toRadians(124.9 + (-1934.134 + 0.002063 * d) * d);
            double d3 = Math.toRadians(201.11 + (72001.5377 + 5.7E-4 * d) * d);
            return -0.004778 * Math.sin(d2) - 3.667E-4 * Math.sin(d3);
        }

        private double obliquity(double d) {
            return 23.433333333333334 + (21.448 + (-46.815 + (-5.9E-4 + 0.001813 * d) * d) * d) / 3600.0;
        }

        private double meanLongitude(double d) {
            return (280.46645 + (36000.76983 + 3.032E-4 * d) * d) % 360.0;
        }

        private double meanAnomaly(double d) {
            return 357.5291 + (35999.0503 + (-1.559E-4 + 4.8E-7 * d) * d) * d;
        }

        private double excentricity(double d) {
            return 0.016708617 - (4.2037E-5 + 1.236E-7 * d) * d;
        }
    }
    ,
    TIME4J{

        @Override
        public Moment sunrise(CalendarDate calendarDate, double d, double d2, double d3) {
            return this.event(true, calendarDate, d, d2, d3);
        }

        @Override
        public Moment sunset(CalendarDate calendarDate, double d, double d2, double d3) {
            return this.event(false, calendarDate, d, d2, d3);
        }

        @Override
        public double equationOfTime(double d) {
            double d2 = StdSolarCalculator.toJulianCenturies(d);
            double d3 = Math.tan(Math.toRadians(this.trueObliquity(d2) / 2.0));
            double d4 = d3 * d3;
            double d5 = Math.toRadians(2.0 * this.meanLongitude(d2));
            double d6 = this.excentricity(d2);
            double d7 = Math.toRadians(this.meanAnomaly(d2));
            double d8 = Math.sin(d7);
            double d9 = d4 * Math.sin(d5) - 2.0 * d6 * d8 + 4.0 * d6 * d4 * d8 * Math.cos(d5) - d4 * d4 * Math.sin(2.0 * d5) / 2.0 - 5.0 * d6 * d6 * Math.sin(2.0 * d7) / 4.0;
            return Math.toDegrees(d9) * 240.0;
        }

        @Override
        public double declination(double d) {
            return this.getFeature(d, "declination");
        }

        @Override
        public double rightAscension(double d) {
            return this.getFeature(d, "right-ascension");
        }

        @Override
        public double getFeature(double d, String string) {
            double d2 = StdSolarCalculator.toJulianCenturies(d);
            if (string.equals("declination")) {
                return Math.toDegrees(this.declinationRad(d2));
            }
            if (string.equals("right-ascension")) {
                double[] dArray = new double[2];
                4.nutations(d2, dArray);
                double d3 = Math.toRadians(StdSolarCalculator.apparentSolarLongitude(d2, dArray[0]));
                double d4 = Math.cos(Math.toRadians(4.meanObliquity(d2) + dArray[1])) * Math.sin(d3);
                double d5 = Math.toDegrees(Math.atan2(d4, Math.cos(d3)));
                return AstroUtils.toRange_0_360(d5);
            }
            if (string.equals("nutation")) {
                double[] dArray = new double[2];
                4.nutations(d2, dArray);
                return dArray[0];
            }
            if (string.equals("obliquity")) {
                double[] dArray = new double[2];
                4.nutations(d2, dArray);
                return 4.meanObliquity(d2) + dArray[1];
            }
            if (string.equals("mean-anomaly")) {
                return this.meanAnomaly(d2);
            }
            if (string.equals("solar-longitude")) {
                double[] dArray = new double[2];
                4.nutations(d2, dArray);
                return StdSolarCalculator.apparentSolarLongitude(d2, dArray[0]);
            }
            if (string.equals("solar-latitude")) {
                return 0.0;
            }
            return Double.NaN;
        }

        @Override
        public double getGeodeticAngle(double d, int n) {
            if (n == 0) {
                return 0.0;
            }
            double d2 = Math.toRadians(d);
            double d3 = 6378137.0 * Math.cos(d2);
            double d4 = 6356752.3 * Math.sin(d2);
            double d5 = 4.0680631590769E13 / Math.sqrt(d3 * d3 + d4 * d4);
            return Math.toDegrees(Math.acos(d5 / (d5 + (double)n)));
        }

        @Override
        public double getZenithAngle(double d, int n) {
            if (n == 0) {
                return 90.83333333333333;
            }
            double d2 = AstroUtils.refractionFactorOfStdAtmosphere(n) * 34.0;
            return 90.0 + this.getGeodeticAngle(d, n) + (16.0 + d2) / 60.0;
        }

        private Moment event(boolean bl, CalendarDate calendarDate, double d, double d2, double d3) {
            double d4;
            Moment moment = SolarTime.fromLocalEvent(calendarDate, 12, d2, this.name());
            double d5 = JulianDay.getValue(moment, TimeScale.TT);
            double d6 = 0.0;
            do {
                if (!Double.isNaN(d6 = this.localHourAngle(bl, d5 + (d4 = d6) / 86400.0, d, d3))) continue;
                return null;
            } while (Math.abs(d6 - d4) >= 15.0);
            long l = (long)Math.floor(d6);
            int n = (int)((d6 - (double)l) * 1.0E9);
            Moment moment2 = (Moment)((Moment)moment.plus(l, TimeUnit.SECONDS)).plus((long)n, TimeUnit.NANOSECONDS);
            return (Moment)moment2.with(Moment.PRECISION, TimeUnit.SECONDS);
        }

        private double localHourAngle(boolean bl, double d, double d2, double d3) {
            double d4 = StdSolarCalculator.toJulianCenturies(d);
            double d5 = Math.toRadians(d2);
            double d6 = this.declinationRad(d4);
            double d7 = (Math.cos(Math.toRadians(d3)) - Math.sin(d6) * Math.sin(d5)) / (Math.cos(d6) * Math.cos(d5));
            if (Double.compare(d7, 1.0) > 0 || Double.compare(d7, -1.0) < 0) {
                return Double.NaN;
            }
            double d8 = Math.toDegrees(Math.acos(d7)) * 240.0;
            if (bl) {
                d8 = -d8;
            }
            return d8;
        }

        private double declinationRad(double d) {
            double[] dArray = new double[2];
            4.nutations(d, dArray);
            return Math.asin(Math.sin(Math.toRadians(4.meanObliquity(d) + dArray[1])) * Math.sin(Math.toRadians(StdSolarCalculator.apparentSolarLongitude(d, dArray[0]))));
        }

        private double trueObliquity(double d) {
            return 4.meanObliquity(d) + 0.00256 * Math.cos(Math.toRadians(125.04 - 1934.136 * d));
        }

        private double meanLongitude(double d) {
            return (280.46646 + (36000.76983 + 3.032E-4 * d) * d) % 360.0;
        }

        private double meanAnomaly(double d) {
            return 357.52911 + (35999.05029 - 1.537E-4 * d) * d;
        }

        private double excentricity(double d) {
            return 0.016708634 - (4.2037E-5 + 1.267E-7 * d) * d;
        }
    };

    private static final int[] DG_X;
    private static final double[] DG_Y;
    private static final double[] DG_Z;
    private static final int MEAN_EARTH_RADIUS = 6372000;
    private static final double EQUATORIAL_RADIUS = 6378137.0;
    private static final double POLAR_RADIUS = 6356752.3;
    private static final double[][] TABLE_22A;

    @Override
    public double declination(double d) {
        throw new AbstractMethodError();
    }

    public double rightAscension(double d) {
        throw new AbstractMethodError();
    }

    @Override
    public double getFeature(double d, String string) {
        if (string.equals("declination")) {
            return this.declination(d);
        }
        if (string.equals("right-ascension")) {
            return this.rightAscension(d);
        }
        return Double.NaN;
    }

    static double meanObliquity(double d) {
        return 23.433333333333334 + (21.448 + (-46.815 + (-5.9E-4 + 0.001813 * d) * d) * d) / 3600.0;
    }

    static void nutations(double d, double[] dArray) {
        double d2 = Math.toRadians(297.85036 + (445267.11148 + (-0.0019142 + 5.277768981496142E-6 * d) * d) * d);
        double d3 = Math.toRadians(357.52772 + (35999.05034 + (-1.603E-4 + -3.3333333333333333E-6 * d) * d) * d);
        double d4 = Math.toRadians(134.96298 + (477198.867398 + (0.0086972 + 1.7777777777777779E-4 * d) * d) * d);
        double d5 = Math.toRadians(93.27191 + (483202.017538 + (-0.0036825 + 3.0555810187307116E-6 * d) * d) * d);
        double d6 = Math.toRadians(125.04452 + (-1934.136261 + (0.0020708 + 2.222222222222222E-6 * d) * d) * d);
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = TABLE_22A.length - 1; i >= 0; --i) {
            double[] dArray2 = TABLE_22A[i];
            double d9 = dArray2[0] * d2 + dArray2[1] * d3 + dArray2[2] * d4 + dArray2[3] * d5 + dArray2[4] * d6;
            d7 += Math.sin(d9) * (dArray2[5] + dArray2[6] * d);
            d8 += Math.cos(d9) * (dArray2[7] + dArray2[8] * d);
        }
        dArray[0] = d7 * 1.0E-4 / 3600.0;
        dArray[1] = d8 * 1.0E-4 / 3600.0;
    }

    private static double toJulianCenturies(double d) {
        return (d - 2451545.0) / 36525.0;
    }

    private static double apparentSolarLongitude(double d, double d2) {
        double d3 = 0.0;
        for (int i = DG_X.length - 1; i >= 0; --i) {
            d3 += (double)DG_X[i] * Math.sin(Math.toRadians(DG_Y[i] + DG_Z[i] * d));
        }
        double d4 = (282.7771834 + 36000.76953744 * d + 5.729577951308232 * d3 / 1000000.0 + StdSolarCalculator.aberration(d) + d2) / 360.0;
        return (d4 - Math.floor(d4)) * 360.0;
    }

    private static double aberration(double d) {
        return 9.74E-5 * Math.cos(Math.toRadians(177.63 + 35999.01848 * d)) - 0.005575;
    }

    static {
        DG_X = new int[]{403406, 195207, 119433, 112392, 3891, 2819, 1721, 660, 350, 334, 314, 268, 242, 234, 158, 132, 129, 114, 99, 93, 86, 78, 72, 68, 64, 46, 38, 37, 32, 29, 28, 27, 27, 25, 24, 21, 21, 20, 18, 17, 14, 13, 13, 13, 12, 10, 10, 10, 10};
        DG_Y = new double[]{270.54861, 340.19128, 63.91854, 331.2622, 317.843, 86.631, 240.052, 310.26, 247.23, 260.87, 297.82, 343.14, 166.79, 81.53, 3.5, 132.75, 182.95, 162.03, 29.8, 266.4, 249.2, 157.6, 257.8, 185.1, 69.9, 8.0, 197.1, 250.4, 65.3, 162.7, 341.5, 291.6, 98.5, 146.7, 110.0, 5.2, 342.6, 230.9, 256.1, 45.3, 242.9, 115.2, 151.8, 285.3, 53.3, 126.6, 205.7, 85.9, 146.1};
        DG_Z = new double[]{0.9287892, 35999.1376958, 35999.4089666, 35998.7287385, 71998.20261, 71998.4403, 36000.35726, 71997.4812, 32964.4678, -19.441, 445267.1117, 45036.884, 3.1008, 22518.4434, -19.9739, 65928.9345, 9038.0293, 3034.7684, 33718.148, 3034.448, -2280.773, 29929.992, 31556.493, 149.588, 9037.75, 107997.405, -4444.176, 151.771, 67555.316, 31556.08, -4561.54, 107996.706, 1221.655, 62894.167, 31437.369, 14578.298, -31931.757, 34777.243, 1221.999, 62894.511, -4442.039, 107997.909, 119.066, 16859.071, -4.578, 26895.292, -39.127, 12297.536, 90073.778};
        TABLE_22A = new double[][]{{0.0, 0.0, 0.0, 0.0, 1.0, -171996.0, -174.2, 92025.0, 8.9}, {-2.0, 0.0, 0.0, 2.0, 2.0, -13187.0, -1.6, 5736.0, -3.1}, {0.0, 0.0, 0.0, 2.0, 2.0, -2274.0, -0.2, 977.0, -0.5}, {0.0, 0.0, 0.0, 0.0, 2.0, 2062.0, 0.2, -895.0, 0.5}, {0.0, 1.0, 0.0, 0.0, 0.0, 1426.0, -3.4, 54.0, -0.1}, {0.0, 0.0, 1.0, 0.0, 0.0, 712.0, 0.1, -7.0, 0.0}, {-2.0, 1.0, 0.0, 2.0, 2.0, -517.0, 1.2, 224.0, -0.6}, {0.0, 0.0, 0.0, 2.0, 1.0, -386.0, -0.4, 200.0, 0.0}, {0.0, 0.0, 1.0, 2.0, 2.0, -301.0, 0.0, 129.0, -0.1}, {-2.0, -1.0, 0.0, 2.0, 2.0, 217.0, -0.5, -95.0, 0.3}, {-2.0, 0.0, 1.0, 0.0, 0.0, -158.0, 0.0, 0.0, 0.0}, {-2.0, 0.0, 0.0, 2.0, 1.0, 129.0, 0.1, -70.0, 0.0}, {0.0, 0.0, -1.0, 2.0, 2.0, 123.0, 0.0, -53.0, 0.0}, {2.0, 0.0, 0.0, 0.0, 0.0, 63.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 1.0, 63.0, 0.1, -33.0, 0.0}, {2.0, 0.0, -1.0, 2.0, 2.0, -59.0, 0.0, 26.0, 0.0}, {0.0, 0.0, -1.0, 0.0, 1.0, -58.0, -0.1, 32.0, 0.0}, {0.0, 0.0, 1.0, 2.0, 1.0, -51.0, 0.0, 27.0, 0.0}, {-2.0, 0.0, 2.0, 0.0, 0.0, 48.0, 0.0, 0.0, 0.0}, {0.0, 0.0, -2.0, 2.0, 1.0, 46.0, 0.0, -24.0, 0.0}, {2.0, 0.0, 0.0, 2.0, 2.0, -38.0, 0.0, 16.0, 0.0}, {0.0, 0.0, 2.0, 2.0, 2.0, -31.0, 0.0, 13.0, 0.0}, {0.0, 0.0, 2.0, 0.0, 0.0, 29.0, 0.0, 0.0, 0.0}, {-2.0, 0.0, 1.0, 2.0, 2.0, 29.0, 0.0, -12.0, 0.0}, {0.0, 0.0, 0.0, 2.0, 0.0, 26.0, 0.0, 0.0, 0.0}, {-2.0, 0.0, 0.0, 2.0, 0.0, -22.0, 0.0, 0.0, 0.0}, {0.0, 0.0, -1.0, 2.0, 1.0, 21.0, 0.0, -10.0, 0.0}, {0.0, 2.0, 0.0, 0.0, 0.0, 17.0, -0.1, 0.0, 0.0}, {2.0, 0.0, -1.0, 0.0, 1.0, 16.0, 0.0, -8.0, 0.0}, {-2.0, 2.0, 0.0, 2.0, 2.0, -16.0, 0.1, 7.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 1.0, -15.0, 0.0, 9.0, 0.0}, {-2.0, 0.0, 1.0, 0.0, 1.0, -13.0, 0.0, 7.0, 0.0}, {0.0, -1.0, 0.0, 0.0, 1.0, -12.0, 0.0, 6.0, 0.0}, {0.0, 0.0, 2.0, -2.0, 0.0, 11.0, 0.0, 0.0, 0.0}, {2.0, 0.0, -1.0, 2.0, 1.0, -10.0, 0.0, 5.0, 0.0}, {2.0, 0.0, 1.0, 2.0, 2.0, -8.0, 0.0, 3.0, 0.0}, {0.0, 1.0, 0.0, 2.0, 2.0, 7.0, 0.0, -3.0, 0.0}, {-2.0, 1.0, 1.0, 0.0, 0.0, -7.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 0.0, 2.0, 2.0, -7.0, 0.0, 3.0, 0.0}, {2.0, 0.0, 0.0, 2.0, 1.0, -7.0, 0.0, 3.0, 0.0}, {2.0, 0.0, 1.0, 0.0, 0.0, 6.0, 0.0, 0.0, 0.0}, {-2.0, 0.0, 2.0, 2.0, 2.0, 6.0, 0.0, -3.0, 0.0}, {-2.0, 0.0, 1.0, 2.0, 1.0, 6.0, 0.0, -3.0, 0.0}, {2.0, 0.0, -2.0, 0.0, 1.0, -6.0, 0.0, 3.0, 0.0}, {2.0, 0.0, 0.0, 0.0, 1.0, -6.0, 0.0, 3.0, 0.0}, {0.0, -1.0, 1.0, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0}, {-2.0, -1.0, 0.0, 2.0, 1.0, -5.0, 0.0, 3.0, 0.0}, {-2.0, 0.0, 0.0, 0.0, 1.0, -5.0, 0.0, 3.0, 0.0}, {0.0, 0.0, 2.0, 2.0, 1.0, -5.0, 0.0, 3.0, 0.0}, {-2.0, 0.0, 2.0, 0.0, 1.0, 4.0, 0.0, 0.0, 0.0}, {-2.0, 1.0, 0.0, 2.0, 1.0, 4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, -2.0, 0.0, 4.0, 0.0, 0.0, 0.0}, {-1.0, 0.0, 1.0, 0.0, 0.0, -4.0, 0.0, 0.0, 0.0}, {-2.0, 1.0, 0.0, 0.0, 0.0, -4.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0, -4.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 2.0, 0.0, 3.0, 0.0, 0.0, 0.0}, {0.0, 0.0, -2.0, 2.0, 2.0, -3.0, 0.0, 0.0, 0.0}, {-1.0, -1.0, 1.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 1.0, 0.0, 0.0, -3.0, 0.0, 0.0, 0.0}, {0.0, -1.0, 1.0, 2.0, 2.0, -3.0, 0.0, 0.0, 0.0}, {2.0, -1.0, -1.0, 2.0, 2.0, -3.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 3.0, 2.0, 2.0, -3.0, 0.0, 0.0, 0.0}, {2.0, -1.0, 0.0, 2.0, 2.0, -3.0, 0.0, 0.0, 0.0}};
    }
}

