/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.calendar.CyclicYear;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoException;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.TextElement;

class EastAsianCY
implements TextElement<CyclicYear>,
Serializable {
    static final EastAsianCY SINGLETON = new EastAsianCY();
    private static final long serialVersionUID = -4211396220263977858L;

    EastAsianCY() {
    }

    @Override
    public String name() {
        return "CYCLIC_YEAR";
    }

    @Override
    public Class<CyclicYear> getType() {
        return CyclicYear.class;
    }

    @Override
    public char getSymbol() {
        return 'U';
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return chronoDisplay.get(this).compareTo(chronoDisplay2.get(this));
    }

    @Override
    public CyclicYear getDefaultMinimum() {
        return CyclicYear.of(1);
    }

    @Override
    public CyclicYear getDefaultMaximum() {
        return CyclicYear.of(60);
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public String getDisplayName(Locale locale) {
        String string = "L_year";
        String string2 = CalendarText.getIsoInstance(locale).getTextForms().get(string);
        return string2 == null ? this.name() : string2;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        appendable.append(chronoDisplay.get(this).getDisplayName(locale));
    }

    @Override
    public CyclicYear parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        boolean bl = !attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isStrict();
        return CyclicYear.parse(charSequence, parsePosition, locale, bl);
    }

    protected Object readResolve() throws ObjectStreamException {
        return SINGLETON;
    }
}

