/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.frenchrev;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.frenchrev.DayOfDecade;
import net.time4j.calendar.frenchrev.FrenchRepublicanAlgorithm;
import net.time4j.calendar.frenchrev.FrenchRepublicanEra;
import net.time4j.calendar.frenchrev.FrenchRepublicanMonth;
import net.time4j.calendar.frenchrev.SPX;
import net.time4j.calendar.frenchrev.Sansculottides;
import net.time4j.calendar.service.DualYearOfEraElement;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="extra/frenchrev")
public final class FrenchRepublicanCalendar
extends Calendrical<Unit, FrenchRepublicanCalendar> {
    static final int MAX_YEAR = 1202;
    private static final int YEAR_INDEX = 0;
    private static final int DECADE_INDEX = 1;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<FrenchRepublicanEra> ERA = new StdEnumDateElement<FrenchRepublicanEra, FrenchRepublicanCalendar>("ERA", FrenchRepublicanCalendar.class, FrenchRepublicanEra.class, 'G');
    @FormattableElement(format="Y")
    public static final StdCalendarElement<Integer, FrenchRepublicanCalendar> YEAR_OF_ERA = new YearOfEraElement();
    private static final SansculottidesAccess SANSCULOTTIDES_ACCESS = new SansculottidesAccess();
    private static final DayOfDecadeAccess DAY_OF_DECADE_ACCESS = new DayOfDecadeAccess();
    @FormattableElement(format="S")
    public static final ChronoElement<Sansculottides> SANSCULOTTIDES = SANSCULOTTIDES_ACCESS;
    @FormattableElement(format="M")
    public static final StdCalendarElement<FrenchRepublicanMonth, FrenchRepublicanCalendar> MONTH_OF_YEAR = new StdEnumDateElement<FrenchRepublicanMonth, FrenchRepublicanCalendar>("MONTH_OF_YEAR", FrenchRepublicanCalendar.class, FrenchRepublicanMonth.class, 'M');
    public static final StdCalendarElement<Integer, FrenchRepublicanCalendar> DECADE_OF_MONTH = new StdIntegerDateElement<FrenchRepublicanCalendar>("DECADE_OF_MONTH", FrenchRepublicanCalendar.class, 1, 3, '\u0000', null, null);
    @FormattableElement(format="C")
    public static final ChronoElement<DayOfDecade> DAY_OF_DECADE = DAY_OF_DECADE_ACCESS;
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, FrenchRepublicanCalendar> DAY_OF_MONTH = new StdIntegerDateElement<FrenchRepublicanCalendar>("DAY_OF_MONTH", FrenchRepublicanCalendar.class, 1, 30, 'D');
    public static final StdCalendarElement<Integer, FrenchRepublicanCalendar> DAY_OF_YEAR = new StdIntegerDateElement<FrenchRepublicanCalendar>("DAY_OF_YEAR", FrenchRepublicanCalendar.class, 1, 365, '\u0000');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, FrenchRepublicanCalendar> DAY_OF_WEEK = new StdWeekdayElement<FrenchRepublicanCalendar>(FrenchRepublicanCalendar.class, FrenchRepublicanCalendar.getDefaultWeekmodel());
    private static final CalendarSystem<FrenchRepublicanCalendar> CALSYS;
    private static final TimeAxis<Unit, FrenchRepublicanCalendar> ENGINE;
    private static final FrenchRepublicanAlgorithm DEFAULT_ALGORITHM;
    private static final long serialVersionUID = -6054794927532842783L;
    private final transient int fyear;
    private final transient int fdoy;

    FrenchRepublicanCalendar(int n, int n2) {
        this.fyear = n;
        this.fdoy = n2;
    }

    public static FrenchRepublicanCalendar of(int n, FrenchRepublicanMonth frenchRepublicanMonth, int n2) {
        return FrenchRepublicanCalendar.of(n, frenchRepublicanMonth.getValue(), n2);
    }

    public static FrenchRepublicanCalendar of(int n, int n2, int n3) {
        if (n < 1 || n > 1202 || n2 < 1 || n2 > 12 || n3 < 1 || n3 > 30) {
            throw new IllegalArgumentException("Invalid French republican date: year=" + n + ", month=" + n2 + ", day=" + n3);
        }
        return new FrenchRepublicanCalendar(n, (n2 - 1) * 30 + n3);
    }

    public static FrenchRepublicanCalendar of(int n, Sansculottides sansculottides) {
        if (n < 1 || n > 1202) {
            throw new IllegalArgumentException("Year out of range: " + n);
        }
        if (sansculottides == Sansculottides.LEAP_DAY && !FrenchRepublicanCalendar.isLeapYear(n)) {
            throw new IllegalArgumentException("Day of Revolution only exists in leap years: " + n);
        }
        return new FrenchRepublicanCalendar(n, 360 + sansculottides.getValue());
    }

    public static FrenchRepublicanCalendar nowInSystemTime() {
        return (FrenchRepublicanCalendar)SystemClock.inLocalView().now(FrenchRepublicanCalendar.axis());
    }

    public FrenchRepublicanEra getEra() {
        return FrenchRepublicanEra.REPUBLICAN;
    }

    public int getYear() {
        return this.fyear;
    }

    public FrenchRepublicanMonth getMonth() {
        if (this.fdoy > 360) {
            throw new ChronoException("Complementary days (sansculottides) do not represent any month: " + this.toString());
        }
        int n = (this.fdoy - 1) / 30 + 1;
        return FrenchRepublicanMonth.valueOf(n);
    }

    public int getDecade() {
        if (this.fdoy > 360) {
            throw new ChronoException("Complementary days (sansculottides) do not represent any decade: " + this.toString());
        }
        return (this.fdoy - 1) % 30 / 10 + 1;
    }

    public int getDayOfMonth() {
        if (this.fdoy > 360) {
            throw new ChronoException("Complementary days (sansculottides) are not part of any month: " + this.toString());
        }
        return (this.fdoy - 1) % 30 + 1;
    }

    public DayOfDecade getDayOfDecade() {
        if (this.hasSansculottides()) {
            throw new ChronoException("Day of decade does not exist on sansculottides: " + this.toString());
        }
        return DayOfDecade.valueOf((this.fdoy - 1) % 10 + 1);
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return this.fdoy;
    }

    public Sansculottides getSansculottides() {
        if (this.fdoy <= 360) {
            throw new ChronoException("Not a sansculottides day: " + this.toString());
        }
        return Sansculottides.valueOf(this.fdoy - 360);
    }

    public boolean hasSansculottides() {
        return this.fdoy > 360;
    }

    public boolean hasMonth() {
        return this.fdoy <= 360;
    }

    public boolean isLeapYear() {
        return FrenchRepublicanCalendar.isLeapYear(this.fyear);
    }

    public static boolean isLeapYear(int n) {
        return DEFAULT_ALGORITHM.isLeapYear(n);
    }

    public static boolean isValid(int n, int n2, int n3) {
        return n >= 1 && n <= 1202 && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= 30;
    }

    public Date getDate(FrenchRepublicanAlgorithm frenchRepublicanAlgorithm) {
        if (frenchRepublicanAlgorithm == DEFAULT_ALGORITHM) {
            return new Date(this, DEFAULT_ALGORITHM);
        }
        long l = DEFAULT_ALGORITHM.transform(this);
        return new Date(frenchRepublicanAlgorithm.transform(l), frenchRepublicanAlgorithm);
    }

    public GeneralTimestamp<FrenchRepublicanCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<FrenchRepublicanCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    public FrenchRepublicanCalendar withEndOfFranciade() {
        int n = this.fyear;
        while (!FrenchRepublicanCalendar.isLeapYear(n)) {
            ++n;
        }
        return new FrenchRepublicanCalendar(n, 366);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FrenchRepublicanCalendar) {
            FrenchRepublicanCalendar frenchRepublicanCalendar = (FrenchRepublicanCalendar)object;
            return this.fyear == frenchRepublicanCalendar.fyear && this.fdoy == frenchRepublicanCalendar.fdoy;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.fdoy + 37 * this.fyear;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("French-Republic-");
        stringBuilder.append(NumberSystem.ROMAN.toNumeral(this.fyear));
        stringBuilder.append('-');
        if (this.fdoy > 360) {
            stringBuilder.append("Sansculottides-");
            stringBuilder.append(String.valueOf(this.fdoy - 360));
        } else {
            int n = this.getMonth().getValue();
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            stringBuilder.append('-');
            int n2 = this.getDayOfMonth();
            if (n2 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        if (chronoElement == MONTH_OF_YEAR || chronoElement == DECADE_OF_MONTH || chronoElement == DAY_OF_DECADE || chronoElement == DAY_OF_MONTH) {
            return this.hasMonth();
        }
        if (chronoElement == SANSCULOTTIDES) {
            return this.hasSansculottides();
        }
        if (this.getRegisteredElements().contains(chronoElement)) {
            return true;
        }
        return FrenchRepublicanCalendar.isAccessible(this, chronoElement);
    }

    @Override
    public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == MONTH_OF_YEAR) {
            return v != null;
        }
        if (chronoElement == SANSCULOTTIDES) {
            return SANSCULOTTIDES_ACCESS.isValid(this, (Sansculottides)((Object)Sansculottides.class.cast(v)));
        }
        return super.isValid(chronoElement, v);
    }

    public static TimeAxis<Unit, FrenchRepublicanCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, FrenchRepublicanCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected FrenchRepublicanCalendar getContext() {
        return this;
    }

    private static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SUNDAY, 1, Weekday.SUNDAY, Weekday.SUNDAY);
    }

    private static <V> boolean isAccessible(FrenchRepublicanCalendar frenchRepublicanCalendar, ChronoElement<V> chronoElement) {
        try {
            return frenchRepublicanCalendar.isValid(chronoElement, frenchRepublicanCalendar.get(chronoElement));
        }
        catch (ChronoException chronoException) {
            return false;
        }
    }

    private Object writeReplace() {
        return new SPX(this, 11);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        DEFAULT_ALGORITHM = FrenchRepublicanAlgorithm.EQUINOX;
        CALSYS = new Transformer();
        TimeAxis.Builder<Unit, FrenchRepublicanCalendar> builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, FrenchRepublicanCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement(YEAR_OF_ERA, new IntegerRule(0), Unit.YEARS).appendElement((ChronoElement)SANSCULOTTIDES, (ElementRule)SANSCULOTTIDES_ACCESS)).appendElement(MONTH_OF_YEAR, new MonthRule(), Unit.MONTHS).appendElement(DECADE_OF_MONTH, new IntegerRule(1), Unit.DECADES).appendElement(DAY_OF_MONTH, new IntegerRule(2), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule(), Unit.DAYS).appendElement((ChronoElement)DAY_OF_DECADE, (ElementRule)DAY_OF_DECADE_ACCESS)).appendUnit(Unit.YEARS, new FUnitRule(Unit.YEARS), Unit.YEARS.getLength()).appendUnit(Unit.MONTHS, new FUnitRule(Unit.MONTHS), Unit.MONTHS.getLength()).appendUnit(Unit.DECADES, new FUnitRule(Unit.DECADES), Unit.DECADES.getLength()).appendUnit(Unit.WEEKS, new FUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new FUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS));
        ENGINE = builder.build();
    }

    private static class FUnitRule
    implements UnitRule<FrenchRepublicanCalendar> {
        private final Unit unit;

        FUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public FrenchRepublicanCalendar addTo(FrenchRepublicanCalendar frenchRepublicanCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    int n = MathUtils.safeCast(MathUtils.safeAdd((long)frenchRepublicanCalendar.fyear, l));
                    if (n < 1 || n > 1202) {
                        throw new IllegalArgumentException("Resulting year out of bounds: " + n);
                    }
                    int n2 = Math.min(frenchRepublicanCalendar.fdoy, FrenchRepublicanCalendar.isLeapYear(n) ? 366 : 365);
                    return new FrenchRepublicanCalendar(n, n2);
                }
                case MONTHS: {
                    long l2 = MathUtils.safeAdd((long)FUnitRule.ymValue(frenchRepublicanCalendar), l);
                    int n = MathUtils.safeCast(MathUtils.floorDivide(l2, 12));
                    int n3 = MathUtils.floorModulo(l2, 12) + 1;
                    int n4 = frenchRepublicanCalendar.hasSansculottides() ? 30 : frenchRepublicanCalendar.getDayOfMonth();
                    return FrenchRepublicanCalendar.of(n, n3, n4);
                }
                case DECADES: {
                    long l3 = MathUtils.safeAdd((long)FUnitRule.decValue(frenchRepublicanCalendar), l);
                    int n = MathUtils.safeCast(MathUtils.floorDivide(l3, 36));
                    int n5 = MathUtils.floorModulo(l3, 36);
                    int n6 = MathUtils.floorDivide(n5, 3) + 1;
                    int n7 = MathUtils.floorModulo(n5, 3);
                    int n8 = ((frenchRepublicanCalendar.hasSansculottides() ? 30 : frenchRepublicanCalendar.getDayOfMonth()) - 1) % 10 + 1;
                    int n9 = n7 * 10 + n8;
                    return FrenchRepublicanCalendar.of(n, n6, n9);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply(l, 7L);
                }
                case DAYS: {
                    long l4 = MathUtils.safeAdd(CALSYS.transform(frenchRepublicanCalendar), l);
                    return (FrenchRepublicanCalendar)CALSYS.transform(l4);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(FrenchRepublicanCalendar frenchRepublicanCalendar, FrenchRepublicanCalendar frenchRepublicanCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    int n = frenchRepublicanCalendar2.fyear - frenchRepublicanCalendar.fyear;
                    if (n > 0 && frenchRepublicanCalendar2.fdoy < frenchRepublicanCalendar.fdoy) {
                        --n;
                    } else if (n < 0 && frenchRepublicanCalendar2.fdoy > frenchRepublicanCalendar.fdoy) {
                        ++n;
                    }
                    return n;
                }
                case MONTHS: {
                    int n;
                    long l = FUnitRule.ymValue(frenchRepublicanCalendar2) - FUnitRule.ymValue(frenchRepublicanCalendar);
                    int n2 = frenchRepublicanCalendar.hasSansculottides() ? frenchRepublicanCalendar.fdoy - 330 : frenchRepublicanCalendar.getDayOfMonth();
                    int n3 = n = frenchRepublicanCalendar2.hasSansculottides() ? frenchRepublicanCalendar2.fdoy - 330 : frenchRepublicanCalendar2.getDayOfMonth();
                    if (l > 0L && n < n2) {
                        --l;
                    } else if (l < 0L && n > n2) {
                        ++l;
                    }
                    return l;
                }
                case DECADES: {
                    int n;
                    long l = FUnitRule.decValue(frenchRepublicanCalendar2) - FUnitRule.decValue(frenchRepublicanCalendar);
                    int n4 = frenchRepublicanCalendar.hasSansculottides() ? frenchRepublicanCalendar.fdoy - 350 : frenchRepublicanCalendar.getDayOfDecade().getValue();
                    int n5 = n = frenchRepublicanCalendar2.hasSansculottides() ? frenchRepublicanCalendar2.fdoy - 350 : frenchRepublicanCalendar2.getDayOfDecade().getValue();
                    if (l > 0L && n < n4) {
                        --l;
                    } else if (l < 0L && n > n4) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(frenchRepublicanCalendar, frenchRepublicanCalendar2) / 7L;
                }
                case DAYS: {
                    return CALSYS.transform(frenchRepublicanCalendar2) - CALSYS.transform(frenchRepublicanCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int ymValue(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            int n = frenchRepublicanCalendar.hasSansculottides() ? 12 : frenchRepublicanCalendar.getMonth().getValue();
            return frenchRepublicanCalendar.fyear * 12 + n - 1;
        }

        private static int decValue(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            int n = frenchRepublicanCalendar.hasSansculottides() ? 3 : frenchRepublicanCalendar.getDecade();
            return FUnitRule.ymValue(frenchRepublicanCalendar) * 3 + n - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<FrenchRepublicanCalendar> {
        private Merger() {
        }

        @Override
        public FrenchRepublicanCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (FrenchRepublicanCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        @Deprecated
        public FrenchRepublicanCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public FrenchRepublicanCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            FrenchRepublicanAlgorithm frenchRepublicanAlgorithm = attributeQuery.get(FrenchRepublicanAlgorithm.attribute(), DEFAULT_ALGORITHM);
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing republican year.");
                return null;
            }
            if (n < 1 || n > 1202) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Republican year out of range: " + n);
                return null;
            }
            FrenchRepublicanCalendar frenchRepublicanCalendar = null;
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2;
                int n3 = ((FrenchRepublicanMonth)((Object)chronoEntity.get(MONTH_OF_YEAR))).getValue();
                int n4 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n4 == Integer.MIN_VALUE && chronoEntity.contains(DAY_OF_DECADE) && (n2 = chronoEntity.getInt(DECADE_OF_MONTH)) != Integer.MIN_VALUE) {
                    n4 = (n2 - 1) * 10 + chronoEntity.get(DAY_OF_DECADE).getValue();
                }
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 >= 1 && n4 <= 30) {
                        frenchRepublicanCalendar = FrenchRepublicanCalendar.of(n, n3, n4);
                    } else {
                        chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid republican date.");
                    }
                }
            } else if (chronoEntity.contains(SANSCULOTTIDES)) {
                Sansculottides sansculottides = chronoEntity.get(SANSCULOTTIDES);
                int n5 = sansculottides.getValue() + 360;
                if (n5 == 6 && !frenchRepublicanAlgorithm.isLeapYear(n)) {
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Republican date is no leap year.");
                } else {
                    frenchRepublicanCalendar = new FrenchRepublicanCalendar(n, n5);
                }
            } else {
                int n6 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n6 != Integer.MIN_VALUE) {
                    if (n6 >= 1 && n6 <= (frenchRepublicanAlgorithm.isLeapYear(n) ? 366 : 365)) {
                        frenchRepublicanCalendar = new FrenchRepublicanCalendar(n, n6);
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid republican date.");
                }
            }
            if (frenchRepublicanCalendar != null && frenchRepublicanAlgorithm != DEFAULT_ALGORITHM) {
                frenchRepublicanCalendar = DEFAULT_ALGORITHM.transform(frenchRepublicanAlgorithm.transform(frenchRepublicanCalendar));
            }
            return frenchRepublicanCalendar;
        }

        @Override
        public ChronoDisplay preformat(FrenchRepublicanCalendar frenchRepublicanCalendar, AttributeQuery attributeQuery) {
            FrenchRepublicanAlgorithm frenchRepublicanAlgorithm = attributeQuery.get(FrenchRepublicanAlgorithm.attribute(), DEFAULT_ALGORITHM);
            if (frenchRepublicanAlgorithm == DEFAULT_ALGORITHM) {
                return frenchRepublicanCalendar;
            }
            return frenchRepublicanCalendar.getDate(frenchRepublicanAlgorithm);
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            throw new UnsupportedOperationException("Localized format patterns are not available.");
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        @Override
        public int getDefaultPivotYear() {
            return PlainDate.axis().getDefaultPivotYear() - 1792;
        }
    }

    private static class WeekdayRule
    implements ElementRule<FrenchRepublicanCalendar, Weekday> {
        private WeekdayRule() {
        }

        @Override
        public Weekday getValue(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return frenchRepublicanCalendar.getDayOfWeek();
        }

        @Override
        public Weekday getMinimum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return frenchRepublicanCalendar.fyear == 1 && frenchRepublicanCalendar.fdoy == 1 ? Weekday.SATURDAY : Weekday.SUNDAY;
        }

        @Override
        public Weekday getMaximum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return frenchRepublicanCalendar.fyear == 1202 && frenchRepublicanCalendar.fdoy == 366 ? Weekday.SUNDAY : Weekday.SATURDAY;
        }

        @Override
        public boolean isValid(FrenchRepublicanCalendar frenchRepublicanCalendar, Weekday weekday) {
            if (weekday == null) {
                return false;
            }
            int n = weekday.getValue(FrenchRepublicanCalendar.getDefaultWeekmodel());
            int n2 = this.getMinimum(frenchRepublicanCalendar).getValue(FrenchRepublicanCalendar.getDefaultWeekmodel());
            int n3 = this.getMaximum(frenchRepublicanCalendar).getValue(FrenchRepublicanCalendar.getDefaultWeekmodel());
            return n2 <= n && n <= n3;
        }

        @Override
        public FrenchRepublicanCalendar withValue(FrenchRepublicanCalendar frenchRepublicanCalendar, Weekday weekday, boolean bl) {
            if (weekday == null) {
                throw new IllegalArgumentException("Missing weekday.");
            }
            Weekmodel weekmodel = FrenchRepublicanCalendar.getDefaultWeekmodel();
            int n = frenchRepublicanCalendar.getDayOfWeek().getValue(weekmodel);
            int n2 = weekday.getValue(weekmodel);
            return (FrenchRepublicanCalendar)frenchRepublicanCalendar.plus(CalendarDays.of(n2 - n));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return null;
        }
    }

    private static class SansculottidesAccess
    extends BasicElement<Sansculottides>
    implements TextElement<Sansculottides>,
    ElementRule<FrenchRepublicanCalendar, Sansculottides> {
        private static final long serialVersionUID = -6615947737325572130L;

        SansculottidesAccess() {
            super("SANSCULOTTIDES");
        }

        @Override
        public char getSymbol() {
            return 'S';
        }

        @Override
        public Sansculottides getValue(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return frenchRepublicanCalendar.getSansculottides();
        }

        @Override
        public Sansculottides getMinimum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return Sansculottides.COMPLEMENTARY_DAY_1;
        }

        @Override
        public Sansculottides getMaximum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return frenchRepublicanCalendar.isLeapYear() ? Sansculottides.LEAP_DAY : Sansculottides.COMPLEMENTARY_DAY_5;
        }

        @Override
        public boolean isValid(FrenchRepublicanCalendar frenchRepublicanCalendar, Sansculottides sansculottides) {
            return sansculottides != null && (frenchRepublicanCalendar.isLeapYear() || sansculottides != Sansculottides.LEAP_DAY);
        }

        @Override
        public FrenchRepublicanCalendar withValue(FrenchRepublicanCalendar frenchRepublicanCalendar, Sansculottides sansculottides, boolean bl) {
            if (sansculottides == null) {
                throw new IllegalArgumentException("Missing sansculottides value.");
            }
            return FrenchRepublicanCalendar.of(frenchRepublicanCalendar.fyear, sansculottides);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return null;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Sansculottides sansculottides = chronoDisplay.get(this);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
            appendable.append(this.accessor(locale, outputContext).print(sansculottides));
        }

        @Override
        public Sansculottides parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            OutputContext outputContext;
            int n = parsePosition.getIndex();
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            Sansculottides sansculottides = this.accessor(locale, outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT)).parse(charSequence, parsePosition, this.getType(), attributeQuery);
            if (sansculottides == null && attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE).booleanValue()) {
                parsePosition.setErrorIndex(-1);
                parsePosition.setIndex(n);
                outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
                sansculottides = this.accessor(locale, outputContext).parse(charSequence, parsePosition, this.getType(), attributeQuery);
            }
            return sansculottides;
        }

        @Override
        public Class<Sansculottides> getType() {
            return Sansculottides.class;
        }

        @Override
        public Sansculottides getDefaultMinimum() {
            return Sansculottides.COMPLEMENTARY_DAY_1;
        }

        @Override
        public Sansculottides getDefaultMaximum() {
            return Sansculottides.COMPLEMENTARY_DAY_5;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        private TextAccessor accessor(Locale locale, OutputContext outputContext) {
            String string = outputContext == OutputContext.FORMAT ? "w" : "W";
            return CalendarText.getInstance("extra/frenchrev", locale).getTextForms(this.name(), this.getType(), string);
        }
    }

    private static class DayOfDecadeAccess
    extends BasicElement<DayOfDecade>
    implements TextElement<DayOfDecade>,
    ElementRule<FrenchRepublicanCalendar, DayOfDecade> {
        private static final long serialVersionUID = -8211850819064695450L;

        DayOfDecadeAccess() {
            super("DAY_OF_DECADE");
        }

        @Override
        public char getSymbol() {
            return 'C';
        }

        @Override
        public DayOfDecade getValue(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return frenchRepublicanCalendar.getDayOfDecade();
        }

        @Override
        public DayOfDecade getMinimum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            if (frenchRepublicanCalendar.hasSansculottides()) {
                throw new ChronoException("Cannot get minimum for day of decade on sansculottides: " + frenchRepublicanCalendar);
            }
            return DayOfDecade.PRIMIDI;
        }

        @Override
        public DayOfDecade getMaximum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            if (frenchRepublicanCalendar.hasSansculottides()) {
                throw new ChronoException("Cannot get maximum for day of decade on sansculottides: " + frenchRepublicanCalendar);
            }
            return DayOfDecade.DECADI;
        }

        @Override
        public boolean isValid(FrenchRepublicanCalendar frenchRepublicanCalendar, DayOfDecade dayOfDecade) {
            return dayOfDecade != null && !frenchRepublicanCalendar.hasSansculottides();
        }

        @Override
        public FrenchRepublicanCalendar withValue(FrenchRepublicanCalendar frenchRepublicanCalendar, DayOfDecade dayOfDecade, boolean bl) {
            if (dayOfDecade == null) {
                throw new IllegalArgumentException("Missing day of decade.");
            }
            if (frenchRepublicanCalendar.hasSansculottides()) {
                throw new IllegalArgumentException("Cannot set day of decade on sansculottides.");
            }
            int n = (frenchRepublicanCalendar.fdoy - 1) % 10 + 1;
            int n2 = dayOfDecade.getValue() - n;
            if (n2 == 0) {
                return frenchRepublicanCalendar;
            }
            return new FrenchRepublicanCalendar(frenchRepublicanCalendar.fyear, frenchRepublicanCalendar.fdoy + n2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return null;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            DayOfDecade dayOfDecade = chronoDisplay.get(this);
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            appendable.append(this.accessor(locale, attributeQuery).print(dayOfDecade));
        }

        @Override
        public DayOfDecade parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            return this.accessor(locale, attributeQuery).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        }

        @Override
        public Class<DayOfDecade> getType() {
            return DayOfDecade.class;
        }

        @Override
        public DayOfDecade getDefaultMinimum() {
            return DayOfDecade.PRIMIDI;
        }

        @Override
        public DayOfDecade getDefaultMaximum() {
            return DayOfDecade.DECADI;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        private TextAccessor accessor(Locale locale, AttributeQuery attributeQuery) {
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
            String string = textWidth == TextWidth.NARROW ? "N" : (outputContext == OutputContext.FORMAT ? "w" : "W");
            return CalendarText.getInstance("extra/frenchrev", locale).getTextForms(this.name(), this.getType(), string);
        }
    }

    private static class EraRule
    implements ElementRule<FrenchRepublicanCalendar, FrenchRepublicanEra> {
        private EraRule() {
        }

        @Override
        public FrenchRepublicanEra getValue(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return FrenchRepublicanEra.REPUBLICAN;
        }

        @Override
        public FrenchRepublicanEra getMinimum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return FrenchRepublicanEra.REPUBLICAN;
        }

        @Override
        public FrenchRepublicanEra getMaximum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return FrenchRepublicanEra.REPUBLICAN;
        }

        @Override
        public boolean isValid(FrenchRepublicanCalendar frenchRepublicanCalendar, FrenchRepublicanEra frenchRepublicanEra) {
            return frenchRepublicanEra != null;
        }

        @Override
        public FrenchRepublicanCalendar withValue(FrenchRepublicanCalendar frenchRepublicanCalendar, FrenchRepublicanEra frenchRepublicanEra, boolean bl) {
            if (frenchRepublicanEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return frenchRepublicanCalendar;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<FrenchRepublicanCalendar, FrenchRepublicanMonth> {
        private MonthRule() {
        }

        @Override
        public FrenchRepublicanMonth getValue(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return frenchRepublicanCalendar.getMonth();
        }

        @Override
        public FrenchRepublicanMonth getMinimum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return FrenchRepublicanMonth.VENDEMIAIRE;
        }

        @Override
        public FrenchRepublicanMonth getMaximum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return FrenchRepublicanMonth.FRUCTIDOR;
        }

        @Override
        public boolean isValid(FrenchRepublicanCalendar frenchRepublicanCalendar, FrenchRepublicanMonth frenchRepublicanMonth) {
            return frenchRepublicanMonth != null;
        }

        @Override
        public FrenchRepublicanCalendar withValue(FrenchRepublicanCalendar frenchRepublicanCalendar, FrenchRepublicanMonth frenchRepublicanMonth, boolean bl) {
            if (frenchRepublicanMonth == null) {
                throw new IllegalArgumentException("Missing republican month.");
            }
            if (frenchRepublicanCalendar.hasSansculottides()) {
                return FrenchRepublicanCalendar.of(frenchRepublicanCalendar.fyear, frenchRepublicanMonth, 30);
            }
            return FrenchRepublicanCalendar.of(frenchRepublicanCalendar.fyear, frenchRepublicanMonth, frenchRepublicanCalendar.getDayOfMonth());
        }

        @Override
        public ChronoElement<?> getChildAtFloor(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements IntElementRule<FrenchRepublicanCalendar> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public int getInt(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            switch (this.index) {
                case 0: {
                    return frenchRepublicanCalendar.fyear;
                }
                case 1: {
                    return frenchRepublicanCalendar.getDecade();
                }
                case 2: {
                    return frenchRepublicanCalendar.getDayOfMonth();
                }
                case 3: {
                    return frenchRepublicanCalendar.fdoy;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(FrenchRepublicanCalendar frenchRepublicanCalendar, int n) {
            if ((this.index == 2 || this.index == 1) && frenchRepublicanCalendar.hasSansculottides()) {
                return false;
            }
            int n2 = this.getMin(frenchRepublicanCalendar);
            int n3 = this.getMax(frenchRepublicanCalendar);
            return n2 <= n && n3 >= n;
        }

        @Override
        public FrenchRepublicanCalendar withValue(FrenchRepublicanCalendar frenchRepublicanCalendar, int n, boolean bl) {
            if (this.index == 2 && frenchRepublicanCalendar.hasSansculottides()) {
                throw new IllegalArgumentException("Day of month not defined on sansculottides: " + n);
            }
            if (this.index == 1 && frenchRepublicanCalendar.hasSansculottides()) {
                throw new IllegalArgumentException("Decade of month not defined on sansculottides: " + n);
            }
            if (!this.isValid(frenchRepublicanCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    int n2 = DEFAULT_ALGORITHM.isLeapYear(n) ? 366 : 365;
                    return new FrenchRepublicanCalendar(n, Math.min(frenchRepublicanCalendar.fdoy, n2));
                }
                case 1: {
                    int n3 = (n - 1) * 10 + (frenchRepublicanCalendar.getDayOfMonth() - 1) % 10 + 1;
                    return FrenchRepublicanCalendar.of(frenchRepublicanCalendar.fyear, frenchRepublicanCalendar.getMonth(), n3);
                }
                case 2: {
                    return FrenchRepublicanCalendar.of(frenchRepublicanCalendar.fyear, frenchRepublicanCalendar.getMonth(), n);
                }
                case 3: {
                    return new FrenchRepublicanCalendar(frenchRepublicanCalendar.fyear, n);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getValue(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return this.getInt(frenchRepublicanCalendar);
        }

        @Override
        public Integer getMinimum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return this.getMin(frenchRepublicanCalendar);
        }

        @Override
        public Integer getMaximum(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return this.getMax(frenchRepublicanCalendar);
        }

        @Override
        public boolean isValid(FrenchRepublicanCalendar frenchRepublicanCalendar, Integer n) {
            return n != null && this.isValid(frenchRepublicanCalendar, (int)n);
        }

        @Override
        public FrenchRepublicanCalendar withValue(FrenchRepublicanCalendar frenchRepublicanCalendar, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            return this.withValue(frenchRepublicanCalendar, (int)n, bl);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            if (this.index == 1) {
                return DAY_OF_DECADE;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            if (this.index == 0) {
                return SANSCULOTTIDES;
            }
            if (this.index == 1) {
                return DAY_OF_DECADE;
            }
            return null;
        }

        private int getMin(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            switch (this.index) {
                case 0: 
                case 3: {
                    return 1;
                }
                case 1: 
                case 2: {
                    if (frenchRepublicanCalendar.hasSansculottides()) {
                        throw new ChronoException("Complementary days (sansculottides) are not part of any month or decade: " + frenchRepublicanCalendar);
                    }
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        private int getMax(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            switch (this.index) {
                case 0: {
                    return 1202;
                }
                case 1: 
                case 2: {
                    if (frenchRepublicanCalendar.hasSansculottides()) {
                        throw new ChronoException("Complementary days (sansculottides) are not part of any month: " + frenchRepublicanCalendar);
                    }
                    return this.index == 2 ? 30 : 3;
                }
                case 3: {
                    return DEFAULT_ALGORITHM.isLeapYear(frenchRepublicanCalendar.fyear) ? 366 : 365;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }
    }

    private static class YearOfEraElement
    extends DualYearOfEraElement<FrenchRepublicanCalendar> {
        private static final long serialVersionUID = 7337125729623271040L;

        private YearOfEraElement() {
            super(FrenchRepublicanCalendar.class, 1, 1202, 'Y');
        }

        @Override
        protected NumberSystem getNumberSystem(AttributeQuery attributeQuery) {
            String string = attributeQuery.get(Attributes.FORMAT_PATTERN, "");
            if (string.contains("Y") && attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT).getLanguage().equals("fr")) {
                return NumberSystem.ROMAN;
            }
            return attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ROMAN);
        }
    }

    private static class Transformer
    implements CalendarSystem<FrenchRepublicanCalendar> {
        private Transformer() {
        }

        @Override
        public FrenchRepublicanCalendar transform(long l) {
            return DEFAULT_ALGORITHM.transform(l);
        }

        @Override
        public long transform(FrenchRepublicanCalendar frenchRepublicanCalendar) {
            return DEFAULT_ALGORITHM.transform(frenchRepublicanCalendar);
        }

        @Override
        public long getMinimumSinceUTC() {
            FrenchRepublicanCalendar frenchRepublicanCalendar = new FrenchRepublicanCalendar(1, 1);
            return this.transform(frenchRepublicanCalendar);
        }

        @Override
        public long getMaximumSinceUTC() {
            FrenchRepublicanCalendar frenchRepublicanCalendar = new FrenchRepublicanCalendar(1202, 366);
            return this.transform(frenchRepublicanCalendar);
        }

        @Override
        public List<CalendarEra> getEras() {
            FrenchRepublicanEra frenchRepublicanEra = FrenchRepublicanEra.REPUBLICAN;
            return Collections.singletonList(frenchRepublicanEra);
        }
    }

    public static final class Date
    implements ChronoDisplay {
        private final FrenchRepublicanCalendar delegate;
        private final FrenchRepublicanAlgorithm algorithm;

        private Date(FrenchRepublicanCalendar frenchRepublicanCalendar, FrenchRepublicanAlgorithm frenchRepublicanAlgorithm) {
            this.delegate = frenchRepublicanCalendar;
            this.algorithm = frenchRepublicanAlgorithm;
        }

        @Override
        public boolean contains(ChronoElement<?> chronoElement) {
            return ENGINE.isRegistered(chronoElement);
        }

        @Override
        public <V> V get(ChronoElement<V> chronoElement) {
            if (chronoElement == DAY_OF_WEEK) {
                long l = this.algorithm.transform(this.delegate);
                return chronoElement.getType().cast(Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1));
            }
            if (chronoElement instanceof EpochDays) {
                EpochDays epochDays = (EpochDays)EpochDays.class.cast(chronoElement);
                long l = this.algorithm.transform(this.delegate);
                return chronoElement.getType().cast(epochDays.transform(l, EpochDays.UTC));
            }
            if (ENGINE.isRegistered(chronoElement)) {
                return this.delegate.get(chronoElement);
            }
            throw new ChronoException("French republican dates only support registered elements.");
        }

        @Override
        public int getInt(ChronoElement<Integer> chronoElement) {
            if (ENGINE.isRegistered(chronoElement)) {
                return this.delegate.getInt(chronoElement);
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public <V> V getMinimum(ChronoElement<V> chronoElement) {
            if (ENGINE.isRegistered(chronoElement)) {
                return this.delegate.getMinimum(chronoElement);
            }
            throw new ChronoException("French republican dates only support registered elements.");
        }

        @Override
        public <V> V getMaximum(ChronoElement<V> chronoElement) {
            if (ENGINE.isRegistered(chronoElement)) {
                return this.delegate.getMaximum(chronoElement);
            }
            throw new ChronoException("French republican dates only support registered elements.");
        }

        @Override
        public boolean hasTimezone() {
            return false;
        }

        @Override
        public TZID getTimezone() {
            throw new ChronoException("Timezone not available.");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                if (this.algorithm != date.algorithm) {
                    return false;
                }
                return this.delegate.equals(date.delegate);
            }
            return false;
        }

        public int hashCode() {
            return 7 * this.delegate.hashCode() + 31 * this.algorithm.hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.delegate);
            stringBuilder.append('[');
            stringBuilder.append((Object)this.algorithm);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.1556941113599997E7),
        MONTHS(2592000.0),
        DECADES(864000.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public long between(FrenchRepublicanCalendar frenchRepublicanCalendar, FrenchRepublicanCalendar frenchRepublicanCalendar2) {
            return frenchRepublicanCalendar.until(frenchRepublicanCalendar2, this);
        }
    }
}

