/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.EpochDays;
import net.time4j.scale.TimeScale;
import net.time4j.tz.ZonalOffset;

public final class JulianDay
implements Serializable {
    private static final int MRD = 1000000000;
    private static final int DAY_IN_SECONDS = 86400;
    private static final long OFFSET_1970 = 210866760000L;
    private static final long OFFSET_1972 = 210929832000L;
    public static final double MIN = 990575.0;
    public static final double MAX = 2817152.0;
    private static final long serialVersionUID = 486345450973062467L;
    private final double value;
    private final TimeScale scale;

    private JulianDay(double d, TimeScale timeScale) {
        JulianDay.check(d, timeScale);
        this.value = d;
        this.scale = timeScale;
    }

    public static JulianDay ofEphemerisTime(double d) {
        return new JulianDay(d, TimeScale.TT);
    }

    public static JulianDay ofEphemerisTime(Moment moment) {
        return new JulianDay(JulianDay.getValue(moment, TimeScale.TT), TimeScale.TT);
    }

    public static JulianDay ofEphemerisTime(CalendarDate calendarDate, PlainTime plainTime, ZonalOffset zonalOffset) {
        long l = EpochDays.JULIAN_DAY_NUMBER.transform(calendarDate.getDaysSinceEpochUTC(), EpochDays.UTC);
        double d = (double)((Long)plainTime.get(PlainTime.NANO_OF_DAY)).longValue() / 8.64E13;
        double d2 = (double)l - 0.5 + d - (double)zonalOffset.getIntegralAmount() / 86400.0;
        return new JulianDay(d2, TimeScale.TT);
    }

    public static JulianDay ofMeanSolarTime(double d) {
        return new JulianDay(d, TimeScale.UT);
    }

    public static JulianDay ofMeanSolarTime(Moment moment) {
        return new JulianDay(JulianDay.getValue(moment, TimeScale.UT), TimeScale.UT);
    }

    public static JulianDay ofSimplifiedTime(double d) {
        return new JulianDay(d, TimeScale.POSIX);
    }

    public static JulianDay ofSimplifiedTime(Moment moment) {
        return new JulianDay(JulianDay.getValue(moment, TimeScale.POSIX), TimeScale.POSIX);
    }

    public double getValue() {
        return this.value;
    }

    public double getMJD() {
        return this.value - 2400000.5;
    }

    public double getCenturyJ2000() {
        return (this.value - 2451545.0) / 36525.0;
    }

    public TimeScale getScale() {
        return this.scale;
    }

    public JulianDay plusDays(double d) {
        return new JulianDay(this.value + d, this.scale);
    }

    public JulianDay minusDays(double d) {
        return new JulianDay(this.value - d, this.scale);
    }

    public JulianDay plusSeconds(double d) {
        return new JulianDay(this.value + d / 86400.0, this.scale);
    }

    public JulianDay minusSeconds(double d) {
        return new JulianDay(this.value - d / 86400.0, this.scale);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JulianDay) {
            JulianDay julianDay = (JulianDay)object;
            return this.value == julianDay.value && this.scale == julianDay.scale;
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        int n = (int)(l ^ l >>> 32);
        return n ^ this.scale.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JD(");
        stringBuilder.append(this.scale.name());
        stringBuilder.append(')');
        stringBuilder.append(this.value);
        return stringBuilder.toString();
    }

    public Moment toMoment() {
        double d = this.value * 86400.0;
        long l = (long)d;
        int n = (int)((d - Math.floor(d)) * 1.0E9);
        return Moment.of(MathUtils.safeSubtract(l, JulianDay.jdOffset(this.scale)), n, this.scale);
    }

    static double getValue(Moment moment, TimeScale timeScale) {
        long l = moment.getElapsedTime(timeScale) + JulianDay.jdOffset(timeScale);
        int n = moment.getNanosecond(timeScale);
        double d = (double)l + (double)n / 1.0E9;
        return d / 86400.0;
    }

    private static long jdOffset(TimeScale timeScale) {
        switch (timeScale) {
            case UT: 
            case TT: {
                return 210929832000L;
            }
            case POSIX: {
                return 210866760000L;
            }
        }
        throw new UnsupportedOperationException(timeScale.name());
    }

    private static void check(double d, TimeScale timeScale) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Value is not finite: " + d);
        }
        switch (timeScale) {
            case UT: 
            case TT: 
            case POSIX: {
                if (Double.compare(990575.0, d) <= 0 && Double.compare(d, 2817152.0) <= 0) break;
                throw new IllegalArgumentException("Out of range: " + d);
            }
            default: {
                throw new IllegalArgumentException("Unsupported time scale: " + (Object)((Object)timeScale));
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            JulianDay.check(this.value, this.scale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new StreamCorruptedException();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException();
        }
    }
}

