/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum HebrewMonth implements ChronoCondition<HebrewCalendar>
{
    TISHRI,
    HESHVAN,
    KISLEV,
    TEVET,
    SHEVAT,
    ADAR_I,
    ADAR_II,
    NISAN,
    IYAR,
    SIVAN,
    TAMUZ,
    AV,
    ELUL;

    private static final HebrewMonth[] ENUMS;
    private static final AttributeKey<Order> ATTRIBUTE;

    public static HebrewMonth valueOfCivil(int n, boolean bl) {
        if (n < 1 || n > 13 || !bl && n == 13) {
            throw new IllegalArgumentException("Hebrew month out of range: " + n);
        }
        if (!bl && n >= 6) {
            return ENUMS[n];
        }
        return ENUMS[n - 1];
    }

    public static HebrewMonth valueOfBiblical(int n, boolean bl) {
        if (n < 1 || n > 13 || !bl && n == 13) {
            throw new IllegalArgumentException("Hebrew month out of range: " + n);
        }
        int n2 = n + 7;
        if (n2 > 13) {
            n2 -= 13;
        }
        if (!bl && n == 12) {
            return ADAR_II;
        }
        return ENUMS[n2 - 1];
    }

    public int getCivilValue(boolean bl) {
        int n = this.ordinal() + 1;
        if (!bl && n >= 7) {
            --n;
        }
        return n;
    }

    public int getBiblicalValue(boolean bl) {
        int n = this.ordinal() + 7;
        if (n > 13) {
            n -= 13;
        }
        if (!bl && n == 13) {
            n = 12;
        }
        return n;
    }

    public String getDisplayName(Locale locale, boolean bl) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT, bl);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
        CalendarText calendarText = CalendarText.getInstance("hebrew", locale);
        if (bl && this == ADAR_II) {
            return calendarText.getLeapMonths(textWidth, outputContext).print(this);
        }
        return calendarText.getStdMonths(textWidth, outputContext).print(this);
    }

    @Override
    public boolean test(HebrewCalendar hebrewCalendar) {
        return hebrewCalendar.getMonth() == this;
    }

    public static AttributeKey<Order> order() {
        return ATTRIBUTE;
    }

    static HebrewMonth valueOf(int n) {
        if (n < 1 || n > 13) {
            throw new IllegalArgumentException("Hebrew month out of range: " + n);
        }
        return ENUMS[n - 1];
    }

    int getValue() {
        return this.ordinal() + 1;
    }

    static {
        ENUMS = HebrewMonth.values();
        ATTRIBUTE = Attributes.createKey("HEBREW_MONTH_ORDER", Order.class);
    }

    public static enum Order {
        CIVIL,
        BIBLICAL,
        ENUM,
        BIBILICAL;

    }
}

