/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.time4j.Moment;
import net.time4j.OldApiTimezone;
import net.time4j.ZonalDateTime;
import net.time4j.base.MathUtils;
import net.time4j.engine.Converter;
import net.time4j.scale.TimeScale;
import net.time4j.tz.Timezone;

public abstract class TemporalType<S, T>
implements Converter<S, T> {
    private static final int MIO = 1000000;
    public static final TemporalType<Date, Moment> JAVA_UTIL_DATE = new JavaUtilDateRule();
    public static final TemporalType<Long, Moment> MILLIS_SINCE_UNIX = new MillisSinceUnixRule();
    public static final TemporalType<Calendar, ZonalDateTime> JAVA_UTIL_CALENDAR = new CalendarRule();
    public static final TemporalType<TimeZone, Timezone> JAVA_UTIL_TIMEZONE = new ZoneRule();
    private static final String JUT_PROVIDER = "java.util.TimeZone~";

    protected TemporalType() {
    }

    @Override
    public abstract T translate(S var1);

    @Override
    public abstract S from(T var1);

    private static class ZoneRule
    extends TemporalType<TimeZone, Timezone> {
        private ZoneRule() {
        }

        @Override
        public Timezone translate(TimeZone timeZone) {
            if (timeZone instanceof OldApiTimezone) {
                return ((OldApiTimezone)timeZone).getDelegate();
            }
            return Timezone.of(TemporalType.JUT_PROVIDER + timeZone.getID());
        }

        @Override
        public TimeZone from(Timezone timezone) {
            if (timezone.getHistory() == null) {
                String string = timezone.getID().canonical();
                if (string.startsWith(TemporalType.JUT_PROVIDER)) {
                    string = string.substring(TemporalType.JUT_PROVIDER.length());
                }
                return TimeZone.getTimeZone(string);
            }
            return new OldApiTimezone(timezone);
        }

        @Override
        public Class<TimeZone> getSourceType() {
            return TimeZone.class;
        }
    }

    private static class CalendarRule
    extends TemporalType<Calendar, ZonalDateTime> {
        private CalendarRule() {
        }

        @Override
        public ZonalDateTime translate(Calendar calendar) {
            Moment moment = JAVA_UTIL_DATE.translate(calendar.getTime());
            Timezone timezone = JAVA_UTIL_TIMEZONE.translate(calendar.getTimeZone());
            return ZonalDateTime.of(moment, timezone);
        }

        @Override
        public Calendar from(ZonalDateTime zonalDateTime) {
            Date date = JAVA_UTIL_DATE.from(zonalDateTime.toMoment());
            TimeZone timeZone = JAVA_UTIL_TIMEZONE.from(zonalDateTime.getTimezone0());
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
            gregorianCalendar.setFirstDayOfWeek(2);
            gregorianCalendar.setMinimalDaysInFirstWeek(4);
            gregorianCalendar.setTimeZone(timeZone);
            gregorianCalendar.setTime(date);
            return gregorianCalendar;
        }

        @Override
        public Class<Calendar> getSourceType() {
            return Calendar.class;
        }
    }

    private static class MillisSinceUnixRule
    extends TemporalType<Long, Moment> {
        private MillisSinceUnixRule() {
        }

        @Override
        public Moment translate(Long l) {
            long l2 = l;
            long l3 = MathUtils.floorDivide(l2, 1000);
            int n = MathUtils.floorModulo(l2, 1000) * 1000000;
            return Moment.of(l3, n, TimeScale.POSIX);
        }

        @Override
        public Long from(Moment moment) {
            long l = moment.getPosixTime();
            int n = moment.getNanosecond();
            return MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), (long)(n / 1000000));
        }

        @Override
        public Class<Long> getSourceType() {
            return Long.class;
        }
    }

    private static class JavaUtilDateRule
    extends TemporalType<Date, Moment> {
        private JavaUtilDateRule() {
        }

        @Override
        public Moment translate(Date date) {
            long l = date.getTime();
            long l2 = MathUtils.floorDivide(l, 1000);
            int n = MathUtils.floorModulo(l, 1000) * 1000000;
            return Moment.of(l2, n, TimeScale.POSIX);
        }

        @Override
        public Date from(Moment moment) {
            long l = moment.getPosixTime();
            int n = moment.getNanosecond();
            long l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), (long)(n / 1000000));
            return new Date(l2);
        }

        @Override
        public Class<Date> getSourceType() {
            return Date.class;
        }
    }
}

