/*
 * -----------------------------------------------------------------------
 * Copyright © 2013-2016 Meno Hochschild, <http://www.menodata.de/>
 * -----------------------------------------------------------------------
 * This file (LocalizedPatternSupport.java) is part of project Time4J.
 *
 * Time4J is free software: You can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * Time4J is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Time4J. If not, see <http://www.gnu.org/licenses/>.
 * -----------------------------------------------------------------------
 */

package net.time4j.format;


/**
 * <p>Marker interface which indicates support for general localized format patterns compatible with
 * the CLDR-specification. </p>
 *
 * @author  Meno Hochschild
 * @see     net.time4j.engine.ChronoMerger#getFormatPattern
 * @since   3.10/4.7
 */
/*[deutsch]
 * <p>Marker-Interface, das die Unterst&uuml;tzung von lokalisierten CLDR-kompatiblen Formatmustern
 * signalisiert. </p>
 *
 * @author  Meno Hochschild
 * @see     net.time4j.engine.ChronoMerger#getFormatPattern
 * @since   3.10/4.7
 */
public interface LocalizedPatternSupport {

}
