/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.List;
import java.util.Locale;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.base.GregorianDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.history.ChronoHistory;
import net.time4j.history.CutOverEvent;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearRule;
import net.time4j.history.NewYearStrategy;
import net.time4j.history.YearDefinition;
import net.time4j.history.internal.StdHistoricalElement;

final class HistoricIntegerElement
extends StdHistoricalElement
implements DualFormatElement {
    static final int YEAR_OF_ERA_INDEX = 2;
    static final int MONTH_INDEX = 3;
    static final int DAY_OF_MONTH_INDEX = 4;
    static final int DAY_OF_YEAR_INDEX = 5;
    static final int YEAR_AFTER_INDEX = 6;
    static final int YEAR_BEFORE_INDEX = 7;
    static final int CENTURY_INDEX = 8;
    private static final long serialVersionUID = -6283098762945747308L;
    private final ChronoHistory history;
    private final transient int index;

    HistoricIntegerElement(char c, int n, int n2, ChronoHistory chronoHistory, int n3) {
        super(HistoricIntegerElement.toName(n3), c, n, n2);
        this.history = chronoHistory;
        this.index = n3;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        char c = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        this.print(chronoDisplay, appendable, attributeQuery, numberSystem, c, 1, 9);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, NumberSystem numberSystem, char c, int n, int n2) throws IOException {
        if (this.index == 5) {
            appendable.append(String.valueOf(chronoDisplay.get(this.history.dayOfYear())));
            return;
        }
        HistoricDate historicDate = chronoDisplay instanceof GregorianDate ? this.history.convert(PlainDate.from((GregorianDate)((Object)chronoDisplay))) : chronoDisplay.get(this.history.date());
        switch (this.index) {
            case 2: {
                int n3;
                NewYearStrategy newYearStrategy = this.history.getNewYearStrategy();
                int n4 = historicDate.getYearOfEra();
                String string = null;
                if (!NewYearStrategy.DEFAULT.equals(newYearStrategy) && (n3 = historicDate.getYearOfEra(newYearStrategy)) != n4) {
                    if (attributeQuery.get(ChronoHistory.YEAR_DEFINITION, YearDefinition.DUAL_DATING) == YearDefinition.DUAL_DATING) {
                        string = this.dual(numberSystem, c, n3, n4, n);
                    } else {
                        n4 = n3;
                    }
                }
                if (string == null) {
                    string = numberSystem.isDecimal() ? HistoricIntegerElement.pad(numberSystem.toNumeral(n4), n, c) : numberSystem.toNumeral(n4);
                }
                if (numberSystem.isDecimal()) {
                    n3 = numberSystem.getDigits().charAt(0);
                    if (c != n3) {
                        StringBuilder stringBuilder = new StringBuilder();
                        int n5 = string.length();
                        for (int i = 0; i < n5; ++i) {
                            char c2 = string.charAt(i);
                            if (numberSystem.contains(c2)) {
                                int n6 = c - n3;
                                stringBuilder.append((char)(c2 + n6));
                                continue;
                            }
                            stringBuilder.append(c2);
                        }
                        string = stringBuilder.toString();
                    }
                    this.checkLength(string, n2);
                }
                appendable.append(string);
                break;
            }
            case 3: {
                OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
                appendable.append(this.monthAccessor(attributeQuery, outputContext).print(Month.valueOf(historicDate.getMonth())));
                break;
            }
            case 4: {
                appendable.append(String.valueOf(historicDate.getDayOfMonth()));
                break;
            }
            default: {
                throw new ChronoException("Not printable as text: " + this.name());
            }
        }
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        return this.parse(charSequence, parsePosition, attributeQuery, null);
    }

    @Override
    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery, ChronoEntity<?> chronoEntity) {
        int n;
        if (this.index == 3) {
            int n2 = parsePosition.getIndex();
            OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
            Month month = this.monthAccessor(attributeQuery, outputContext).parse(charSequence, parsePosition, Month.class, attributeQuery);
            if (month == null && attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE).booleanValue()) {
                parsePosition.setErrorIndex(-1);
                parsePosition.setIndex(n2);
                outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
                month = this.monthAccessor(attributeQuery, outputContext).parse(charSequence, parsePosition, Month.class, attributeQuery);
            }
            if (month == null) {
                return null;
            }
            return month.getValue();
        }
        if (this.index == 6 || this.index == 7 || this.index == 8) {
            throw new ChronoException("Not parseable as text element: " + this.name());
        }
        NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        char c = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)attributeQuery.get(Attributes.ZERO_DIGIT).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        Leniency leniency = numberSystem.isDecimal() ? Leniency.SMART : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        int n3 = n = parsePosition.getIndex();
        int n4 = HistoricIntegerElement.parseNum(numberSystem, c, charSequence, n3, parsePosition, leniency);
        n3 = parsePosition.getIndex();
        if (this.index == 2 && n3 > n && !NewYearStrategy.DEFAULT.equals(this.history.getNewYearStrategy()) && n3 < charSequence.length() && charSequence.charAt(n3) == '/' && attributeQuery.get(ChronoHistory.YEAR_DEFINITION, YearDefinition.DUAL_DATING) == YearDefinition.DUAL_DATING) {
            int n5 = n3;
            int n6 = HistoricIntegerElement.parseNum(numberSystem, c, charSequence, n3 + 1, parsePosition, leniency);
            int n7 = parsePosition.getIndex();
            if (n7 == n3 + 1) {
                parsePosition.setIndex(n3);
            } else {
                n3 = n7;
                int n8 = n4;
                int n9 = this.history.getNewYearStrategy().rule(HistoricEra.AD, n8) == NewYearRule.CALCULUS_PISANUS ? 2 : 1;
                int n10 = this.getAncientYear(n8, n6, n9);
                if (numberSystem.isDecimal() && n10 != Integer.MAX_VALUE) {
                    n4 = n10;
                    if (chronoEntity != null) {
                        chronoEntity.with(StdHistoricalElement.YEAR_OF_DISPLAY, n8);
                    }
                } else if (Math.abs(n6 - n8) <= n9) {
                    n4 = n6;
                    if (chronoEntity != null) {
                        chronoEntity.with(StdHistoricalElement.YEAR_OF_DISPLAY, n8);
                    }
                } else {
                    n4 = n8;
                    n3 = n5;
                    parsePosition.setIndex(n3);
                }
            }
        }
        if (n3 == n) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        return n4;
    }

    @Override
    protected <T extends ChronoEntity<T>> ElementRule<T, Integer> derive(Chronology<T> chronology) {
        if (chronology.isRegistered(PlainDate.COMPONENT)) {
            return new Rule(this.index, this.history);
        }
        return null;
    }

    @Override
    protected boolean isSingleton() {
        return false;
    }

    @Override
    protected boolean doEquals(BasicElement<?> basicElement) {
        return this.history.equals(((HistoricIntegerElement)basicElement).history);
    }

    private int getAncientYear(int n, int n2, int n3) {
        if (n2 >= 0 && n2 < 100 && n >= 100) {
            int n4;
            int n5 = n4 = n2 < 10 ? 10 : 100;
            if (Math.abs(n2 - MathUtils.floorModulo(n, n4)) <= n3) {
                return MathUtils.floorDivide(n, n4) * n4 + n2;
            }
        }
        return Integer.MAX_VALUE;
    }

    private String dual(NumberSystem numberSystem, char c, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(numberSystem.toNumeral(n));
        stringBuilder.append('/');
        if (numberSystem.isDecimal() && n2 >= 100 && MathUtils.floorDivide(n, 100) == MathUtils.floorDivide(n2, 100)) {
            int n4 = MathUtils.floorModulo(n2, 100);
            if (n4 < 10) {
                stringBuilder.append(c);
            }
            stringBuilder.append(numberSystem.toNumeral(n4));
        } else {
            stringBuilder.append(numberSystem.toNumeral(n2));
        }
        if (numberSystem.isDecimal()) {
            return HistoricIntegerElement.pad(stringBuilder.toString(), n3, c);
        }
        return stringBuilder.toString();
    }

    private static String pad(String string, int n, char c) {
        int n2 = string.length();
        if (n <= n2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n - n2;
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private void checkLength(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            throw new IllegalArgumentException("Element " + this.name() + " cannot be printed as the formatted value " + string + " exceeds the maximum width of " + n + ".");
        }
    }

    private TextAccessor monthAccessor(AttributeQuery attributeQuery, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getIsoInstance(attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        return calendarText.getStdMonths(textWidth, outputContext);
    }

    private static int parseNum(NumberSystem numberSystem, char c, CharSequence charSequence, int n, ParsePosition parsePosition, Leniency leniency) {
        int n2 = 0;
        int n3 = n;
        if (numberSystem.isDecimal()) {
            boolean bl = false;
            if (numberSystem == NumberSystem.ARABIC && charSequence.charAt(n3) == '-') {
                bl = true;
                ++n3;
            }
            char c2 = leniency.isStrict() ? (char)'\u0000' : numberSystem.getDigits().charAt(0);
            int n4 = Math.min(n3 + 9, charSequence.length());
            for (int i = n3; i < n4; ++i) {
                int n5 = charSequence.charAt(i) - c;
                if (n5 >= 0 && n5 <= 9) {
                    n2 = n2 * 10 + n5;
                    ++n3;
                    continue;
                }
                if (c2 == '\u0000' || c == c2 || (n5 = charSequence.charAt(i) - c2) < 0 || n5 > 9) break;
                c = c2;
                n2 = n2 * 10 + n5;
                ++n3;
            }
            if (bl) {
                if (n3 == n + 1) {
                    n3 = n;
                } else {
                    n2 = MathUtils.safeNegate(n2);
                }
            }
        } else {
            int n6 = 0;
            int n7 = charSequence.length();
            for (int i = n3; i < n7 && numberSystem.contains(charSequence.charAt(i)); ++i) {
                ++n6;
            }
            if (n6 > 0) {
                n2 = numberSystem.toInteger(charSequence.subSequence(n3, n3 + n6).toString(), leniency);
                n3 += n6;
            }
        }
        parsePosition.setIndex(n3);
        return n2;
    }

    private static String toName(int n) {
        switch (n) {
            case 2: {
                return "YEAR_OF_ERA";
            }
            case 3: {
                return "HISTORIC_MONTH";
            }
            case 4: {
                return "HISTORIC_DAY_OF_MONTH";
            }
            case 5: {
                return "HISTORIC_DAY_OF_YEAR";
            }
            case 6: {
                return "YEAR_AFTER";
            }
            case 7: {
                return "YEAR_BEFORE";
            }
            case 8: {
                return "CENTURY_OF_ERA";
            }
        }
        throw new UnsupportedOperationException("Unknown element index: " + n);
    }

    private Object readResolve() throws ObjectStreamException {
        String string = this.name();
        if (string.equals("YEAR_OF_ERA")) {
            return this.history.yearOfEra();
        }
        if (string.equals("HISTORIC_MONTH")) {
            return this.history.month();
        }
        if (string.equals("HISTORIC_DAY_OF_MONTH")) {
            return this.history.dayOfMonth();
        }
        if (string.equals("HISTORIC_DAY_OF_YEAR")) {
            return this.history.dayOfYear();
        }
        if (string.equals("YEAR_AFTER")) {
            return this.history.yearOfEra(YearDefinition.AFTER_NEW_YEAR);
        }
        if (string.equals("YEAR_BEFORE")) {
            return this.history.yearOfEra(YearDefinition.BEFORE_NEW_YEAR);
        }
        if (string.equals("CENTURY_OF_ERA")) {
            return this.history.centuryOfEra();
        }
        throw new InvalidObjectException("Unknown element: " + string);
    }

    private static class Rule<C extends ChronoEntity<C>>
    implements ElementRule<C, Integer> {
        private final int index;
        private final ChronoHistory history;

        Rule(int n, ChronoHistory chronoHistory) {
            this.index = n;
            this.history = chronoHistory;
        }

        @Override
        public Integer getValue(C c) {
            try {
                int n;
                PlainDate plainDate = ((ChronoEntity)c).get(PlainDate.COMPONENT);
                HistoricDate historicDate = this.history.convert(plainDate);
                switch (this.index) {
                    case 2: {
                        n = historicDate.getYearOfEra();
                        break;
                    }
                    case 3: {
                        n = historicDate.getMonth();
                        break;
                    }
                    case 4: {
                        n = historicDate.getDayOfMonth();
                        break;
                    }
                    case 5: {
                        long l = plainDate.getDaysSinceEpochUTC();
                        int n2 = historicDate.getYearOfEra(this.history.getNewYearStrategy());
                        HistoricDate historicDate2 = this.history.getBeginOfYear(historicDate.getEra(), n2);
                        n = (int)(l - this.history.convert(historicDate2).getDaysSinceEpochUTC() + 1L);
                        break;
                    }
                    case 6: 
                    case 7: {
                        n = historicDate.getYearOfEra(this.history.getNewYearStrategy());
                        break;
                    }
                    case 8: {
                        n = (historicDate.getYearOfEra() - 1) / 100 + 1;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown element index: " + this.index);
                    }
                }
                return n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        @Override
        public Integer getMinimum(C c) {
            try {
                int n;
                HistoricDate historicDate = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
                if (this.index == 2 || this.index == 6 || this.index == 7 || this.index == 8) {
                    if (historicDate.getEra() == HistoricEra.BYZANTINE && historicDate.getMonth() >= 9) {
                        return 0;
                    }
                    return 1;
                }
                HistoricDate historicDate2 = this.adjust(c, 1);
                if (this.history.isValid(historicDate2)) {
                    return 1;
                }
                if (this.index == 5) {
                    throw new ChronoException("Historic New Year cannot be determined.");
                }
                List<CutOverEvent> list = this.history.getEvents();
                for (n = list.size() - 1; n >= 0; --n) {
                    CutOverEvent cutOverEvent = list.get(n);
                    if (historicDate.compareTo(cutOverEvent.dateAtCutOver) < 0) continue;
                    historicDate2 = cutOverEvent.dateAtCutOver;
                    break;
                }
                n = this.index == 3 ? historicDate2.getMonth() : historicDate2.getDayOfMonth();
                return n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        @Override
        public Integer getMaximum(C c) {
            try {
                HistoricDate historicDate;
                int n;
                HistoricDate historicDate2 = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
                switch (this.index) {
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: {
                        int n2 = historicDate2.getEra() == HistoricEra.BC ? this.history.convert(PlainDate.axis().getMinimum()).getYearOfEra() : this.history.convert(PlainDate.axis().getMaximum()).getYearOfEra();
                        if (this.index == 8) {
                            n2 = (n2 - 1) / 100 + 1;
                        }
                        return n2;
                    }
                    case 3: {
                        n = 12;
                        historicDate = this.adjust(c, n);
                        break;
                    }
                    case 4: {
                        n = this.history.getAlgorithm(historicDate2).getMaximumDayOfMonth(historicDate2);
                        historicDate = this.adjust(c, n);
                        break;
                    }
                    case 5: {
                        int n3 = historicDate2.getYearOfEra(this.history.getNewYearStrategy());
                        int n4 = this.history.getLengthOfYear(historicDate2.getEra(), n3);
                        if (n4 == -1) {
                            throw new ChronoException("Length of historic year undefined.");
                        }
                        return n4;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown element index: " + this.index);
                    }
                }
                if (this.history.isValid(historicDate)) {
                    return n;
                }
                List<CutOverEvent> list = this.history.getEvents();
                for (int i = list.size() - 1; i >= 0; --i) {
                    CutOverEvent cutOverEvent;
                    CutOverEvent cutOverEvent2 = cutOverEvent = list.get(i);
                    if (historicDate2.compareTo(cutOverEvent.dateAtCutOver) >= 0) continue;
                    historicDate = cutOverEvent2.dateBeforeCutOver;
                    break;
                }
                n = this.index == 3 ? historicDate.getMonth() : historicDate.getDayOfMonth();
                return n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }

        @Override
        public boolean isValid(C c, Integer n) {
            if (n == null) {
                return false;
            }
            try {
                HistoricDate historicDate = this.adjust(c, n);
                return this.history.isValid(historicDate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        @Override
        public C withValue(C c, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing historic element value.");
            }
            HistoricDate historicDate = this.adjust(c, n);
            return (C)((ChronoEntity)c).with((ChronoElement<PlainDate>)PlainDate.COMPONENT, (PlainDate)this.history.convert(historicDate));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        private HistoricDate adjust(C c, int n) {
            HistoricDate historicDate;
            HistoricDate historicDate2 = this.history.convert(((ChronoEntity)c).get(PlainDate.COMPONENT));
            YearDefinition yearDefinition = YearDefinition.DUAL_DATING;
            NewYearStrategy newYearStrategy = this.history.getNewYearStrategy();
            switch (this.index) {
                case 6: 
                case 7: {
                    yearDefinition = this.index == 6 ? YearDefinition.AFTER_NEW_YEAR : YearDefinition.BEFORE_NEW_YEAR;
                }
                case 2: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), n, historicDate2.getMonth(), historicDate2.getDayOfMonth(), yearDefinition, newYearStrategy);
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                case 3: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), historicDate2.getYearOfEra(), n, historicDate2.getDayOfMonth());
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                case 4: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), historicDate2.getYearOfEra(), historicDate2.getMonth(), n);
                    break;
                }
                case 5: {
                    int n2 = historicDate2.getYearOfEra(this.history.getNewYearStrategy());
                    HistoricDate historicDate3 = this.history.getBeginOfYear(historicDate2.getEra(), n2);
                    int n3 = this.history.getLengthOfYear(historicDate2.getEra(), n2);
                    if (n == 1) {
                        historicDate = historicDate3;
                        break;
                    }
                    if (n > 1 && n <= n3) {
                        PlainDate plainDate = this.history.convert(historicDate3);
                        plainDate = (PlainDate)plainDate.plus(CalendarDays.of(n - 1));
                        historicDate = this.history.convert(plainDate);
                        break;
                    }
                    throw new IllegalArgumentException("Out of range: " + n);
                }
                case 8: {
                    int n4 = historicDate2.getYearOfEra() % 100;
                    int n5 = (n - 1) * 100 + (n4 == 0 ? 100 : n4);
                    historicDate = HistoricDate.of(historicDate2.getEra(), n5, historicDate2.getMonth(), historicDate2.getDayOfMonth(), yearDefinition, newYearStrategy);
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown element index: " + this.index);
                }
            }
            return historicDate;
        }
    }
}

