/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekmodel;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.Chronology;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.ChronoPattern;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatEngine;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.SignPolicy;
import net.time4j.format.internal.DualFormatElement;
import net.time4j.history.ChronoHistory;
import net.time4j.i18n.UltimateFormatEngine;

public enum PatternType implements ChronoPattern<PatternType>
{
    CLDR,
    SIMPLE_DATE_FORMAT,
    CLDR_24,
    CLDR_DATE,
    NON_ISO_DATE,
    DYNAMIC;


    @Override
    public FormatEngine<PatternType> getFormatEngine() {
        return UltimateFormatEngine.INSTANCE;
    }

    Map<ChronoElement<?>, ChronoElement<?>> registerSymbol(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        Chronology<?> chronology = PatternType.getEffectiveChronology(builder);
        switch (this) {
            case CLDR: {
                return this.cldr(builder, locale, c, n);
            }
            case SIMPLE_DATE_FORMAT: {
                return this.sdf(builder, chronology, locale, c, n);
            }
            case CLDR_24: {
                return this.cldr24(builder, locale, c, n);
            }
            case NON_ISO_DATE: {
                if (PatternType.isISO(chronology)) {
                    throw new IllegalArgumentException("Choose CLDR or CLDR_DATE for ISO-8601-chronology.");
                }
                return this.general(builder, chronology, c, n, locale);
            }
            case CLDR_DATE: {
                Class<?> clazz = chronology.getChronoType();
                if (Calendrical.class.isAssignableFrom(clazz) || CalendarVariant.class.isAssignableFrom(clazz)) {
                    return this.general(builder, chronology, c, n, locale);
                }
                throw new IllegalArgumentException("No calendar chronology.");
            }
            case DYNAMIC: {
                return this.dynamic(builder, c, n, locale);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    private static boolean isGeneralSymbol(char c) {
        switch (c) {
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'L': 
            case 'M': 
            case 'W': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'r': 
            case 'w': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    private static boolean isISO(Chronology<?> chronology) {
        return PatternType.getCalendarType(chronology).equals("iso8601");
    }

    private static String getCalendarType(Chronology<?> chronology) {
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? "iso8601" : calendarType.value();
    }

    private static ChronoElement<Integer> findEthiopianHour(Chronology<?> chronology) {
        for (ChronoExtension chronoExtension : chronology.getExtensions()) {
            for (ChronoElement<?> chronoElement : chronoExtension.getElements(Locale.ROOT, Attributes.empty())) {
                if (!chronoElement.name().equals("ETHIOPIAN_HOUR")) continue;
                return (ChronoElement)PatternType.cast(chronoElement);
            }
        }
        return null;
    }

    private static Chronology<?> getEffectiveChronology(ChronoFormatter.Builder<?> builder) {
        Chronology<?> chronology = builder.getChronology();
        while (chronology instanceof BridgeChronology) {
            chronology = chronology.preparser();
        }
        return chronology;
    }

    private Map<ChronoElement<?>, ChronoElement<?>> cldr(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        Chronology<?> chronology = PatternType.getEffectiveChronology(builder);
        if (PatternType.isGeneralSymbol(c) && !PatternType.isISO(chronology)) {
            return this.general(builder, chronology, c, n, locale);
        }
        if (c == 'h' && PatternType.getCalendarType(chronology).equals("ethiopic")) {
            ChronoElement<Integer> chronoElement = PatternType.findEthiopianHour(chronology);
            if (chronoElement == null) {
                throw new IllegalArgumentException("Ethiopian time not available.");
            }
            PatternType.addNumber(chronoElement, c, builder, n, false);
            return Collections.emptyMap();
        }
        return this.cldrISO(builder, chronology, locale, c, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<ChronoElement<?>, ChronoElement<?>> cldrISO(ChronoFormatter.Builder<?> builder, Chronology<?> chronology, Locale locale, char c, int n, boolean bl) {
        switch (c) {
            case 'G': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4 || bl) {
                    textWidth = TextWidth.WIDE;
                } else {
                    if (n != 5) throw new IllegalArgumentException("Too many pattern letters (G): " + n);
                    textWidth = TextWidth.NARROW;
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                ChronoHistory chronoHistory = ChronoHistory.of(locale);
                TextElement textElement = (TextElement)TextElement.class.cast(chronoHistory.era());
                builder.addText(textElement);
                builder.endSection();
                HashMap hashMap = new HashMap();
                hashMap.put(PlainDate.YEAR, chronoHistory.yearOfEra());
                hashMap.put(PlainDate.MONTH_OF_YEAR, chronoHistory.month());
                hashMap.put(PlainDate.MONTH_AS_NUMBER, chronoHistory.month());
                hashMap.put(PlainDate.DAY_OF_MONTH, chronoHistory.dayOfMonth());
                hashMap.put(PlainDate.DAY_OF_YEAR, chronoHistory.dayOfYear());
                return hashMap;
            }
            case 'y': {
                if (n == 2) {
                    builder.addTwoDigitYear(PlainDate.YEAR);
                    return Collections.emptyMap();
                }
                builder.addYear(PlainDate.YEAR, n, false);
                return Collections.emptyMap();
            }
            case 'Y': {
                if (n == 2) {
                    builder.addTwoDigitYear(PlainDate.YEAR_OF_WEEKDATE);
                    return Collections.emptyMap();
                }
                builder.addYear(PlainDate.YEAR_OF_WEEKDATE, n, false);
                return Collections.emptyMap();
            }
            case 'u': {
                builder.addYear(PlainDate.YEAR, n, true);
                return Collections.emptyMap();
            }
            case 'r': {
                builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                builder.startSection(Attributes.ZERO_DIGIT, 48);
                builder.addYear(PlainDate.YEAR, n, true);
                builder.endSection();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'Q': {
                PatternType.addQuarterOfYear(builder, n);
                return Collections.emptyMap();
            }
            case 'q': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addQuarterOfYear(builder, n);
                    return Collections.emptyMap();
                }
                finally {
                    builder.endSection();
                }
            }
            case 'M': {
                PatternType.addMonth(builder, Math.min(n, bl ? 4 : n));
                return Collections.emptyMap();
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addMonth(builder, n);
                    return Collections.emptyMap();
                }
                finally {
                    builder.endSection();
                }
            }
            case 'w': {
                if (n > 2) throw new IllegalArgumentException("Too many pattern letters (w): " + n);
                PatternType.addNumber(Weekmodel.of(locale).weekOfYear(), c, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'W': {
                if (n != 1) throw new IllegalArgumentException("Too many pattern letters (W): " + n);
                builder.addFixedInteger(Weekmodel.of(locale).weekOfMonth(), 1);
                return Collections.emptyMap();
            }
            case 'd': {
                PatternType.addNumber(PlainDate.DAY_OF_MONTH, c, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'D': {
                if (n < 3) {
                    builder.addInteger(PlainDate.DAY_OF_YEAR, n, 3);
                    return Collections.emptyMap();
                }
                if (n != 3 && !bl) throw new IllegalArgumentException("Too many pattern letters (D): " + n);
                builder.addFixedInteger(PlainDate.DAY_OF_YEAR, n);
                return Collections.emptyMap();
            }
            case 'F': {
                if (n != 1 && !bl) throw new IllegalArgumentException("Too many pattern letters (F): " + n);
                builder.addFixedInteger(PlainDate.WEEKDAY_IN_MONTH, n);
                return Collections.emptyMap();
            }
            case 'g': {
                builder.addLongNumber(EpochDays.MODIFIED_JULIAN_DATE, n, 18, SignPolicy.SHOW_WHEN_NEGATIVE);
                return Collections.emptyMap();
            }
            case 'E': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4 || bl) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    if (n != 6) throw new IllegalArgumentException("Too many pattern letters (E): " + n);
                    textWidth = TextWidth.SHORT;
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainDate.DAY_OF_WEEK);
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'e': {
                if (n <= 2) {
                    builder.addFixedNumerical(Weekmodel.of(locale).localDayOfWeek(), n);
                    return Collections.emptyMap();
                }
                this.cldrISO(builder, chronology, locale, 'E', n, bl);
                return Collections.emptyMap();
            }
            case 'c': {
                if (n == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    if (n == 1) {
                        builder.addFixedNumerical(Weekmodel.of(locale).localDayOfWeek(), 1);
                        return Collections.emptyMap();
                    }
                    this.cldrISO(builder, chronology, locale, 'E', n, bl);
                    return Collections.emptyMap();
                }
                finally {
                    builder.endSection();
                }
            }
            case 'a': {
                TextWidth textWidth = bl ? TextWidth.ABBREVIATED : PatternType.getPeriodWidth(n);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainTime.AM_PM_OF_DAY);
                builder.endSection();
                if (!PatternType.getCalendarType(chronology).equals("ethiopic")) return Collections.emptyMap();
                ChronoElement<Integer> chronoElement = PatternType.findEthiopianHour(chronology);
                if (chronoElement == null) {
                    throw new IllegalArgumentException("Ethiopian time not available.");
                }
                HashMap hashMap = new HashMap();
                hashMap.put(chronoElement, PlainTime.CLOCK_HOUR_OF_AMPM);
                return hashMap;
            }
            case 'b': {
                TextWidth textWidth = PatternType.getPeriodWidth(n);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addDayPeriodFixed();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'B': {
                TextWidth textWidth = PatternType.getPeriodWidth(n);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addDayPeriodApproximate();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'h': {
                PatternType.addNumber(PlainTime.CLOCK_HOUR_OF_AMPM, c, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'H': {
                PatternType.addNumber(PlainTime.DIGITAL_HOUR_OF_DAY, c, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'K': {
                PatternType.addNumber(PlainTime.DIGITAL_HOUR_OF_AMPM, c, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'k': {
                PatternType.addNumber(PlainTime.CLOCK_HOUR_OF_DAY, c, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'm': {
                PatternType.addNumber(PlainTime.MINUTE_OF_HOUR, c, builder, n, bl);
                return Collections.emptyMap();
            }
            case 's': {
                PatternType.addNumber(PlainTime.SECOND_OF_MINUTE, c, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'S': {
                builder.addFraction(PlainTime.NANO_OF_SECOND, n, n, false);
                return Collections.emptyMap();
            }
            case 'A': {
                builder.addInteger(PlainTime.MILLI_OF_DAY, n, 9);
                return Collections.emptyMap();
            }
            case 'z': {
                try {
                    if (n < 4) {
                        builder.addShortTimezoneName();
                        return Collections.emptyMap();
                    }
                    if (n != 4 && !bl) throw new IllegalArgumentException("Too many pattern letters (z): " + n);
                    builder.addLongTimezoneName();
                    return Collections.emptyMap();
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IllegalArgumentException(illegalStateException.getMessage());
                }
            }
            case 'Z': {
                if (n < 4) {
                    builder.addTimezoneOffset(DisplayMode.LONG, false, Collections.singletonList("+0000"));
                    return Collections.emptyMap();
                }
                if (n == 4) {
                    builder.addLongLocalizedOffset();
                    return Collections.emptyMap();
                }
                if (n != 5) throw new IllegalArgumentException("Too many pattern letters (Z): " + n);
                builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList("Z"));
                return Collections.emptyMap();
            }
            case 'O': {
                if (n == 1) {
                    builder.addShortLocalizedOffset();
                    return Collections.emptyMap();
                }
                if (n != 4) throw new IllegalArgumentException("Count of pattern letters is not 1 or 4: " + n);
                builder.addLongLocalizedOffset();
                return Collections.emptyMap();
            }
            case 'V': {
                if (n != 2) throw new IllegalArgumentException("Count of pattern letters is not 2: " + n);
                try {
                    builder.addTimezoneID();
                    return Collections.emptyMap();
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IllegalArgumentException(illegalStateException.getMessage());
                }
            }
            case 'X': {
                PatternType.addOffset(builder, c, n, true);
                return Collections.emptyMap();
            }
            case 'x': {
                PatternType.addOffset(builder, c, n, false);
                return Collections.emptyMap();
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
            }
        }
    }

    private static TextWidth getPeriodWidth(int n) {
        if (n <= 3) {
            return TextWidth.ABBREVIATED;
        }
        if (n == 4) {
            return TextWidth.WIDE;
        }
        if (n == 5) {
            return TextWidth.NARROW;
        }
        throw new IllegalArgumentException("Too many pattern letters: " + n);
    }

    private Map<ChronoElement<?>, ChronoElement<?>> sdf(ChronoFormatter.Builder<?> builder, Chronology<?> chronology, Locale locale, char c, int n) {
        switch (c) {
            case 'W': {
                builder.addFixedInteger(Weekmodel.of(locale).boundedWeekOfMonth(), n);
                break;
            }
            case 'u': {
                builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, n);
                break;
            }
            case 'S': {
                builder.addFixedInteger(PlainTime.MILLI_OF_SECOND, n);
                break;
            }
            case 'Z': {
                PatternType.addOffset(builder, c, 2, false);
                break;
            }
            case 'B': 
            case 'O': 
            case 'Q': 
            case 'V': 
            case 'b': 
            case 'c': 
            case 'e': 
            case 'g': 
            case 'q': 
            case 'r': 
            case 'x': {
                throw new IllegalArgumentException("CLDR pattern symbol not supported in SimpleDateFormat-style: " + c);
            }
            case 'X': {
                if (n >= 4) {
                    throw new IllegalArgumentException("Too many pattern letters (X): " + n);
                }
                return this.cldrISO(builder, chronology, locale, 'X', n, true);
            }
            default: {
                return this.cldrISO(builder, chronology, locale, c, n, true);
            }
        }
        return Collections.emptyMap();
    }

    private Map<ChronoElement<?>, ChronoElement<?>> cldr24(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        if (c == 'H') {
            PatternType.addNumber(PlainTime.HOUR_FROM_0_TO_24, c, builder, n, false);
            return Collections.emptyMap();
        }
        return this.cldr(builder, locale, c, n);
    }

    private static void addOffset(ChronoFormatter.Builder<?> builder, char c, int n, boolean bl) {
        switch (n) {
            case 1: {
                builder.addTimezoneOffset(DisplayMode.SHORT, false, Collections.singletonList(bl ? "Z" : "+00"));
                break;
            }
            case 2: {
                builder.addTimezoneOffset(DisplayMode.MEDIUM, false, Collections.singletonList(bl ? "Z" : "+0000"));
                break;
            }
            case 3: {
                builder.addTimezoneOffset(DisplayMode.MEDIUM, true, Collections.singletonList(bl ? "Z" : "+00:00"));
                break;
            }
            case 4: {
                builder.addTimezoneOffset(DisplayMode.LONG, false, Collections.singletonList(bl ? "Z" : "+0000"));
                break;
            }
            case 5: {
                builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList(bl ? "Z" : "+00:00"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters (" + c + "): " + n);
            }
        }
    }

    private static void addNumber(ChronoElement<Integer> chronoElement, char c, ChronoFormatter.Builder<?> builder, int n, boolean bl) {
        if (n == 1) {
            builder.addInteger(chronoElement, 1, 2);
        } else if (n == 2 || bl) {
            builder.addFixedInteger(chronoElement, n);
        } else {
            throw new IllegalArgumentException("Too many pattern letters (" + c + "): " + n);
        }
    }

    private static void addMonth(ChronoFormatter.Builder<?> builder, int n) {
        switch (n) {
            case 1: {
                builder.addInteger(PlainDate.MONTH_AS_NUMBER, 1, 2);
                break;
            }
            case 2: {
                builder.addFixedInteger(PlainDate.MONTH_AS_NUMBER, 2);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters for month: " + n);
            }
        }
    }

    private static void addQuarterOfYear(ChronoFormatter.Builder<?> builder, int n) {
        switch (n) {
            case 1: 
            case 2: {
                builder.addFixedNumerical(PlainDate.QUARTER_OF_YEAR, n);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters for quarter-of-year: " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ChronoElement<?>, ChronoElement<?>> general(ChronoFormatter.Builder<?> builder, Chronology<?> chronology, char c, int n, Locale locale) {
        ChronoElement chronoElement;
        TextElement textElement;
        String string;
        Set<ChronoElement<?>> set = PatternType.getElements(chronology, c, locale);
        ChronoElement<?> chronoElement2 = PatternType.find(set, c, string = builder.getChronology().getChronoType().getName());
        if (Integer.class.isAssignableFrom(chronoElement2.getType())) {
            textElement = null;
            if (chronoElement2 instanceof DualFormatElement) {
                textElement = (TextElement)PatternType.cast(chronoElement2);
            }
            chronoElement = (ChronoElement)PatternType.cast(chronoElement2);
        } else if (chronoElement2 instanceof TextElement) {
            textElement = (TextElement)PatternType.cast(chronoElement2);
            chronoElement = null;
        } else {
            throw new IllegalStateException("Implementation error: " + chronoElement2 + " in \"" + string + "\"");
        }
        switch (c) {
            case 'G': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters (G): " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 'y': {
                boolean bl = false;
                if (locale.getLanguage().equals("am") && PatternType.getCalendarType(chronology).equals("ethiopic")) {
                    bl = true;
                    builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ETHIOPIC);
                }
                if (n == 2) {
                    builder.addTwoDigitYear(chronoElement);
                } else {
                    builder.addYear(chronoElement, n, false);
                }
                if (!bl) break;
                builder.endSection();
                break;
            }
            case 'r': {
                builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                builder.startSection(Attributes.ZERO_DIGIT, 48);
                builder.addYear(chronoElement, n, true);
                builder.endSection();
                builder.endSection();
                break;
            }
            case 'M': {
                PatternType.addMonth(builder, Math.min(n, n), textElement);
                break;
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addMonth(builder, n, textElement);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'w': {
                PatternType.addNumber(chronoElement, c, builder, n, false);
                break;
            }
            case 'W': {
                if (n == 1) {
                    builder.addFixedInteger(chronoElement, 1);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (W): " + n);
            }
            case 'd': {
                PatternType.addNumber(chronoElement, c, builder, n, false);
                break;
            }
            case 'D': {
                if (n < 3) {
                    builder.addInteger(chronoElement, n, 3);
                    break;
                }
                if (n == 3) {
                    builder.addFixedInteger(chronoElement, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (D): " + n);
            }
            case 'E': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else if (n == 6) {
                    textWidth = TextWidth.SHORT;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters (E): " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 'e': {
                if (n <= 2) {
                    ChronoElement chronoElement3 = (ChronoElement)PatternType.cast(chronoElement2);
                    builder.addFixedNumerical(chronoElement3, n);
                    break;
                }
                this.general(builder, chronology, 'E', n, locale);
                break;
            }
            case 'c': {
                if (n == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    if (n == 1) {
                        ChronoElement chronoElement4 = (ChronoElement)PatternType.cast(chronoElement2);
                        builder.addFixedNumerical(chronoElement4, 1);
                        break;
                    }
                    this.general(builder, chronology, 'E', n, locale);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'F': {
                if (n == 1) {
                    builder.addFixedInteger(chronoElement, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters (F): " + n);
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
            }
        }
        return Collections.emptyMap();
    }

    private Map<ChronoElement<?>, ChronoElement<?>> dynamic(ChronoFormatter.Builder<?> builder, char c, int n, Locale locale) {
        Object object;
        ChronoElement<?> chronoElement = null;
        Chronology<?> chronology = PatternType.getEffectiveChronology(builder);
        for (ChronoElement<?> chronoElement2 : chronology.getRegisteredElements()) {
            if (chronoElement2.getSymbol() != c) continue;
            chronoElement = chronoElement2;
            break;
        }
        if (chronoElement == null) {
            for (ChronoExtension chronoExtension : chronology.getExtensions()) {
                for (ChronoElement<?> chronoElement2 : chronoExtension.getElements(locale, Attributes.empty())) {
                    if (chronoElement2.getSymbol() != c) continue;
                    chronoElement = chronoElement2;
                    break;
                }
                if (chronoElement == null) continue;
                break;
            }
        }
        if (chronoElement == null) {
            throw new IllegalArgumentException("Cannot resolve symbol: " + c);
        }
        if (chronoElement instanceof TextElement) {
            switch (n) {
                case 1: {
                    builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                    break;
                }
                case 2: {
                    builder.startSection(Attributes.TEXT_WIDTH, TextWidth.SHORT);
                    break;
                }
                case 3: {
                    builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                    break;
                }
                case 4: {
                    builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal count of symbols: " + c);
                }
            }
            object = (TextElement)PatternType.cast(chronoElement);
            builder.addText((TextElement<?>)object);
            builder.endSection();
        } else if (chronoElement.getType() == Integer.class) {
            object = (ChronoElement)PatternType.cast(chronoElement);
            builder.addInteger((ChronoElement<Integer>)object, n, 9);
        } else {
            throw new IllegalArgumentException("Can only handle integer or text elements: " + chronoElement);
        }
        return Collections.emptyMap();
    }

    private static Set<ChronoElement<?>> getElements(Chronology<?> chronology, char c, Locale locale) {
        if (c == 'w' || c == 'W' || c == 'e' || c == 'c') {
            for (ChronoExtension chronoExtension : chronology.getExtensions()) {
                for (ChronoElement<?> chronoElement : chronoExtension.getElements(locale, Attributes.empty())) {
                    if ((c != 'e' && c != 'c' || !chronoElement.name().equals("LOCAL_DAY_OF_WEEK")) && (c != 'w' || !chronoElement.name().equals("WEEK_OF_YEAR")) && (c != 'W' || !chronoElement.name().equals("WEEK_OF_MONTH"))) continue;
                    HashSet hashSet = new HashSet();
                    hashSet.add(chronoElement);
                    return hashSet;
                }
            }
            return Collections.emptySet();
        }
        return chronology.getRegisteredElements();
    }

    private static ChronoElement<?> find(Set<ChronoElement<?>> set, char c, String string) {
        char c2 = c == 'L' ? (char)'M' : (c == 'c' ? (char)'e' : (char)c);
        for (ChronoElement<?> chronoElement : set) {
            if (!chronoElement.isDateElement() || chronoElement.getSymbol() != c2) continue;
            return chronoElement;
        }
        throw new IllegalArgumentException("Cannot find any chronological date element for symbol " + c + " in \"" + string + "\".");
    }

    private static <V extends Enum<V>> void addMonth(ChronoFormatter.Builder<?> builder, int n, TextElement<?> textElement) {
        switch (n) {
            case 1: 
            case 2: {
                if (Enum.class.isAssignableFrom(textElement.getType())) {
                    ChronoElement chronoElement = (ChronoElement)PatternType.cast(textElement);
                    if (n == 1) {
                        builder.addNumerical(chronoElement, 1, 2);
                        break;
                    }
                    if (n != 2) break;
                    builder.addFixedNumerical(chronoElement, 2);
                    break;
                }
                builder.startSection(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS, Integer.valueOf(n).intValue());
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters for month: " + n);
            }
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }
}

