/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.Serializable;
import net.time4j.Moment;
import net.time4j.calendar.astro.AstroUtils;
import net.time4j.calendar.astro.GeoLocation;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.StdSolarCalculator;

public class SunPosition
implements Serializable {
    private static final long serialVersionUID = -3023032442869934354L;
    private final double rightAscension;
    private final double declination;
    private final double azimuth;
    private final double elevation;

    private SunPosition(double d, double d2, double d3, double d4) {
        this.rightAscension = d;
        this.declination = d2;
        this.azimuth = d3;
        this.elevation = d4;
    }

    public static SunPosition at(Moment moment, GeoLocation geoLocation) {
        double d;
        JulianDay julianDay = JulianDay.ofEphemerisTime(moment);
        double d2 = julianDay.getCenturyJ2000();
        StdSolarCalculator stdSolarCalculator = StdSolarCalculator.TIME4J;
        double[] dArray = new double[2];
        StdSolarCalculator.nutations(d2, dArray);
        double d3 = dArray[0];
        double d4 = StdSolarCalculator.meanObliquity(d2) + dArray[1];
        double d5 = Math.toRadians(stdSolarCalculator.rightAscension(julianDay.getValue()));
        double d6 = Math.toRadians(stdSolarCalculator.declination(julianDay.getValue()));
        double d7 = Math.toRadians(geoLocation.getLatitude());
        double d8 = Math.toRadians(geoLocation.getLongitude());
        double d9 = Math.cos(d7);
        double d10 = Math.sin(d7);
        int n = geoLocation.getAltitude();
        double d11 = JulianDay.ofMeanSolarTime(moment).getMJD();
        double d12 = d3 * Math.cos(Math.toRadians(d4));
        double d13 = AstroUtils.gmst(d11) + Math.toRadians(d12) + d8 - d5;
        double d14 = d10 * Math.sin(d6) + d9 * Math.cos(d6) * Math.cos(d13);
        double d15 = Math.toDegrees(Math.asin(d14));
        double d16 = stdSolarCalculator.getGeodeticAngle(geoLocation.getLatitude(), n);
        if (d15 >= -0.5 - d16) {
            d = AstroUtils.refractionFactorOfStdAtmosphere(n);
            double d17 = d * AstroUtils.getRefraction(d15) / 60.0;
            d15 += d17;
        }
        d = Math.toDegrees(Math.atan2(Math.sin(d13), Math.cos(d13) * d10 - Math.tan(d6) * d9)) + 180.0;
        return new SunPosition(Math.toDegrees(d5), Math.toDegrees(d6), d, d15);
    }

    public double getRightAscension() {
        return this.rightAscension;
    }

    public double getDeclination() {
        return this.declination;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public double getElevation() {
        return this.elevation;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SunPosition) {
            SunPosition sunPosition = (SunPosition)object;
            return this.rightAscension == sunPosition.rightAscension && this.declination == sunPosition.declination && this.azimuth == sunPosition.azimuth && this.elevation == sunPosition.elevation;
        }
        return false;
    }

    public int hashCode() {
        return SunPosition.hashCode(this.rightAscension) + 31 * SunPosition.hashCode(this.declination);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append("sun-position[ra=");
        stringBuilder.append(this.rightAscension);
        stringBuilder.append(",decl=");
        stringBuilder.append(this.declination);
        stringBuilder.append(",azimuth=");
        stringBuilder.append(this.azimuth);
        stringBuilder.append(",elevation=");
        stringBuilder.append(this.elevation);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }
}

