/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Locale;
import java.util.Map;
import net.time4j.engine.AttributeKey;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumberSystem;

public final class EastAsianMonth
implements Comparable<EastAsianMonth>,
Serializable {
    public static final AttributeKey<Character> LEAP_MONTH_INDICATOR = Attributes.createKey("LEAP_MONTH_INDICATOR", Character.class);
    private static final EastAsianMonth[] CACHE;
    private static final long serialVersionUID = 7544059597266533279L;
    private final int index;
    private final boolean leap;

    private EastAsianMonth(int n, boolean bl) {
        this.index = n;
        this.leap = bl;
    }

    public static EastAsianMonth valueOf(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return CACHE[n - 1];
    }

    public int getNumber() {
        return this.index + 1;
    }

    public boolean isLeap() {
        return this.leap;
    }

    public EastAsianMonth withLeap() {
        return CACHE[this.index + 12];
    }

    public String getOldJapaneseName(Locale locale) {
        Map<String, String> map = CalendarText.getInstance("japanese", locale).getTextForms();
        return map.get("t" + this.getNumber());
    }

    public String getDisplayName(Locale locale, NumberSystem numberSystem) {
        Map<String, String> map = CalendarText.getInstance("generic", locale).getTextForms();
        String string = map.get("month-num-pattern");
        String string2 = string.replace("{0}", numberSystem.toNumeral(this.getNumber()));
        if (this.leap) {
            string2 = map.get("leap-month") + string2;
        }
        return string2;
    }

    @Override
    public int compareTo(EastAsianMonth eastAsianMonth) {
        if (this.index < eastAsianMonth.index) {
            return -1;
        }
        if (this.index > eastAsianMonth.index) {
            return 1;
        }
        if (this.leap) {
            return eastAsianMonth.leap ? 0 : 1;
        }
        return eastAsianMonth.leap ? -1 : 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EastAsianMonth) {
            EastAsianMonth eastAsianMonth = (EastAsianMonth)object;
            return this.index == eastAsianMonth.index && this.leap == eastAsianMonth.leap;
        }
        return false;
    }

    public int hashCode() {
        return this.index + (this.leap ? 12 : 0);
    }

    public String toString() {
        String string = String.valueOf(this.index + 1);
        return this.leap ? "*" + string : string;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return CACHE[this.index + (this.leap ? 12 : 0)];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StreamCorruptedException();
        }
    }

    static {
        EastAsianMonth[] eastAsianMonthArray = new EastAsianMonth[24];
        for (int i = 0; i < 12; ++i) {
            eastAsianMonthArray[i] = new EastAsianMonth(i, false);
            eastAsianMonthArray[i + 12] = new EastAsianMonth(i, true);
        }
        CACHE = eastAsianMonthArray;
    }
}

