/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.StartOfDay;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class GeneralTimestamp<C>
implements ChronoDisplay {
    private final CalendarVariant<?> cv;
    private final Calendrical<?, ?> ca;
    private final PlainTime time;

    private GeneralTimestamp(CalendarVariant<?> calendarVariant, Calendrical<?, ?> calendrical, PlainTime plainTime) {
        if (plainTime.getHour() == 24) {
            if (calendarVariant == null) {
                this.cv = null;
                this.ca = calendrical.plus(CalendarDays.of(1L));
            } else {
                this.cv = calendarVariant.plus(CalendarDays.of(1L));
                this.ca = null;
            }
            this.time = PlainTime.midnightAtStartOfDay();
        } else {
            this.cv = calendarVariant;
            this.ca = calendrical;
            this.time = plainTime;
        }
    }

    public static <C extends CalendarVariant<C>> GeneralTimestamp<C> of(C c, PlainTime plainTime) {
        if (c == null) {
            throw new NullPointerException("Missing date component.");
        }
        return new GeneralTimestamp<C>(c, null, plainTime);
    }

    public static <C extends Calendrical<?, C>> GeneralTimestamp<C> of(C c, PlainTime plainTime) {
        if (c == null) {
            throw new NullPointerException("Missing date component.");
        }
        return new GeneralTimestamp<C>(null, c, plainTime);
    }

    public C toDate() {
        ChronoEntity chronoEntity = this.cv == null ? this.ca : this.cv;
        return (C)chronoEntity;
    }

    public PlainTime toTime() {
        return this.time;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof GeneralTimestamp) {
            GeneralTimestamp generalTimestamp = (GeneralTimestamp)GeneralTimestamp.class.cast(object);
            if (!this.time.equals(generalTimestamp.time)) {
                return false;
            }
            if (this.cv == null) {
                return generalTimestamp.cv == null && this.ca.equals(generalTimestamp.ca);
            }
            return generalTimestamp.ca == null && this.cv.equals(generalTimestamp.cv);
        }
        return false;
    }

    public int hashCode() {
        int n = this.cv == null ? this.ca.hashCode() : this.cv.hashCode();
        return n + this.time.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.cv == null) {
            stringBuilder.append(this.ca);
        } else {
            stringBuilder.append(this.cv);
        }
        stringBuilder.append(this.time);
        return stringBuilder.toString();
    }

    public Moment at(ZonalOffset zonalOffset, StartOfDay startOfDay) {
        PlainTimestamp plainTimestamp = this.cv == null ? this.ca.transform(PlainDate.class).at(this.time) : this.cv.transform(PlainDate.class).at(this.time);
        int n = startOfDay.getDeviation(plainTimestamp.getCalendarDate(), zonalOffset);
        int n2 = (Integer)this.time.get(PlainTime.SECOND_OF_DAY) - n;
        if (n2 >= 86400) {
            plainTimestamp = (PlainTimestamp)plainTimestamp.minus(1L, CalendarUnit.DAYS);
        } else if (n2 < 0) {
            plainTimestamp = (PlainTimestamp)plainTimestamp.plus(1L, CalendarUnit.DAYS);
        }
        return plainTimestamp.at(zonalOffset);
    }

    public Moment in(Timezone timezone, StartOfDay startOfDay) {
        PlainTimestamp plainTimestamp = this.cv == null ? this.ca.transform(PlainDate.class).at(this.time) : this.cv.transform(PlainDate.class).at(this.time);
        int n = startOfDay.getDeviation(plainTimestamp.getCalendarDate(), timezone.getID());
        int n2 = (Integer)this.time.get(PlainTime.SECOND_OF_DAY) - n;
        if (n2 >= 86400) {
            plainTimestamp = (PlainTimestamp)plainTimestamp.minus(1L, CalendarUnit.DAYS);
        } else if (n2 < 0) {
            plainTimestamp = (PlainTimestamp)plainTimestamp.plus(1L, CalendarUnit.DAYS);
        }
        return plainTimestamp.in(timezone);
    }

    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        return chronoElement.isDateElement() ? this.toDate0().contains(chronoElement) : this.time.contains(chronoElement);
    }

    @Override
    public <V> V get(ChronoElement<V> chronoElement) {
        return chronoElement.isDateElement() ? this.toDate0().get(chronoElement) : this.time.get(chronoElement);
    }

    @Override
    public int getInt(ChronoElement<Integer> chronoElement) {
        return chronoElement.isDateElement() ? this.toDate0().getInt(chronoElement) : this.time.getInt(chronoElement);
    }

    @Override
    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        return chronoElement.isDateElement() ? this.toDate0().getMinimum(chronoElement) : this.time.getMinimum(chronoElement);
    }

    @Override
    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        return chronoElement.isDateElement() ? this.toDate0().getMaximum(chronoElement) : this.time.getMaximum(chronoElement);
    }

    @Override
    public boolean hasTimezone() {
        return false;
    }

    @Override
    public TZID getTimezone() {
        throw new ChronoException("Timezone not available: " + this);
    }

    private ChronoDisplay toDate0() {
        ChronoEntity chronoEntity = this.cv == null ? this.ca : this.cv;
        return chronoEntity;
    }
}

