/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public abstract class StartOfDay {
    public static final StartOfDay MIDNIGHT = new FixedStartOfDay(0);
    public static final StartOfDay EVENING = new FixedStartOfDay(-21600);
    public static final StartOfDay MORNING = new FixedStartOfDay(21600);

    protected StartOfDay() {
    }

    public static StartOfDay ofFixedDeviation(int n) {
        if (n == 0) {
            return MIDNIGHT;
        }
        if (n == -21600) {
            return EVENING;
        }
        if (n > 43200 || n <= -43200) {
            throw new IllegalArgumentException("Start of day out of range: " + n);
        }
        return new FixedStartOfDay(n);
    }

    public static <T extends UnixTime> StartOfDay definedBy(ChronoFunction<CalendarDate, T> chronoFunction) {
        return new FunctionalStartOfDay(chronoFunction);
    }

    @Deprecated
    public abstract int getDeviation(Calendrical<?, ?> var1, TZID var2);

    private static class FunctionalStartOfDay<T extends UnixTime>
    extends StartOfDay {
        private final ChronoFunction<CalendarDate, T> event;

        private FunctionalStartOfDay(ChronoFunction<CalendarDate, T> chronoFunction) {
            if (chronoFunction == null) {
                throw new NullPointerException("Missing event function.");
            }
            this.event = chronoFunction;
        }

        @Override
        public int getDeviation(Calendrical<?, ?> calendrical, TZID tZID) {
            UnixTime unixTime = (UnixTime)this.event.apply(calendrical);
            if (unixTime != null) {
                long l;
                long l2 = unixTime.getPosixTime() - 63072000L + (long)Timezone.of(tZID).getOffset(unixTime).getIntegralAmount();
                int n = MathUtils.safeCast(l2 - (l = calendrical.getDaysSinceEpochUTC() * 86400L));
                return n >= 43200 ? n - 86400 : n;
            }
            throw new ChronoException("Cannot determine start of day: No event.");
        }
    }

    private static class FixedStartOfDay
    extends StartOfDay {
        private final int deviation;

        private FixedStartOfDay(int n) {
            this.deviation = n;
        }

        @Override
        public int getDeviation(Calendrical<?, ?> calendrical, TZID tZID) {
            return this.deviation;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof FixedStartOfDay) {
                FixedStartOfDay fixedStartOfDay = (FixedStartOfDay)object;
                return this.deviation == fixedStartOfDay.deviation;
            }
            return false;
        }

        public int hashCode() {
            return this.deviation;
        }

        public String toString() {
            return "FixedStartOfDay[" + this.deviation + "]";
        }
    }
}

