/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.base.ResourceLoader;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.Twilight;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.EpochDays;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;

public final class SolarTime
implements Serializable {
    private static final double EQUATORIAL_RADIUS = 6378137.0;
    private static final double POLAR_RADIUS = 6356752.3;
    private static final double STD_ZENITH = 90.83333333333333;
    private static final Calculator DEFAULT_CALCULATOR;
    private static final Map<String, Calculator> CALCULATORS;
    private static final long serialVersionUID = -4816619838743247977L;
    private final double latitude;
    private final double longitude;
    private final int altitude;
    private final String calculator;

    private SolarTime(double d, double d2, int n, String string) {
        this.latitude = d;
        this.longitude = d2;
        this.altitude = n;
        this.calculator = string;
    }

    public static Builder ofLocation() {
        return new Builder();
    }

    public static SolarTime ofLocation(double d, double d2) {
        return SolarTime.ofLocation(d, d2, 0, DEFAULT_CALCULATOR.name());
    }

    public static SolarTime ofLocation(double d, double d2, int n, String string) {
        SolarTime.check(d, d2, n, string);
        return new SolarTime(d, d2, n, string);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getAltitude() {
        return this.altitude;
    }

    public Calculator getCalculator() {
        return CALCULATORS.get(this.calculator);
    }

    public ChronoFunction<CalendarDate, Moment> sunrise() {
        return new ChronoFunction<CalendarDate, Moment>(){

            @Override
            public Moment apply(CalendarDate calendarDate) {
                return SolarTime.this.getCalculator().sunrise(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, SolarTime.this.zenithAngle());
            }
        };
    }

    public ChronoFunction<CalendarDate, Moment> sunrise(Twilight twilight) {
        final double d = 90.0 + this.sunAngleOfAltitude() + twilight.getAngle();
        return new ChronoFunction<CalendarDate, Moment>(){

            @Override
            public Moment apply(CalendarDate calendarDate) {
                return SolarTime.this.getCalculator().sunrise(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, d);
            }
        };
    }

    public ChronoFunction<CalendarDate, PlainTime> sunrise(final TZID tZID) {
        return new ChronoFunction<CalendarDate, PlainTime>(){

            @Override
            public PlainTime apply(CalendarDate calendarDate) {
                Moment moment = SolarTime.this.getCalculator().sunrise(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, SolarTime.this.zenithAngle());
                if (moment == null) {
                    throw new ChronoException("No sunrise event.");
                }
                return moment.toZonalTimestamp(tZID).getWallTime();
            }
        };
    }

    public ChronoFunction<CalendarDate, Moment> sunset() {
        return new ChronoFunction<CalendarDate, Moment>(){

            @Override
            public Moment apply(CalendarDate calendarDate) {
                return SolarTime.this.getCalculator().sunset(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, SolarTime.this.zenithAngle());
            }
        };
    }

    public ChronoFunction<CalendarDate, Moment> sunset(Twilight twilight) {
        final double d = 90.0 + this.sunAngleOfAltitude() + twilight.getAngle();
        return new ChronoFunction<CalendarDate, Moment>(){

            @Override
            public Moment apply(CalendarDate calendarDate) {
                return SolarTime.this.getCalculator().sunset(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, d);
            }
        };
    }

    public ChronoFunction<CalendarDate, PlainTime> sunset(final TZID tZID) {
        return new ChronoFunction<CalendarDate, PlainTime>(){

            @Override
            public PlainTime apply(CalendarDate calendarDate) {
                Moment moment = SolarTime.this.getCalculator().sunset(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, SolarTime.this.zenithAngle());
                if (moment == null) {
                    throw new ChronoException("No sunset event.");
                }
                return moment.toZonalTimestamp(tZID).getWallTime();
            }
        };
    }

    public ChronoFunction<CalendarDate, Sunshine> sunshine(final TZID tZID) {
        return new ChronoFunction<CalendarDate, Sunshine>(){

            @Override
            public Sunshine apply(CalendarDate calendarDate) {
                double d;
                PlainDate plainDate = SolarTime.toGregorian(calendarDate);
                Calculator calculator = SolarTime.this.getCalculator();
                double d2 = SolarTime.this.zenithAngle();
                Moment moment = calculator.sunrise(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, d2);
                Moment moment2 = calculator.sunset(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, d2);
                boolean bl = false;
                if (moment == null && moment2 == null && Double.compare(d = SolarTime.this.getHighestElevationOfSun(plainDate), 90.0 - d2) < 0) {
                    bl = true;
                }
                return new Sunshine(plainDate, moment, moment2, tZID, bl);
            }
        };
    }

    public ChronoCondition<CalendarDate> polarNight() {
        return new ChronoCondition<CalendarDate>(){

            @Override
            public boolean test(CalendarDate calendarDate) {
                if (Double.compare(Math.abs(SolarTime.this.latitude), 66.0) < 0) {
                    return false;
                }
                PlainDate plainDate = SolarTime.toGregorian(calendarDate);
                Calculator calculator = SolarTime.this.getCalculator();
                double d = SolarTime.this.zenithAngle();
                Moment moment = calculator.sunrise(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, d);
                Moment moment2 = calculator.sunset(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, d);
                if (moment != null || moment2 != null) {
                    return false;
                }
                double d2 = SolarTime.this.getHighestElevationOfSun(plainDate);
                return Double.compare(d2, 90.0 - d) < 0;
            }
        };
    }

    public ChronoCondition<CalendarDate> midnightSun() {
        return new ChronoCondition<CalendarDate>(){

            @Override
            public boolean test(CalendarDate calendarDate) {
                if (Double.compare(Math.abs(SolarTime.this.latitude), 66.0) < 0) {
                    return false;
                }
                PlainDate plainDate = SolarTime.toGregorian(calendarDate);
                Calculator calculator = SolarTime.this.getCalculator();
                double d = SolarTime.this.zenithAngle();
                Moment moment = calculator.sunrise(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, d);
                Moment moment2 = calculator.sunset(calendarDate, SolarTime.this.latitude, SolarTime.this.longitude, d);
                if (moment != null || moment2 != null) {
                    return false;
                }
                double d2 = SolarTime.this.getHighestElevationOfSun(plainDate);
                return Double.compare(d2, 90.0 - d) > 0;
            }
        };
    }

    public ChronoFunction<CalendarDate, Moment> transitAtNoon() {
        return new ChronoFunction<CalendarDate, Moment>(){

            @Override
            public Moment apply(CalendarDate calendarDate) {
                return SolarTime.transitAtNoon(calendarDate, SolarTime.this.longitude, SolarTime.this.calculator);
            }
        };
    }

    public ChronoFunction<CalendarDate, PlainTime> transitAtNoon(final TZID tZID) {
        return new ChronoFunction<CalendarDate, PlainTime>(){

            @Override
            public PlainTime apply(CalendarDate calendarDate) {
                Moment moment = SolarTime.transitAtNoon(calendarDate, SolarTime.this.longitude, SolarTime.this.calculator);
                return moment.toZonalTimestamp(tZID).getWallTime();
            }
        };
    }

    public ChronoFunction<CalendarDate, Moment> transitAtMidnight() {
        return new ChronoFunction<CalendarDate, Moment>(){

            @Override
            public Moment apply(CalendarDate calendarDate) {
                return SolarTime.transitAtMidnight(calendarDate, SolarTime.this.longitude, SolarTime.this.calculator);
            }
        };
    }

    public ChronoFunction<CalendarDate, PlainTime> transitAtMidnight(final TZID tZID) {
        return new ChronoFunction<CalendarDate, PlainTime>(){

            @Override
            public PlainTime apply(CalendarDate calendarDate) {
                Moment moment = SolarTime.transitAtMidnight(calendarDate, SolarTime.this.longitude, SolarTime.this.calculator);
                return moment.toZonalTimestamp(tZID).getWallTime();
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SolarTime) {
            SolarTime solarTime = (SolarTime)object;
            return this.calculator.equals(solarTime.calculator) && Double.compare(this.latitude, solarTime.latitude) == 0 && Double.compare(this.longitude, solarTime.longitude) == 0 && this.altitude == solarTime.altitude;
        }
        return false;
    }

    public int hashCode() {
        return this.calculator.hashCode() + 7 * Double.valueOf(this.latitude).hashCode() + 31 * Double.valueOf(this.longitude).hashCode() + 37 * this.altitude;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SolarTime[latitude=");
        stringBuilder.append(this.latitude);
        stringBuilder.append(",longitude=");
        stringBuilder.append(this.longitude);
        if (this.altitude != 0) {
            stringBuilder.append(",altitude=");
            stringBuilder.append(this.altitude);
        }
        if (!this.calculator.equals(DEFAULT_CALCULATOR.name())) {
            stringBuilder.append(",calculator=");
            stringBuilder.append(this.calculator);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static ChronoFunction<Moment, PlainTimestamp> apparentAt(final ZonalOffset zonalOffset) {
        return new ChronoFunction<Moment, PlainTimestamp>(){

            @Override
            public PlainTimestamp apply(Moment moment) {
                PlainTimestamp plainTimestamp = SolarTime.onAverage(moment, zonalOffset);
                double d = SolarTime.equationOfTime(moment);
                long l = (long)Math.floor(d);
                int n = (int)((d - (double)l) * 1.0E9);
                return (PlainTimestamp)((PlainTimestamp)plainTimestamp.plus(l, ClockUnit.SECONDS)).plus(n, ClockUnit.NANOS);
            }
        };
    }

    public static ChronoFunction<Moment, PlainTimestamp> apparentAt(final ZonalOffset zonalOffset, final String string) {
        return new ChronoFunction<Moment, PlainTimestamp>(){

            @Override
            public PlainTimestamp apply(Moment moment) {
                PlainTimestamp plainTimestamp = SolarTime.onAverage(moment, zonalOffset);
                double d = SolarTime.equationOfTime(moment, string);
                long l = (long)Math.floor(d);
                int n = (int)((d - (double)l) * 1.0E9);
                return (PlainTimestamp)((PlainTimestamp)plainTimestamp.plus(l, ClockUnit.SECONDS)).plus(n, ClockUnit.NANOS);
            }
        };
    }

    public static ChronoFunction<Moment, PlainTimestamp> onAverage(final ZonalOffset zonalOffset) {
        return new ChronoFunction<Moment, PlainTimestamp>(){

            @Override
            public PlainTimestamp apply(Moment moment) {
                return SolarTime.onAverage(moment, zonalOffset);
            }
        };
    }

    public static double equationOfTime(Moment moment) {
        double d = JulianDay.getValue(moment, TimeScale.TT);
        return DEFAULT_CALCULATOR.equationOfTime(d);
    }

    public static double equationOfTime(Moment moment, String string) {
        if (string == null) {
            throw new NullPointerException("Missing calculator parameter.");
        }
        if (CALCULATORS.containsKey(string)) {
            double d = JulianDay.getValue(moment, TimeScale.TT);
            return CALCULATORS.get(string).equationOfTime(d);
        }
        throw new IllegalArgumentException("Unknown calculator: " + string);
    }

    double getHighestElevationOfSun(PlainDate plainDate) {
        Moment moment = plainDate.get(this.transitAtNoon());
        double d = JulianDay.getValue(moment, TimeScale.TT);
        double d2 = Math.toRadians(this.getCalculator().declination(d));
        double d3 = Math.toRadians(this.latitude);
        double d4 = Math.sin(d3) * Math.sin(d2) + Math.cos(d3) * Math.cos(d2);
        return Math.toDegrees(Math.asin(d4));
    }

    private static PlainTimestamp onAverage(Moment moment, ZonalOffset zonalOffset) {
        Moment moment2 = Moment.of(moment.getElapsedTime(TimeScale.UT) + 63072000L, moment.getNanosecond(TimeScale.UT), TimeScale.POSIX);
        return moment2.toZonalTimestamp(zonalOffset);
    }

    private static Moment transitAtNoon(CalendarDate calendarDate, double d, String string) {
        Moment moment = SolarTime.fromLocalEvent(calendarDate, 12, d, string);
        return (Moment)moment.with(Moment.PRECISION, string.equals("SIMPLE") ? TimeUnit.MINUTES : TimeUnit.SECONDS);
    }

    private static Moment transitAtMidnight(CalendarDate calendarDate, double d, String string) {
        Moment moment = SolarTime.fromLocalEvent(calendarDate, 0, d, string);
        return (Moment)moment.with(Moment.PRECISION, string.equals("SIMPLE") ? TimeUnit.MINUTES : TimeUnit.SECONDS);
    }

    private static Moment fromLocalEvent(CalendarDate calendarDate, int n, double d, String string) {
        Calculator calculator = CALCULATORS.get(string);
        double d2 = (double)(calendarDate.getDaysSinceEpochUTC() * 86400L + (long)(n * 3600)) - d * 240.0;
        long l = (long)Math.floor(d2);
        int n2 = (int)((d2 - (double)l) * 1.0E9);
        Moment moment = Moment.of(l, n2, TimeScale.UT);
        double d3 = calculator.equationOfTime(JulianDay.getValue(moment, TimeScale.TT));
        l = (long)Math.floor(d3);
        n2 = (int)((d3 - (double)l) * 1.0E9);
        Moment moment2 = (Moment)((Moment)moment.minus(l, TimeUnit.SECONDS)).minus((long)n2, TimeUnit.NANOSECONDS);
        d3 = calculator.equationOfTime(JulianDay.getValue(moment2, TimeScale.TT));
        l = (long)Math.floor(d3);
        n2 = (int)((d3 - (double)l) * 1.0E9);
        return (Moment)((Moment)moment.minus(l, TimeUnit.SECONDS)).minus((long)n2, TimeUnit.NANOSECONDS);
    }

    private static PlainDate toGregorian(CalendarDate calendarDate) {
        if (calendarDate instanceof PlainDate) {
            return (PlainDate)calendarDate;
        }
        return PlainDate.of(calendarDate.getDaysSinceEpochUTC(), EpochDays.UTC);
    }

    private double earthRadius() {
        double d = Math.toRadians(this.latitude);
        double d2 = 6378137.0 * Math.cos(d);
        double d3 = 6356752.3 * Math.sin(d);
        return 4.0680631590769E13 / Math.sqrt(d2 * d2 + d3 * d3);
    }

    private double sunAngleOfAltitude() {
        if (this.altitude == 0) {
            return 0.0;
        }
        double d = this.earthRadius();
        return Math.toDegrees(Math.acos(d / (d + (double)this.altitude)));
    }

    private double zenithAngle() {
        return 90.83333333333333 + this.sunAngleOfAltitude();
    }

    private static void check(double d, double d2, int n, String string) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new IllegalArgumentException("Latitude must be a finite value: " + d);
        }
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException("Longitude must be a finite value: " + d2);
        }
        if (Double.compare(d, 90.0) > 0 || Double.compare(d, -90.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -90.0 <= latitude <= +90.0: " + d);
        }
        if (Double.compare(d2, 180.0) >= 0 || Double.compare(d2, -180.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -180.0 <= longitude < +180.0: " + d2);
        }
        if (n < -1000 || n > 9999) {
            throw new IllegalArgumentException("Meters out of range -1000 <= altitude < +10,000: " + n);
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Missing calculator.");
        }
        if (!CALCULATORS.containsKey(string)) {
            throw new IllegalArgumentException("Unknown calculator: " + string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        SolarTime.check(this.latitude, this.longitude, this.altitude, this.calculator);
    }

    static /* synthetic */ Calculator access$1000() {
        return DEFAULT_CALCULATOR;
    }

    static {
        Calculator calculator = null;
        HashMap<String, Calculator> hashMap = new HashMap<String, Calculator>();
        Iterator<Calculator> iterator = ResourceLoader.getInstance().services(Calculator.class).iterator();
        while (iterator.hasNext()) {
            Calculator calculator2;
            calculator = calculator2 = iterator.next();
            hashMap.put(calculator2.name(), calculator2);
        }
        hashMap.put("SIMPLE", StdCalculator.SIMPLE);
        hashMap.put("NOAA", StdCalculator.NOAA);
        CALCULATORS = Collections.unmodifiableMap(hashMap);
        DEFAULT_CALCULATOR = calculator == null ? StdCalculator.NOAA : calculator;
    }

    private static enum StdCalculator implements Calculator
    {
        SIMPLE{

            @Override
            public Moment sunrise(CalendarDate calendarDate, double d, double d2, double d3) {
                return this.event(calendarDate, d, d2, d3, true);
            }

            @Override
            public Moment sunset(CalendarDate calendarDate, double d, double d2, double d3) {
                return this.event(calendarDate, d, d2, d3, false);
            }

            @Override
            public double equationOfTime(double d) {
                double d2 = this.time0(d);
                return (-7.66 * Math.sin(Math.toRadians(0.9856 * d2 - 3.8)) - 9.78 * Math.sin(Math.toRadians(1.9712 * d2 + 17.96))) * 60.0;
            }

            @Override
            public double declination(double d) {
                double d2 = this.time0(d);
                double d3 = this.trueLongitudeOfSunInDegrees(d2);
                double d4 = 0.39782 * Math.sin(Math.toRadians(d3));
                return Math.toDegrees(Math.asin(d4));
            }

            private double time0(double d) {
                PlainTimestamp plainTimestamp = JulianDay.ofEphemerisTime(d).toMoment().toZonalTimestamp(ZonalOffset.UTC);
                return (double)plainTimestamp.getCalendarDate().getDayOfYear() + (double)((Integer)plainTimestamp.getWallTime().get(PlainTime.SECOND_OF_DAY)).intValue() / 86400.0;
            }

            private double trueLongitudeOfSunInDegrees(double d) {
                double d2 = 0.9856 * d - 3.289;
                double d3 = d2 + 1.916 * Math.sin(Math.toRadians(d2)) + 0.02 * Math.sin(2.0 * Math.toRadians(d2)) + 282.634;
                return this.adjustRange(d3);
            }

            private Moment event(CalendarDate calendarDate, double d, double d2, double d3, boolean bl) {
                double d4;
                PlainDate plainDate = SolarTime.toGregorian(calendarDate);
                int n = plainDate.getDayOfYear();
                double d5 = d2 / 15.0;
                double d6 = (double)n + ((double)(bl ? 6 : 18) - d5) / 24.0;
                double d7 = this.trueLongitudeOfSunInDegrees(d6);
                double d8 = Math.toDegrees(Math.atan(0.91764 * Math.tan(Math.toRadians(d7))));
                d8 = this.adjustRange(d8);
                double d9 = Math.floor(d7 / 90.0) * 90.0;
                double d10 = Math.floor(d8 / 90.0) * 90.0;
                d8 = (d8 + (d9 - d10)) / 15.0;
                double d11 = 0.39782 * Math.sin(Math.toRadians(d7));
                double d12 = Math.cos(Math.asin(d11));
                double d13 = Math.toRadians(d);
                double d14 = (Math.cos(Math.toRadians(d3)) - d11 * Math.sin(d13)) / (d12 * Math.cos(d13));
                if (Double.compare(d14, 1.0) > 0 || Double.compare(d14, -1.0) < 0) {
                    return null;
                }
                double d15 = Math.toDegrees(Math.acos(d14));
                if (bl) {
                    d15 = 360.0 - d15;
                }
                if (Double.compare(0.0, d4 = (d15 /= 15.0) + d8 - 0.06571 * d6 - 6.622) > 0) {
                    d4 += 24.0;
                } else if (Double.compare(24.0, d4) <= 0) {
                    d4 -= 24.0;
                }
                double d16 = d4 - d5;
                int n2 = (int)Math.floor(d16 * 3600.0);
                long l = plainDate.get(EpochDays.UTC) * 86400L + (long)n2;
                Moment moment = Moment.of(Math.round((double)l / 60.0) * 60L, TimeScale.UT);
                return (Moment)moment.with(Moment.PRECISION, TimeUnit.MINUTES);
            }

            private double adjustRange(double d) {
                while (Double.compare(0.0, d) > 0) {
                    d += 360.0;
                }
                while (Double.compare(d, 360.0) >= 0) {
                    d -= 360.0;
                }
                return d;
            }
        }
        ,
        NOAA{

            @Override
            public Moment sunrise(CalendarDate calendarDate, double d, double d2, double d3) {
                return this.event(true, calendarDate, d, d2, d3);
            }

            @Override
            public Moment sunset(CalendarDate calendarDate, double d, double d2, double d3) {
                return this.event(false, calendarDate, d, d2, d3);
            }

            @Override
            public double equationOfTime(double d) {
                double d2 = (d - 2451545.0) / 36525.0;
                double d3 = Math.tan(Math.toRadians(this.obliquity(d2) / 2.0));
                double d4 = d3 * d3;
                double d5 = Math.toRadians(2.0 * this.meanLongitude(d2));
                double d6 = this.excentricity(d2);
                double d7 = Math.toRadians(this.meanAnomaly(d2));
                double d8 = Math.sin(d7);
                double d9 = d4 * Math.sin(d5) - 2.0 * d6 * d8 + 4.0 * d6 * d4 * d8 * Math.cos(d5) - d4 * d4 * Math.sin(2.0 * d5) / 2.0 - 5.0 * d6 * d6 * Math.sin(2.0 * d7) / 4.0;
                return Math.toDegrees(d9) * 240.0;
            }

            @Override
            public double declination(double d) {
                double d2 = (d - 2451545.0) / 36525.0;
                return Math.toDegrees(this.declinationRad(d2));
            }

            private Moment event(boolean bl, CalendarDate calendarDate, double d, double d2, double d3) {
                Moment moment = SolarTime.fromLocalEvent(calendarDate, 12, d2, this.name());
                double d4 = JulianDay.getValue(moment, TimeScale.TT);
                double d5 = this.localHourAngle(bl, d4, d, d3);
                if (Double.isNaN(d5)) {
                    return null;
                }
                if (Double.isNaN(d5 = this.localHourAngle(bl, d4 + d5 / 86400.0, d, d3))) {
                    return null;
                }
                long l = (long)Math.floor(d5);
                int n = (int)((d5 - (double)l) * 1.0E9);
                Moment moment2 = (Moment)((Moment)moment.plus(l, TimeUnit.SECONDS)).plus((long)n, TimeUnit.NANOSECONDS);
                return (Moment)moment2.with(Moment.PRECISION, TimeUnit.SECONDS);
            }

            private double localHourAngle(boolean bl, double d, double d2, double d3) {
                double d4 = (d - 2451545.0) / 36525.0;
                double d5 = this.localHourAngle(d4, d2, d3);
                if (Double.isNaN(d5)) {
                    return Double.NaN;
                }
                if (bl) {
                    d5 = -d5;
                }
                return d5;
            }

            private double obliquity(double d) {
                double d2 = 23.433333333333334 + (21.448 + (-46.815 + (-5.9E-4 + 0.001813 * d) * d) * d) / 3600.0;
                double d3 = 0.00256 * Math.cos(Math.toRadians(125.04 - 1934.136 * d));
                return d2 + d3;
            }

            private double meanLongitude(double d) {
                return (280.46646 + (36000.76983 + 3.032E-4 * d) * d) % 360.0;
            }

            private double meanAnomaly(double d) {
                return 357.52911 + (35999.05029 - 1.537E-4 * d) * d;
            }

            private double excentricity(double d) {
                return 0.016708634 - (4.2037E-5 + 1.267E-7 * d) * d;
            }

            private double localHourAngle(double d, double d2, double d3) {
                double d4 = Math.toRadians(d2);
                double d5 = this.declinationRad(d);
                double d6 = (Math.cos(Math.toRadians(d3)) - Math.sin(d5) * Math.sin(d4)) / (Math.cos(d5) * Math.cos(d4));
                if (Double.compare(d6, 1.0) > 0 || Double.compare(d6, -1.0) < 0) {
                    return Double.NaN;
                }
                return Math.toDegrees(Math.acos(d6)) * 240.0;
            }

            private double declinationRad(double d) {
                return Math.asin(Math.sin(Math.toRadians(this.obliquity(d))) * Math.sin(Math.toRadians(this.apparentLongitude(d))));
            }

            private double apparentLongitude(double d) {
                return this.meanLongitude(d) + this.equationOfCenter(d) - 0.00569 - 0.00478 * Math.sin(Math.toRadians(125.04 - 1934.136 * d));
            }

            private double equationOfCenter(double d) {
                double d2 = Math.toRadians(this.meanAnomaly(d));
                return Math.sin(d2) * (1.914602 - (0.004817 + 1.4E-5 * d) * d) + Math.sin(2.0 * d2) * (0.019993 - 1.01E-4 * d) + Math.sin(3.0 * d2) * 2.89E-4;
            }
        };

    }

    public static class Sunshine {
        private final Moment startUTC;
        private final Moment endUTC;
        private final PlainTimestamp startLocal;
        private final PlainTimestamp endLocal;

        private Sunshine(PlainDate plainDate, Moment moment, Moment moment2, TZID tZID, boolean bl) {
            if (bl) {
                this.startUTC = null;
                this.endUTC = null;
                this.startLocal = null;
                this.endLocal = null;
            } else if (moment != null) {
                this.startUTC = moment;
                this.startLocal = this.startUTC.toZonalTimestamp(tZID);
                if (moment2 != null) {
                    this.endUTC = moment2;
                    this.endLocal = this.endUTC.toZonalTimestamp(tZID);
                } else {
                    PlainDate plainDate2 = (PlainDate)plainDate.plus(1L, CalendarUnit.DAYS);
                    this.endUTC = plainDate2.atFirstMoment(tZID);
                    this.endLocal = plainDate2.atStartOfDay(tZID);
                }
            } else if (moment2 != null) {
                this.startUTC = plainDate.atFirstMoment(tZID);
                this.startLocal = plainDate.atStartOfDay(tZID);
                this.endUTC = moment2;
                this.endLocal = this.endUTC.toZonalTimestamp(tZID);
            } else {
                this.startUTC = plainDate.atFirstMoment(tZID);
                this.startLocal = plainDate.atStartOfDay(tZID);
                PlainDate plainDate3 = (PlainDate)plainDate.plus(1L, CalendarUnit.DAYS);
                this.endUTC = plainDate3.atFirstMoment(tZID);
                this.endLocal = plainDate3.atStartOfDay(tZID);
            }
        }

        public Moment startUTC() {
            return Sunshine.checkAndGet(this.startUTC);
        }

        public Moment endUTC() {
            return Sunshine.checkAndGet(this.endUTC);
        }

        public PlainTimestamp startLocal() {
            return Sunshine.checkAndGet(this.startLocal);
        }

        public PlainTimestamp endLocal() {
            return Sunshine.checkAndGet(this.endLocal);
        }

        public boolean isPresent(Moment moment) {
            if (this.isAbsent()) {
                return false;
            }
            return !this.startUTC.isAfter(moment) && moment.isBefore(this.endUTC);
        }

        public boolean isPresent(PlainTimestamp plainTimestamp) {
            if (this.isAbsent()) {
                return false;
            }
            return !this.startLocal.isAfter(plainTimestamp) && plainTimestamp.isBefore(this.endLocal);
        }

        public boolean isAbsent() {
            return this.startUTC == null;
        }

        public int length() {
            if (this.isAbsent()) {
                return 0;
            }
            return (int)this.startUTC.until(this.endUTC, TimeUnit.SECONDS);
        }

        public String toString() {
            if (this.isAbsent()) {
                return "Polar night";
            }
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("Sunshine[");
            stringBuilder.append("utc=");
            stringBuilder.append(this.startUTC);
            stringBuilder.append('/');
            stringBuilder.append(this.endUTC);
            stringBuilder.append(",local=");
            stringBuilder.append(this.startLocal);
            stringBuilder.append('/');
            stringBuilder.append(this.endLocal);
            stringBuilder.append(",length=");
            stringBuilder.append(this.length());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        private static <T> T checkAndGet(T t) {
            if (t == null) {
                throw new IllegalStateException("Sunshine is absent (polar night).");
            }
            return t;
        }
    }

    public static interface Calculator {
        public static final String NOAA = "NOAA";
        public static final String SIMPLE = "SIMPLE";

        public String name();

        public Moment sunrise(CalendarDate var1, double var2, double var4, double var6);

        public Moment sunset(CalendarDate var1, double var2, double var4, double var6);

        public double equationOfTime(double var1);

        public double declination(double var1);
    }

    public static class Builder {
        private double latitude = Double.NaN;
        private double longitude = Double.NaN;
        private int altitude = 0;
        private String calculator = SolarTime.access$1000().name();

        private Builder() {
        }

        public Builder northernLatitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 90);
            this.latitude = (double)n + (double)n2 / 60.0 + d / 3600.0;
            return this;
        }

        public Builder southernLatitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 90);
            this.latitude = -1.0 * ((double)n + (double)n2 / 60.0 + d / 3600.0);
            return this;
        }

        public Builder easternLongitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 179);
            this.longitude = (double)n + (double)n2 / 60.0 + d / 3600.0;
            return this;
        }

        public Builder westernLongitude(int n, int n2, double d) {
            Builder.check(n, n2, d, 180);
            this.longitude = -1.0 * ((double)n + (double)n2 / 60.0 + d / 3600.0);
            return this;
        }

        public Builder atAltitude(int n) {
            if (n < -1000 || n > 9999) {
                throw new IllegalArgumentException("Meters out of range -1000 <= altitude < +10,000: " + n);
            }
            this.altitude = n;
            return this;
        }

        public Builder usingCalculator(String string) {
            if (string.isEmpty()) {
                throw new IllegalArgumentException("Missing calculator.");
            }
            this.calculator = string;
            return this;
        }

        public SolarTime build() {
            if (Double.isNaN(this.latitude)) {
                throw new IllegalStateException("Latitude was not yet set.");
            }
            if (Double.isNaN(this.longitude)) {
                throw new IllegalStateException("Longitude was not yet set.");
            }
            return new SolarTime(this.latitude, this.longitude, this.altitude, this.calculator);
        }

        private static void check(int n, int n2, double d, int n3) {
            if (n < 0 || n > n3 || n == n3 && n3 != 179 && (n2 > 0 || Double.compare(d, 0.0) > 0)) {
                double d2 = (double)n + (double)n2 / 60.0 + d / 3600.0;
                throw new IllegalArgumentException("Degrees out of range: " + n + " (decimal=" + d2 + ")");
            }
            if (n2 < 0 || n2 >= 60) {
                throw new IllegalArgumentException("Arc minutes out of range: " + n2);
            }
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                throw new IllegalArgumentException("Arc seconds must be finite.");
            }
            if (Double.compare(d, 0.0) < 0 || Double.compare(d, 60.0) >= 0) {
                throw new IllegalArgumentException("Arc seconds out of range: " + d);
            }
        }
    }
}

