/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.Locale;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.YearDefinition;
import net.time4j.history.internal.HistoricAttribute;
import net.time4j.history.internal.StdHistoricalElement;

public class HistoricExtension
implements ChronoExtension {
    @Override
    public boolean accept(Class<?> clazz) {
        return clazz == PlainDate.class;
    }

    @Override
    public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
        return HistoricExtension.getHistory(locale, attributeQuery).getElements();
    }

    @Override
    public ChronoEntity<?> resolve(ChronoEntity<?> chronoEntity, Locale locale, AttributeQuery attributeQuery) {
        ChronoHistory chronoHistory = HistoricExtension.getHistory(locale, attributeQuery);
        HistoricEra historicEra = null;
        if (chronoEntity.contains(chronoHistory.era())) {
            historicEra = chronoEntity.get(chronoHistory.era());
        } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
            historicEra = HistoricEra.AD;
        }
        if (historicEra != null && chronoEntity.contains(chronoHistory.yearOfEra())) {
            int n = chronoEntity.get(chronoHistory.yearOfEra());
            if (chronoEntity.contains(chronoHistory.month()) && chronoEntity.contains(chronoHistory.dayOfMonth())) {
                YearDefinition yearDefinition = attributeQuery.get(ChronoHistory.YEAR_DEFINITION, YearDefinition.DUAL_DATING);
                int n2 = chronoEntity.get(chronoHistory.month());
                int n3 = chronoEntity.get(chronoHistory.dayOfMonth());
                HistoricDate historicDate = HistoricDate.of(historicEra, n, n2, n3, yearDefinition, chronoHistory.getNewYearStrategy());
                PlainDate plainDate = chronoHistory.convert(historicDate);
                chronoEntity.with(chronoHistory.era(), null);
                chronoEntity.with(chronoHistory.yearOfEra(), null);
                chronoEntity.with(chronoHistory.month(), null);
                chronoEntity.with(chronoHistory.dayOfMonth(), null);
                return chronoEntity.with(PlainDate.COMPONENT, plainDate);
            }
            if (chronoEntity.contains(chronoHistory.dayOfYear())) {
                int n4 = chronoEntity.get(chronoHistory.dayOfYear());
                if (chronoEntity.contains(StdHistoricalElement.YEAR_OF_DISPLAY)) {
                    n = chronoEntity.getInt(StdHistoricalElement.YEAR_OF_DISPLAY);
                }
                HistoricDate historicDate = chronoHistory.getBeginOfYear(historicEra, n);
                PlainDate plainDate = (PlainDate)chronoHistory.convert(historicDate).with((ChronoElement<Integer>)chronoHistory.dayOfYear(), n4);
                return chronoEntity.with(PlainDate.COMPONENT, plainDate);
            }
        }
        return chronoEntity;
    }

    private static ChronoHistory getHistory(Locale locale, AttributeQuery attributeQuery) {
        if (attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601").equals("julian")) {
            return ChronoHistory.PROLEPTIC_JULIAN;
        }
        if (attributeQuery.contains(HistoricAttribute.CALENDAR_HISTORY)) {
            return attributeQuery.get(HistoricAttribute.CALENDAR_HISTORY);
        }
        return ChronoHistory.of(locale);
    }
}

