/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.LocalizedGMTProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class TimezoneGenericProcessor
implements FormatProcessor<TZID> {
    private static final Map<NameStyle, ConcurrentMap<Locale, TZNames>> CACHE_ZONENAMES = new EnumMap<NameStyle, ConcurrentMap<Locale, TZNames>>(NameStyle.class);
    private static final int MAX = 25;
    private static final String DEFAULT_PROVIDER = "DEFAULT";
    private final NameStyle style;
    private final FormatProcessor<TZID> fallback;
    private final Set<TZID> preferredZones;
    private final Leniency lenientMode;
    private final Locale locale;

    TimezoneGenericProcessor(NameStyle nameStyle) {
        this.style = nameStyle;
        this.fallback = new LocalizedGMTProcessor(nameStyle.isAbbreviation());
        this.preferredZones = null;
        this.lenientMode = Leniency.SMART;
        this.locale = Locale.ROOT;
    }

    TimezoneGenericProcessor(NameStyle nameStyle, Set<TZID> set) {
        this.style = nameStyle;
        this.fallback = new LocalizedGMTProcessor(nameStyle.isAbbreviation());
        this.preferredZones = Collections.unmodifiableSet(new LinkedHashSet<TZID>(set));
        this.lenientMode = Leniency.SMART;
        this.locale = Locale.ROOT;
    }

    private TimezoneGenericProcessor(NameStyle nameStyle, FormatProcessor<TZID> formatProcessor, Set<TZID> set, Leniency leniency, Locale locale) {
        this.style = nameStyle;
        this.fallback = formatProcessor;
        this.preferredZones = set;
        this.lenientMode = leniency;
        this.locale = locale;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        TZID tZID;
        if (chronoDisplay.hasTimezone()) {
            tZID = chronoDisplay.getTimezone();
        } else if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
            tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
        } else {
            throw new IllegalArgumentException("Cannot extract timezone name in style " + (Object)((Object)this.style) + " from: " + chronoDisplay);
        }
        if (tZID instanceof ZonalOffset) {
            return this.fallback.print(chronoDisplay, appendable, attributeQuery, set, bl);
        }
        String string = Timezone.of(tZID).getDisplayName(this.style, bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        if (string.equals(tZID.canonical())) {
            return this.fallback.print(chronoDisplay, appendable, attributeQuery, set, bl);
        }
        int n = -1;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        int n2 = string.length();
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
        return n2;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        Object object;
        int n;
        List<TZID> list;
        Object object2;
        char c;
        int n2 = charSequence.length();
        int n3 = parseLog.getPosition();
        int n4 = n3;
        if (n4 >= n2) {
            parseLog.setError(n3, "Missing timezone name in style " + (Object)((Object)this.style) + ".");
            return;
        }
        Locale locale = bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        Leniency leniency = bl ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        StringBuilder stringBuilder = new StringBuilder();
        while (n4 < n2 && (Character.isLetter(c = charSequence.charAt(n4)) || !this.style.isAbbreviation() && n4 > n3 && !Character.isDigit(c))) {
            stringBuilder.append(c);
            ++n4;
        }
        String string = stringBuilder.toString().trim();
        n4 = n3 + string.length();
        if (string.startsWith("GMT") || string.startsWith("UT")) {
            this.fallback.parse(charSequence, parseLog, attributeQuery, parsedEntity, bl);
            return;
        }
        ConcurrentMap<Locale, TZNames> concurrentMap = CACHE_ZONENAMES.get((Object)this.style);
        Object object3 = (TZNames)concurrentMap.get(locale);
        if (object3 == null) {
            object2 = this.getTimezoneNameMap(locale);
            object3 = new TZNames((Map<String, List<TZID>>)object2);
            if (concurrentMap.size() < 25 && (list = concurrentMap.putIfAbsent(locale, (TZNames)object3)) != null) {
                object3 = list;
            }
        }
        if ((n = (list = TimezoneGenericProcessor.readZones((TZNames)object3, string, object2 = new int[]{n4})).size()) == 0) {
            parseLog.setError(n3, "Unknown timezone name: " + string);
            return;
        }
        if (n > 1 && !leniency.isStrict()) {
            list = TimezoneGenericProcessor.excludeWinZones(list);
            n = list.size();
        }
        List<TZID> list2 = list;
        if (n > 1 && !leniency.isLax()) {
            object = attributeQuery.get(Attributes.TIMEZONE_ID, ZonalOffset.UTC);
            if (object instanceof ZonalOffset) {
                list = this.resolveUsingPreferred(list, locale, leniency);
            } else {
                boolean bl2 = false;
                for (TZID tZID : list) {
                    if (!tZID.canonical().equals(object.canonical())) continue;
                    list = Collections.singletonList(tZID);
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    list = this.resolveUsingPreferred(list, locale, leniency);
                }
            }
        }
        if ((n = list.size()) == 0) {
            object = new ArrayList();
            for (TZID tZID : list2) {
                object.add(tZID.canonical());
            }
            parseLog.setError(n3, "Time zone name \"" + string + "\" not found among preferred timezones in locale " + locale + ", style=" + (Object)((Object)this.style) + ", candidates=" + object);
            return;
        }
        if (n > 1) {
            object = null;
            for (TZID tZID : list) {
                if (tZID.canonical().indexOf(126) != -1) continue;
                if (object == null) {
                    object = new ArrayList<String>();
                }
                object.add(tZID);
            }
            if (object != null) {
                list = object;
                n = list.size();
            }
        }
        if (n == 1 || leniency.isLax()) {
            parsedEntity.put(TimezoneElement.TIMEZONE_ID, list.get(0));
            parseLog.setPosition(object2[0]);
        } else {
            parseLog.setError(n3, "Time zone name of style " + (Object)((Object)this.style) + " is not unique: \"" + string + "\" in " + TimezoneGenericProcessor.toString(list));
        }
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_ID;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<TZID> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        return new TimezoneGenericProcessor(this.style, this.fallback, this.preferredZones, attributeQuery.get(Attributes.LENIENCY, Leniency.SMART), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TimezoneGenericProcessor) {
            TimezoneGenericProcessor timezoneGenericProcessor = (TimezoneGenericProcessor)object;
            return this.style == timezoneGenericProcessor.style && (this.preferredZones == null ? timezoneGenericProcessor.preferredZones == null : this.preferredZones.equals(timezoneGenericProcessor.preferredZones));
        }
        return false;
    }

    public int hashCode() {
        return this.style.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[style=");
        stringBuilder.append((Object)this.style);
        stringBuilder.append(", preferredZones=");
        stringBuilder.append(this.preferredZones);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private Map<String, List<TZID>> getTimezoneNameMap(Locale locale) {
        HashMap<String, ArrayList<TZID>> hashMap = new HashMap<String, ArrayList<TZID>>();
        for (TZID tZID : Timezone.getAvailableIDs()) {
            String string = Timezone.getDisplayName(tZID, this.style, locale);
            if (string.equals(tZID.canonical())) continue;
            ArrayList<TZID> arrayList = (ArrayList<TZID>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<TZID>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(tZID);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static List<TZID> readZones(TZNames tZNames, String string, int[] nArray) {
        int n;
        List<TZID> list = tZNames.search(string);
        if (list.isEmpty() && !Character.isLetter(string.charAt(n = string.length() - 1)) && !(list = tZNames.search(string.substring(0, n))).isEmpty()) {
            nArray[0] = nArray[0] - 1;
        }
        return list;
    }

    private static List<TZID> excludeWinZones(List<TZID> list) {
        if (list.size() > 1) {
            ArrayList<TZID> arrayList = new ArrayList<TZID>(list);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                TZID tZID = list.get(i);
                if (!tZID.canonical().startsWith("WINDOWS~")) continue;
                arrayList.remove(tZID);
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private List<TZID> resolveUsingPreferred(List<TZID> list, Locale locale, Leniency leniency) {
        void var6_13;
        HashMap hashMap = new HashMap();
        hashMap.put(DEFAULT_PROVIDER, new ArrayList());
        block0: for (TZID object2 : list) {
            String string = object2.canonical();
            Set<TZID> set = this.preferredZones;
            String string2 = DEFAULT_PROVIDER;
            int n = string.indexOf(126);
            if (n >= 0) {
                string2 = string.substring(0, n);
            }
            if (set == null) {
                set = Timezone.getPreferredIDs(locale, leniency.isSmart(), string2);
            }
            for (TZID tZID : set) {
                if (!tZID.canonical().equals(string)) continue;
                ArrayList<TZID> arrayList = (ArrayList<TZID>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<TZID>();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(tZID);
                continue block0;
            }
        }
        Object object3 = (List)hashMap.get(DEFAULT_PROVIDER);
        List<TZID> list2 = list;
        if (object3.isEmpty()) {
            hashMap.remove(DEFAULT_PROVIDER);
            boolean bl = false;
            for (String string2 : hashMap.keySet()) {
                object3 = (List)hashMap.get(string2);
                if (object3.isEmpty()) continue;
                bl = true;
                Object object = object3;
                break;
            }
            if (!bl) {
                List list3 = Collections.emptyList();
            }
        } else {
            Object object = object3;
        }
        return var6_13;
    }

    private static String toString(List<TZID> list) {
        StringBuilder stringBuilder = new StringBuilder(list.size() * 16);
        stringBuilder.append('{');
        boolean bl = true;
        for (TZID tZID : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(tZID.canonical());
        }
        return stringBuilder.append('}').toString();
    }

    static {
        for (NameStyle nameStyle : NameStyle.values()) {
            CACHE_ZONENAMES.put(nameStyle, new ConcurrentHashMap());
        }
    }

    private static class TZNames {
        private final Map<String, List<TZID>> names;

        TZNames(Map<String, List<TZID>> map) {
            this.names = map;
        }

        List<TZID> search(String string) {
            if (this.names.containsKey(string)) {
                return this.names.get(string);
            }
            return Collections.emptyList();
        }
    }
}

