/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Locale;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.format.Attributes;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.tz.ZonalOffset;

public class Iso8601Format {
    private static final char ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
    private static final NonZeroCondition NON_ZERO_SECOND = new NonZeroCondition(PlainTime.SECOND_OF_MINUTE);
    private static final NonZeroCondition NON_ZERO_FRACTION = new NonZeroCondition(PlainTime.NANO_OF_SECOND);
    private static final ChronoCondition<ChronoDisplay> SECOND_PART = NON_ZERO_SECOND.or(NON_ZERO_FRACTION);
    private static final ChronoCondition<Character> T_CONDITION = new TCondition();
    public static final ChronoFormatter<PlainDate> BASIC_CALENDAR_DATE = Iso8601Format.calendarFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_CALENDAR_DATE = Iso8601Format.calendarFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_ORDINAL_DATE = Iso8601Format.ordinalFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_ORDINAL_DATE = Iso8601Format.ordinalFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_WEEK_DATE = Iso8601Format.weekdateFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_WEEK_DATE = Iso8601Format.weekdateFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_DATE = Iso8601Format.generalDateFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_DATE = Iso8601Format.generalDateFormat(true);
    public static final ChronoFormatter<PlainTime> BASIC_WALL_TIME = Iso8601Format.timeFormat(false);
    public static final ChronoFormatter<PlainTime> EXTENDED_WALL_TIME = Iso8601Format.timeFormat(true);
    public static final ChronoFormatter<PlainTimestamp> BASIC_DATE_TIME = Iso8601Format.timestampFormat(false);
    public static final ChronoFormatter<PlainTimestamp> EXTENDED_DATE_TIME = Iso8601Format.timestampFormat(true);
    public static final ChronoFormatter<Moment> BASIC_DATE_TIME_OFFSET = Iso8601Format.momentFormat(false);
    public static final ChronoFormatter<Moment> EXTENDED_DATE_TIME_OFFSET = Iso8601Format.momentFormat(true);

    private Iso8601Format() {
    }

    public static PlainDate parseDate(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        PlainDate plainDate = Iso8601Format.parseDate(charSequence, parseLog);
        if (plainDate == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < charSequence.length()) {
            throw new ParseException("Trailing characters found: " + charSequence, parseLog.getPosition());
        }
        return plainDate;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PlainDate parseDate(CharSequence charSequence, ParseLog parseLog) {
        PlainDate plainDate;
        int n;
        int n2;
        int n3 = 0;
        int n4 = charSequence.length();
        int n5 = n4 - (n2 = parseLog.getPosition());
        if (n5 < 7) {
            parseLog.setError(n4, "Too short to be compatible with ISO-8601: " + charSequence.subSequence(n2, n4));
            return null;
        }
        block5: for (n = n2 + 1; n < n4; ++n) {
            switch (charSequence.charAt(n)) {
                case '-': {
                    ++n3;
                    break;
                }
                case 'W': {
                    PlainDate plainDate2;
                    if (n3 > 0) {
                        plainDate2 = EXTENDED_WEEK_DATE.parse(charSequence, parseLog);
                        return plainDate2;
                    }
                    plainDate2 = BASIC_WEEK_DATE.parse(charSequence, parseLog);
                    return plainDate2;
                }
                case '/': 
                case 'T': {
                    n5 = n - n2;
                    break block5;
                }
            }
        }
        if (n3 != 0) {
            if (n3 != 1) return EXTENDED_CALENDAR_DATE.parse(charSequence, parseLog);
            return EXTENDED_ORDINAL_DATE.parse(charSequence, parseLog);
        }
        n5 -= 4;
        n = charSequence.charAt(n2);
        if (n == 43 || n == 45) {
            n5 -= 2;
        }
        if (n5 == 3) {
            plainDate = BASIC_ORDINAL_DATE.parse(charSequence, parseLog);
            return plainDate;
        }
        plainDate = BASIC_CALENDAR_DATE.parse(charSequence, parseLog);
        return plainDate;
    }

    private static ChronoFormatter<PlainDate> calendarFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger(PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger(PlainDate.MONTH_AS_NUMBER, 2);
        if (bl) {
            builder.addLiteral('-');
        }
        return builder.addFixedInteger(PlainDate.DAY_OF_MONTH, 2).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> ordinalFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger(PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        return builder.addFixedInteger(PlainDate.DAY_OF_YEAR, 3).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> weekdateFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger(PlainDate.YEAR_OF_WEEKDATE, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addLiteral('W');
        builder.addFixedInteger(Weekmodel.ISO.weekOfYear(), 2);
        if (bl) {
            builder.addLiteral('-');
        }
        return builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, 1).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> generalDateFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl), Iso8601Format.generalDateParser(bl));
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainTime> timeFormat(boolean bl) {
        ChronoFormatter.Builder<PlainTime> builder = ChronoFormatter.setUp(PlainTime.class, Locale.ROOT);
        builder.skipUnknown(T_CONDITION, 1);
        Iso8601Format.addWallTime(builder, bl);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainTimestamp> timestampFormat(boolean bl) {
        ChronoFormatter.Builder<PlainTimestamp> builder = ChronoFormatter.setUp(PlainTimestamp.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl), Iso8601Format.generalDateParser(bl));
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, bl);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<Moment> momentFormat(boolean bl) {
        ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
        builder.addCustomized(Moment.axis().element(), Iso8601Format.momentFormat(DisplayMode.MEDIUM, bl), Iso8601Format.momentFormat(DisplayMode.SHORT, bl));
        return ((ChronoFormatter)builder.build().with(Leniency.STRICT)).withTimezone(ZonalOffset.UTC);
    }

    private static ChronoFormatter<Moment> momentFormat(DisplayMode displayMode, boolean bl) {
        ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl), Iso8601Format.generalDateParser(bl));
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, bl);
        builder.addTimezoneOffset(displayMode, bl, Collections.singletonList("Z"));
        return builder.build();
    }

    private static ChronoPrinter<PlainDate> generalDatePrinter(final boolean bl) {
        return new ChronoPrinter<PlainDate>(){

            @Override
            public <R> R print(PlainDate plainDate, Appendable appendable, AttributeQuery attributeQuery, ChronoFunction<ChronoDisplay, R> chronoFunction) throws IOException {
                ChronoFormatter<PlainDate> chronoFormatter = bl ? EXTENDED_CALENDAR_DATE : BASIC_CALENDAR_DATE;
                chronoFormatter.formatToBuffer(plainDate, appendable);
                return null;
            }
        };
    }

    private static ChronoParser<PlainDate> generalDateParser(final boolean bl) {
        return new ChronoParser<PlainDate>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public PlainDate parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
                int n;
                int n2 = 0;
                int n3 = charSequence.length();
                int n4 = parseLog.getPosition();
                int n5 = n3 - n4;
                block5: for (n = n4 + 1; n < n3; ++n) {
                    switch (charSequence.charAt(n)) {
                        case '-': {
                            ++n2;
                            break;
                        }
                        case 'W': {
                            if (bl) {
                                return EXTENDED_WEEK_DATE.parse(charSequence, parseLog);
                            }
                            return BASIC_WEEK_DATE.parse(charSequence, parseLog);
                        }
                        case '/': 
                        case 'T': {
                            n5 = n - n4;
                            break block5;
                        }
                    }
                }
                if (bl) {
                    if (n2 == 1) {
                        return EXTENDED_ORDINAL_DATE.parse(charSequence, parseLog);
                    }
                    return EXTENDED_CALENDAR_DATE.parse(charSequence, parseLog);
                }
                n5 -= 4;
                n = charSequence.charAt(n4);
                if (n == 43 || n == 45) {
                    n5 -= 2;
                }
                if (n5 == 3) {
                    return BASIC_ORDINAL_DATE.parse(charSequence, parseLog);
                }
                return BASIC_CALENDAR_DATE.parse(charSequence, parseLog);
            }
        };
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean bl) {
        builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        builder.startSection(Attributes.ZERO_DIGIT, 48);
        builder.addFixedInteger(PlainTime.ISO_HOUR, 2);
        builder.startOptionalSection();
        if (bl) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger(PlainTime.MINUTE_OF_HOUR, 2);
        builder.startOptionalSection(SECOND_PART);
        if (bl) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger(PlainTime.SECOND_OF_MINUTE, 2);
        builder.startOptionalSection(NON_ZERO_FRACTION);
        if (ISO_DECIMAL_SEPARATOR == ',') {
            builder.addLiteral(',', '.');
        } else {
            builder.addLiteral('.', ',');
        }
        builder.addFraction(PlainTime.NANO_OF_SECOND, 0, 9, false);
        for (int i = 0; i < 5; ++i) {
            builder.endSection();
        }
    }

    private static class TCondition
    implements ChronoCondition<Character> {
        private TCondition() {
        }

        @Override
        public boolean test(Character c) {
            return c.charValue() == 'T';
        }
    }

    private static class NonZeroCondition
    implements ChronoCondition<ChronoDisplay> {
        private final ChronoElement<Integer> element;

        NonZeroCondition(ChronoElement<Integer> chronoElement) {
            this.element = chronoElement;
        }

        @Override
        public boolean test(ChronoDisplay chronoDisplay) {
            return chronoDisplay.getInt(this.element) > 0;
        }

        ChronoCondition<ChronoDisplay> or(final NonZeroCondition nonZeroCondition) {
            return new ChronoCondition<ChronoDisplay>(){

                @Override
                public boolean test(ChronoDisplay chronoDisplay) {
                    return NonZeroCondition.this.test(chronoDisplay) || nonZeroCondition.test(chronoDisplay);
                }
            };
        }
    }
}

