/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceControl;

public final class GenericTextProviderSPI
implements TextProvider {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Set<String> TYPES;
    private static final Set<String> LANGUAGES;
    private static final Set<Locale> LOCALES;
    private static final ResourceBundle.Control CONTROL;

    @Override
    public boolean supportsCalendarType(String string) {
        return TYPES.contains(string);
    }

    @Override
    public boolean supportsLanguage(Locale locale) {
        return true;
    }

    @Override
    public String[] getSupportedCalendarTypes() {
        return TYPES.toArray(new String[TYPES.size()]);
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LOCALES.toArray(new Locale[LOCALES.size()]);
    }

    @Override
    public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
        if (string.equals("roc") || string.equals("buddhist")) {
            List<String> list = CalendarText.getIsoInstance(locale).getStdMonths(textWidth, outputContext).getTextForms();
            return list.toArray(new String[list.size()]);
        }
        if (string.equals("japanese")) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"};
        }
        ResourceBundle resourceBundle = GenericTextProviderSPI.getBundle(string, locale);
        if (textWidth == TextWidth.SHORT) {
            textWidth = TextWidth.ABBREVIATED;
        }
        String string2 = GenericTextProviderSPI.getKey(resourceBundle, "MONTH_OF_YEAR");
        String[] stringArray = GenericTextProviderSPI.lookupBundle(resourceBundle, GenericTextProviderSPI.countOfMonths(string), string2, textWidth, outputContext, bl, 1);
        if (stringArray == null) {
            if (outputContext == OutputContext.STANDALONE) {
                if (textWidth != TextWidth.NARROW) {
                    stringArray = this.months(string, locale, textWidth, OutputContext.FORMAT, bl);
                }
            } else if (textWidth == TextWidth.ABBREVIATED) {
                stringArray = this.months(string, locale, TextWidth.WIDE, OutputContext.FORMAT, bl);
            } else if (textWidth == TextWidth.NARROW) {
                stringArray = this.months(string, locale, textWidth, OutputContext.STANDALONE, bl);
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find calendar month.", GenericTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    @Override
    public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return EMPTY_STRINGS;
    }

    @Override
    public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return EMPTY_STRINGS;
    }

    @Override
    public String[] eras(String string, Locale locale, TextWidth textWidth) {
        if (string.equals("japanese")) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"M", "T", "S", "H"};
            }
            return new String[]{"Meiji", "Taish\u014d", "Sh\u014dwa", "Heisei"};
        }
        ResourceBundle resourceBundle = GenericTextProviderSPI.getBundle(string, locale);
        if (textWidth == TextWidth.SHORT) {
            textWidth = TextWidth.ABBREVIATED;
        }
        String string2 = GenericTextProviderSPI.getKey(resourceBundle, "ERA");
        String[] stringArray = GenericTextProviderSPI.lookupBundle(resourceBundle, GenericTextProviderSPI.countOfEras(string), string2, textWidth, OutputContext.FORMAT, false, 0);
        if (stringArray == null && textWidth != TextWidth.ABBREVIATED) {
            stringArray = this.eras(string, locale, TextWidth.ABBREVIATED);
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find calendar resource for era.", GenericTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    @Override
    public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
        return EMPTY_STRINGS;
    }

    @Override
    public String[] meridiems(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return EMPTY_STRINGS;
    }

    @Override
    public ResourceBundle.Control getControl() {
        return CONTROL;
    }

    public String toString() {
        return "GenericTextProviderSPI";
    }

    static ResourceBundle getBundle(String string, Locale locale) {
        return ResourceBundle.getBundle("names/" + string, LANGUAGES.contains(LanguageMatch.getAlias(locale)) ? locale : Locale.ROOT, GenericTextProviderSPI.getDefaultLoader(), CONTROL);
    }

    private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth, OutputContext outputContext, boolean bl, int n2) {
        String[] stringArray = new String[n];
        boolean bl2 = string.length() == 1;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('(');
            if (bl2) {
                char c = textWidth.name().charAt(0);
                if (outputContext != OutputContext.STANDALONE) {
                    c = Character.toLowerCase(c);
                }
                stringBuilder.append(c);
            } else {
                stringBuilder.append(textWidth.name());
                if (outputContext == OutputContext.STANDALONE) {
                    stringBuilder.append('|');
                    stringBuilder.append(outputContext.name());
                }
                if (bl) {
                    stringBuilder.append('|');
                    stringBuilder.append("LEAP");
                }
            }
            stringBuilder.append(')');
            stringBuilder.append('_');
            stringBuilder.append(i + n2);
            String string2 = stringBuilder.toString();
            if (!resourceBundle.containsKey(string2)) {
                return null;
            }
            stringArray[i] = resourceBundle.getString(string2);
        }
        return stringArray;
    }

    private static String getKey(ResourceBundle resourceBundle, String string) {
        if (resourceBundle.containsKey("useShortKeys") && "true".equals(resourceBundle.getString("useShortKeys"))) {
            return string.substring(0, 1);
        }
        return string;
    }

    private static ClassLoader getDefaultLoader() {
        return GenericTextProviderSPI.class.getClassLoader();
    }

    private static int countOfMonths(String string) {
        return string.equals("coptic") || string.equals("ethiopic") || string.equals("generic") ? 13 : 12;
    }

    private static int countOfEras(String string) {
        return string.equals("ethiopic") || string.equals("generic") || string.equals("roc") || string.equals("buddhist") ? 2 : 1;
    }

    static {
        CONTROL = new UTF8ResourceControl(){

            @Override
            protected String getModuleName() {
                return "calendar";
            }

            @Override
            protected Class<?> getModuleRef() {
                return GenericTextProviderSPI.class;
            }
        };
        ResourceBundle resourceBundle = ResourceBundle.getBundle("names/generic", Locale.ROOT, GenericTextProviderSPI.getDefaultLoader(), CONTROL);
        String[] stringArray = resourceBundle.getString("languages").split(" ");
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, stringArray);
        hashSet.add("");
        LANGUAGES = Collections.unmodifiableSet(hashSet);
        HashSet<Locale> hashSet2 = new HashSet<Locale>();
        for (String string : LANGUAGES) {
            if (string.isEmpty()) {
                hashSet2.add(Locale.ROOT);
                continue;
            }
            hashSet2.add(new Locale(string));
        }
        LOCALES = Collections.unmodifiableSet(hashSet2);
        HashSet hashSet3 = new HashSet();
        hashSet3.add("buddhist");
        hashSet3.add("coptic");
        hashSet3.add("ethiopic");
        hashSet3.add("extra/frenchrev");
        hashSet3.add("generic");
        hashSet3.add("indian");
        hashSet3.add("islamic");
        hashSet3.add("japanese");
        hashSet3.add("persian");
        hashSet3.add("roc");
        TYPES = Collections.unmodifiableSet(hashSet3);
    }
}

