/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.time4j.PlainTime;
import net.time4j.calendar.EthiopianTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;

public class EthiopianExtension
implements ChronoExtension {
    @Override
    public boolean accept(Class<?> clazz) {
        return false;
    }

    @Override
    public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
        HashSet<ChronoElement<Integer>> hashSet = new HashSet<ChronoElement<Integer>>();
        hashSet.add(EthiopianTime.ETHIOPIAN_HOUR);
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public ChronoEntity<?> resolve(ChronoEntity<?> chronoEntity, Locale locale, AttributeQuery attributeQuery) {
        if (chronoEntity.contains(EthiopianTime.ETHIOPIAN_HOUR)) {
            int n = chronoEntity.get(EthiopianTime.ETHIOPIAN_HOUR);
            if (n == 12) {
                n = 0;
            }
            if ((n += 6) >= 12) {
                n -= 12;
            }
            chronoEntity = chronoEntity.with((ChronoElement<Integer>)PlainTime.DIGITAL_HOUR_OF_AMPM, n);
        }
        return chronoEntity;
    }
}

