/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class LocalizedGMTProcessor
implements FormatProcessor<TZID> {
    private static final ZonalOffset PROTOTYPE = ZonalOffset.ofTotalSeconds(64800);
    private static final ConcurrentMap<Locale, String> UTC_LITERALS = new ConcurrentHashMap<Locale, String>();
    private static final ConcurrentMap<Locale, Info> STD_PATTERN_INFOS = new ConcurrentHashMap<Locale, Info>();
    private final boolean abbreviated;
    private final boolean caseInsensitive;
    private final boolean noPrefix;
    private final Locale locale;
    private final String plusSign;
    private final String minusSign;
    private final char zeroDigit;
    private final Leniency lenientMode;

    LocalizedGMTProcessor(boolean bl) {
        this(bl, true, false, Locale.ROOT, "+", "-", '0', Leniency.SMART);
    }

    private LocalizedGMTProcessor(boolean bl, boolean bl2, boolean bl3, Locale locale, String string, String string2, char c, Leniency leniency) {
        this.abbreviated = bl;
        this.caseInsensitive = bl2;
        this.noPrefix = bl3;
        this.locale = locale;
        this.plusSign = string;
        this.minusSign = string2;
        this.zeroDigit = c;
        this.lenientMode = leniency;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        ZonalOffset zonalOffset;
        int n = -1;
        int n2 = 0;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        TZID tZID = null;
        if (chronoDisplay.hasTimezone()) {
            tZID = chronoDisplay.getTimezone();
        }
        if (tZID == null) {
            zonalOffset = LocalizedGMTProcessor.getOffset(chronoDisplay, attributeQuery);
        } else if (tZID instanceof ZonalOffset) {
            zonalOffset = (ZonalOffset)tZID;
        } else if (chronoDisplay instanceof UnixTime) {
            zonalOffset = Timezone.of(tZID).getOffset((UnixTime)((Object)chronoDisplay));
        } else {
            throw new IllegalArgumentException("Cannot extract timezone offset from: " + chronoDisplay);
        }
        Locale locale = bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        char c = bl ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        String string = bl ? this.plusSign : attributeQuery.get(AttributeSet.PLUS_SIGN, "+");
        String string2 = bl ? this.minusSign : attributeQuery.get(AttributeSet.MINUS_SIGN, "-");
        boolean bl2 = bl ? this.noPrefix : attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE);
        int n3 = zonalOffset.getIntegralAmount();
        int n4 = zonalOffset.getFractionalAmount();
        if (!bl2 && n3 == 0 && n4 == 0) {
            String string3 = LocalizedGMTProcessor.getLiteralUTC(locale);
            appendable.append(string3);
            n2 = string3.length();
        } else {
            Info info = LocalizedGMTProcessor.getPatternInfo(locale);
            int n5 = info.pattern.length();
            for (int i = 0; i < n5; ++i) {
                int n6;
                char c2 = info.pattern.charAt(i);
                if (info.start > i || info.end <= i) {
                    if (bl2) continue;
                    appendable.append(c2);
                    ++n2;
                    continue;
                }
                if (zonalOffset.getSign() == OffsetSign.BEHIND_UTC) {
                    appendable.append(string2);
                    n2 += string2.length();
                } else {
                    appendable.append(string);
                    n2 += string.length();
                }
                int n7 = zonalOffset.getAbsoluteHours();
                int n8 = zonalOffset.getAbsoluteMinutes();
                int n9 = zonalOffset.getAbsoluteSeconds();
                if (n7 < 10 && !this.abbreviated) {
                    appendable.append(c);
                    ++n2;
                }
                String string4 = String.valueOf(n7);
                for (int j = 0; j < string4.length(); ++j) {
                    n6 = string4.charAt(j) - 48 + c;
                    appendable.append((char)n6);
                    ++n2;
                }
                if (n8 != 0 || n9 != 0 || !this.abbreviated) {
                    int n10;
                    appendable.append(info.separator);
                    n2 += info.separator.length();
                    if (n8 < 10) {
                        appendable.append(c);
                        ++n2;
                    }
                    String string5 = String.valueOf(n8);
                    for (n6 = 0; n6 < string5.length(); ++n6) {
                        n10 = string5.charAt(n6) - 48 + c;
                        appendable.append((char)n10);
                        ++n2;
                    }
                    if (n9 != 0) {
                        appendable.append(info.separator);
                        n2 += info.separator.length();
                        if (n9 < 10) {
                            appendable.append(c);
                            ++n2;
                        }
                        String string6 = String.valueOf(n9);
                        for (n10 = 0; n10 < string6.length(); ++n10) {
                            char c3 = (char)(string6.charAt(n10) - 48 + c);
                            appendable.append(c3);
                            ++n2;
                        }
                    }
                }
                i = info.end - 1;
            }
        }
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        int n = charSequence.length();
        int n2 = parseLog.getPosition();
        int n3 = n2;
        if (n3 >= n) {
            parseLog.setError(n2, "Missing localized time zone offset.");
            return;
        }
        Locale locale = bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        boolean bl2 = CalendarText.isRTL(locale);
        boolean bl3 = bl ? this.noPrefix : attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE);
        boolean bl4 = bl ? this.caseInsensitive : attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        char c = bl ? this.zeroDigit : attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue();
        String string = bl ? this.plusSign : attributeQuery.get(AttributeSet.PLUS_SIGN, "+");
        String string2 = bl ? this.minusSign : attributeQuery.get(AttributeSet.MINUS_SIGN, "-");
        Info info = LocalizedGMTProcessor.getPatternInfo(locale);
        int n4 = info.pattern.length();
        ZonalOffset zonalOffset = null;
        int n5 = n3;
        for (int i = 0; i < n4; ++i) {
            OffsetSign offsetSign;
            int n6;
            int n7;
            char c2 = info.pattern.charAt(i);
            if (info.start > i || info.end <= i) {
                char c3;
                if (bl3) continue;
                char c4 = c3 = n3 < n ? charSequence.charAt(n3) : (char)'\u0000';
                if (!bl4 && c2 == c3 || bl4 && LocalizedGMTProcessor.charEqualsIgnoreCase(c2, c3)) {
                    ++n3;
                    continue;
                }
                n7 = LocalizedGMTProcessor.parseUTC(charSequence, n, n5, locale, bl4);
                if (n7 > 0) {
                    parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                    parseLog.setPosition(n5 + n7);
                } else {
                    parseLog.setError(n2, "Literal mismatched in localized time zone offset.");
                }
                return;
            }
            n7 = LiteralProcessor.subSequenceEquals(charSequence, n3, string, bl4, bl2);
            if (n7 == -1) {
                n7 = LiteralProcessor.subSequenceEquals(charSequence, n3, string2, bl4, bl2);
                if (n7 == -1) {
                    int n8 = n6 = bl3 ? 0 : LocalizedGMTProcessor.parseUTC(charSequence, n, n5, locale, bl4);
                    if (n6 > 0) {
                        parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                        parseLog.setPosition(n5 + n6);
                        return;
                    }
                    parseLog.setError(n2, "Missing sign in localized time zone offset.");
                    return;
                }
                offsetSign = OffsetSign.BEHIND_UTC;
            } else {
                offsetSign = OffsetSign.AHEAD_OF_UTC;
            }
            n6 = LocalizedGMTProcessor.parseHours(charSequence, n3 += n7, c);
            if (n6 == -1000) {
                parseLog.setError(n3, "Missing hour part in localized time zone offset.");
                return;
            }
            if (n6 < 0) {
                n6 ^= 0xFFFFFFFF;
                ++n3;
            } else {
                n3 += 2;
            }
            if (n3 >= n) {
                if (this.abbreviated) {
                    parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours(offsetSign, n6));
                    parseLog.setPosition(n3);
                } else {
                    parseLog.setError(n3, "Missing minute part in localized time zone offset.");
                }
                return;
            }
            Leniency leniency = bl ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
            int n9 = LiteralProcessor.subSequenceEquals(charSequence, n3, info.separator, bl4, bl2);
            if (n9 != -1) {
                n3 += n9;
            } else {
                if (this.abbreviated) {
                    parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours(offsetSign, n6));
                    parseLog.setPosition(n3);
                    return;
                }
                if (leniency.isStrict()) {
                    parseLog.setError(n3, "Mismatch of localized time zone offset separator.");
                    return;
                }
            }
            int n10 = LocalizedGMTProcessor.parseTwoDigits(charSequence, n3, c);
            if (n10 == -1000) {
                parseLog.setError(n3, "Minute part in localized time zone offset does not match expected pattern mm.");
                return;
            }
            int n11 = 0;
            if ((n3 += 2) < n && (n9 = LiteralProcessor.subSequenceEquals(charSequence, n3, info.separator, bl4, bl2)) != -1) {
                n11 = LocalizedGMTProcessor.parseTwoDigits(charSequence, n3 += n9, c);
                n3 = n11 == -1000 ? (n3 -= n9) : (n3 += 2);
            }
            if (n11 == 0 || n11 == -1000) {
                zonalOffset = ZonalOffset.ofHoursMinutes(offsetSign, n6, n10);
            } else {
                int n12 = n6 * 3600 + n10 * 60 + n11;
                if (offsetSign == OffsetSign.BEHIND_UTC) {
                    n12 = -n12;
                }
                zonalOffset = ZonalOffset.ofTotalSeconds(n12);
            }
            i = info.end - 1;
        }
        if (zonalOffset == null) {
            parseLog.setError(n3, "Unable to determine localized time zone offset.");
        } else {
            parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, zonalOffset);
            parseLog.setPosition(n3);
        }
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_OFFSET;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<TZID> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        return new LocalizedGMTProcessor(this.abbreviated, attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE), attributeQuery.get(Attributes.NO_GMT_PREFIX, Boolean.FALSE), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT), attributeQuery.get(AttributeSet.PLUS_SIGN, "+"), attributeQuery.get(AttributeSet.MINUS_SIGN, "-"), attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf('0')).charValue(), attributeQuery.get(Attributes.LENIENCY, Leniency.SMART));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalizedGMTProcessor) {
            LocalizedGMTProcessor localizedGMTProcessor = (LocalizedGMTProcessor)object;
            return this.abbreviated == localizedGMTProcessor.abbreviated;
        }
        return false;
    }

    public int hashCode() {
        return this.abbreviated ? 1 : 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[abbreviated=");
        stringBuilder.append(this.abbreviated);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static ZonalOffset getOffset(ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
        TZID tZID;
        if (attributeQuery.contains(Attributes.TIMEZONE_ID) && (tZID = attributeQuery.get(Attributes.TIMEZONE_ID)) instanceof ZonalOffset) {
            return (ZonalOffset)tZID;
        }
        throw new IllegalArgumentException("Cannot extract timezone offset from format attributes for: " + chronoDisplay);
    }

    private static int parseUTC(CharSequence charSequence, int n, int n2, Locale locale, boolean bl) {
        String[] stringArray;
        String string = LocalizedGMTProcessor.getLiteralUTC(locale);
        for (String string2 : stringArray = new String[]{"GMT", string, "UTC", "UT"}) {
            int n3 = string2.length();
            if (n - n2 < n3) continue;
            String string3 = charSequence.subSequence(n2, n2 + n3).toString();
            if ((!bl || !string3.equalsIgnoreCase(string2)) && (bl || !string3.equals(string2))) continue;
            return n3;
        }
        return 0;
    }

    private static int parseTwoDigits(CharSequence charSequence, int n, char c) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            if (n + i >= charSequence.length()) {
                return -1000;
            }
            int n3 = charSequence.charAt(n + i) - c;
            if (n3 < 0 || n3 > 9) {
                return -1000;
            }
            n2 = n2 * 10 + n3;
        }
        return n2;
    }

    private static int parseHours(CharSequence charSequence, int n, char c) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            if (n + i >= charSequence.length()) {
                if (i == 0) {
                    return -1000;
                }
                return ~n2;
            }
            int n3 = charSequence.charAt(n + i) - c;
            if (n3 < 0 || n3 > 9) {
                if (i == 0) {
                    return -1000;
                }
                return ~n2;
            }
            n2 = n2 * 10 + n3;
        }
        return n2;
    }

    private static boolean charEqualsIgnoreCase(char c, char c2) {
        return c == c2 || Character.toUpperCase(c) == Character.toUpperCase(c2) || Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    private static String getLiteralUTC(Locale locale) {
        String string;
        String string2 = (String)UTC_LITERALS.get(locale);
        if (string2 == null && (string = UTC_LITERALS.putIfAbsent(locale, string2 = ZonalOffset.UTC.getStdFormatPattern(locale))) != null) {
            string2 = string;
        }
        return string2;
    }

    private static Info getPatternInfo(Locale locale) {
        Info info = (Info)STD_PATTERN_INFOS.get(locale);
        if (info == null) {
            String string = PROTOTYPE.getStdFormatPattern(locale);
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                int n2;
                if (string.charAt(i) != '\u00b1') continue;
                int n3 = string.indexOf("hh", i) + 2;
                info = new Info(string, string.substring(n3, n2 = string.indexOf("mm", n3)), i, n2 + 2);
                Info info2 = STD_PATTERN_INFOS.putIfAbsent(locale, info);
                if (info2 == null) break;
                info = info2;
                break;
            }
        }
        assert (info != null);
        return info;
    }

    private static class Info {
        private final String pattern;
        private final String separator;
        private final int start;
        private final int end;

        Info(String string, String string2, int n, int n2) {
            this.pattern = string;
            this.separator = string2;
            this.start = n;
            this.end = n2;
        }
    }
}

