/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.time4j.base.MathUtils;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.HijriEra;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.VariantSource;

public enum HijriAlgorithm implements VariantSource
{
    EAST_ISLAMIC_CIVIL("islamic-eastc", new int[]{2, 5, 7, 10, 13, 15, 18, 21, 24, 26, 29}, true),
    EAST_ISLAMIC_ASTRO("islamic-easta", new int[]{2, 5, 7, 10, 13, 15, 18, 21, 24, 26, 29}, false),
    WEST_ISLAMIC_CIVIL("islamic-civil", new int[]{2, 5, 7, 10, 13, 16, 18, 21, 24, 26, 29}, true),
    WEST_ISLAMIC_ASTRO("islamic-tbla", new int[]{2, 5, 7, 10, 13, 16, 18, 21, 24, 26, 29}, false),
    FATIMID_CIVIL("islamic-fatimidc", new int[]{2, 5, 8, 10, 13, 16, 19, 21, 24, 27, 29}, true),
    FATIMID_ASTRO("islamic-fatimida", new int[]{2, 5, 8, 10, 13, 16, 19, 21, 24, 27, 29}, false),
    HABASH_AL_HASIB_CIVIL("islamic-habashalhasibc", new int[]{2, 5, 8, 11, 13, 16, 19, 21, 24, 27, 30}, true),
    HABASH_AL_HASIB_ASTRO("islamic-habashalhasiba", new int[]{2, 5, 8, 11, 13, 16, 19, 21, 24, 27, 30}, false);

    private static final long LENGTH_OF_30_YEAR_CYCLE;
    private static final long START_622_07_15;
    private static final long START_622_07_16;
    private static final int MAX_YEAR;
    private static final long ASTRO_1600_12_29;
    private static final long CIVIL_1600_12_29;
    private final transient Transformer calsys;

    private HijriAlgorithm(String string2, int[] nArray, boolean bl) {
        this.calsys = new Transformer(string2, nArray, bl);
    }

    @Override
    public String getVariant() {
        return this.calsys.variant;
    }

    EraYearMonthDaySystem<HijriCalendar> getCalendarSystem() {
        return this.calsys;
    }

    static {
        LENGTH_OF_30_YEAR_CYCLE = 10631L;
        START_622_07_15 = -492879L;
        START_622_07_16 = START_622_07_15 + 1L;
        MAX_YEAR = 1600;
        ASTRO_1600_12_29 = 74106L;
        CIVIL_1600_12_29 = ASTRO_1600_12_29 + 1L;
    }

    private static class Transformer
    implements EraYearMonthDaySystem<HijriCalendar> {
        private final String variant;
        private final int[] intercalaries;
        private final boolean civil;

        Transformer(String string, int[] nArray, boolean bl) {
            this.variant = string;
            this.intercalaries = nArray;
            this.civil = bl;
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            return calendarEra == HijriEra.ANNO_HEGIRAE && n >= 1 && n <= MAX_YEAR && n2 >= 1 && n2 <= 12 && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            if (calendarEra != HijriEra.ANNO_HEGIRAE) {
                throw new IllegalArgumentException("Wrong era: " + calendarEra);
            }
            if (n < 1 || n > MAX_YEAR || n2 < 1 || n2 > 12) {
                throw new IllegalArgumentException("Out of bounds: " + n + "/" + n2);
            }
            if (n2 == 12) {
                int n3 = (n - 1) % 30 + 1;
                return Arrays.binarySearch(this.intercalaries, n3) >= 0 ? 30 : 29;
            }
            return n2 % 2 == 1 ? 30 : 29;
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            if (calendarEra != HijriEra.ANNO_HEGIRAE) {
                throw new IllegalArgumentException("Wrong era: " + calendarEra);
            }
            if (n < 1 || n > MAX_YEAR) {
                throw new IllegalArgumentException("Out of bounds: yearOfEra=" + n);
            }
            int n2 = (n - 1) % 30 + 1;
            return Arrays.binarySearch(this.intercalaries, n2) >= 0 ? 355 : 354;
        }

        @Override
        public HijriCalendar transform(long l) {
            int n;
            int n2;
            long l2 = this.getMinimumSinceUTC();
            if (l < l2 || l > this.getMaximumSinceUTC()) {
                throw new IllegalArgumentException("Out of supported range: " + l);
            }
            long l3 = MathUtils.safeSubtract(l, l2);
            int n3 = 1;
            int n4 = 1;
            int n5 = 1;
            n3 += MathUtils.safeCast(l3 / LENGTH_OF_30_YEAR_CYCLE * 30L);
            int n6 = (int)(l3 % LENGTH_OF_30_YEAR_CYCLE);
            for (n2 = 1; n2 < 30; ++n2) {
                n = 354;
                if (Arrays.binarySearch(this.intercalaries, n2) >= 0) {
                    ++n;
                }
                if (n6 <= n) break;
                n6 -= n;
                ++n3;
            }
            for (n2 = 1; n2 < 12; ++n2) {
                n = 30;
                if (n2 % 2 == 0) {
                    n = 29;
                }
                if (n6 <= n) break;
                n6 -= n;
                ++n4;
            }
            n5 += n6;
            if (n4 == 12) {
                n = (n3 - 1) % 30 + 1;
                n2 = Arrays.binarySearch(this.intercalaries, n) >= 0 ? 30 : 29;
            } else {
                int n7 = n2 = n4 % 2 == 1 ? 30 : 29;
            }
            if (n5 > n2) {
                n5 = 1;
                if (++n4 > 12) {
                    n4 = 1;
                    ++n3;
                }
            }
            return HijriCalendar.of(this.variant, n3, n4, n5);
        }

        @Override
        public long transform(HijriCalendar hijriCalendar) {
            int n;
            int n2 = hijriCalendar.getYear();
            int n3 = hijriCalendar.getMonth().getValue();
            int n4 = hijriCalendar.getDayOfMonth();
            if (n2 < 1 || n2 > MAX_YEAR || n3 < 1 || n3 > 12 || n4 < 1 || n4 > 30) {
                throw new IllegalArgumentException("Out of supported range: " + hijriCalendar);
            }
            long l = (long)((n2 - 1) / 30) * LENGTH_OF_30_YEAR_CYCLE;
            int n5 = (n2 - 1) % 30 + 1;
            for (n = 1; n < n5; ++n) {
                if (Arrays.binarySearch(this.intercalaries, n) >= 0) {
                    l += 355L;
                    continue;
                }
                l += 354L;
            }
            for (n = 1; n < n3; ++n) {
                if (n % 2 == 0) {
                    l += 29L;
                    continue;
                }
                l += 30L;
            }
            if (n4 == 30 && (n3 == 12 && Arrays.binarySearch(this.intercalaries, n5) < 0 || n3 != 12 && n3 % 2 == 0)) {
                throw new IllegalArgumentException("Invalid day-of-month: " + hijriCalendar);
            }
            return this.getMinimumSinceUTC() + (l += (long)n4) - 1L;
        }

        @Override
        public long getMinimumSinceUTC() {
            return this.civil ? START_622_07_16 : START_622_07_15;
        }

        @Override
        public long getMaximumSinceUTC() {
            return this.civil ? CIVIL_1600_12_29 : ASTRO_1600_12_29;
        }

        @Override
        public List<CalendarEra> getEras() {
            HijriEra hijriEra = HijriEra.ANNO_HEGIRAE;
            return Collections.singletonList(hijriEra);
        }
    }
}

