/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.CopticEra;
import net.time4j.calendar.CopticMonth;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.SPX;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="coptic")
public final class CopticCalendar
extends Calendrical<Unit, CopticCalendar>
implements LocalizedPatternSupport {
    private static final long DIOCLETIAN;
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<CopticEra> ERA;
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, CopticCalendar> YEAR_OF_ERA;
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<CopticMonth, CopticCalendar> MONTH_OF_YEAR;
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, CopticCalendar> DAY_OF_MONTH;
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, CopticCalendar> DAY_OF_YEAR;
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, CopticCalendar> DAY_OF_WEEK;
    private static final EraYearMonthDaySystem<CopticCalendar> CALSYS;
    private static final TimeAxis<Unit, CopticCalendar> ENGINE;
    private static final long serialVersionUID = -8248846000788617742L;
    private final transient int cyear;
    private final transient int cmonth;
    private final transient int cdom;

    private CopticCalendar(int n, int n2, int n3) {
        this.cyear = n;
        this.cmonth = n2;
        this.cdom = n3;
    }

    public static CopticCalendar of(int n, CopticMonth copticMonth, int n2) {
        return CopticCalendar.of(n, copticMonth.getValue(), n2);
    }

    public static CopticCalendar of(int n, int n2, int n3) {
        if (!CALSYS.isValid(CopticEra.ANNO_MARTYRUM, n, n2, n3)) {
            throw new IllegalArgumentException("Invalid Coptic date: year=" + n + ", month=" + n2 + ", day=" + n3);
        }
        return new CopticCalendar(n, n2, n3);
    }

    public static CopticCalendar nowInSystemTime() {
        return (CopticCalendar)SystemClock.inLocalView().now(CopticCalendar.axis());
    }

    public CopticEra getEra() {
        return CopticEra.ANNO_MARTYRUM;
    }

    public int getYear() {
        return this.cyear;
    }

    public CopticMonth getMonth() {
        return CopticMonth.valueOf(this.cmonth);
    }

    public int getDayOfMonth() {
        return this.cdom;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return (Integer)this.get(DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, this.cyear, this.cmonth);
    }

    public int lengthOfYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public boolean isLeapYear() {
        return this.cyear % 4 == 3;
    }

    public GeneralTimestamp<CopticCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<CopticCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CopticCalendar) {
            CopticCalendar copticCalendar = (CopticCalendar)object;
            return this.cdom == copticCalendar.cdom && this.cmonth == copticCalendar.cmonth && this.cyear == copticCalendar.cyear;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.cdom + 31 * this.cmonth + 37 * this.cyear;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("A.M.-");
        String string = String.valueOf(this.cyear);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (this.cmonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.cmonth);
        stringBuilder.append('-');
        if (this.cdom < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.cdom);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SATURDAY, 1, Weekday.FRIDAY, Weekday.SATURDAY);
    }

    public static TimeAxis<Unit, CopticCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, CopticCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected CopticCalendar getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this, 3);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Object object = ChronoHistory.PROLEPTIC_JULIAN.convert(HistoricDate.of(HistoricEra.AD, 284, 8, 29));
        DIOCLETIAN = ((ChronoEntity)object).get(EpochDays.UTC);
        ERA = new StdEnumDateElement<CopticEra, CopticCalendar>("ERA", CopticCalendar.class, CopticEra.class, 'G');
        YEAR_OF_ERA = new StdIntegerDateElement<CopticCalendar>("YEAR_OF_ERA", CopticCalendar.class, 1, 9999, 'y', null, null);
        MONTH_OF_YEAR = new StdEnumDateElement<CopticMonth, CopticCalendar>("MONTH_OF_YEAR", CopticCalendar.class, CopticMonth.class, 'M');
        DAY_OF_MONTH = new StdIntegerDateElement<CopticCalendar>("DAY_OF_MONTH", CopticCalendar.class, 1, 30, 'd');
        DAY_OF_YEAR = new StdIntegerDateElement<CopticCalendar>("DAY_OF_YEAR", CopticCalendar.class, 1, 365, 'D');
        DAY_OF_WEEK = new StdWeekdayElement<CopticCalendar>(CopticCalendar.class);
        CALSYS = new Transformer();
        object = ((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, CopticCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement(YEAR_OF_ERA, new IntegerRule(0), Unit.YEARS).appendElement(MONTH_OF_YEAR, new MonthRule(), Unit.MONTHS).appendElement(DAY_OF_MONTH, new IntegerRule(2), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule(), Unit.DAYS).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<CopticCalendar>(CALSYS, DAY_OF_YEAR))).appendUnit(Unit.YEARS, new CopticUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit(Unit.MONTHS, new CopticUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit(Unit.WEEKS, new CopticUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new CopticUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS)).appendExtension(new CommonElements.Weekengine(CopticCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, CopticCalendar.getDefaultWeekmodel()));
        ENGINE = ((TimeAxis.Builder)object).build();
    }

    private static class CopticUnitRule
    implements UnitRule<CopticCalendar> {
        private final Unit unit;

        CopticUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public CopticCalendar addTo(CopticCalendar copticCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    l = MathUtils.safeMultiply(l, 13L);
                }
                case MONTHS: {
                    long l2 = MathUtils.safeAdd((long)CopticUnitRule.ymValue(copticCalendar), l);
                    int n = MathUtils.safeCast(MathUtils.floorDivide(l2, 13));
                    int n2 = MathUtils.floorModulo(l2, 13) + 1;
                    int n3 = Math.min(copticCalendar.cdom, CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, n, n2));
                    return CopticCalendar.of(n, n2, n3);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply(l, 7L);
                }
                case DAYS: {
                    long l3 = MathUtils.safeAdd(CALSYS.transform(copticCalendar), l);
                    return (CopticCalendar)CALSYS.transform(l3);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(CopticCalendar copticCalendar, CopticCalendar copticCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    return Unit.MONTHS.between(copticCalendar, copticCalendar2) / 13;
                }
                case MONTHS: {
                    long l = CopticUnitRule.ymValue(copticCalendar2) - CopticUnitRule.ymValue(copticCalendar);
                    if (l > 0L && copticCalendar2.cdom < copticCalendar.cdom) {
                        --l;
                    } else if (l < 0L && copticCalendar2.cdom > copticCalendar.cdom) {
                        ++l;
                    }
                    return l;
                }
                case WEEKS: {
                    return Unit.DAYS.between(copticCalendar, copticCalendar2) / 7;
                }
                case DAYS: {
                    return CALSYS.transform(copticCalendar2) - CALSYS.transform(copticCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        private static int ymValue(CopticCalendar copticCalendar) {
            return copticCalendar.cyear * 13 + copticCalendar.cmonth - 1;
        }
    }

    private static class Merger
    implements ChronoMerger<CopticCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("coptic", displayStyle, locale);
        }

        @Override
        public CopticCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (CopticCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        @Deprecated
        public CopticCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public CopticCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR_OF_ERA);
            if (n == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Coptic year.");
                return null;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                int n2 = ((CopticMonth)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                int n3 = chronoEntity.getInt(DAY_OF_MONTH);
                if (n3 != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(CopticEra.ANNO_MARTYRUM, n, n2, n3)) {
                        return CopticCalendar.of(n, n2, n3);
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Coptic date.");
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE) {
                    if (n4 > 0) {
                        int n5 = 1;
                        int n6 = 0;
                        while (n5 <= 13) {
                            int n7 = CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, n, n5);
                            if (n4 > n6 + n7) {
                                ++n5;
                                n6 += n7;
                                continue;
                            }
                            return CopticCalendar.of(n, n5, n4 - n6);
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Coptic date.");
                }
            }
            return null;
        }

        @Override
        public ChronoDisplay preformat(CopticCalendar copticCalendar, AttributeQuery attributeQuery) {
            return copticCalendar;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.EVENING;
        }
    }

    private static class WeekdayRule
    implements ElementRule<CopticCalendar, Weekday> {
        private WeekdayRule() {
        }

        @Override
        public Weekday getValue(CopticCalendar copticCalendar) {
            return copticCalendar.getDayOfWeek();
        }

        @Override
        public Weekday getMinimum(CopticCalendar copticCalendar) {
            return Weekday.SATURDAY;
        }

        @Override
        public Weekday getMaximum(CopticCalendar copticCalendar) {
            return Weekday.FRIDAY;
        }

        @Override
        public boolean isValid(CopticCalendar copticCalendar, Weekday weekday) {
            return weekday != null;
        }

        @Override
        public CopticCalendar withValue(CopticCalendar copticCalendar, Weekday weekday, boolean bl) {
            if (weekday == null) {
                throw new IllegalArgumentException("Missing weekday.");
            }
            Weekmodel weekmodel = CopticCalendar.getDefaultWeekmodel();
            int n = copticCalendar.getDayOfWeek().getValue(weekmodel);
            int n2 = weekday.getValue(weekmodel);
            return (CopticCalendar)copticCalendar.plus(CalendarDays.of(n2 - n));
        }

        @Override
        public ChronoElement<?> getChildAtFloor(CopticCalendar copticCalendar) {
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(CopticCalendar copticCalendar) {
            return null;
        }
    }

    private static class EraRule
    implements ElementRule<CopticCalendar, CopticEra> {
        private EraRule() {
        }

        @Override
        public CopticEra getValue(CopticCalendar copticCalendar) {
            return CopticEra.ANNO_MARTYRUM;
        }

        @Override
        public CopticEra getMinimum(CopticCalendar copticCalendar) {
            return CopticEra.ANNO_MARTYRUM;
        }

        @Override
        public CopticEra getMaximum(CopticCalendar copticCalendar) {
            return CopticEra.ANNO_MARTYRUM;
        }

        @Override
        public boolean isValid(CopticCalendar copticCalendar, CopticEra copticEra) {
            return copticEra != null;
        }

        @Override
        public CopticCalendar withValue(CopticCalendar copticCalendar, CopticEra copticEra, boolean bl) {
            if (copticEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return copticCalendar;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(CopticCalendar copticCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(CopticCalendar copticCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<CopticCalendar, CopticMonth> {
        private MonthRule() {
        }

        @Override
        public CopticMonth getValue(CopticCalendar copticCalendar) {
            return copticCalendar.getMonth();
        }

        @Override
        public CopticMonth getMinimum(CopticCalendar copticCalendar) {
            return CopticMonth.TOUT;
        }

        @Override
        public CopticMonth getMaximum(CopticCalendar copticCalendar) {
            return CopticMonth.NASIE;
        }

        @Override
        public boolean isValid(CopticCalendar copticCalendar, CopticMonth copticMonth) {
            return copticMonth != null;
        }

        @Override
        public CopticCalendar withValue(CopticCalendar copticCalendar, CopticMonth copticMonth, boolean bl) {
            if (copticMonth == null) {
                throw new IllegalArgumentException("Missing month.");
            }
            int n = copticMonth.getValue();
            int n2 = CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, copticCalendar.cyear, n);
            int n3 = Math.min(copticCalendar.cdom, n2);
            return new CopticCalendar(copticCalendar.cyear, n, n3);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(CopticCalendar copticCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(CopticCalendar copticCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements ElementRule<CopticCalendar, Integer> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public Integer getValue(CopticCalendar copticCalendar) {
            switch (this.index) {
                case 0: {
                    return copticCalendar.cyear;
                }
                case 2: {
                    return copticCalendar.cdom;
                }
                case 3: {
                    int n = 0;
                    for (int i = 1; i < copticCalendar.cmonth; ++i) {
                        n += CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, copticCalendar.cyear, i);
                    }
                    return n + copticCalendar.cdom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMinimum(CopticCalendar copticCalendar) {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMaximum(CopticCalendar copticCalendar) {
            switch (this.index) {
                case 0: {
                    return 9999;
                }
                case 2: {
                    return CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, copticCalendar.cyear, copticCalendar.cmonth);
                }
                case 3: {
                    return CALSYS.getLengthOfYear(CopticEra.ANNO_MARTYRUM, copticCalendar.cyear);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(CopticCalendar copticCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            Integer n2 = this.getMinimum(copticCalendar);
            Integer n3 = this.getMaximum(copticCalendar);
            return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
        }

        @Override
        public CopticCalendar withValue(CopticCalendar copticCalendar, Integer n, boolean bl) {
            if (!this.isValid(copticCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    int n2 = n;
                    int n3 = CALSYS.getLengthOfMonth(CopticEra.ANNO_MARTYRUM, n2, copticCalendar.cmonth);
                    int n4 = Math.min(copticCalendar.cdom, n3);
                    return CopticCalendar.of(n2, copticCalendar.cmonth, n4);
                }
                case 2: {
                    return new CopticCalendar(copticCalendar.cyear, copticCalendar.cmonth, n);
                }
                case 3: {
                    int n5 = n - this.getValue(copticCalendar);
                    return (CopticCalendar)copticCalendar.plus(CalendarDays.of(n5));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(CopticCalendar copticCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(CopticCalendar copticCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<CopticCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            return calendarEra == CopticEra.ANNO_MARTYRUM && n >= 1 && n <= 9999 && n2 >= 1 && n2 <= 13 && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            if (calendarEra != CopticEra.ANNO_MARTYRUM) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 9999 && n2 >= 1 && n2 <= 13) {
                if (n2 <= 12) {
                    return 30;
                }
                return n % 4 == 3 ? 6 : 5;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + n2);
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            if (calendarEra != CopticEra.ANNO_MARTYRUM) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 9999) {
                return n % 4 == 3 ? 366 : 365;
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n);
        }

        @Override
        public CopticCalendar transform(long l) {
            int n = MathUtils.safeCast(MathUtils.floorDivide(MathUtils.safeAdd(MathUtils.safeMultiply(4L, MathUtils.safeSubtract(l, DIOCLETIAN)), 1463L), 1461));
            int n2 = MathUtils.safeCast(this.transform(new CopticCalendar(n, 1, 1)));
            int n3 = 1 + MathUtils.safeCast(MathUtils.floorDivide(l - (long)n2, 30));
            int n4 = MathUtils.safeCast(this.transform(new CopticCalendar(n, n3, 1)));
            int n5 = 1 + MathUtils.safeCast(MathUtils.safeSubtract(l, (long)n4));
            return CopticCalendar.of(n, n3, n5);
        }

        @Override
        public long transform(CopticCalendar copticCalendar) {
            return DIOCLETIAN - 1L + (long)(365 * (copticCalendar.cyear - 1)) + (long)MathUtils.floorDivide(copticCalendar.cyear, 4) + (long)(30 * (copticCalendar.cmonth - 1)) + (long)copticCalendar.cdom;
        }

        @Override
        public long getMinimumSinceUTC() {
            CopticCalendar copticCalendar = new CopticCalendar(1, 1, 1);
            return this.transform(copticCalendar);
        }

        @Override
        public long getMaximumSinceUTC() {
            CopticCalendar copticCalendar = new CopticCalendar(9999, 13, 6);
            return this.transform(copticCalendar);
        }

        @Override
        public List<CalendarEra> getEras() {
            CopticEra copticEra = CopticEra.ANNO_MARTYRUM;
            return Collections.singletonList(copticEra);
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.15576E7),
        MONTHS(2592000.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public int between(CopticCalendar copticCalendar, CopticCalendar copticCalendar2) {
            return (int)copticCalendar.until(copticCalendar2, this);
        }
    }
}

