/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.spi;

import java.text.DateFormatSymbols;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.i18n.UTF8ResourceControl;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.ZoneNameProvider;
import net.time4j.tz.olson.AFRICA;
import net.time4j.tz.olson.AMERICA;
import net.time4j.tz.olson.ANTARCTICA;
import net.time4j.tz.olson.ASIA;
import net.time4j.tz.olson.ATLANTIC;
import net.time4j.tz.olson.AUSTRALIA;
import net.time4j.tz.olson.EUROPE;
import net.time4j.tz.olson.INDIAN;
import net.time4j.tz.olson.PACIFIC;

public class ZoneNameProviderSPI
implements ZoneNameProvider {
    private static final ConcurrentMap<Locale, Map<String, Map<NameStyle, String>>> NAMES = new ConcurrentHashMap<Locale, Map<String, Map<NameStyle, String>>>();
    private static final Set<String> GMT_ZONES;
    private static final Map<String, Set<String>> TERRITORIES;
    private static final Map<String, String> PRIMARIES;
    private static final ResourceBundle.Control CONTROL;

    @Override
    public Set<String> getPreferredIDs(Locale locale, boolean bl) {
        Object object;
        String string = locale.getCountry();
        if (bl) {
            if (string.equals("US")) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.add("America/New_York");
                linkedHashSet.add("America/Chicago");
                linkedHashSet.add("America/Denver");
                linkedHashSet.add("America/Los_Angeles");
                linkedHashSet.add("America/Anchorage");
                linkedHashSet.add("Pacific/Honolulu");
                linkedHashSet.add("America/Adak");
                return Collections.unmodifiableSet(linkedHashSet);
            }
            object = PRIMARIES.get(string);
            if (object != null) {
                return Collections.singleton(object);
            }
        }
        if ((object = TERRITORIES.get(string)) == null) {
            object = Collections.emptySet();
        }
        return object;
    }

    @Override
    public String getDisplayName(String string, NameStyle nameStyle, Locale locale) {
        Object object;
        if (GMT_ZONES.contains(string)) {
            return "";
        }
        Map map = (Map)NAMES.get(locale);
        if (map == null) {
            object = DateFormatSymbols.getInstance(locale);
            String[][] stringArray = ((DateFormatSymbols)object).getZoneStrings();
            map = new HashMap();
            for (String[] stringArray2 : stringArray) {
                EnumMap<NameStyle, String> enumMap = new EnumMap<NameStyle, String>(NameStyle.class);
                enumMap.put(NameStyle.LONG_STANDARD_TIME, stringArray2[1]);
                enumMap.put(NameStyle.SHORT_STANDARD_TIME, stringArray2[2]);
                enumMap.put(NameStyle.LONG_DAYLIGHT_TIME, stringArray2[3]);
                enumMap.put(NameStyle.SHORT_DAYLIGHT_TIME, stringArray2[4]);
                map.put(stringArray2[0], enumMap);
            }
            Map map2 = NAMES.putIfAbsent(locale, map);
            if (map2 != null) {
                map = map2;
            }
        }
        if ((object = (Map)map.get(string)) != null) {
            return (String)object.get((Object)nameStyle);
        }
        return "";
    }

    @Override
    public String getStdFormatPattern(boolean bl, Locale locale) {
        return ZoneNameProviderSPI.getBundle(locale).getString(bl ? "utc-literal" : "offset-pattern");
    }

    private static void addTerritory(Map<String, Set<String>> map, String string, TZID tZID) {
        Set<String> set = map.get(string);
        if (set == null) {
            set = new LinkedHashSet<String>();
            map.put(string, set);
        }
        set.add(tZID.canonical());
    }

    private static void addPrimary(Map<String, String> map, String string, TZID tZID) {
        map.put(string, tZID.canonical());
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("zones/tzname", locale, ZoneNameProviderSPI.class.getClassLoader(), CONTROL);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Z");
        hashSet.add("GMT");
        hashSet.add("GMT0");
        hashSet.add("Greenwich");
        hashSet.add("UCT");
        hashSet.add("UTC");
        hashSet.add("UTC0");
        hashSet.add("Universal");
        hashSet.add("Zulu");
        GMT_ZONES = Collections.unmodifiableSet(hashSet);
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        for (AFRICA aFRICA : AFRICA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, aFRICA.getCountry(), aFRICA);
        }
        for (AMERICA aMERICA : AMERICA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, aMERICA.getCountry(), aMERICA);
        }
        for (AMERICA.ARGENTINA aRGENTINA : AMERICA.ARGENTINA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, "AR", aRGENTINA);
        }
        for (AMERICA.INDIANA iNDIANA : AMERICA.INDIANA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, "US", iNDIANA);
        }
        for (AMERICA.KENTUCKY kENTUCKY : AMERICA.KENTUCKY.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, "US", kENTUCKY);
        }
        for (AMERICA.NORTH_DAKOTA nORTH_DAKOTA : AMERICA.NORTH_DAKOTA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, "US", nORTH_DAKOTA);
        }
        for (ANTARCTICA aNTARCTICA : ANTARCTICA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, aNTARCTICA.getCountry(), aNTARCTICA);
        }
        for (ASIA aSIA : ASIA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, aSIA.getCountry(), aSIA);
        }
        for (ATLANTIC aTLANTIC : ATLANTIC.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, aTLANTIC.getCountry(), aTLANTIC);
        }
        for (AUSTRALIA aUSTRALIA : AUSTRALIA.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, aUSTRALIA.getCountry(), aUSTRALIA);
        }
        for (EUROPE eUROPE : EUROPE.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, eUROPE.getCountry(), eUROPE);
        }
        for (INDIAN iNDIAN : INDIAN.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, iNDIAN.getCountry(), iNDIAN);
        }
        for (PACIFIC pACIFIC : PACIFIC.values()) {
            ZoneNameProviderSPI.addTerritory(hashMap, pACIFIC.getCountry(), pACIFIC);
        }
        hashMap.put("SJ", Collections.singleton("Arctic/Longyearbyen"));
        TERRITORIES = Collections.unmodifiableMap(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        ZoneNameProviderSPI.addPrimary(hashMap2, "CL", AMERICA.SANTIAGO);
        ZoneNameProviderSPI.addPrimary(hashMap2, "CN", ASIA.SHANGHAI);
        ZoneNameProviderSPI.addPrimary(hashMap2, "DE", EUROPE.BERLIN);
        ZoneNameProviderSPI.addPrimary(hashMap2, "EC", AMERICA.GUAYAQUIL);
        ZoneNameProviderSPI.addPrimary(hashMap2, "ES", EUROPE.MADRID);
        ZoneNameProviderSPI.addPrimary(hashMap2, "MH", PACIFIC.MAJURO);
        ZoneNameProviderSPI.addPrimary(hashMap2, "MY", ASIA.KUALA_LUMPUR);
        ZoneNameProviderSPI.addPrimary(hashMap2, "NZ", PACIFIC.AUCKLAND);
        ZoneNameProviderSPI.addPrimary(hashMap2, "PT", EUROPE.LISBON);
        ZoneNameProviderSPI.addPrimary(hashMap2, "UA", EUROPE.KIEV);
        ZoneNameProviderSPI.addPrimary(hashMap2, "UZ", ASIA.TASHKENT);
        PRIMARIES = Collections.unmodifiableMap(hashMap2);
        CONTROL = new UTF8ResourceControl(){

            @Override
            protected String getModuleName() {
                return "olson";
            }

            @Override
            protected Class<?> getModuleRef() {
                return ZoneNameProviderSPI.class;
            }
        };
    }
}

