/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import net.time4j.CalendarUnit;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.base.GregorianMath;
import net.time4j.tz.model.GregorianTimezoneRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.SPX;

final class DayOfWeekInMonthPattern
extends GregorianTimezoneRule {
    private static final long serialVersionUID = -7354650946442523175L;
    private final transient byte dayOfMonth;
    private final transient byte dayOfWeek;
    private final transient boolean after;

    DayOfWeekInMonthPattern(Month month, int n, Weekday weekday, PlainTime plainTime, OffsetIndicator offsetIndicator, int n2, boolean bl) {
        super(month, plainTime, offsetIndicator, n2);
        GregorianMath.checkDate(2000, month.getValue(), n);
        this.dayOfMonth = (byte)n;
        this.dayOfWeek = (byte)weekday.getValue();
        this.after = bl;
    }

    @Override
    public PlainDate getDate(int n) {
        byte by = this.getMonthValue();
        int n2 = GregorianMath.getDayOfWeek(n, by, this.dayOfMonth);
        PlainDate plainDate = PlainDate.of(n, (int)by, (int)this.dayOfMonth);
        if (n2 == this.dayOfWeek) {
            return plainDate;
        }
        int n3 = n2 - this.dayOfWeek;
        int n4 = -1;
        if (this.after) {
            n3 = -n3;
            n4 = 1;
        }
        if (n3 < 0) {
            n3 += 7;
        }
        return (PlainDate)plainDate.plus(n3 * n4, CalendarUnit.DAYS);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DayOfWeekInMonthPattern) {
            DayOfWeekInMonthPattern dayOfWeekInMonthPattern = (DayOfWeekInMonthPattern)object;
            return this.dayOfMonth == dayOfWeekInMonthPattern.dayOfMonth && this.dayOfWeek == dayOfWeekInMonthPattern.dayOfWeek && this.after == dayOfWeekInMonthPattern.after && super.isEqual(dayOfWeekInMonthPattern);
        }
        return false;
    }

    public int hashCode() {
        int n = this.dayOfMonth;
        return (n += 17 * (this.dayOfWeek + 37 * this.getMonthValue())) + (this.after ? 1 : 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("DayOfWeekInMonthPattern:[month=");
        stringBuilder.append(this.getMonthValue());
        stringBuilder.append(",dayOfMonth=");
        stringBuilder.append(this.dayOfMonth);
        stringBuilder.append(",dayOfWeek=");
        stringBuilder.append(Weekday.valueOf(this.dayOfWeek));
        stringBuilder.append(",time-of-day=");
        stringBuilder.append(this.getTimeOfDay());
        stringBuilder.append(",offset-indicator=");
        stringBuilder.append((Object)this.getIndicator());
        stringBuilder.append(",dst-offset=");
        stringBuilder.append(this.getSavings());
        stringBuilder.append(",after=");
        stringBuilder.append(this.after);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    int getDayOfMonth() {
        return this.dayOfMonth;
    }

    byte getDayOfWeek() {
        return this.dayOfWeek;
    }

    boolean isAfter() {
        return this.after;
    }

    @Override
    int getType() {
        return 121;
    }

    private Object writeReplace() {
        return new SPX(this, this.getType());
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

