/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.time4j.CalendarUnit;
import net.time4j.DayPeriod;
import net.time4j.GeneralTimestamp;
import net.time4j.IsoTimeUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.ValidationElement;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.PluralCategory;
import net.time4j.format.RawValues;
import net.time4j.format.TemporalFormatter;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.AmbivalentValueException;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.CustomizedProcessor;
import net.time4j.format.expert.DecimalProcessor;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.FractionProcessor;
import net.time4j.format.expert.IgnorableWhitespaceProcessor;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.LocalizedGMTProcessor;
import net.time4j.format.expert.LookupProcessor;
import net.time4j.format.expert.MergedAttributes;
import net.time4j.format.expert.NonAmbivalentMap;
import net.time4j.format.expert.NumberProcessor;
import net.time4j.format.expert.OrdinalProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.ParsedValue;
import net.time4j.format.expert.ParsedValues;
import net.time4j.format.expert.PatternType;
import net.time4j.format.expert.SignPolicy;
import net.time4j.format.expert.SkipProcessor;
import net.time4j.format.expert.StyleProcessor;
import net.time4j.format.expert.TextProcessor;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.format.expert.TimezoneIDProcessor;
import net.time4j.format.expert.TimezoneNameProcessor;
import net.time4j.format.expert.TimezoneOffsetProcessor;
import net.time4j.format.expert.TwoDigitYearProcessor;
import net.time4j.history.ChronoHistory;
import net.time4j.history.internal.HistoricAttribute;
import net.time4j.history.internal.HistorizedElement;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;

public final class ChronoFormatter<T>
implements ChronoPrinter<T>,
ChronoParser<T>,
TemporalFormatter<T> {
    public static final ChronoFormatter<Moment> RFC_1123 = ChronoFormatter.rfc1123();
    private final Chronology<T> chronology;
    private final OverrideHandler<?> overrideHandler;
    private final AttributeSet globalAttributes;
    private final List<FormatStep> steps;
    private final Map<ChronoElement<?>, Object> defaults;
    private final FractionProcessor fracproc;
    private final boolean hasOptionals;
    private final boolean needsHistorization;
    private final boolean needsExtensions;
    private final int countOfElements;
    private final Leniency leniency;
    private final boolean indexable;
    private final boolean trailing;
    private final boolean noPreparser;
    private final Chronology<?> deepestParser;
    private final int stepCount;
    private final boolean singleStepMode;

    private ChronoFormatter(Chronology<T> chronology, Chronology<?> chronology2, Locale locale, List<FormatStep> list, Map<ChronoElement<?>, Object> map, Attributes attributes, Chronology<?> chronology3) {
        if (chronology == null) {
            throw new NullPointerException("Missing chronology.");
        }
        if (list.isEmpty()) {
            throw new IllegalStateException("No format processors defined.");
        }
        this.chronology = chronology;
        this.overrideHandler = OverrideHandler.of(chronology2);
        this.deepestParser = chronology3;
        this.globalAttributes = AttributeSet.createDefaults(chronology2 == null ? chronology : chronology2, attributes, locale);
        this.leniency = this.globalAttributes.get(Attributes.LENIENCY, Leniency.SMART);
        this.defaults = Collections.unmodifiableMap(map);
        FractionProcessor fractionProcessor = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        boolean bl4 = true;
        for (FormatStep formatStep : list) {
            ChronoElement<?> chronoElement;
            if (fractionProcessor == null && formatStep.getProcessor() instanceof FractionProcessor) {
                fractionProcessor = (FractionProcessor)FractionProcessor.class.cast(formatStep.getProcessor());
            }
            if (!bl && formatStep.getLevel() > 0) {
                bl = true;
            }
            if ((chronoElement = formatStep.getProcessor().getElement()) == null) continue;
            ++n;
            if (bl4 && !ParsedValues.isIndexed(chronoElement)) {
                bl4 = false;
            }
            if (chronoElement instanceof HistorizedElement) {
                bl2 = true;
                continue;
            }
            if (bl3 || !chronoElement.name().endsWith("_DAY_PERIOD")) continue;
            bl3 = true;
        }
        this.fracproc = fractionProcessor;
        this.hasOptionals = bl;
        this.needsHistorization = bl2;
        this.countOfElements = n;
        this.indexable = bl4;
        Class<T> clazz = chronology.getChronoType();
        this.needsExtensions = PlainDate.class.isAssignableFrom(clazz) ? bl2 || chronology.getExtensions().size() > 2 : (PlainTime.class.isAssignableFrom(clazz) ? bl3 || chronology.getExtensions().size() > 1 : (PlainTimestamp.class.isAssignableFrom(clazz) ? bl3 || bl2 || chronology.getExtensions().size() > 3 : true));
        this.trailing = this.globalAttributes.get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE);
        this.noPreparser = this.hasNoPreparser();
        this.stepCount = list.size();
        this.steps = this.freeze(list);
        this.singleStepMode = this.getSingleStepMode();
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, Attributes attributes) {
        this(chronoFormatter, chronoFormatter.globalAttributes.withAttributes(attributes), null);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, AttributeSet attributeSet) {
        this(chronoFormatter, attributeSet, null);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, AttributeSet attributeSet, ChronoHistory chronoHistory) {
        if (attributeSet == null) {
            throw new NullPointerException("Missing global format attributes.");
        }
        this.chronology = chronoFormatter.chronology;
        this.overrideHandler = chronoFormatter.overrideHandler;
        this.deepestParser = chronoFormatter.deepestParser;
        this.globalAttributes = attributeSet;
        this.leniency = this.globalAttributes.get(Attributes.LENIENCY, Leniency.SMART);
        this.defaults = Collections.unmodifiableMap(new NonAmbivalentMap((Map<? extends ChronoElement<?>, ?>)chronoFormatter.defaults));
        this.fracproc = chronoFormatter.fracproc;
        this.hasOptionals = chronoFormatter.hasOptionals;
        this.needsHistorization = chronoFormatter.needsHistorization || chronoHistory != null;
        this.needsExtensions = chronoFormatter.needsExtensions || this.needsHistorization;
        this.countOfElements = chronoFormatter.countOfElements;
        int n = chronoFormatter.steps.size();
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>(chronoFormatter.steps);
        boolean bl = chronoFormatter.indexable;
        for (int i = 0; i < n; ++i) {
            FormatStep formatStep = (FormatStep)arrayList.get(i);
            ChronoElement<?> chronoElement = formatStep.getProcessor().getElement();
            Chronology<Object> chronology = this.chronology;
            if (chronology instanceof BridgeChronology) {
                chronology = chronology.preparser();
            }
            if (chronology == Moment.axis()) {
                chronology = chronology.preparser();
            }
            if (chronoElement != null && !chronology.isRegistered(chronoElement)) {
                block1: for (ChronoExtension chronoExtension : chronology.getExtensions()) {
                    if (!chronoExtension.getElements(chronoFormatter.getLocale(), chronoFormatter.globalAttributes).contains(chronoElement)) continue;
                    Set<ChronoElement<?>> set = chronoExtension.getElements(attributeSet.getLocale(), attributeSet);
                    for (ChronoElement<?> chronoElement2 : set) {
                        if (!chronoElement2.name().equals(chronoElement.name())) continue;
                        if (chronoElement2 == chronoElement) break block1;
                        arrayList.set(i, formatStep.updateElement(chronoElement2));
                        bl = false;
                        break block1;
                    }
                }
            }
            if (chronoHistory == null) continue;
            bl = false;
            TextElement<Integer> textElement = null;
            if (chronoElement == PlainDate.YEAR) {
                textElement = chronoHistory.yearOfEra();
            } else if (chronoElement == PlainDate.MONTH_OF_YEAR || chronoElement == PlainDate.MONTH_AS_NUMBER) {
                textElement = chronoHistory.month();
            } else if (chronoElement == PlainDate.DAY_OF_MONTH) {
                textElement = chronoHistory.dayOfMonth();
            } else if (chronoElement == PlainDate.DAY_OF_YEAR) {
                textElement = chronoHistory.dayOfYear();
            }
            if (textElement == null) continue;
            arrayList.set(i, formatStep.updateElement(textElement));
        }
        this.indexable = bl;
        this.trailing = this.globalAttributes.get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE);
        this.noPreparser = this.hasNoPreparser();
        this.stepCount = arrayList.size();
        this.steps = this.freeze(arrayList);
        this.singleStepMode = this.getSingleStepMode();
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, Map<ChronoElement<?>, Object> map) {
        Chronology<?> chronology = chronoFormatter.overrideHandler == null ? null : chronoFormatter.overrideHandler.getCalendarOverride();
        for (ChronoElement<?> chronoElement : map.keySet()) {
            ChronoFormatter.checkElement(chronoFormatter.chronology, chronology, chronoElement);
        }
        this.chronology = chronoFormatter.chronology;
        this.overrideHandler = chronoFormatter.overrideHandler;
        this.deepestParser = chronoFormatter.deepestParser;
        this.globalAttributes = chronoFormatter.globalAttributes;
        this.leniency = chronoFormatter.leniency;
        this.fracproc = chronoFormatter.fracproc;
        this.hasOptionals = chronoFormatter.hasOptionals;
        this.needsHistorization = chronoFormatter.needsHistorization;
        this.needsExtensions = chronoFormatter.needsExtensions;
        this.countOfElements = chronoFormatter.countOfElements;
        this.trailing = chronoFormatter.trailing;
        HashMap<ChronoElement<?>, Object> hashMap = new HashMap(chronoFormatter.defaults);
        boolean bl = chronoFormatter.indexable;
        for (ChronoElement<?> chronoElement : map.keySet()) {
            Object object = map.get(chronoElement);
            if (object == null) {
                hashMap.remove(chronoElement);
                continue;
            }
            hashMap.put(chronoElement, object);
            bl = bl && ParsedValues.isIndexed(chronoElement);
        }
        this.defaults = Collections.unmodifiableMap(hashMap);
        this.indexable = bl;
        this.noPreparser = this.hasNoPreparser();
        this.stepCount = chronoFormatter.stepCount;
        this.steps = this.freeze(chronoFormatter.steps);
        this.singleStepMode = this.getSingleStepMode();
    }

    public Chronology<T> getChronology() {
        return this.chronology;
    }

    public Locale getLocale() {
        return this.globalAttributes.getLocale();
    }

    @Override
    public AttributeQuery getAttributes() {
        return this.globalAttributes;
    }

    @Override
    public String format(T t) {
        ChronoDisplay chronoDisplay = this.display(t, this.globalAttributes);
        return this.format0(chronoDisplay);
    }

    @Override
    public String format(GeneralTimestamp<?> generalTimestamp) {
        return this.format0(generalTimestamp);
    }

    @Override
    public void formatToBuffer(T t, Appendable appendable) throws IOException {
        this.print(t, appendable, this.globalAttributes);
    }

    public Set<ElementPosition> print(T t, StringBuilder stringBuilder) {
        ChronoDisplay chronoDisplay = this.display(t, this.globalAttributes);
        try {
            return this.print(chronoDisplay, (Appendable)stringBuilder, (AttributeQuery)this.globalAttributes, true);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public Set<ElementPosition> print(T t, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        ChronoDisplay chronoDisplay = this.display(t, attributeQuery);
        return this.print(chronoDisplay, appendable, attributeQuery, true);
    }

    @Override
    public <R> R print(T t, Appendable appendable, AttributeQuery attributeQuery, ChronoFunction<ChronoDisplay, R> chronoFunction) throws IOException {
        ChronoDisplay chronoDisplay = this.display(t, attributeQuery);
        this.print(chronoDisplay, appendable, attributeQuery, false);
        return chronoFunction.apply(chronoDisplay);
    }

    Set<ElementPosition> print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, boolean bl) throws IOException {
        boolean bl2;
        if (appendable == null) {
            throw new NullPointerException("Missing text result buffer.");
        }
        LinkedHashSet<ElementPosition> linkedHashSet = null;
        boolean bl3 = bl2 = attributeQuery == this.globalAttributes;
        if (bl) {
            linkedHashSet = new LinkedHashSet<ElementPosition>(this.steps.size());
        }
        try {
            int n = this.steps.size();
            for (int i = 0; i < n; ++i) {
                FormatStep formatStep = this.steps.get(i);
                formatStep.print(chronoDisplay, appendable, attributeQuery, linkedHashSet, bl2);
                if (!formatStep.isNewOrBlockStarted()) continue;
                i = formatStep.skipTrailingOrBlocks();
            }
        }
        catch (ChronoException chronoException) {
            throw new IllegalArgumentException("Not formattable: " + chronoDisplay, chronoException);
        }
        if (bl) {
            return Collections.unmodifiableSet(linkedHashSet);
        }
        return Collections.emptySet();
    }

    @Override
    public T parse(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        T t = this.parse(charSequence, parseLog);
        if (t == null) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        int n = parseLog.getPosition();
        if (!this.trailing && n < charSequence.length()) {
            throw new ParseException("Unparsed trailing characters: " + ChronoFormatter.sub(n, charSequence), n);
        }
        return t;
    }

    @Override
    public T parse(CharSequence charSequence, ParsePosition parsePosition) {
        return this.parse(charSequence, new ParseLog(parsePosition));
    }

    @Override
    public T parse(CharSequence charSequence, ParsePosition parsePosition, RawValues rawValues) {
        ParseLog parseLog = new ParseLog(parsePosition);
        T t = this.parse(charSequence, parseLog);
        rawValues.accept(parseLog.getRawValues());
        return t;
    }

    public T parse(CharSequence charSequence, ParseLog parseLog) {
        if (this.noPreparser) {
            return ChronoFormatter.parse(this, this.chronology, this.chronology.getExtensions(), charSequence, parseLog, this.globalAttributes, this.leniency, false, true);
        }
        return this.parse(charSequence, parseLog, this.globalAttributes);
    }

    @Override
    public T parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        AttributeQuery attributeQuery2 = attributeQuery;
        Leniency leniency = this.leniency;
        boolean bl = true;
        if (attributeQuery != this.globalAttributes) {
            attributeQuery2 = new MergedAttributes(attributeQuery, this.globalAttributes);
            leniency = attributeQuery2.get(Attributes.LENIENCY, Leniency.SMART);
            bl = false;
        }
        if (this.overrideHandler != null) {
            StartOfDay startOfDay;
            List<ChronoExtension> list = this.overrideHandler.getExtensions();
            OverrideHandler<?> overrideHandler = this.overrideHandler;
            GeneralTimestamp generalTimestamp = (GeneralTimestamp)ChronoFormatter.parse(this, overrideHandler, list, charSequence, parseLog, attributeQuery2, leniency, true, bl);
            if (parseLog.isError()) {
                return null;
            }
            ChronoEntity<?> chronoEntity = parseLog.getRawValues0();
            TZID tZID = null;
            Moment moment = null;
            if (chronoEntity.hasTimezone()) {
                tZID = chronoEntity.getTimezone();
            } else if (attributeQuery2.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery2.get(Attributes.TIMEZONE_ID);
            }
            if (tZID != null) {
                startOfDay = attributeQuery.get(Attributes.START_OF_DAY, overrideHandler.getDefaultStartOfDay());
                if (attributeQuery2.contains(Attributes.TRANSITION_STRATEGY)) {
                    TransitionStrategy transitionStrategy = attributeQuery2.get(Attributes.TRANSITION_STRATEGY);
                    moment = generalTimestamp.in(Timezone.of(tZID).with(transitionStrategy), startOfDay);
                } else {
                    moment = generalTimestamp.in(Timezone.of(tZID), startOfDay);
                }
            }
            if (moment == null) {
                parseLog.setError(charSequence.length(), "Missing timezone or offset.");
                return null;
            }
            chronoEntity.with(Moment.axis().element(), moment);
            startOfDay = ChronoFormatter.cast(moment);
            if (leniency.isStrict()) {
                ChronoFormatter.checkConsistency(chronoEntity, startOfDay, charSequence, parseLog);
            }
            return (T)startOfDay;
        }
        return ChronoFormatter.parse(this, this.chronology, 0, charSequence, parseLog, attributeQuery2, leniency, bl);
    }

    public ChronoEntity<?> parseRaw(String string) {
        return this.parseRaw(string, 0);
    }

    public ChronoEntity<?> parseRaw(CharSequence charSequence, int n) {
        ChronoEntity<?> chronoEntity;
        ParseLog parseLog;
        block5: {
            if (n >= charSequence.length()) {
                return new ParsedValues(0, false);
            }
            parseLog = new ParseLog(n);
            chronoEntity = null;
            try {
                chronoEntity = this.parseElements(charSequence, parseLog, this.globalAttributes, true, this.countOfElements);
                parseLog.setRawValues(chronoEntity);
            }
            catch (AmbivalentValueException ambivalentValueException) {
                if (parseLog.isError()) break block5;
                parseLog.setError(parseLog.getPosition(), ambivalentValueException.getMessage());
            }
        }
        if (chronoEntity == null || parseLog.isError()) {
            return new ParsedValues(0, false);
        }
        for (ChronoElement<?> chronoElement : this.defaults.keySet()) {
            if (chronoEntity.contains(chronoElement)) continue;
            ChronoFormatter.setValue(chronoEntity, chronoElement, this.defaults.get(chronoElement));
        }
        return chronoEntity;
    }

    @Override
    public ChronoFormatter<T> with(Locale locale) {
        if (locale.equals(this.globalAttributes.getLocale())) {
            return this;
        }
        return new ChronoFormatter<T>(this, this.globalAttributes.withLocale(locale));
    }

    @Override
    public ChronoFormatter<T> with(Leniency leniency) {
        return this.with(Attributes.LENIENCY, leniency);
    }

    public ChronoFormatter<T> withAlternativeEraNames() {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(HistoricAttribute.COMMON_ERA, true).set(HistoricAttribute.LATIN_ERA, false).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withLatinEraNames() {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(HistoricAttribute.COMMON_ERA, false).set(HistoricAttribute.LATIN_ERA, true).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withGregorianCutOver(PlainDate plainDate) {
        return this.with(ChronoHistory.ofGregorianReform(plainDate));
    }

    public ChronoFormatter<T> with(ChronoHistory chronoHistory) {
        if (chronoHistory == null) {
            throw new NullPointerException("Missing calendar history.");
        }
        AttributeSet attributeSet = this.globalAttributes.withInternal(HistoricAttribute.CALENDAR_HISTORY, chronoHistory);
        return new ChronoFormatter<T>(this, attributeSet, chronoHistory);
    }

    public ChronoFormatter<T> with(Timezone timezone) {
        if (timezone == null) {
            throw new NullPointerException("Missing timezone id.");
        }
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setTimezone(timezone.getID()).build();
        AttributeSet attributeSet = this.globalAttributes.withAttributes(attributes);
        attributeSet = attributeSet.withInternal(Attributes.TRANSITION_STRATEGY, timezone.getStrategy());
        return new ChronoFormatter<T>(this, attributeSet);
    }

    @Override
    public ChronoFormatter<T> withTimezone(TZID tZID) {
        return this.with(Timezone.of(tZID));
    }

    @Override
    public ChronoFormatter<T> withTimezone(String string) {
        return this.with(Timezone.of(string));
    }

    public ChronoFormatter<T> withStdTimezone() {
        return this.with(Timezone.ofSystem());
    }

    public ChronoFormatter<T> withCalendarVariant(String string) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setCalendarVariant(string).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withCalendarVariant(VariantSource variantSource) {
        return this.withCalendarVariant(variantSource.getVariant());
    }

    public ChronoFormatter<T> with(StartOfDay startOfDay) {
        if (startOfDay == null) {
            throw new NullPointerException("Missing start of day.");
        }
        return new ChronoFormatter<T>(this, this.globalAttributes.withInternal(Attributes.START_OF_DAY, startOfDay));
    }

    public <V> ChronoFormatter<T> withDefault(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        HashMap hashMap = new HashMap();
        hashMap.put(chronoElement, v);
        return new ChronoFormatter<T>(this, hashMap);
    }

    public ChronoFormatter<T> with(AttributeKey<Boolean> attributeKey, boolean bl) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, bl).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(AttributeKey<Integer> attributeKey, int n) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, n).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(AttributeKey<Character> attributeKey, char c) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, c).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public <A extends Enum<A>> ChronoFormatter<T> with(AttributeKey<A> attributeKey, A a) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, a).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(Attributes attributes) {
        Attributes attributes2 = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setAll(attributes).build();
        return new ChronoFormatter<T>(this, attributes2);
    }

    ChronoFormatter<T> with(Map<ChronoElement<?>, Object> map, AttributeSet attributeSet) {
        AttributeSet attributeSet2 = AttributeSet.merge(attributeSet, this.globalAttributes);
        return new ChronoFormatter<T>(new ChronoFormatter<T>(this, map), attributeSet2, attributeSet2.get(HistoricAttribute.CALENDAR_HISTORY, null));
    }

    Map<ChronoElement<?>, Object> getDefaults() {
        return this.defaults;
    }

    public Format toFormat() {
        return new TraditionalFormat(this);
    }

    public static ChronoFormatter<PlainDate> ofDatePattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainDate.axis(), locale);
        ChronoFormatter.addPattern(builder, string, patternType);
        try {
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static ChronoFormatter<PlainTime> ofTimePattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainTime.axis(), locale);
        ChronoFormatter.addPattern(builder, string, patternType);
        try {
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static ChronoFormatter<PlainTimestamp> ofTimestampPattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainTimestamp.axis(), locale);
        ChronoFormatter.addPattern(builder, string, patternType);
        try {
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static ChronoFormatter<Moment> ofMomentPattern(String string, PatternType patternType, Locale locale, TZID tZID) {
        Builder builder = new Builder((Chronology)Moment.axis(), locale);
        ChronoFormatter.addPattern(builder, string, patternType);
        try {
            return builder.build().withTimezone(tZID);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static <T> ChronoFormatter<T> ofPattern(String string, PatternType patternType, Locale locale, Chronology<T> chronology) {
        Builder builder = new Builder((Chronology)chronology, locale);
        ChronoFormatter.addPattern(builder, string, patternType);
        try {
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static ChronoFormatter<PlainDate> ofDateStyle(DisplayMode displayMode, Locale locale) {
        Builder builder = new Builder((Chronology)PlainDate.axis(), locale);
        builder.addProcessor(new StyleProcessor(displayMode, displayMode));
        return builder.build();
    }

    public static ChronoFormatter<PlainTime> ofTimeStyle(DisplayMode displayMode, Locale locale) {
        Builder builder = new Builder((Chronology)PlainTime.axis(), locale);
        builder.addProcessor(new StyleProcessor(displayMode, displayMode));
        return builder.build();
    }

    public static ChronoFormatter<PlainTimestamp> ofTimestampStyle(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        Builder builder = new Builder((Chronology)PlainTimestamp.axis(), locale);
        builder.addProcessor(new StyleProcessor(displayMode, displayMode2));
        return builder.build();
    }

    public static ChronoFormatter<Moment> ofMomentStyle(DisplayMode displayMode, DisplayMode displayMode2, Locale locale, TZID tZID) {
        Builder builder = new Builder((Chronology)Moment.axis(), locale);
        builder.addProcessor(new StyleProcessor(displayMode, displayMode2));
        return builder.build().withTimezone(tZID);
    }

    public static <T extends LocalizedPatternSupport> ChronoFormatter<T> ofStyle(DisplayStyle displayStyle, Locale locale, Chronology<T> chronology) {
        if (LocalizedPatternSupport.class.isAssignableFrom(chronology.getChronoType())) {
            Builder builder = new Builder((Chronology)chronology, locale);
            builder.addProcessor(new StyleProcessor(displayStyle, displayStyle));
            return builder.build();
        }
        if (chronology.equals(Moment.axis())) {
            throw new UnsupportedOperationException("Timezone required, use 'ofMomentStyle()' instead.");
        }
        throw new UnsupportedOperationException("Localized format patterns not available: " + chronology);
    }

    public static <T extends ChronoEntity<T>> Builder<T> setUp(Class<T> clazz, Locale locale) {
        if (clazz == null) {
            throw new NullPointerException("Missing chronological type.");
        }
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Not formattable: " + clazz);
        }
        return new Builder((Chronology)chronology, locale);
    }

    public static <T> Builder<T> setUp(Chronology<T> chronology, Locale locale) {
        return new Builder((Chronology)chronology, locale);
    }

    public static <C extends CalendarVariant<C>> Builder<Moment> setUpWithOverride(Locale locale, CalendarFamily<C> calendarFamily) {
        if (calendarFamily == null) {
            throw new NullPointerException("Missing override calendar.");
        }
        return new Builder<Moment>(Moment.axis(), locale, calendarFamily);
    }

    public static <C extends Calendrical<?, C>> Builder<Moment> setUpWithOverride(Locale locale, Chronology<C> chronology) {
        if (chronology == null) {
            throw new NullPointerException("Missing override calendar.");
        }
        return new Builder<Moment>(Moment.axis(), locale, chronology);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoFormatter) {
            ChronoFormatter chronoFormatter = (ChronoFormatter)object;
            return this.chronology.equals(chronoFormatter.chronology) && ChronoFormatter.isEqual(this.overrideHandler, chronoFormatter.overrideHandler) && this.globalAttributes.equals(chronoFormatter.globalAttributes) && this.defaults.equals(chronoFormatter.defaults) && this.steps.equals(chronoFormatter.steps);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.chronology.hashCode() + 31 * this.globalAttributes.hashCode() + 37 * this.steps.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("net.time4j.format.ChronoFormatter[chronology=");
        stringBuilder.append(this.chronology.getChronoType().getName());
        if (this.overrideHandler != null) {
            stringBuilder.append(", override=");
            stringBuilder.append(this.overrideHandler);
        }
        stringBuilder.append(", default-attributes=");
        stringBuilder.append(this.globalAttributes);
        stringBuilder.append(", default-values=");
        stringBuilder.append(this.defaults);
        stringBuilder.append(", processors=");
        boolean bl = true;
        for (FormatStep formatStep : this.steps) {
            if (bl) {
                bl = false;
                stringBuilder.append('{');
            } else {
                stringBuilder.append('|');
            }
            stringBuilder.append(formatStep);
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    AttributeSet getAttributes0() {
        return this.globalAttributes;
    }

    boolean isToleratingTrailingChars() {
        return this.trailing;
    }

    boolean isSingleStepOptimizationPossible() {
        return this.stepCount == 1 && !this.hasOptionals;
    }

    private boolean getSingleStepMode() {
        boolean bl = this.isSingleStepOptimizationPossible();
        if (bl) {
            FormatProcessor<?> formatProcessor = this.steps.get(0).getProcessor();
            if (formatProcessor instanceof CustomizedProcessor) {
                bl = ((CustomizedProcessor)CustomizedProcessor.class.cast(formatProcessor)).isSingleStepMode();
            } else if (!(formatProcessor instanceof StyleProcessor)) {
                bl = false;
            }
        }
        return bl;
    }

    private String format0(ChronoDisplay chronoDisplay) {
        StringBuilder stringBuilder = new StringBuilder(this.steps.size() * 8);
        try {
            this.print(chronoDisplay, (Appendable)stringBuilder, (AttributeQuery)this.globalAttributes, false);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return stringBuilder.toString();
    }

    private static ChronoFormatter<Moment> rfc1123() {
        Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ENGLISH);
        ChronoFormatter.rfc1123DateTime(builder);
        builder.addTimezoneOffset(DisplayMode.MEDIUM, false, Arrays.asList("GMT", "UT", "Z"));
        builder.or();
        ChronoFormatter.rfc1123DateTime(builder);
        final HashMap<String, ZonalOffset> hashMap = new HashMap<String, ZonalOffset>();
        hashMap.put("EST", ZonalOffset.ofHours(OffsetSign.BEHIND_UTC, 5));
        hashMap.put("EDT", ZonalOffset.ofHours(OffsetSign.BEHIND_UTC, 4));
        hashMap.put("CST", ZonalOffset.ofHours(OffsetSign.BEHIND_UTC, 6));
        hashMap.put("CDT", ZonalOffset.ofHours(OffsetSign.BEHIND_UTC, 5));
        hashMap.put("MST", ZonalOffset.ofHours(OffsetSign.BEHIND_UTC, 7));
        hashMap.put("MDT", ZonalOffset.ofHours(OffsetSign.BEHIND_UTC, 6));
        hashMap.put("PST", ZonalOffset.ofHours(OffsetSign.BEHIND_UTC, 8));
        hashMap.put("PDT", ZonalOffset.ofHours(OffsetSign.BEHIND_UTC, 7));
        ((Builder)builder).addProcessor(new CustomizedProcessor<TZID>(TimezoneElement.TIMEZONE_OFFSET, new ChronoPrinter<TZID>(){

            @Override
            public <R> R print(TZID tZID, Appendable appendable, AttributeQuery attributeQuery, ChronoFunction<ChronoDisplay, R> chronoFunction) throws IOException {
                return null;
            }
        }, new ChronoParser<TZID>(){

            @Override
            public TZID parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
                int n = parseLog.getPosition();
                if (n + 3 <= charSequence.length()) {
                    String string = charSequence.subSequence(n, n + 3).toString();
                    TZID tZID = (TZID)hashMap.get(string);
                    if (tZID != null) {
                        parseLog.setPosition(n + 3);
                        return tZID;
                    }
                    parseLog.setError(n, "No time zone information found.");
                }
                return null;
            }
        }));
        return builder.build().withTimezone(ZonalOffset.UTC);
    }

    private static void rfc1123DateTime(Builder<Moment> builder) {
        builder.startOptionalSection().startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED).addText(PlainDate.DAY_OF_WEEK).endSection().addLiteral(", ").endSection().addInteger(PlainDate.DAY_OF_MONTH, 1, 2).addLiteral(' ').startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED).addText(PlainDate.MONTH_OF_YEAR).endSection().addLiteral(' ').addFixedInteger(PlainDate.YEAR, 4).addLiteral(' ').addFixedInteger(PlainTime.DIGITAL_HOUR_OF_DAY, 2).addLiteral(':').addFixedInteger(PlainTime.MINUTE_OF_HOUR, 2).startOptionalSection().addLiteral(':').addFixedInteger(PlainTime.SECOND_OF_MINUTE, 2).endSection().addLiteral(' ');
    }

    private ChronoDisplay display(T t, AttributeQuery attributeQuery) {
        if (this.overrideHandler == null) {
            return this.chronology.preformat(t, attributeQuery);
        }
        try {
            GeneralTimestamp<Object> generalTimestamp;
            Class<?> clazz = this.overrideHandler.getCalendarOverride().getChronoType();
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.overrideHandler.getDefaultStartOfDay());
            Moment moment = (Moment)Moment.class.cast(t);
            TZID tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            if (CalendarVariant.class.isAssignableFrom(clazz)) {
                CalendarFamily calendarFamily = (CalendarFamily)ChronoFormatter.cast(this.overrideHandler.getCalendarOverride());
                String string = attributeQuery.get(Attributes.CALENDAR_VARIANT);
                generalTimestamp = moment.toGeneralTimestamp(calendarFamily, string, tZID, startOfDay);
            } else if (Calendrical.class.isAssignableFrom(clazz)) {
                Chronology<?> chronology = this.overrideHandler.getCalendarOverride();
                generalTimestamp = moment.toGeneralTimestamp(chronology, tZID, startOfDay);
            } else {
                throw new IllegalStateException("Unexpected calendar override: " + clazz);
            }
            return new ZonalDisplay(generalTimestamp, tZID);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Not formattable: " + t, classCastException);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException.getMessage(), noSuchElementException);
        }
    }

    private static <C> C parse(ChronoFormatter<?> chronoFormatter, Chronology<C> chronology, int n, CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Leniency leniency, boolean bl) {
        C c;
        ChronoEntity<?> chronoEntity;
        block10: {
            Chronology<?> chronology2 = chronology.preparser();
            if (chronology2 == null || chronology == chronoFormatter.deepestParser) {
                return ChronoFormatter.parse(chronoFormatter, chronology, chronology.getExtensions(), charSequence, parseLog, attributeQuery, leniency, n > 0, bl);
            }
            Object obj = chronology2 == chronoFormatter.deepestParser ? ChronoFormatter.parse(chronoFormatter, chronology2, chronology2.getExtensions(), charSequence, parseLog, attributeQuery, leniency, true, bl) : ChronoFormatter.parse(chronoFormatter, chronology2, n + 1, charSequence, parseLog, attributeQuery, leniency, bl);
            if (parseLog.isError()) {
                return null;
            }
            if (obj == null) {
                ChronoEntity<?> chronoEntity2 = parseLog.getRawValues();
                parseLog.setError(charSequence.length(), ChronoFormatter.getReason(chronoEntity2) + ChronoFormatter.getDescription(chronoEntity2));
                return null;
            }
            chronoEntity = parseLog.getRawValues0();
            try {
                if (chronology2 instanceof TimeAxis) {
                    ChronoElement chronoElement = ((TimeAxis)TimeAxis.class.cast(chronology2)).element();
                    ChronoFormatter.updateSelf(chronoEntity, chronoElement, obj);
                    c = chronology.createFrom(chronoEntity, attributeQuery, leniency.isLax(), false);
                    break block10;
                }
                if (chronology instanceof BridgeChronology) {
                    c = chronology.createFrom((ChronoEntity)ChronoEntity.class.cast(obj), Attributes.empty(), false, false);
                    break block10;
                }
                throw new IllegalStateException("Unsupported chronology or preparser: " + chronology);
            }
            catch (RuntimeException runtimeException) {
                parseLog.setError(charSequence.length(), runtimeException.getMessage() + ChronoFormatter.getDescription(chronoEntity));
                return null;
            }
        }
        if (c == null) {
            if (!parseLog.isError()) {
                parseLog.setError(charSequence.length(), ChronoFormatter.getReason(chronoEntity) + ChronoFormatter.getDescription(chronoEntity));
            }
            return null;
        }
        if (leniency.isStrict()) {
            return ChronoFormatter.checkConsistency(chronoEntity, c, charSequence, parseLog);
        }
        return c;
    }

    private static <T> void updateSelf(ChronoEntity<?> chronoEntity, ChronoElement<T> chronoElement, Object object) {
        chronoEntity.with(chronoElement, chronoElement.getType().cast(object));
    }

    private static <T> T parse(ChronoFormatter<?> chronoFormatter, ChronoMerger<T> chronoMerger, List<ChronoExtension> list, CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Leniency leniency, boolean bl, boolean bl2) {
        Set<ChronoElement<Object>> set;
        ChronoEntity<?> chronoEntity;
        int n;
        block24: {
            n = charSequence.length();
            if (parseLog.getPosition() >= n) {
                throw new IndexOutOfBoundsException("[" + parseLog.getPosition() + "]: " + charSequence.toString());
            }
            chronoEntity = null;
            try {
                if (chronoFormatter.singleStepMode && !bl) {
                    set = new ParsedValue();
                    chronoFormatter.steps.get(0).parse(charSequence, parseLog, attributeQuery, (ParsedEntity<?>)((Object)set), bl2);
                    if (parseLog.isError()) {
                        return null;
                    }
                    try {
                        Object object2 = ((ParsedValue)((Object)set)).getResult();
                        if (object2 != null) {
                            return (T)object2;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    chronoEntity = set;
                    parseLog.setRawValues(chronoEntity);
                    break block24;
                }
                chronoEntity = super.parseElements(charSequence, parseLog, attributeQuery, bl2, chronoFormatter.countOfElements);
                parseLog.setRawValues(chronoEntity);
            }
            catch (AmbivalentValueException ambivalentValueException) {
                if (parseLog.isError()) break block24;
                parseLog.setError(parseLog.getPosition(), ambivalentValueException.getMessage());
            }
        }
        if (chronoEntity == null || parseLog.isError()) {
            return null;
        }
        if (!chronoFormatter.defaults.isEmpty()) {
            set = null;
            for (ChronoElement<?> chronoElement : chronoFormatter.defaults.keySet()) {
                if (chronoEntity.contains(chronoElement)) continue;
                char c = chronoElement.getSymbol();
                boolean bl3 = true;
                if (c != '\u0000') {
                    if (set == null) {
                        set = chronoEntity.getRegisteredElements();
                    }
                    for (ChronoElement chronoElement2 : set) {
                        if (chronoElement2.getSymbol() != c) continue;
                        bl3 = false;
                        break;
                    }
                }
                if (!bl3) continue;
                ChronoFormatter.setValue(chronoEntity, chronoElement, chronoFormatter.defaults.get(chronoElement));
            }
        }
        if (chronoFormatter.needsExtensions) {
            try {
                for (ChronoExtension chronoExtension : list) {
                    chronoEntity = chronoExtension.resolve(chronoEntity, chronoFormatter.getLocale(), attributeQuery);
                }
            }
            catch (RuntimeException runtimeException) {
                parseLog.setError(n, runtimeException.getMessage() + ChronoFormatter.getDescription(chronoEntity));
                return null;
            }
        }
        try {
            set = chronoMerger.createFrom(chronoEntity, attributeQuery, leniency.isLax(), bl);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(n, runtimeException.getMessage() + ChronoFormatter.getDescription(chronoEntity));
            return null;
        }
        if (chronoFormatter.fracproc != null && set instanceof ChronoEntity) {
            ChronoEntity chronoEntity2 = (ChronoEntity)ChronoEntity.class.cast(set);
            set = ChronoFormatter.cast(chronoFormatter.fracproc.update(chronoEntity2, chronoEntity));
        }
        if (set == null) {
            if (!bl) {
                parseLog.setError(n, ChronoFormatter.getReason(chronoEntity) + ChronoFormatter.getDescription(chronoEntity));
            }
            return null;
        }
        if (leniency.isStrict()) {
            return (T)ChronoFormatter.checkConsistency(chronoEntity, set, charSequence, parseLog);
        }
        return (T)set;
    }

    private static <V> void setValue(ChronoEntity<?> chronoEntity, ChronoElement<V> chronoElement, Object object) {
        chronoEntity.with(chronoElement, chronoElement.getType().cast(object));
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private static String getReason(ChronoEntity<?> chronoEntity) {
        String string;
        if (chronoEntity.contains(ValidationElement.ERROR_MESSAGE)) {
            string = "Validation failed => " + chronoEntity.get(ValidationElement.ERROR_MESSAGE);
            chronoEntity.with(ValidationElement.ERROR_MESSAGE, null);
        } else {
            string = "Insufficient data:";
        }
        return string;
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static <T> void addPattern(Builder<T> builder, String string, PatternType patternType) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                ++i;
                while (i < n) {
                    if (string.charAt(i) == '\'') {
                        if (i + 1 >= n || string.charAt(i + 1) != '\'') continue block3;
                        ++i;
                    }
                    ++i;
                }
                continue;
            }
            stringBuilder.append(c);
        }
        String string2 = stringBuilder.toString();
        switch (patternType) {
            case CLDR: 
            case CLDR_24: 
            case SIMPLE_DATE_FORMAT: 
            case NON_ISO_DATE: {
                if (!(!string2.contains("h") && !string2.contains("K") || string2.contains("a") || string2.contains("b") || string2.contains("B"))) {
                    throw new IllegalArgumentException("12-hour-clock requires am/pm-marker or dayperiod: " + string);
                }
                if (string2.contains("Y") && (string2.contains("M") || string2.contains("L")) && !string2.contains("w")) {
                    throw new IllegalArgumentException("Y as week-based-year requires a week-date-format: " + string);
                }
                if (!string2.contains("D") || !string2.contains("M") && !string2.contains("L") || string2.contains("d")) break;
                throw new IllegalArgumentException("D is the day of year but not the day of month: " + string);
            }
        }
        builder.addPattern(string, patternType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> T checkConsistency(ChronoEntity<?> chronoEntity, T t, CharSequence charSequence, ParseLog parseLog) {
        if (t instanceof UnixTime) {
            TZID tZID;
            UnixTime unixTime = (UnixTime)UnixTime.class.cast(t);
            if (chronoEntity.contains(TimezoneElement.TIMEZONE_ID) && chronoEntity.contains(TimezoneElement.TIMEZONE_OFFSET)) {
                tZID = chronoEntity.get(TimezoneElement.TIMEZONE_ID);
                TZID tZID2 = chronoEntity.get(TimezoneElement.TIMEZONE_OFFSET);
                if (!Timezone.of(tZID).getOffset(unixTime).equals(tZID2)) {
                    parseLog.setError(charSequence.length(), "Ambivalent offset information: " + tZID + " versus " + tZID2);
                    return null;
                }
            }
            if (parseLog.getDSTInfo() == null) return t;
            tZID = chronoEntity.getTimezone();
            try {
                boolean bl = Timezone.of(tZID).isDaylightSaving(unixTime);
                if (bl == parseLog.getDSTInfo()) return t;
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Conflict found: ");
                stringBuilder.append("Parsed entity is ");
                if (!bl) {
                    stringBuilder.append("not ");
                }
                stringBuilder.append("daylight-saving, but timezone name");
                stringBuilder.append(" has not the appropriate form in {");
                stringBuilder.append(charSequence.toString());
                stringBuilder.append("}.");
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                t = null;
                return t;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Unable to check timezone name: ");
                stringBuilder.append(illegalArgumentException.getMessage());
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                return null;
            }
        } else {
            if (!(t instanceof ChronoDisplay)) return t;
            Object var4_5 = null;
            ChronoDisplay chronoDisplay = (ChronoDisplay)t;
            if (t instanceof PlainTimestamp && ((PlainTimestamp)PlainTimestamp.class.cast(t)).getHour() == 0 && (chronoEntity.getInt(PlainTime.ISO_HOUR) == 24 || chronoEntity.contains(PlainTime.COMPONENT) && chronoEntity.get(PlainTime.COMPONENT).getHour() == 24)) {
                var4_5 = ((PlainTimestamp)PlainTimestamp.class.cast(t)).toDate().minus(1L, CalendarUnit.DAYS);
            }
            for (ChronoElement<?> chronoElement : chronoEntity.getRegisteredElements()) {
                Object object;
                if (chronoElement == PlainTime.SECOND_OF_MINUTE && chronoEntity.getInt(PlainTime.SECOND_OF_MINUTE) == 60) continue;
                if (var4_5 != null) {
                    if (chronoElement.isDateElement()) {
                        chronoDisplay = var4_5;
                    } else if (chronoElement.isTimeElement()) {
                        chronoDisplay = PlainTime.midnightAtEndOfDay();
                    }
                }
                if (!chronoDisplay.contains(chronoElement)) continue;
                Integer n = null;
                boolean bl = true;
                if (chronoElement.getType() == Integer.class) {
                    object = (ChronoElement)ChronoFormatter.cast(chronoElement);
                    int n2 = chronoEntity.getInt((ChronoElement<Integer>)object);
                    if (chronoDisplay.getInt((ChronoElement<Integer>)object) != n2) {
                        n = n2;
                        bl = false;
                    }
                } else {
                    n = (Integer)chronoEntity.get(chronoElement);
                    bl = chronoDisplay.get(chronoElement).equals(n);
                }
                if (bl) continue;
                object = new StringBuilder(256);
                ((StringBuilder)object).append("Conflict found: ");
                ((StringBuilder)object).append("Text {");
                ((StringBuilder)object).append(charSequence.toString());
                ((StringBuilder)object).append("} with element ");
                ((StringBuilder)object).append(chronoElement.name());
                ((StringBuilder)object).append(" {");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append("}, but parsed entity ");
                ((StringBuilder)object).append("has element value {");
                ((StringBuilder)object).append(chronoDisplay.get(chronoElement));
                ((StringBuilder)object).append("}.");
                parseLog.setError(charSequence.length(), ((StringBuilder)object).toString());
                return null;
            }
        }
        return t;
    }

    private ChronoEntity<?> parseElements(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, boolean bl, int n) {
        ParsedValues parsedValues = new ParsedValues(n, this.indexable);
        parsedValues.setPosition(parseLog.getPosition());
        LinkedList<ParsedValues> linkedList = null;
        if (this.hasOptionals) {
            linkedList = new LinkedList<ParsedValues>();
            linkedList.push(parsedValues);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.steps.size();
        for (int i = 0; i < n4; ++i) {
            ChronoElement<?> chronoElement;
            int n5;
            ParsedValues parsedValues2;
            FormatStep formatStep = this.steps.get(i);
            if (linkedList == null) {
                parsedValues2 = parsedValues;
            } else {
                for (n5 = n3 = formatStep.getLevel(); n5 > n2; --n5) {
                    parsedValues = new ParsedValues(n >>> 1, this.indexable);
                    parsedValues.setPosition(parseLog.getPosition());
                    linkedList.push(parsedValues);
                }
                while (n5 < n2) {
                    parsedValues = (ParsedValues)linkedList.pop();
                    ((ParsedValues)linkedList.peek()).putAll(parsedValues);
                    ++n5;
                }
                parsedValues2 = (ParsedValues)linkedList.peek();
            }
            parseLog.clearWarning();
            formatStep.parse(charSequence, parseLog, attributeQuery, parsedValues2, bl);
            if (parseLog.isWarning() && (chronoElement = formatStep.getProcessor().getElement()) != null && this.defaults.containsKey(chronoElement)) {
                parsedValues2.put(chronoElement, this.defaults.get(chronoElement));
                parsedValues2.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)null);
                parseLog.clearError();
                parseLog.clearWarning();
            }
            if (parseLog.isError()) {
                int n6;
                n5 = formatStep.getSection();
                int n7 = i;
                if (!formatStep.isNewOrBlockStarted()) {
                    for (n6 = i + 1; n6 < n4; ++n6) {
                        FormatStep formatStep2 = this.steps.get(n6);
                        if (!formatStep2.isNewOrBlockStarted() || formatStep2.getSection() != n5) continue;
                        n7 = n6;
                        break;
                    }
                }
                if (n7 > i || formatStep.isNewOrBlockStarted()) {
                    if (linkedList != null) {
                        parsedValues = (ParsedValues)linkedList.pop();
                    }
                    parseLog.clearError();
                    parseLog.setPosition(parsedValues.getPosition());
                    parsedValues.reset();
                    if (linkedList != null) {
                        linkedList.push(parsedValues);
                    }
                    i = n7;
                } else {
                    if (n3 == 0) {
                        if (linkedList != null) {
                            parsedValues = (ParsedValues)linkedList.peek();
                        }
                        parsedValues.setNoAmbivalentCheck();
                        return parsedValues;
                    }
                    for (n6 = n4 - 1; n6 > i; --n6) {
                        if (this.steps.get(n6).getSection() != n5) continue;
                        n7 = n6;
                        break;
                    }
                    i = n7;
                    --n3;
                    assert (linkedList != null);
                    parsedValues = (ParsedValues)linkedList.pop();
                    parseLog.clearError();
                    parseLog.setPosition(parsedValues.getPosition());
                }
            } else if (formatStep.isNewOrBlockStarted()) {
                i = formatStep.skipTrailingOrBlocks();
            }
            n2 = n3;
        }
        while (n3 > 0) {
            assert (linkedList != null);
            parsedValues = (ParsedValues)linkedList.pop();
            ((ParsedValues)linkedList.peek()).putAll(parsedValues);
            --n3;
        }
        if (linkedList != null) {
            parsedValues = (ParsedValues)linkedList.peek();
        }
        parsedValues.setNoAmbivalentCheck();
        return parsedValues;
    }

    private static String sub(int n, CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 - n <= 10) {
            return charSequence.subSequence(n, n2).toString();
        }
        return charSequence.subSequence(n, n + 10).toString() + "...";
    }

    private static String getDescription(ChronoEntity<?> chronoEntity) {
        Set<ChronoElement<?>> set = chronoEntity.getRegisteredElements();
        StringBuilder stringBuilder = new StringBuilder(set.size() * 16);
        stringBuilder.append(" [parsed={");
        boolean bl = true;
        for (ChronoElement<?> chronoElement : set) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(chronoEntity.get(chronoElement));
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    private static Chronology<?> checkElement(Chronology<?> chronology, Chronology<?> chronology2, ChronoElement<?> chronoElement) {
        boolean bl = chronology.isSupported(chronoElement);
        if (bl) {
            return chronology;
        }
        if (chronology2 == null) {
            Chronology<?> chronology3 = chronology;
            while ((chronology3 = chronology3.preparser()) != null) {
                if (!chronology3.isSupported(chronoElement)) continue;
                return chronology3;
            }
        } else {
            if (chronoElement.isDateElement() && chronology2.isSupported(chronoElement)) {
                return chronology2;
            }
            if (chronoElement.isTimeElement() && PlainTime.axis().isSupported((IsoTimeUnit)((Object)chronoElement))) {
                return PlainTime.axis();
            }
        }
        throw new IllegalArgumentException("Unsupported element: " + chronoElement.name());
    }

    private static int getDepth(Chronology<?> chronology, Chronology<?> chronology2, Chronology<?> chronology3) {
        if (chronology3 != null) {
            return -1;
        }
        if (chronology.equals(chronology2)) {
            return 0;
        }
        Chronology<?> chronology4 = chronology2;
        int n = 0;
        while ((chronology4 = chronology4.preparser()) != null) {
            ++n;
            if (!chronology.equals(chronology4)) continue;
            return n;
        }
        return Integer.MAX_VALUE;
    }

    private List<FormatStep> freeze(List<FormatStep> list) {
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>(list.size());
        for (FormatStep formatStep : list) {
            arrayList.add(formatStep.quickPath(this));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private boolean hasNoPreparser() {
        return this.chronology.preparser() == null && this.overrideHandler == null;
    }

    private static class ZonalDisplay
    implements ChronoDisplay,
    UnixTime {
        private final GeneralTimestamp<?> tsp;
        private final TZID tzid;

        private ZonalDisplay(GeneralTimestamp<?> generalTimestamp, TZID tZID) {
            this.tsp = generalTimestamp;
            this.tzid = tZID;
        }

        @Override
        public boolean contains(ChronoElement<?> chronoElement) {
            return this.tsp.contains(chronoElement);
        }

        @Override
        public <V> V get(ChronoElement<V> chronoElement) {
            return this.tsp.get(chronoElement);
        }

        @Override
        public int getInt(ChronoElement<Integer> chronoElement) {
            return this.tsp.getInt(chronoElement);
        }

        @Override
        public <V> V getMinimum(ChronoElement<V> chronoElement) {
            return this.tsp.getMinimum(chronoElement);
        }

        @Override
        public <V> V getMaximum(ChronoElement<V> chronoElement) {
            return this.tsp.getMaximum(chronoElement);
        }

        @Override
        public boolean hasTimezone() {
            return true;
        }

        @Override
        public TZID getTimezone() {
            return this.tzid;
        }

        @Override
        public long getPosixTime() {
            return this.getUnixTime().getPosixTime();
        }

        @Override
        public int getNanosecond() {
            return this.getUnixTime().getNanosecond();
        }

        private UnixTime getUnixTime() {
            StartOfDay startOfDay;
            try {
                Class<?> clazz = this.tsp.toDate().getClass();
                startOfDay = Chronology.lookup(clazz).getDefaultStartOfDay();
            }
            catch (RuntimeException runtimeException) {
                startOfDay = StartOfDay.MIDNIGHT;
            }
            return this.tsp.in(Timezone.of(this.tzid), startOfDay);
        }
    }

    private static class OverrideHandler<C>
    implements ChronoMerger<GeneralTimestamp<C>> {
        private final Chronology<C> override;
        private final List<ChronoExtension> extensions;

        private OverrideHandler(Chronology<C> chronology) {
            this.override = chronology;
            ArrayList<ChronoExtension> arrayList = new ArrayList<ChronoExtension>();
            arrayList.addAll(this.override.getExtensions());
            arrayList.addAll(PlainTime.axis().getExtensions());
            this.extensions = Collections.unmodifiableList(arrayList);
        }

        static <C> OverrideHandler<C> of(Chronology<C> chronology) {
            if (chronology == null) {
                return null;
            }
            return new OverrideHandler<C>(chronology);
        }

        @Override
        @Deprecated
        public GeneralTimestamp<C> createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        @Override
        public GeneralTimestamp<C> createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            GeneralTimestamp<ChronoEntity> generalTimestamp;
            C c = this.override.createFrom(chronoEntity, attributeQuery, bl, bl2);
            PlainTime plainTime = (PlainTime)PlainTime.axis().createFrom((ChronoEntity)chronoEntity, attributeQuery, bl, bl2);
            if (c instanceof CalendarVariant) {
                generalTimestamp = GeneralTimestamp.of((CalendarVariant)CalendarVariant.class.cast(c), plainTime);
            } else if (c instanceof Calendrical) {
                generalTimestamp = GeneralTimestamp.of((Calendrical)Calendrical.class.cast(c), plainTime);
            } else {
                throw new IllegalStateException("Cannot determine calendar type: " + c);
            }
            return (GeneralTimestamp)ChronoFormatter.cast(generalTimestamp);
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return this.override.getDefaultStartOfDay();
        }

        public List<ChronoExtension> getExtensions() {
            return this.extensions;
        }

        public Chronology<?> getCalendarOverride() {
            return this.override;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof OverrideHandler) {
                OverrideHandler overrideHandler = (OverrideHandler)object;
                return this.override.equals(overrideHandler.override);
            }
            return false;
        }

        public int hashCode() {
            return this.override.hashCode();
        }

        public String toString() {
            return this.override.getChronoType().getName();
        }

        @Override
        public ChronoDisplay preformat(GeneralTimestamp<C> generalTimestamp, AttributeQuery attributeQuery) {
            throw new UnsupportedOperationException("Not used.");
        }

        @Override
        public Chronology<?> preparser() {
            throw new UnsupportedOperationException("Not used.");
        }

        @Override
        public GeneralTimestamp<C> createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            throw new UnsupportedOperationException("Not used.");
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            throw new UnsupportedOperationException("Not used.");
        }
    }

    private static class TraditionalFormat<T>
    extends Format {
        private static final Map<String, DateFormat.Field> FIELD_MAP;
        private final ChronoFormatter<T> formatter;

        TraditionalFormat(ChronoFormatter<T> chronoFormatter) {
            this.formatter = chronoFormatter;
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(0);
            try {
                AttributeSet attributeSet = ((ChronoFormatter)this.formatter).globalAttributes;
                String string = attributeSet.get(Attributes.CALENDAR_TYPE, "iso8601");
                T t = this.formatter.getChronology().getChronoType().cast(object);
                Set<ElementPosition> set = this.formatter.print(t, stringBuffer, attributeSet);
                if (string.equals("iso8601")) {
                    for (ElementPosition elementPosition : set) {
                        DateFormat.Field field = TraditionalFormat.toField(elementPosition.getElement());
                        if (field == null || !(field.equals(fieldPosition.getFieldAttribute()) || field.getCalendarField() == fieldPosition.getField() && fieldPosition.getField() != -1 || field.equals(DateFormat.Field.TIME_ZONE) && fieldPosition.getField() == 17 || field.equals(DateFormat.Field.HOUR_OF_DAY1) && fieldPosition.getField() == 4) && (!field.equals(DateFormat.Field.HOUR1) || fieldPosition.getField() != 15)) continue;
                        fieldPosition.setBeginIndex(elementPosition.getStartIndex());
                        fieldPosition.setEndIndex(elementPosition.getEndIndex());
                        break;
                    }
                }
                return stringBuffer;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Not formattable: " + object, classCastException);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot print object: " + object, iOException);
            }
        }

        @Override
        public AttributedCharacterIterator formatToCharacterIterator(Object object) {
            String string = ((ChronoFormatter)this.formatter).globalAttributes.get(Attributes.CALENDAR_TYPE, "iso8601");
            if (string.equals("iso8601")) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    T t = this.formatter.getChronology().getChronoType().cast(object);
                    Set<ElementPosition> set = this.formatter.print(t, stringBuilder);
                    AttributedString attributedString = new AttributedString(stringBuilder.toString());
                    for (ElementPosition elementPosition : set) {
                        DateFormat.Field field = TraditionalFormat.toField(elementPosition.getElement());
                        if (field == null) continue;
                        attributedString.addAttribute(field, field, elementPosition.getStartIndex(), elementPosition.getEndIndex());
                    }
                    return attributedString.getIterator();
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Not formattable: " + object, classCastException);
                }
            }
            return super.formatToCharacterIterator(object);
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            ParseLog parseLog = new ParseLog(parsePosition.getIndex());
            T t = this.formatter.parse((CharSequence)string, parseLog);
            if (t == null) {
                parsePosition.setErrorIndex(parseLog.getErrorIndex());
            } else {
                parsePosition.setIndex(parseLog.getPosition());
            }
            return t;
        }

        private static DateFormat.Field toField(ChronoElement<?> chronoElement) {
            return FIELD_MAP.get(chronoElement.name());
        }

        static {
            HashMap<String, DateFormat.Field> hashMap = new HashMap<String, DateFormat.Field>();
            hashMap.put("YEAR", DateFormat.Field.YEAR);
            hashMap.put("YEAR_OF_ERA", DateFormat.Field.YEAR);
            hashMap.put("YEAR_OF_WEEKDATE", DateFormat.Field.YEAR);
            hashMap.put("WEEK_OF_YEAR", DateFormat.Field.WEEK_OF_YEAR);
            hashMap.put("WEEK_OF_MONTH", DateFormat.Field.WEEK_OF_MONTH);
            hashMap.put("BOUNDED_WEEK_OF_YEAR", DateFormat.Field.WEEK_OF_YEAR);
            hashMap.put("BOUNDED_WEEK_OF_MONTH", DateFormat.Field.WEEK_OF_MONTH);
            hashMap.put("MONTH_OF_YEAR", DateFormat.Field.MONTH);
            hashMap.put("MONTH_AS_NUMBER", DateFormat.Field.MONTH);
            hashMap.put("HISTORIC_MONTH", DateFormat.Field.MONTH);
            hashMap.put("WEEKDAY_IN_MONTH", DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
            hashMap.put("SECOND_OF_MINUTE", DateFormat.Field.SECOND);
            hashMap.put("MINUTE_OF_HOUR", DateFormat.Field.MINUTE);
            hashMap.put("MILLI_OF_SECOND", DateFormat.Field.MILLISECOND);
            hashMap.put("DIGITAL_HOUR_OF_DAY", DateFormat.Field.HOUR_OF_DAY0);
            hashMap.put("DIGITAL_HOUR_OF_AMPM", DateFormat.Field.HOUR0);
            hashMap.put("CLOCK_HOUR_OF_DAY", DateFormat.Field.HOUR_OF_DAY1);
            hashMap.put("CLOCK_HOUR_OF_AMPM", DateFormat.Field.HOUR1);
            hashMap.put("AM_PM_OF_DAY", DateFormat.Field.AM_PM);
            hashMap.put("DAY_OF_MONTH", DateFormat.Field.DAY_OF_MONTH);
            hashMap.put("HISTORIC_DAY_OF_MONTH", DateFormat.Field.DAY_OF_MONTH);
            hashMap.put("DAY_OF_WEEK", DateFormat.Field.DAY_OF_WEEK);
            hashMap.put("LOCAL_DAY_OF_WEEK", DateFormat.Field.DAY_OF_WEEK);
            hashMap.put("DAY_OF_YEAR", DateFormat.Field.DAY_OF_YEAR);
            hashMap.put("TIMEZONE_ID", DateFormat.Field.TIME_ZONE);
            hashMap.put("ERA", DateFormat.Field.ERA);
            FIELD_MAP = Collections.unmodifiableMap(hashMap);
        }
    }

    public static final class Builder<T> {
        private static final AttributeKey<DayPeriod> CUSTOM_DAY_PERIOD = Attributes.createKey("CUSTOM_DAY_PERIOD", DayPeriod.class);
        private final Chronology<T> chronology;
        private final Chronology<?> override;
        private final Locale locale;
        private List<FormatStep> steps;
        private LinkedList<AttributeSet> stack;
        private int sectionID;
        private int reservedIndex;
        private int leftPadWidth;
        private DayPeriod dayPeriod;
        private Map<ChronoElement<?>, Object> defaultMap;
        private Chronology<?> deepestParser;
        private int depthOfParser;

        private Builder(Chronology<T> chronology, Locale locale) {
            this(chronology, locale, null);
        }

        private Builder(Chronology<T> chronology, Locale locale, Chronology<?> chronology2) {
            if (chronology == null) {
                throw new NullPointerException("Missing chronology.");
            }
            if (locale == null) {
                throw new NullPointerException("Missing locale.");
            }
            this.chronology = chronology;
            this.override = chronology2;
            this.locale = locale;
            this.steps = new ArrayList<FormatStep>();
            this.stack = new LinkedList();
            this.sectionID = 0;
            this.reservedIndex = -1;
            this.leftPadWidth = 0;
            this.dayPeriod = null;
            this.defaultMap = new HashMap();
            this.deepestParser = chronology;
            this.depthOfParser = 0;
        }

        public Chronology<?> getChronology() {
            return this.override == null ? this.chronology : this.override;
        }

        public Builder<T> addInteger(ChronoElement<Integer> chronoElement, int n, int n2) {
            return this.addNumber(chronoElement, false, n, n2, SignPolicy.SHOW_NEVER);
        }

        public Builder<T> addInteger(ChronoElement<Integer> chronoElement, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, false, n, n2, signPolicy);
        }

        public Builder<T> addLongNumber(ChronoElement<Long> chronoElement, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, false, n, n2, signPolicy);
        }

        public Builder<T> addFixedInteger(ChronoElement<Integer> chronoElement, int n) {
            return this.addNumber(chronoElement, true, n, n, SignPolicy.SHOW_NEVER);
        }

        public <V extends Enum<V>> Builder<T> addNumerical(ChronoElement<V> chronoElement, int n, int n2) {
            return this.addNumber(chronoElement, false, n, n2, SignPolicy.SHOW_NEVER);
        }

        public <V extends Enum<V>> Builder<T> addFixedNumerical(ChronoElement<V> chronoElement, int n) {
            return this.addNumber(chronoElement, true, n, n, SignPolicy.SHOW_NEVER);
        }

        public Builder<T> addFraction(ChronoElement<Integer> chronoElement, int n, int n2, boolean bl) {
            this.checkElement(chronoElement);
            boolean bl2 = !bl && n == n2;
            this.ensureOnlyOneFractional(bl2, bl);
            FractionProcessor fractionProcessor = new FractionProcessor(chronoElement, n, n2, bl);
            if (this.reservedIndex != -1 && bl2) {
                int n3 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n3);
                this.addProcessor(fractionProcessor);
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n3;
                    this.steps.set(n3, formatStep.reserve(n));
                }
            } else {
                this.addProcessor(fractionProcessor);
            }
            return this;
        }

        public Builder<T> addFixedDecimal(ChronoElement<BigDecimal> chronoElement, int n, int n2) {
            this.checkElement(chronoElement);
            this.ensureDecimalDigitsOnlyOnce();
            DecimalProcessor decimalProcessor = new DecimalProcessor(chronoElement, n, n2);
            if (this.reservedIndex != -1) {
                int n3 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n3);
                this.addProcessor(decimalProcessor);
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n3;
                    this.steps.set(n3, formatStep.reserve(n - n2));
                }
            } else {
                this.addProcessor(decimalProcessor);
            }
            return this;
        }

        public Builder<T> addEnglishOrdinal(ChronoElement<Integer> chronoElement) {
            return this.addOrdinalProcessor(chronoElement, null);
        }

        public Builder<T> addOrdinal(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
            if (map == null) {
                throw new NullPointerException("Missing ordinal indicators.");
            }
            return this.addOrdinalProcessor(chronoElement, map);
        }

        public Builder<T> addLiteral(char c) {
            return this.addLiteral(String.valueOf(c));
        }

        public Builder<T> addLiteral(char c, char c2) {
            this.addProcessor(new LiteralProcessor(c, c2));
            return this;
        }

        public Builder<T> addLiteral(String string) {
            LiteralProcessor literalProcessor = new LiteralProcessor(string);
            int n = literalProcessor.getPrefixedDigitArea();
            if (n > 0) {
                FormatStep formatStep;
                FormatStep formatStep2 = formatStep = this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
                if (formatStep != null && formatStep.isDecimal() && !formatStep.isNewOrBlockStarted()) {
                    throw new IllegalStateException("Numerical literal can't be inserted after an element with decimal digits.");
                }
            }
            if (n == 0 || this.reservedIndex == -1) {
                this.addProcessor(literalProcessor);
            } else {
                int n2 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n2);
                this.addProcessor(literalProcessor);
                if (formatStep.getSection() == this.steps.get(this.steps.size() - 1).getSection()) {
                    this.reservedIndex = n2;
                    this.steps.set(n2, formatStep.reserve(n));
                }
            }
            return this;
        }

        public Builder<T> addLiteral(AttributeKey<Character> attributeKey) {
            this.addProcessor(new LiteralProcessor(attributeKey));
            return this;
        }

        public Builder<T> addIgnorableWhitespace() {
            this.addProcessor(IgnorableWhitespaceProcessor.SINGLETON);
            return this;
        }

        public Builder<T> skipUnknown(int n) {
            this.addProcessor(new SkipProcessor(n));
            return this;
        }

        public Builder<T> skipUnknown(ChronoCondition<Character> chronoCondition, int n) {
            this.addProcessor(new SkipProcessor(chronoCondition, n));
            return this;
        }

        public Builder<T> addPattern(String string, PatternType patternType) {
            Object object;
            Object object2;
            int n;
            int n2;
            if (patternType == null) {
                throw new NullPointerException("Missing pattern type.");
            }
            Object object3 = Collections.emptyMap();
            int n3 = string.length();
            Locale locale = this.locale;
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.stack.isEmpty()) {
                locale = this.stack.getLast().getLocale();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                n = string.charAt(n2);
                if (Builder.isSymbol((char)n)) {
                    this.addLiteralChars(stringBuilder);
                    n4 = n2++;
                    while (n2 < n3 && string.charAt(n2) == n) {
                        ++n2;
                    }
                    object2 = patternType.registerSymbol(this, locale, (char)n, n2 - n4);
                    if (!object2.isEmpty()) {
                        if (object3.isEmpty()) {
                            object3 = object2;
                        } else {
                            object = new HashMap(object3);
                            object.putAll(object2);
                            object3 = object;
                        }
                    }
                    --n2;
                    continue;
                }
                if (n == 39) {
                    this.addLiteralChars(stringBuilder);
                    n4 = n2++;
                    while (n2 < n3) {
                        if (string.charAt(n2) == '\'') {
                            if (n2 + 1 >= n3 || string.charAt(n2 + 1) != '\'') break;
                            ++n2;
                        }
                        ++n2;
                    }
                    if (n2 >= n3) {
                        throw new IllegalArgumentException("String literal in pattern not closed: " + string);
                    }
                    if (n4 + 1 == n2) {
                        this.addLiteral('\'');
                        continue;
                    }
                    object2 = string.substring(n4 + 1, n2);
                    this.addLiteral(((String)object2).replace("''", "'"));
                    continue;
                }
                if (n == 91) {
                    this.addLiteralChars(stringBuilder);
                    this.startOptionalSection();
                    continue;
                }
                if (n == 93) {
                    this.addLiteralChars(stringBuilder);
                    this.endSection();
                    continue;
                }
                if (n == 124) {
                    try {
                        this.addLiteralChars(stringBuilder);
                        this.or();
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new IllegalArgumentException(illegalStateException);
                    }
                }
                if (n == 35 || n == 123 || n == 125) {
                    throw new IllegalArgumentException("Pattern contains reserved character: '" + (char)n + "'");
                }
                stringBuilder.append((char)n);
            }
            this.addLiteralChars(stringBuilder);
            if (!object3.isEmpty()) {
                n2 = this.steps.size();
                for (n = 0; n < n2; ++n) {
                    FormatStep formatStep = this.steps.get(n);
                    object2 = formatStep.getProcessor().getElement();
                    if (!object3.containsKey(object2)) continue;
                    object = (ChronoElement)object3.get(object2);
                    this.steps.set(n, formatStep.updateElement((ChronoElement<?>)object));
                }
            }
            return this;
        }

        public Builder<T> addText(TextElement<?> textElement) {
            this.checkElement(textElement);
            this.addProcessor(TextProcessor.create(textElement));
            return this;
        }

        public <V extends Enum<V>> Builder<T> addText(ChronoElement<V> chronoElement) {
            this.checkElement(chronoElement);
            if (chronoElement instanceof TextElement) {
                TextElement textElement = (TextElement)TextElement.class.cast(chronoElement);
                this.addProcessor(TextProcessor.create(textElement));
            } else {
                Map map = Collections.emptyMap();
                this.addProcessor(new LookupProcessor<V>(chronoElement, map));
            }
            return this;
        }

        public <V extends Enum<V>> Builder<T> addText(ChronoElement<V> chronoElement, Map<V, String> map) {
            this.checkElement(chronoElement);
            this.addProcessor(new LookupProcessor<V>(chronoElement, map));
            return this;
        }

        public Builder<T> addDayPeriodFixed() {
            TextElement<?> textElement = this.findDayPeriodElement(true, null);
            return this.addText(textElement);
        }

        public Builder<T> addDayPeriodApproximate() {
            TextElement<?> textElement = this.findDayPeriodElement(false, null);
            return this.addText(textElement);
        }

        public Builder<T> addDayPeriod(Map<PlainTime, String> map) {
            if (this.dayPeriod != null) {
                throw new IllegalStateException("Cannot add custom day period more than once.");
            }
            DayPeriod dayPeriod = DayPeriod.of(map);
            TextElement<?> textElement = this.findDayPeriodElement(false, dayPeriod);
            this.dayPeriod = dayPeriod;
            this.addProcessor(TextProcessor.createProtected(textElement));
            return this;
        }

        public <V extends ChronoEntity<V>> Builder<T> addCustomized(ChronoElement<V> chronoElement, ChronoFormatter<V> chronoFormatter) {
            return this.addCustomized(chronoElement, chronoFormatter, chronoFormatter);
        }

        public <V> Builder<T> addCustomized(ChronoElement<V> chronoElement, ChronoPrinter<V> chronoPrinter, ChronoParser<V> chronoParser) {
            this.checkElement(chronoElement);
            this.addProcessor(new CustomizedProcessor<V>(chronoElement, chronoPrinter, chronoParser));
            return this;
        }

        public Builder<T> addTwoDigitYear(ChronoElement<Integer> chronoElement) {
            this.checkElement(chronoElement);
            this.checkAfterDecimalDigits(chronoElement);
            TwoDigitYearProcessor twoDigitYearProcessor = new TwoDigitYearProcessor(chronoElement);
            if (this.reservedIndex == -1) {
                this.addProcessor(twoDigitYearProcessor);
                this.reservedIndex = this.steps.size() - 1;
            } else {
                int n = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n);
                this.startSection(Attributes.LENIENCY, Leniency.STRICT);
                this.addProcessor(twoDigitYearProcessor);
                this.endSection();
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n;
                    this.steps.set(n, formatStep.reserve(2));
                }
            }
            return this;
        }

        public Builder<T> addTimezoneID() {
            if (Builder.hasUnixChronology(this.chronology)) {
                this.addProcessor(TimezoneIDProcessor.INSTANCE);
                return this;
            }
            throw new IllegalStateException("Only unix timestamps can have a timezone id.");
        }

        public Builder<T> addShortTimezoneName() {
            this.checkMomentChrono();
            this.addProcessor(new TimezoneNameProcessor(true));
            return this;
        }

        public Builder<T> addLongTimezoneName() {
            this.checkMomentChrono();
            this.addProcessor(new TimezoneNameProcessor(false));
            return this;
        }

        public Builder<T> addShortTimezoneName(Set<TZID> set) {
            this.checkMomentChrono();
            this.addProcessor(new TimezoneNameProcessor(true, set));
            return this;
        }

        public Builder<T> addLongTimezoneName(Set<TZID> set) {
            this.checkMomentChrono();
            this.addProcessor(new TimezoneNameProcessor(false, set));
            return this;
        }

        public Builder<T> addTimezoneOffset() {
            return this.addTimezoneOffset(DisplayMode.MEDIUM, true, Collections.singletonList("Z"));
        }

        public Builder<T> addTimezoneOffset(DisplayMode displayMode, boolean bl, List<String> list) {
            this.addProcessor(new TimezoneOffsetProcessor(displayMode, bl, list));
            return this;
        }

        public Builder<T> addShortLocalizedOffset() {
            this.addProcessor(new LocalizedGMTProcessor(true));
            return this;
        }

        public Builder<T> addLongLocalizedOffset() {
            this.addProcessor(new LocalizedGMTProcessor(false));
            return this;
        }

        public Builder<T> padNext(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative pad width: " + n);
            }
            if (n > 0) {
                this.leftPadWidth = n;
            }
            return this;
        }

        public Builder<T> padPrevious(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative pad width: " + n);
            }
            if (!this.steps.isEmpty() && n > 0) {
                int n2 = this.steps.size() - 1;
                FormatStep formatStep = this.steps.get(n2);
                int n3 = 0;
                if (!this.stack.isEmpty()) {
                    n3 = this.stack.getLast().getSection();
                }
                if (n3 == formatStep.getSection() && !formatStep.isNewOrBlockStarted()) {
                    this.steps.set(n2, formatStep.pad(0, n));
                }
            }
            return this;
        }

        public Builder<T> startOptionalSection() {
            return this.startOptionalSection(null);
        }

        public Builder<T> startOptionalSection(final ChronoCondition<ChronoDisplay> chronoCondition) {
            ChronoCondition<ChronoDisplay> chronoCondition2;
            this.resetPadding();
            Attributes.Builder builder = new Attributes.Builder();
            AttributeSet attributeSet = null;
            ChronoCondition<ChronoDisplay> chronoCondition3 = null;
            if (!this.stack.isEmpty()) {
                attributeSet = this.stack.getLast();
                builder.setAll(attributeSet.getAttributes());
                chronoCondition3 = attributeSet.getCondition();
            }
            int n = Builder.getLevel(attributeSet) + 1;
            int n2 = ++this.sectionID;
            if (chronoCondition != null) {
                chronoCondition2 = chronoCondition3;
                chronoCondition3 = chronoCondition2 == null ? chronoCondition : new ChronoCondition<ChronoDisplay>(){

                    @Override
                    public boolean test(ChronoDisplay chronoDisplay) {
                        return chronoCondition2.test(chronoDisplay) && chronoCondition.test(chronoDisplay);
                    }
                };
            }
            chronoCondition2 = new AttributeSet(builder.build(), this.locale, n, n2, chronoCondition3);
            this.stack.addLast((AttributeSet)((Object)chronoCondition2));
            return this;
        }

        public Builder<T> startSection(AttributeKey<Boolean> attributeKey, boolean bl) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder();
                attributeSet = new AttributeSet(builder.set(attributeKey, bl).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, bl);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> startSection(AttributeKey<Integer> attributeKey, int n) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder();
                attributeSet = new AttributeSet(builder.set(attributeKey, n).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, n);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> startSection(AttributeKey<Character> attributeKey, char c) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder();
                attributeSet = new AttributeSet(builder.set(attributeKey, c).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, c);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public <A extends Enum<A>> Builder<T> startSection(AttributeKey<A> attributeKey, A a) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder();
                attributeSet = new AttributeSet(builder.set(attributeKey, a).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, a);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> endSection() {
            this.stack.removeLast();
            this.resetPadding();
            return this;
        }

        public Builder<T> or() {
            int n = -1;
            FormatStep formatStep = null;
            int n2 = -1;
            int n3 = 0;
            if (!this.stack.isEmpty()) {
                n3 = this.stack.getLast().getSection();
            }
            if (!this.steps.isEmpty()) {
                n = this.steps.size() - 1;
                formatStep = this.steps.get(n);
                n2 = formatStep.getSection();
            }
            if (n3 != n2) {
                throw new IllegalStateException("Cannot start or-block without any previous step in current section.");
            }
            this.steps.set(n, formatStep.startNewOrBlock());
            this.resetPadding();
            this.reservedIndex = -1;
            return this;
        }

        public <V> Builder<T> setDefault(ChronoElement<V> chronoElement, V v) {
            if (v == null) {
                throw new NullPointerException("Missing default value.");
            }
            this.checkElement(chronoElement);
            this.defaultMap.put(chronoElement, v);
            return this;
        }

        public ChronoFormatter<T> build() {
            return this.build(Attributes.empty());
        }

        public ChronoFormatter<T> build(Attributes attributes) {
            HashMap<Integer, FormatStep> hashMap = null;
            int n = this.steps.size();
            for (int i = 0; i < n; ++i) {
                FormatStep formatStep = this.steps.get(i);
                if (!formatStep.isNewOrBlockStarted()) continue;
                int n2 = formatStep.getSection();
                boolean bl = false;
                for (int j = n - 1; j > i; --j) {
                    if (this.steps.get(j).getSection() != n2) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap<Integer, FormatStep>();
                    }
                    hashMap.put(i, formatStep.markLastOrBlock(j));
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new IllegalStateException("Missing format processor after or-operator.");
            }
            if (hashMap != null) {
                for (Integer n3 : hashMap.keySet()) {
                    this.steps.set(n3, (FormatStep)hashMap.get(n3));
                }
            }
            ChronoFormatter chronoFormatter = new ChronoFormatter(this.chronology, this.override, this.locale, this.steps, this.defaultMap, attributes, this.deepestParser);
            if (this.dayPeriod != null) {
                AttributeSet attributeSet = chronoFormatter.globalAttributes;
                attributeSet = attributeSet.withInternal(CUSTOM_DAY_PERIOD, this.dayPeriod);
                chronoFormatter = new ChronoFormatter(chronoFormatter, attributeSet);
            }
            return chronoFormatter;
        }

        Builder<T> addYear(ChronoElement<Integer> chronoElement, int n, boolean bl) {
            FormatStep formatStep;
            FormatStep formatStep2 = formatStep = this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
            if (formatStep == null || formatStep.isNewOrBlockStarted() || !formatStep.isNumerical() || n != 4) {
                return this.addNumber(chronoElement, false, n, 9, SignPolicy.SHOW_WHEN_NEGATIVE, bl);
            }
            return this.addNumber(chronoElement, true, 4, 4, SignPolicy.SHOW_NEVER, bl);
        }

        private <V> Builder<T> addNumber(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, bl, n, n2, signPolicy, false);
        }

        private <V> Builder<T> addNumber(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy, boolean bl2) {
            this.checkElement(chronoElement);
            FormatStep formatStep = this.checkAfterDecimalDigits(chronoElement);
            NumberProcessor<V> numberProcessor = new NumberProcessor<V>(chronoElement, bl, n, n2, signPolicy, bl2);
            if (bl) {
                if (this.reservedIndex == -1) {
                    this.addProcessor(numberProcessor);
                } else {
                    int n3 = this.reservedIndex;
                    FormatStep formatStep2 = this.steps.get(n3);
                    this.addProcessor(numberProcessor);
                    FormatStep formatStep3 = this.steps.get(this.steps.size() - 1);
                    if (formatStep2.getSection() == formatStep3.getSection()) {
                        this.reservedIndex = n3;
                        this.steps.set(n3, formatStep2.reserve(n));
                    }
                }
            } else {
                if (formatStep != null && formatStep.isNumerical() && !formatStep.isNewOrBlockStarted()) {
                    throw new IllegalStateException("Numerical element with variable width can't be inserted after another numerical element. Consider \"addFixedXXX()\" instead.");
                }
                this.addProcessor(numberProcessor);
                this.reservedIndex = this.steps.size() - 1;
            }
            return this;
        }

        private Builder<T> addOrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
            this.checkElement(chronoElement);
            FormatStep formatStep = this.checkAfterDecimalDigits(chronoElement);
            OrdinalProcessor ordinalProcessor = new OrdinalProcessor(chronoElement, map);
            if (formatStep != null && formatStep.isNumerical() && !formatStep.isNewOrBlockStarted()) {
                throw new IllegalStateException("Ordinal element with variable width can't be inserted after another numerical element.");
            }
            this.addProcessor(ordinalProcessor);
            return this;
        }

        private void addProcessor(FormatProcessor<?> formatProcessor) {
            this.reservedIndex = -1;
            AttributeSet attributeSet = null;
            int n = 0;
            int n2 = 0;
            if (!this.stack.isEmpty()) {
                attributeSet = this.stack.getLast();
                n = attributeSet.getLevel();
                n2 = attributeSet.getSection();
            }
            FormatStep formatStep = new FormatStep(formatProcessor, n, n2, attributeSet);
            if (this.leftPadWidth > 0) {
                formatStep = formatStep.pad(this.leftPadWidth, 0);
                this.leftPadWidth = 0;
            }
            this.steps.add(formatStep);
        }

        private TextElement<?> findDayPeriodElement(boolean bl, DayPeriod dayPeriod) {
            Attributes attributes;
            AttributeQuery attributeQuery = attributes = new Attributes.Builder(this.getChronology()).build();
            if (dayPeriod != null) {
                AttributeSet attributeSet = this.stack.isEmpty() ? new AttributeSet(attributes, this.locale) : this.stack.getLast();
                attributeQuery = attributeSet.withInternal(CUSTOM_DAY_PERIOD, dayPeriod);
            }
            for (ChronoExtension chronoExtension : PlainTime.axis().getExtensions()) {
                for (ChronoElement<?> chronoElement : chronoExtension.getElements(this.locale, attributeQuery)) {
                    if (bl && chronoElement.getSymbol() == 'b' && this.isDayPeriodSupported(chronoElement)) {
                        return (TextElement)ChronoFormatter.cast(chronoElement);
                    }
                    if (bl || chronoElement.getSymbol() != 'B' || !this.isDayPeriodSupported(chronoElement)) continue;
                    return (TextElement)ChronoFormatter.cast(chronoElement);
                }
            }
            throw new IllegalStateException("Day periods are not supported: " + this.getChronology().getChronoType());
        }

        private boolean isDayPeriodSupported(ChronoElement<?> chronoElement) {
            if (!chronoElement.name().endsWith("_DAY_PERIOD")) {
                return false;
            }
            if (this.override == null && !this.chronology.isSupported(chronoElement)) {
                Chronology<Object> chronology = this.chronology;
                while ((chronology = chronology.preparser()) != null) {
                    if (!chronology.isSupported(chronoElement)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        private static int getLevel(AttributeSet attributeSet) {
            if (attributeSet == null) {
                return 0;
            }
            return attributeSet.getLevel();
        }

        private static void checkAttribute(AttributeKey<?> attributeKey) {
            if (attributeKey.name().charAt(0) == '_') {
                throw new IllegalArgumentException("Internal attribute not allowed: " + attributeKey.name());
            }
        }

        private void checkMomentChrono() {
            if (!Builder.hasUnixChronology(this.chronology)) {
                throw new IllegalStateException("Timezone names in specific non-location format can only be reliably combined with instant-like types, for example \"Moment\".");
            }
        }

        private static boolean hasUnixChronology(Chronology<?> chronology) {
            Chronology<?> chronology2 = chronology;
            do {
                if (!UnixTime.class.isAssignableFrom(chronology2.getChronoType())) continue;
                return true;
            } while ((chronology2 = chronology2.preparser()) != null);
            return false;
        }

        private void resetPadding() {
            this.leftPadWidth = 0;
        }

        private static boolean isSymbol(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }

        private void checkElement(ChronoElement<?> chronoElement) {
            Chronology chronology = ChronoFormatter.checkElement(this.chronology, this.override, chronoElement);
            int n = ChronoFormatter.getDepth(chronology, this.chronology, this.override);
            if (n >= this.depthOfParser) {
                this.deepestParser = chronology;
                this.depthOfParser = n;
            }
        }

        private void ensureDecimalDigitsOnlyOnce() {
            for (FormatStep formatStep : this.steps) {
                if (!formatStep.isDecimal()) continue;
                throw new IllegalArgumentException("Cannot define more than one element with decimal digits.");
            }
        }

        private void ensureOnlyOneFractional(boolean bl, boolean bl2) {
            this.ensureDecimalDigitsOnlyOnce();
            if (!bl && !bl2 && this.reservedIndex != -1) {
                throw new IllegalArgumentException("Cannot add fractional element with variable width after another numerical element with variable width.");
            }
        }

        private FormatStep checkAfterDecimalDigits(ChronoElement<?> chronoElement) {
            FormatStep formatStep;
            FormatStep formatStep2 = formatStep = this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
            if (formatStep == null) {
                return null;
            }
            if (formatStep.isDecimal() && !formatStep.isNewOrBlockStarted()) {
                throw new IllegalStateException(chronoElement.name() + " can't be inserted after an element" + " with decimal digits.");
            }
            return formatStep;
        }

        private void addLiteralChars(StringBuilder stringBuilder) {
            if (stringBuilder.length() > 0) {
                this.addLiteral(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
    }
}

